/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.servant;

import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.fateubw.common.entity.HeldEquipmentHandler;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.BehaviourUtils;
import io.github.flemmli97.fateubw.common.entity.misc.BabylonWeapon;
import io.github.flemmli97.fateubw.common.entity.misc.EnkiduChains;
import io.github.flemmli97.fateubw.common.entity.misc.EnumaElish;
import io.github.flemmli97.fateubw.common.entity.utils.OnProjectileHit;
import io.github.flemmli97.fateubw.common.particles.trail.TrailInfo;
import io.github.flemmli97.fateubw.common.particles.trail.TrailParticleData;
import io.github.flemmli97.fateubw.common.particles.trail.provider.ParticlePositionProvider;
import io.github.flemmli97.fateubw.common.registry.FateAttributes;
import io.github.flemmli97.fateubw.common.registry.FateDataComponents;
import io.github.flemmli97.fateubw.common.registry.FateItems;
import io.github.flemmli97.fateubw.common.registry.FateParticles;
import io.github.flemmli97.tenshilib.common.entity.ai.TargetPosition;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.LeapInDirection;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.PlayAnimation;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinition;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.CirclingData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.utils.math.MathUtils;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_4140;
import net.minecraft.class_8103;
import net.minecraft.class_9331;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.joml.Vector4f;

public class Gilgamesh
extends BaseServant
implements OnProjectileHit {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String ONE_HAND_1 = BUILDER.add("one_hand_1", AnimationsBuilder.definition((double)0.68).marker("attack", new double[]{0.56}));
    public static final String ONE_HAND_2 = BUILDER.add("one_hand_2", AnimationsBuilder.definition((double)0.68).marker("attack", new double[]{0.56}));
    public static final String STAB_1 = BUILDER.add("stab_1", AnimationsBuilder.definition((double)0.84).marker("attack", new double[]{0.6, 0.72}));
    public static final String GUARD = BUILDER.add("guard", AnimationsBuilder.definition((double)0.4));
    public static final String BABYLON_1 = BUILDER.add("babylon_1", AnimationsBuilder.definition((double)1.0).marker("attack", new double[]{0.32}));
    public static final String BABYLON_2 = BUILDER.add("babylon_2", AnimationsBuilder.definition((double)1.0).marker("attack", new double[]{0.32}));
    public static final String BABYLON_3 = BUILDER.add("babylon_3", AnimationsBuilder.definition((double)1.0).marker("attack", new double[]{0.32}));
    public static final String EA = BUILDER.add("ea", AnimationsBuilder.definition((double)3.12).marker("start_attack", new double[]{0.1}).marker("attack", new double[]{1.56}));
    public static final String SUMMON = BUILDER.add("summon", AnimationsBuilder.definition((double)2.0));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final Vector4f summonColor = new Vector4f(1.0f, 0.85f, 0.3f, 0.7f);
    private final AnimationHandler<Gilgamesh> animationHandler = new AnimationHandler((class_1297)this, ANIMS);
    public final HeldEquipmentHandler heldEquipmentHandler = new HeldEquipmentHandler((class_1309)this, new class_1799((class_1935)FateItems.ENUMAELISH.get()), null);
    private int chainCooldown = 200;
    private int leapCooldown;

    public Gilgamesh(class_1299<? extends Gilgamesh> entityType, class_1937 level) {
        super(entityType, level);
        this.revealServant();
    }

    @Override
    public boolean hasOwnWeapon() {
        return true;
    }

    @Override
    public HeldEquipmentHandler getEquipmentHandler() {
        return this.heldEquipmentHandler;
    }

    @Override
    public ExtendedBehaviour<? extends BaseServant> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{ONE_HAND_1}).play(BehaviourUtils.cooldownedPlay(true, 18, 30)).condition(gil -> !gil.useRanged() && BehaviourUtils.ifCloserThan(4.0).test(gil)).end(7).start(new String[]{ONE_HAND_2}).play(BehaviourUtils.cooldownedPlay(true, 18, 30)).condition(gil -> !gil.useRanged() && BehaviourUtils.ifCloserThan(4.0).test(gil)).end(7).start(new String[]{STAB_1}).play(BehaviourUtils.cooldownedPlay(true, 18, 30)).condition(gil -> !gil.useRanged() && BehaviourUtils.ifCloserThan(4.0).test(gil)).end(7).start(new String[]{BABYLON_1, BABYLON_2, BABYLON_3}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(20.0), (s, entity) -> 30 + entity.method_59922().method_43048(20) - (entity.chainCooldown > 0 ? 15 : 0))).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(8.0).max(18.0).speedMod(1.2f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack(15, 30)}).end(33).start(new String[]{BABYLON_1, BABYLON_2, BABYLON_3}).play((PlayAnimation)BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(20.0), (s, entity) -> 30 + entity.method_59922().method_43048(20) - (entity.chainCooldown > 0 ? 15 : 0)).startCondition(gil -> gil.chainCooldown <= 0 && BehaviourUtils.ifCloserThan(16.0).test(gil))).condition(gil -> !gil.useRanged()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(BehaviourUtils.closeEnough(16))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(27).start(new String[]{EA}).play(BehaviourUtils.cooldownedPlay(false, 20, 35)).condition(BaseServant::canUseNobelPhantasm).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(4.0).max(8.0).speedMod(1.1f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(40).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseServant> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(3, Gilgamesh::useRanged, new ExtendedBehaviour[]{new Idle()}).add(10, new ExtendedBehaviour[]{new StrafeTarget().strafeDistance(14.0f)}).add(7, new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().radius(7.0).speedMod(1.1f), BehaviourUtils.moveTo()}).add(2, gil -> gil.leapCooldown < 0 && BehaviourUtils.ifCloserThan(7.0).test(gil), new ExtendedBehaviour[]{new LeapInDirection().horizontalDirection((owner, target) -> LeapInDirection.createBackwardsVec((class_243)owner.method_19538(), (class_243)target.method_19538())).whenStarting(e -> {
            e.leapCooldown = 80 + e.method_59922().method_43048(40);
            BehaviourUtils.modifyExpiringMemory((class_1308)this, class_4140.field_22475, -15);
        })}).build();
    }

    @Override
    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().field_9236) {
            --this.chainCooldown;
            --this.leapCooldown;
            this.heldEquipmentHandler.setInUse(this.getAnimationHandler().isCurrent(new String[]{EA}) || this.healthBelow(0.5f));
        }
    }

    @Override
    public void setupAttack(AnimationDefinition anim) {
        if (this.getAnimationHandler().isCurrent(new String[]{BABYLON_1, BABYLON_2, BABYLON_3})) {
            BrainUtils.clearMemory((class_1309)this, (class_4140)class_4140.field_18446);
            this.method_5942().method_6340();
            return;
        }
        super.setupAttack(anim);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{EA})) {
            if (anim.isAt("start_attack")) {
                this.method_6019(class_1268.field_5808);
                this.method_6047().method_57379((class_9331)FateDataComponents.GLOWING_ITEM.get(), (Object)class_3902.field_17274);
            }
            if (!anim.isAt("attack")) {
                this.setTargetPositionFromAttackTarget();
            }
            if (anim.isAt("attack")) {
                this.ea(this.getTargetPosition());
            }
        } else if (anim.is(new String[]{BABYLON_1, BABYLON_2, BABYLON_3})) {
            class_1309 target = this.method_5968();
            if (!anim.isPast("attack") && target != null) {
                this.method_5988().method_6226((class_1297)target, 60.0f, 30.0f);
            }
            if (anim.isAt("attack") && target != null) {
                this.attackWithRangedAttack(target);
            }
        } else {
            super.handleAttack(anim);
        }
    }

    protected float method_59924(class_1297 attacker, class_1282 damageSource) {
        if (this.getAnimationHandler().isCurrent(new String[]{STAB_1})) {
            return 0.0f;
        }
        return super.method_59924(attacker, damageSource) + 3.0f;
    }

    public AnimationHandler<Gilgamesh> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        double height = this.method_17682();
        double width = this.method_17681();
        double length = 1.0f * this.method_55693();
        if (anim.is(new String[]{ONE_HAND_1})) {
            width += 0.5 * (double)this.method_55693();
            length += 0.7 * (double)this.method_55693();
        }
        if (anim.is(new String[]{ONE_HAND_2})) {
            width += 1.2 * (double)this.method_55693();
            length += 0.8 * (double)this.method_55693();
        }
        if (anim.is(new String[]{STAB_1})) {
            width += 0.3 * (double)this.method_55693();
            length += 0.9 * (double)this.method_55693();
        }
        return new class_238(-width * 0.5, -0.03, 0.0, width * 0.5, height + 0.03, length);
    }

    @Override
    public boolean method_5643(class_1282 damageSource, float damage) {
        if (!this.getAnimationHandler().isCurrent(new String[]{EA}) && !damageSource.method_48789(class_8103.field_42241) && !damageSource.method_48789(class_8103.field_42247) && this.method_6047().method_31574((class_1792)FateItems.ENUMAELISH.get()) && (double)this.method_59922().method_43057() < 0.15) {
            this.method_5783((class_3414)class_3417.field_15152.comp_349(), 1.0f, 1.0f);
            this.getAnimationHandler().setAnimation(GUARD);
            class_1297 class_12972 = damageSource.method_5529();
            if (class_12972 instanceof class_1309) {
                class_1309 entity = (class_1309)class_12972;
                class_243 dir = entity.method_19538().method_1020(this.method_19538());
                dir = new class_243(dir.method_10216(), 0.0, dir.method_10215()).method_1029().method_1021(5.0);
                entity.method_18799(entity.method_18798().method_1019(dir).method_1031(0.0, 0.3, 0.0));
            }
            for (int i = 0; i < 16; ++i) {
                float red = (float)(150 + this.method_59922().method_43048(100)) / 255.0f;
                float col = (float)(10 + this.method_59922().method_43048(200)) / 255.0f;
                if ((double)col >= (double)red * 0.8) {
                    col = 0.1f;
                    red = 0.1f;
                }
                AdvancedParticleContainer.make((class_2394)new TrailParticleData((class_2396<TrailParticleData>)((class_2396)FateParticles.TRAIL.get()), TrailInfo.builder(new ParticlePositionProvider.ParticlePositionData(MathUtils.NORMAL_Y, 6)).setColor(red, col, col, 0.7f).setColor2(red, col, col, 0.7f).setWidth(0.03f).setWidth2(0.03f).build())).addData((AdvancedParticleData)new CirclingData((float)((this.method_59922().method_43058() * 0.15 + 1.0) * (double)this.method_17681()), 0.0f, (float)(this.method_59922().method_43054() * 360), 80.0f, MathUtils.NORMAL_Y)).addData((AdvancedParticleData)new ParticleMetaData(10, false, 0.0f)).add(this.method_37908(), this.method_23317(), this.method_23323(this.method_59922().method_43058() * 1.2), this.method_23321());
            }
            return false;
        }
        return !this.getAnimationHandler().isCurrent(new String[]{EA}) && super.method_5643(damageSource, damage);
    }

    @Override
    public void regenMana(class_1297 source) {
        if (source != this) {
            double amount = this.method_45325(FateAttributes.MANA_LEECH.asHolder());
            this.regenMana(amount * 0.4);
            return;
        }
        super.regenMana(source);
    }

    @Override
    public boolean nobelPhantasmCheck() {
        return this.healthBelow(0.5f) && super.nobelPhantasmCheck();
    }

    public void ea(TargetPosition target) {
        this.method_6047().method_57381((class_9331)FateDataComponents.GLOWING_ITEM.get());
        if (!this.attemptUseNobelPhantasm()) {
            return;
        }
        EnumaElish ea = new EnumaElish(this.method_37908(), (class_1309)this);
        if (target != null) {
            class_243 pos = target.asVec(ea.method_19538());
            ea.setRotationTo(pos.method_10216(), pos.method_10214(), pos.method_10215(), 0.0f);
        }
        this.method_37908().method_8649((class_1297)ea);
        this.revealServant();
        this.method_6021();
    }

    public void attackWithRangedAttack(class_1309 target) {
        double perc = class_3532.method_15350((double)(1.0f - this.method_6032() / this.method_6063()), (double)0.2, (double)0.8);
        int randAmount = (int)(18.0 * perc);
        int base = 6 + (int)(6.0 * perc);
        int weaponAmount = this.method_59922().method_43048(Math.max(1, randAmount)) + base;
        if (this.getAnimationHandler().getAnimation() == null) {
            this.spawnBehind(target, weaponAmount);
        } else if (this.getAnimationHandler().isCurrent(new String[]{BABYLON_1, BABYLON_2, BABYLON_3})) {
            int chainChance = 0;
            if (this.chainCooldown < 0) {
                if ((double)this.method_6032() < (double)this.method_6063() * 0.3) {
                    chainChance = 3;
                } else if ((double)this.method_6032() < (double)this.method_6063() * 0.5) {
                    chainChance = 5;
                } else if ((double)this.method_6032() < (double)this.method_6063() * 0.8) {
                    chainChance = 7;
                }
            }
            if (chainChance > 0 && this.method_59922().method_43048(chainChance) == 0) {
                this.spawnChains(target, weaponAmount);
            } else if (this.method_59922().method_43048(3) == 0) {
                this.spawnAroundTarget(target, weaponAmount);
            } else {
                this.spawnBehind(target, weaponAmount);
            }
        }
    }

    private void spawnBehind(class_1309 target, int amount) {
        BabylonWeapon.spawnWeapons((class_1309)this, target, amount, 7);
        this.chainCooldown -= 50;
    }

    private void spawnAroundTarget(class_1309 target, int amount) {
        BabylonWeapon.spawnWeaponsAround((class_1309)this, target, amount, 6 + amount / 5);
        this.chainCooldown -= 50;
    }

    private void spawnChains(class_1309 target, int amount) {
        amount = Math.max(7, class_3532.method_15384((double)((double)amount * 0.7)));
        EnkiduChains.spawnWeaponsAround((class_1309)this, target, amount, 7 + amount / 7);
    }

    protected boolean useRanged() {
        return this.method_6047().method_7909() != FateItems.ENUMAELISH.get();
    }

    @Override
    protected String getSummonAnimation() {
        return SUMMON;
    }

    @Override
    public Vector4f summonColor() {
        return this.summonColor;
    }

    @Override
    public void onProjectileHit(class_1297 entity) {
        if (entity instanceof EnkiduChains && this.chainCooldown < 0) {
            BehaviourUtils.modifyExpiringMemory((class_1308)this, class_4140.field_22475, -20);
            this.chainCooldown = 250 + this.method_59922().method_43048(100);
            class_1309 target = BrainUtils.getTargetOfEntity((class_1309)this);
            if (target != null && this.method_5858((class_1297)target) < 16.0) {
                class_243 dir = target.method_19538().method_1020(this.method_19538());
                dir = new class_243(-dir.method_10216(), 0.0, -dir.method_10215()).method_1029().method_1021(4.5);
                entity.method_18800(dir.method_10216(), 0.2, dir.method_10215());
            }
        }
    }
}

