/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.servant;

import io.github.flemmli97.fateubw.api.datapack.ServantExtraData;
import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.BehaviourUtils;
import io.github.flemmli97.fateubw.common.entity.misc.MagicShot;
import io.github.flemmli97.fateubw.common.entity.summons.LesserMonster;
import io.github.flemmli97.fateubw.common.entity.summons.Tentacle;
import io.github.flemmli97.fateubw.common.registry.FateAttributes;
import io.github.flemmli97.fateubw.common.registry.FateEntities;
import io.github.flemmli97.fateubw.common.registry.FateItems;
import io.github.flemmli97.tenshilib.common.entity.ai.TargetPosition;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinition;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4140;
import net.minecraft.class_5819;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.util.BrainUtils;

public class Gilles
extends BaseServant {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String SUMMON_MONSTER = BUILDER.add("summon_monster", AnimationsBuilder.definition((double)1.2).marker("attack", new double[]{0.92}));
    public static final String SHOOT = BUILDER.add("shoot", AnimationsBuilder.definition((double)0.88).marker("attack", new double[]{0.76}));
    public static final String SUMMON_TENTACLE = BUILDER.add("summon_tentacle", AnimationsBuilder.definition((double)0.8).marker("attack", new double[]{0.68}));
    public static final String NP_ATTACK = BUILDER.add("np", AnimationsBuilder.definition((double)1.0));
    public static final String SUMMON = BUILDER.add("summon", AnimationsBuilder.definition((double)2.0));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<Gilles> animationHandler = new AnimationHandler((class_1297)this, ANIMS);

    public Gilles(class_1299<? extends Gilles> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void method_5964(class_5819 random, class_1266 difficulty) {
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)FateItems.GRIMOIRE.get()));
    }

    @Override
    public boolean hasOwnWeapon() {
        return this.method_6047().method_31574((class_1792)FateItems.GRIMOIRE.get());
    }

    @Override
    public ExtendedBehaviour<? extends BaseServant> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{SUMMON_MONSTER}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(16.0), 50, 80)).condition(Gilles::canSummonMore).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(7.0).max(12.0).speedMod((m, e) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(14).start(new String[]{SUMMON_MONSTER}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(16.0), 50, 80)).condition(Gilles::canSummonMore).end(11).start(new String[]{SHOOT}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(16.0), 40, 90)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(7.0).max(12.0).speedMod((m, e) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(10).start(new String[]{SHOOT}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(16.0), 40, 90)).end(7).start(new String[]{SUMMON_TENTACLE}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(16.0), 50, 80)).end(10).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseServant> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(7, new ExtendedBehaviour[]{new StrafeTarget().strafeDistance(12.0f)}).add(2, BehaviourUtils.ifCloserThan(7.0), new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().radius(7.0), BehaviourUtils.moveTo()}).build();
    }

    @Override
    public void setupAttack(AnimationDefinition anim) {
        BrainUtils.clearMemory((class_1309)this, (class_4140)class_4140.field_18446);
        this.method_5942().method_6340();
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{SUMMON_MONSTER})) {
            if (!anim.isAt("attack")) {
                this.setTargetPositionFromAttackTarget();
            }
            if (anim.isAt("attack")) {
                this.summonMonster();
            }
        }
        if (anim.is(new String[]{SUMMON_TENTACLE})) {
            if (!anim.isAt("attack")) {
                this.setTargetPositionFromAttackTarget();
            }
            if (anim.isAt("attack")) {
                this.summonTentacleAt(this.getTargetPosition());
            }
        }
        if (anim.is(new String[]{SHOOT})) {
            class_1309 target = this.method_5968();
            if (target != null) {
                this.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
            }
            if (anim.isAt("attack")) {
                this.shoot();
            }
        }
    }

    public AnimationHandler<Gilles> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void regenMana(class_1297 source) {
        if (source != this) {
            double amount = this.method_45325(FateAttributes.MANA_LEECH.asHolder());
            this.regenMana(amount * 0.5);
            return;
        }
        super.regenMana(source);
    }

    @Override
    public boolean nobelPhantasmCheck() {
        return this.healthBelow(0.5f) && super.nobelPhantasmCheck();
    }

    public void cthulhu() {
        if (!this.method_37908().field_9236) {
            // empty if block
        }
    }

    protected boolean canSummonMore() {
        return this.method_37908().method_8390(LesserMonster.class, this.method_5829().method_1014(48.0), monster -> this.method_5667().equals(monster.method_6139())).size() < this.props().getConfig(ServantExtraData.GILLES_MONSTER_MAX);
    }

    public void summonMonster() {
        if (!this.method_37908().field_9236 && this.canSummonMore()) {
            int amount = 1;
            if ((double)this.method_6032() < 0.5 * (double)this.method_6063()) {
                amount = 1 + this.method_59922().method_43048(3);
            } else if ((double)this.method_59922().method_43057() < 0.3) {
                ++amount;
            }
            block0: for (int i = 0; i < amount; ++i) {
                LesserMonster minion = new LesserMonster(this.method_37908(), (class_1309)this);
                for (int j = 0; j < 10; ++j) {
                    double x = this.method_23317() + (double)this.field_5974.method_43048(18) - 9.0;
                    double y = this.method_23318() + (double)this.field_5974.method_43048(4) - 2.0;
                    double z = this.method_23321() + (double)this.field_5974.method_43048(18) - 9.0;
                    minion.setRanged((double)this.method_59922().method_43057() < 0.4);
                    minion.method_5641(x, y, z, class_3532.method_15393((float)(this.method_37908().field_9229.method_43057() * 360.0f)), 0.0f);
                    if (!this.method_37908().method_17892((class_1297)minion)) continue;
                    this.method_37908().method_8649((class_1297)minion);
                    minion.method_5980(this.method_5968());
                    this.revealServant();
                    continue block0;
                }
            }
        }
    }

    public void summonTentacleAt(TargetPosition targetPosition) {
        if (!this.method_37908().field_9236) {
            Tentacle tentacle = (Tentacle)((class_1299)FateEntities.TENTACLE.get()).method_5888((class_3218)this.method_37908(), e -> e.setOwner((class_1309)this), class_2338.method_49638((class_2374)targetPosition.position()), class_3730.field_16471, false, false);
            tentacle.setup(targetPosition.position());
            this.method_37908().method_8649((class_1297)tentacle);
        }
    }

    public void shoot() {
        MagicShot proj = new MagicShot(this.method_37908(), (class_1309)this);
        if (this.method_5968() != null) {
            proj.shootAtEntity((class_1297)this.method_5968(), 1.0f, 0.0f);
        } else {
            proj.shoot((class_1297)this, this.method_36455(), this.method_36454(), 0.0f, 1.0f, 0.0f);
        }
        this.method_37908().method_8649((class_1297)proj);
    }

    @Override
    protected String getSummonAnimation() {
        return SUMMON;
    }
}

