/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.fateubw.common.loot.GrailLootEntry;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_173;
import net.minecraft.class_181;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_8548;
import net.minecraft.class_8567;

public class GrailLootTable {
    public static final Codec<GrailLootTable> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("name").forGetter(d -> d.name.getString()), (App)Codec.STRING.listOf().optionalFieldOf("descriptions").forGetter(d -> d.descriptions.isEmpty() ? Optional.empty() : Optional.of(d.descriptions.stream().map(class_2561::getString).toList())), (App)GrailLootEntry.CODEC.listOf().fieldOf("loot_pools").forGetter(d -> d.lootPool), (App)class_5341.field_51809.listOf().optionalFieldOf("conditions").forGetter(d -> d.conditions.isEmpty() ? Optional.empty() : Optional.of(d.conditions))).apply((Applicative)inst, (name, description, pool, conditions) -> new GrailLootTable((String)name, description.orElse(List.of()), (List<GrailLootEntry<?>>)pool, conditions.orElse(List.of()))));
    public final class_2561 name;
    public final List<class_2561> descriptions;
    private final List<GrailLootEntry<?>> lootPool;
    private final List<class_5341> conditions;
    private final Predicate<class_47> combinedConditions;

    public GrailLootTable(String name, List<String> descriptions, List<GrailLootEntry<?>> lootPool, List<class_5341> conditions) {
        this.name = class_2561.method_43471((String)name);
        this.descriptions = descriptions.stream().map(class_2561::method_43471).collect(Collectors.toUnmodifiableList());
        this.lootPool = lootPool;
        this.conditions = conditions;
        this.combinedConditions = class_8548.method_53404(conditions);
    }

    public boolean isEmpty() {
        return this.lootPool.isEmpty() || this.lootPool.stream().noneMatch(GrailLootEntry::valid);
    }

    public void give(class_3222 player) {
        class_8567 params = new class_8567.class_8568(player.method_51469()).method_51871(player.method_7292()).method_51874(class_181.field_24424, (Object)player.method_19538()).method_51874(class_181.field_1226, (Object)player).method_51875(class_173.field_20762);
        class_47 ctx = new class_47.class_48(params).method_60568(player.method_59922()).method_309(Optional.empty());
        if (this.combinedConditions.test(ctx)) {
            this.lootPool.forEach(loot -> loot.give(player, ctx));
        }
    }
}

