/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.loot.entry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.common.loot.GrailLootEntry;
import io.github.flemmli97.fateubw.common.loot.LootSerializerType;
import io.github.flemmli97.fateubw.common.registry.FateGrailLootSerializer;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_5658;
import net.minecraft.class_5659;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class AttributeEntry
extends GrailLootEntry<AttributeEntry> {
    public static final class_2960 ATTRIBUTE_UUID = Fate.modRes("grail_loot_modifier");
    public static final MapCodec<AttributeEntry> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)class_7923.field_41190.method_40294().fieldOf("attribute").forGetter(d -> d.att), (App)Codec.DOUBLE.fieldOf("max").forGetter(d -> d.max), (App)class_5659.field_45888.fieldOf("range").forGetter(d -> d.range), (App)class_5341.field_51809.listOf().optionalFieldOf("conditions").forGetter(d -> d.conditions.isEmpty() ? Optional.empty() : Optional.of(d.conditions))).apply((Applicative)inst, (att, max, range, cond) -> new AttributeEntry((class_6880<class_1320>)att, (double)max, (class_5658)range, cond.orElse(List.of()))));
    private final class_6880<class_1320> att;
    private final double max;
    private final class_5658 range;

    public AttributeEntry(class_6880<class_1320> att, double max, class_5658 range, class_5341 ... conditions) {
        this(att, max, range, List.of(conditions));
    }

    public AttributeEntry(class_6880<class_1320> att, double max, class_5658 range, List<class_5341> conditions) {
        super(conditions);
        this.att = att;
        this.max = max;
        this.range = range;
    }

    @Override
    public Supplier<LootSerializerType<AttributeEntry>> getType() {
        return FateGrailLootSerializer.ATTRIBUTE;
    }

    @Override
    public void accept(class_3222 player, class_47 context) {
        class_1324 inst = player.method_5996(this.att);
        if (inst != null) {
            class_1322 mod = inst.method_6199(ATTRIBUTE_UUID);
            double val = this.range.method_32454(context);
            if (mod != null) {
                val += mod.comp_2449();
                inst.method_6200(ATTRIBUTE_UUID);
            }
            inst.method_26837(new class_1322(ATTRIBUTE_UUID, Math.min(val, this.max), class_1322.class_1323.field_6328));
        }
    }
}

