/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.network;

import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.api.entity.CommandType;
import io.github.flemmli97.fateubw.api.entity.ServantLike;
import io.github.flemmli97.fateubw.common.attachment.PlayerData;
import io.github.flemmli97.fateubw.common.config.CommonConfig;
import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.fateubw.common.utils.Utils;
import io.github.flemmli97.fateubw.common.world.GrailWarHandler;
import io.github.flemmli97.fateubw.platform.Platform;
import io.github.flemmli97.tenshilib.common.utils.HitResultUtils;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3966;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record C2SServantCommand(ActionType command, int entityId) implements class_8710
{
    public static final class_8710.class_9154<C2SServantCommand> TYPE = new class_8710.class_9154(Fate.modRes("c2s_servant_command"));
    public static final class_9139<class_9129, C2SServantCommand> STREAM_CODEC = new class_9139<class_9129, C2SServantCommand>(){

        public C2SServantCommand decode(class_9129 buf) {
            return new C2SServantCommand((ActionType)buf.method_10818(ActionType.class), buf.readInt());
        }

        public void encode(class_9129 buf, C2SServantCommand pkt) {
            buf.method_10817((Enum)pkt.command);
            buf.method_53002(pkt.entityId);
        }
    };

    public static void handle(C2SServantCommand pkt, class_3222 sender) {
        if (sender == null) {
            return;
        }
        PlayerData data = Platform.INSTANCE.getPlayerData((class_1657)sender);
        ServantLike<?> servant = C2SServantCommand.getServant(sender, pkt.entityId);
        if (servant == null) {
            return;
        }
        switch (pkt.command.ordinal()) {
            case 0: {
                servant.onPlayerCommand(sender, pkt.command.as());
                sender.method_43496((class_2561)class_2561.method_43471((String)"fateubw.chat.command.attackservant").method_27692(class_124.field_1061));
                break;
            }
            case 1: {
                servant.onPlayerCommand(sender, pkt.command.as());
                sender.method_43496((class_2561)class_2561.method_43471((String)"fateubw.chat.command.attackall").method_27692(class_124.field_1061));
                break;
            }
            case 2: {
                servant.onPlayerCommand(sender, pkt.command.as());
                sender.method_43496((class_2561)class_2561.method_43471((String)"fateubw.chat.command.defensive").method_27692(class_124.field_1061));
                break;
            }
            case 3: {
                servant.onPlayerCommand(sender, pkt.command.as());
                sender.method_43496((class_2561)class_2561.method_43471((String)"fateubw.chat.command.follow").method_27692(class_124.field_1061));
                break;
            }
            case 4: {
                servant.onPlayerCommand(sender, pkt.command.as());
                sender.method_43496((class_2561)class_2561.method_43471((String)"fateubw.chat.command.stay").method_27692(class_124.field_1061));
                break;
            }
            case 5: {
                servant.onPlayerCommand(sender, pkt.command.as());
                sender.method_43496((class_2561)class_2561.method_43471((String)"fateubw.chat.command.patrol").method_27692(class_124.field_1061));
                break;
            }
            case 6: {
                servant.onPlayerCommand(sender, pkt.command.as());
                break;
            }
            case 7: {
                servant.onPlayerCommand(sender, pkt.command.as());
                sender.method_43496((class_2561)class_2561.method_43471((String)"fateubw.chat.command.kill").method_27692(class_124.field_1061));
                break;
            }
            case 9: {
                servant.get().method_6082(sender.method_23317(), sender.method_23318(), sender.method_23321(), false);
                servant.get().method_5980(null);
                if (!CommonConfig.punishTeleport) break;
                for (BaseServant others : sender.method_37908().method_18467(BaseServant.class, sender.method_5829().method_1014(32.0))) {
                    if (others == servant || Utils.alliedTo((class_1297)sender, (class_1297)others)) continue;
                    others.method_5980((class_1309)sender);
                    others.method_6092(new class_1293(class_1294.field_5904, 1200, 1));
                    others.method_6092(new class_1293(class_1294.field_5915, 2, 3));
                }
                sender.method_6092(new class_1293(class_1294.field_5909, 1200, 1));
                sender.method_6092(new class_1293(class_1294.field_5919, 600, 1));
                break;
            }
            case 8: {
                if (data.useCommandSeal()) {
                    for (class_1293 effect : CommonConfig.npBoostEffect.potions()) {
                        servant.get().method_6092(effect);
                    }
                    sender.method_43496((class_2561)class_2561.method_43471((String)"fateubw.chat.command.spell.success").method_27692(class_124.field_1061));
                    break;
                }
                sender.method_43496((class_2561)class_2561.method_43471((String)"fateubw.chat.command.spell.fail").method_27692(class_124.field_1061));
                break;
            }
            case 10: {
                class_1309 target;
                Object object;
                class_3966 res = HitResultUtils.calculateEntityFromLook((class_1309)sender, (double)16.0);
                if (res == null || !((object = res.method_17782()) instanceof class_1309) || Utils.alliedTo((class_1297)sender, (class_1297)(target = (class_1309)object))) break;
                servant.get().method_5980(target);
                for (BaseServant others : sender.method_37908().method_8390(BaseServant.class, sender.method_5829().method_1014(32.0), s -> sender.method_5667().equals(s.method_6139()))) {
                    others.method_5980(target);
                }
                break;
            }
            case 11: {
                servant.shouldScheduleEntityDataSync(false);
            }
        }
    }

    public static ServantLike<?> getServant(class_3222 sender, int entityId) {
        ServantLike servant;
        block6: {
            block5: {
                if (entityId == -1) {
                    ServantLike servantLike = GrailWarHandler.get(sender.method_5682()).getServant(sender).orElse(null);
                    if (servantLike != null && sender.method_5667().equals(servantLike.method_6139())) {
                        return servantLike;
                    }
                    return null;
                }
                class_1297 entity = sender.method_37908().method_8469(entityId);
                if (!(entity instanceof ServantLike)) break block5;
                servant = (ServantLike)entity;
                if (sender.method_5667().equals(servant.method_6139())) break block6;
            }
            return null;
        }
        return servant;
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static enum ActionType {
        NORMAL,
        AGGRESSIVE,
        DEFENSIVE,
        FOLLOW,
        STAY,
        GUARD,
        NP,
        KILL,
        BOOST,
        TELEPORT,
        TARGET,
        CLOSE;


        public CommandType as() {
            return switch (this.ordinal()) {
                case 0 -> CommandType.NORMAL;
                case 1 -> CommandType.AGGRESSIVE;
                case 2 -> CommandType.DEFENSIVE;
                case 3 -> CommandType.FOLLOW;
                case 4 -> CommandType.STAY;
                case 5 -> CommandType.GUARD;
                case 6 -> CommandType.NP;
                case 7 -> CommandType.KILL;
                default -> null;
            };
        }
    }
}

