/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.network;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.api.entity.ServantLike;
import io.github.flemmli97.fateubw.client.ClientHandler;
import io.github.flemmli97.fateubw.mixin.ClientboundSetEntityDataPacketAccessor;
import io.github.flemmli97.fateubw.mixinhelper.SynchedEntityDataExtension;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class S2CServantGui
implements class_8710 {
    public static final class_8710.class_9154<S2CServantGui> TYPE = new class_8710.class_9154(Fate.modRes("s2c_servant_gui"));
    public static final class_9139<class_9129, S2CServantGui> STREAM_CODEC = new class_9139<class_9129, S2CServantGui>(){

        public S2CServantGui decode(class_9129 buf) {
            return new S2CServantGui(buf.readBoolean(), buf.readBoolean() ? (ServantMetaData)ServantMetaData.STREAM_CODEC.decode((Object)buf) : null);
        }

        public void encode(class_9129 buf, S2CServantGui pkt) {
            buf.method_52964(pkt.open);
            buf.method_52964(pkt.data != null);
            if (pkt.data != null) {
                ServantMetaData.STREAM_CODEC.encode((Object)buf, (Object)pkt.data);
            }
        }
    };
    private final boolean open;
    private final ServantMetaData data;

    private S2CServantGui(boolean open, ServantMetaData data) {
        this.open = open;
        this.data = data;
    }

    private S2CServantGui(class_3222 player, ServantLike<?> servant, boolean open) {
        this.open = open;
        if (servant != null && player.method_5667().equals(servant.method_6139())) {
            this.data = ServantMetaData.of(servant, open);
            if (open) {
                servant.shouldScheduleEntityDataSync(true);
            }
        } else {
            this.data = null;
        }
    }

    public static void sendServantGui(class_3222 player, ServantLike<?> servant) {
        S2CServantGui.sendServantGui(player, servant, true);
    }

    public static void sendServantGui(class_3222 player, ServantLike<?> servant, boolean open) {
        LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CServantGui(player, servant, open), player);
    }

    public static void handle(S2CServantGui pkt) {
        ClientHandler.displayCommandGui(pkt.data, pkt.open);
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public record ServantMetaData(int entityId, class_1299<?> type, Optional<List<Pair<class_1304, class_1799>>> equipment, List<class_2945.class_7834<?>> syncedData, int npCost) {
        public static final class_9139<class_9129, ServantMetaData> STREAM_CODEC = new class_9139<class_9129, ServantMetaData>(){

            public ServantMetaData decode(class_9129 buf) {
                return new ServantMetaData(buf.readInt(), (class_1299)class_7923.field_41177.method_10223(buf.method_10810()), buf.readBoolean() ? Optional.of(buf.method_34066(b -> Pair.of((Object)((class_1304)b.method_10818(class_1304.class)), (Object)((class_1799)class_1799.field_49268.decode((Object)buf))))) : Optional.empty(), ClientboundSetEntityDataPacketAccessor.doUnpack(buf), buf.readInt());
            }

            public void encode(class_9129 buf, ServantMetaData data) {
                buf.method_53002(data.entityId);
                buf.method_10812(class_7923.field_41177.method_10221(data.type()));
                buf.method_52964(data.equipment.isPresent());
                data.equipment.ifPresent(list -> buf.method_34062((Collection)list, (b, p) -> {
                    b.method_10817((Enum)p.getFirst());
                    class_1799.field_49268.encode((Object)buf, (Object)((class_1799)p.getSecond()));
                }));
                ClientboundSetEntityDataPacketAccessor.doPack(data.syncedData, buf);
                buf.method_53002(data.npCost);
            }
        };

        public static ServantMetaData of(ServantLike<?> servantLike, boolean full) {
            Optional<List<Object>> equip;
            Object servant = servantLike.get();
            if (full) {
                ArrayList list = Lists.newArrayList();
                for (class_1304 equipmentSlot : class_1304.values()) {
                    class_1799 itemStack = servant.method_6118(equipmentSlot);
                    if (itemStack.method_7960()) continue;
                    list.add(Pair.of((Object)equipmentSlot, (Object)itemStack.method_7972()));
                }
                equip = Optional.of(list);
            } else {
                equip = Optional.empty();
            }
            return new ServantMetaData(servant.method_5628(), servant.method_5864(), equip, full ? ((SynchedEntityDataExtension)servant.method_5841()).fate$getAll() : servant.method_5841().method_12781(), servantLike.props().manaCost());
        }
    }
}

