/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.particles.trail;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.fateubw.common.particles.trail.TrailProviderRegistry;
import io.github.flemmli97.fateubw.common.particles.trail.provider.TrailData;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2540;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.joml.Vector4f;

public record TrailInfo(float r, float g, float b, float a, float width, float r2, float g2, float b2, float a2, float width2, int interpolation, Visual visual, int textureIndex, TrailData data) {
    private static final Function<String, Codec<Vector4f>> COLOR = suffix -> RecordCodecBuilder.create(builder -> builder.group((App)Codec.FLOAT.fieldOf("r" + suffix).forGetter(Vector4f::x), (App)Codec.FLOAT.fieldOf("g" + suffix).forGetter(Vector4f::y), (App)Codec.FLOAT.fieldOf("b" + suffix).forGetter(Vector4f::z), (App)Codec.FLOAT.fieldOf("a" + suffix).forGetter(Vector4f::w)).apply((Applicative)builder, Vector4f::new));
    public static final Codec<TrailInfo> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)COLOR.apply("").fieldOf("color").forGetter(d -> new Vector4f(d.r, d.g, d.b, d.a)), (App)Codec.FLOAT.fieldOf("scale").forGetter(d -> Float.valueOf(d.width)), (App)COLOR.apply("_2").fieldOf("color_2").forGetter(d -> new Vector4f(d.r2, d.g2, d.b2, d.a2)), (App)Codec.FLOAT.fieldOf("scale_2").forGetter(d -> Float.valueOf(d.width2)), (App)Codec.INT.fieldOf("interpolation").forGetter(d -> d.interpolation), (App)CodecUtils.stringEnumCodec(Visual.class, (Enum)Visual.SOLID).fieldOf("type").forGetter(d -> d.visual), (App)Codec.INT.optionalFieldOf("texture_index").forGetter(d -> d.visual == Visual.SOLID || d.textureIndex == 0 ? Optional.empty() : Optional.of(d.textureIndex)), (App)TrailProviderRegistry.CODEC.fieldOf("provider").forGetter(d -> d.data)).apply((Applicative)builder, (color, scale, color_2, scale_2, interpolation, visual, text, provider) -> new TrailInfo(color.x(), color.y(), color.z(), color.w(), scale.floatValue(), color_2.x(), color_2.y(), color_2.z(), color_2.w(), scale_2.floatValue(), (int)interpolation, (Visual)((Object)((Object)visual)), text.orElse(0), (TrailData)provider)));
    public static final class_9139<class_9129, TrailInfo> STREAM_CODEC = new class_9139<class_9129, TrailInfo>(){

        public TrailInfo decode(class_9129 buf) {
            return new TrailInfo(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readInt(), (Visual)buf.method_10818(Visual.class), buf.readInt(), TrailProviderRegistry.fromBuffer((class_2540)buf));
        }

        public void encode(class_9129 buf, TrailInfo data) {
            buf.method_52941(data.r);
            buf.method_52941(data.g);
            buf.method_52941(data.b);
            buf.method_52941(data.a);
            buf.method_52941(data.width);
            buf.method_52941(data.r2);
            buf.method_52941(data.g2);
            buf.method_52941(data.b2);
            buf.method_52941(data.a2);
            buf.method_52941(data.width2);
            buf.method_53002(data.interpolation);
            buf.method_10817((Enum)data.visual);
            buf.method_53002(data.textureIndex);
            TrailProviderRegistry.toBuffer(data.data, (class_2540)buf);
        }
    };

    public static Builder builder(TrailData provider) {
        return new Builder(provider);
    }

    public static enum Visual {
        SOLID,
        TEXTURE;

    }

    public static class Builder {
        private final TrailData provider;
        private float r = 1.0f;
        private float g = 1.0f;
        private float b = 1.0f;
        private float a = 0.5f;
        private float r2 = 1.0f;
        private float g2 = 1.0f;
        private float b2 = 1.0f;
        private float a2 = 0.5f;
        private float width = 1.0f;
        private float width2;
        private int interpolation = 4;
        private Visual visual = Visual.SOLID;
        private int textureIndex;

        public Builder(TrailData provider) {
            this.provider = provider;
        }

        public Builder setColor(float r, float g, float b, float a) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            return this;
        }

        public Builder setColor2(float r, float g, float b, float a) {
            this.r2 = r;
            this.g2 = g;
            this.b2 = b;
            this.a2 = a;
            return this;
        }

        public Builder setWidth(float width) {
            this.width = width;
            return this;
        }

        public Builder setWidth2(float scale) {
            this.width2 = scale;
            return this;
        }

        public Builder setType(Visual visual, int index) {
            this.visual = visual;
            this.textureIndex = index;
            return this;
        }

        public Builder setInterpolation(int interpolation) {
            this.interpolation = Math.max(1, interpolation);
            return this;
        }

        public TrailInfo build() {
            return new TrailInfo(this.r, this.g, this.b, this.a, this.width, this.r2, this.g2, this.b2, this.a2, this.width2, this.interpolation, this.visual, this.textureIndex, this.provider);
        }
    }
}

