/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.particles.trail.provider;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.fateubw.common.particles.trail.TrailPositions;
import io.github.flemmli97.fateubw.common.particles.trail.TrailProviderRegistry;
import io.github.flemmli97.fateubw.common.particles.trail.provider.TrailData;
import io.github.flemmli97.fateubw.common.particles.trail.provider.TrailProvider;
import io.github.flemmli97.tenshilib.common.utils.StreamCodecs;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class ParticlePositionProvider
implements TrailProvider {
    private final ParticlePositionData data;
    private final Supplier<class_243> positionSup;
    private final IntSupplier lifetime;
    private final TrailPositions position;
    private int ticks;

    public ParticlePositionProvider(ParticlePositionData data, Supplier<class_243> position, IntSupplier lifetime) {
        this.data = data;
        this.positionSup = position;
        this.lifetime = lifetime;
        this.position = new TrailPositions(data.frames());
    }

    @Override
    public TrailPositions positions() {
        return this.position;
    }

    @Override
    public float adjustedPartialTicks(float partialTicks) {
        return this.isFading() ? 1.0f : partialTicks;
    }

    @Override
    public class_243 particleTick() {
        ++this.ticks;
        if (this.isFading()) {
            this.position.add(this.position.getLast());
            return this.position.getLast() != null ? this.position.getLast().pos() : null;
        }
        class_243 pos = this.positionSup.get();
        this.position.add(pos, this.data.normal);
        return pos;
    }

    private int getLifetime() {
        return this.lifetime.getAsInt() + this.data.frames;
    }

    private boolean isFading() {
        return this.ticks >= this.lifetime.getAsInt();
    }

    @Override
    public TrailData data() {
        return this.data;
    }

    @Override
    public boolean removed() {
        return this.ticks >= this.getLifetime();
    }

    public record ParticlePositionData(@Nullable class_243 normal, int frames) implements TrailData
    {
        private static final Codec<class_243> VEC_3_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.DOUBLE.fieldOf("x").forGetter(class_243::method_10216), (App)Codec.DOUBLE.fieldOf("y").forGetter(class_243::method_10214), (App)Codec.DOUBLE.fieldOf("z").forGetter(class_243::method_10215)).apply((Applicative)builder, class_243::new));
        public static final MapCodec<ParticlePositionData> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)VEC_3_CODEC.optionalFieldOf("normal").forGetter(d -> Optional.ofNullable(d.normal)), (App)Codec.INT.fieldOf("frames").forGetter(d -> d.frames)).apply((Applicative)builder, (normal, frames) -> new ParticlePositionData(normal.orElse(null), (int)frames)));
        public static final class_9139<ByteBuf, ParticlePositionData> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.method_56382((class_9139)StreamCodecs.VEC3), d -> Optional.ofNullable(d.normal()), (class_9139)class_9135.field_49675, ParticlePositionData::frames, (n, frames) -> new ParticlePositionData(n.orElse(null), (int)frames));

        public ParticlePositionData(int frames) {
            this(null, frames);
        }

        @Override
        public TrailProviderRegistry.TrailType<?> type() {
            return TrailProviderRegistry.MOTION_TRAIL;
        }

        @Override
        public TrailProvider createProvider(class_1937 level, Supplier<class_243> position, IntSupplier lifetime) {
            return new ParticlePositionProvider(this, position, lifetime);
        }
    }
}

