#version 150

#moj_import <fog.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec2 texCoord0;
in vec4 vertexColor;

out vec4 fragColor;

void main() {
    vec4 colorTex = texture(Sampler0, texCoord0);
    vec4 colorIn = vertexColor * ColorModulator;
    vec4 color = vec4(colorTex.rgb + colorIn.rgb, colorTex.a * colorIn.a);
    if (color.a < 0.1) {
        discard;
    }
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}
