/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.client.gui;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.common.network.C2STeamMessage;
import io.github.flemmli97.fateubw.common.network.C2STeamUuidMessage;
import io.github.flemmli97.fateubw.common.world.GrailTeam;
import io.github.flemmli97.tenshilib.client.gui.widget.TexturedButton;
import io.github.flemmli97.tenshilib.client.gui.widget.list.SelectableListWidget;
import io.github.flemmli97.tenshilib.client.gui.widget.list.SelectableText;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8666;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public class TeamGui
extends class_437 {
    private static final class_2960 WIDGETS = Fate.modRes("textures/gui/widgets.png");
    private static final class_8666 ACCEPT = new class_8666(Fate.modRes("icon/team/accept"), Fate.modRes("icon/team/accept_highlighted"));
    private static final class_8666 DEMOTE = new class_8666(Fate.modRes("icon/team/demote"), Fate.modRes("icon/team/demote_highlighted"));
    private static final class_8666 DENY = new class_8666(Fate.modRes("icon/team/deny"), Fate.modRes("icon/team/deny_highlighted"));
    private static final class_8666 INVITE = new class_8666(Fate.modRes("icon/team/invite"), Fate.modRes("icon/team/invite_highlighted"));
    private static final class_8666 PROMOTE = new class_8666(Fate.modRes("icon/team/promote"), Fate.modRes("icon/team/promote_highlighted"));
    private static final class_8666 UNDO = new class_8666(Fate.modRes("icon/team/undo"), Fate.modRes("icon/team/undo_highlighted"));
    private static final class_8666 BACK = new class_8666(Fate.modRes("widget/button_back"), Fate.modRes("widget/button_back_disabled"), Fate.modRes("widget/button_back_highlighted"));
    private int leftPos;
    private int topPos;
    private GrailTeam.ClientTeamInfo info;
    private boolean admin;
    private Pages page = Pages.MAIN;
    private int sizeX;
    private int sizeY;
    @Nullable
    private class_342 box;
    private class_4185 leaveButton;

    public TeamGui(GrailTeam.ClientTeamInfo info) {
        super((class_2561)class_2561.method_43471((String)"fateubw.gui.team"));
        this.sizeX = Pages.MAIN.sizeX;
        this.sizeY = Pages.MAIN.sizeY;
        this.update(info, false);
    }

    private void changePage(Pages page) {
        this.page = page;
        this.method_37067();
        this.method_25426();
    }

    protected void method_25426() {
        int padding;
        super.method_25426();
        this.sizeX = this.page.sizeX;
        this.sizeY = this.page.sizeY;
        this.leftPos = this.field_22789 / 2 - this.sizeX / 2;
        this.topPos = this.field_22790 / 2 - this.sizeY / 2;
        int y = padding = 12;
        switch (this.page.ordinal()) {
            case 0: {
                int x = this.leftPos + this.sizeX / 2 - 40;
                if (this.info.team().isPresent()) {
                    GrailTeam.ShortTeamInfo team = this.info.team().get();
                    y = this.topPos + 12 + 24;
                    class_4185 invite = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"fateubw.gui.team.invites"), b -> this.changePage(Pages.INVITES)).method_46434(x, y, 80, 20).method_46431());
                    invite.field_22763 = team.admin();
                    this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"fateubw.gui.team.allies"), b -> this.changePage(Pages.ALLIES)).method_46434(x, y += 24, 80, 20).method_46431());
                    this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"fateubw.gui.team.members"), b -> this.changePage(Pages.MEMBERS)).method_46434(x, y += 24, 80, 20).method_46431());
                    if (this.admin) {
                        this.box = (class_342)this.method_37063((class_364)new class_342(this.field_22793, x, this.topPos + 10, 80, 16, (class_2561)class_2561.method_43473()));
                        this.box.field_22764 = false;
                    }
                    this.leaveButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)(team.creator().equals(this.field_22787.field_1724.method_5667()) ? "fateubw.gui.team.disband" : "fateubw.gui.team.leave")).method_27692(class_124.field_1061), b -> LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2STeamMessage(C2STeamMessage.Type.LEAVE, ""))).method_46434(this.leftPos + this.sizeX - padding - 80, this.topPos + this.sizeY - padding - 20, 80, 20).method_46431());
                    this.leaveButton.field_22763 = false;
                    break;
                }
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"fateubw.gui.team.invites"), b -> this.changePage(Pages.INVITES)).method_46434(this.leftPos + this.sizeX - padding - 80, this.topPos + y, 80, 20).method_46431());
                y = this.topPos + this.sizeY - padding - 20 - 24;
                this.box = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.leftPos + this.sizeX / 2 - 60, y, 120, 20, (class_2561)class_2561.method_43473()));
                class_4185 create = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"fateubw.gui.team.create"), b -> {
                    LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2STeamMessage(C2STeamMessage.Type.CREATE, this.box.method_1882()));
                    b.field_22763 = false;
                }).method_46434(this.leftPos + this.sizeX / 2 - 60, y += 24, 120, 20).method_46431());
                create.field_22763 = false;
                this.box.method_1863(s -> {
                    create.field_22763 = !s.isEmpty();
                });
                break;
            }
            case 1: {
                if (this.info.team().isPresent()) {
                    List<Pair> invites = this.info.players().stream().filter(p -> !((GrailTeam.TeamPosition)((Object)((Object)p.getSecond()))).isInTeam()).toList();
                    if (!invites.isEmpty()) {
                        this.method_37063((class_364)new SelectableListWidget(this.leftPos + 25, this.topPos + 37, 170, 128, this.field_22793, invites.stream().map(t -> {
                            if (t.getSecond() == GrailTeam.TeamPosition.INVITED) {
                                return new SelectableText("\u23f3 " + ((GameProfile)t.getFirst()).getName(), new class_124[0]).with(new SelectableText.SelectButton[]{this.getButton(C2STeamUuidMessage.Type.RETRACT_INVITE, ((GameProfile)t.getFirst()).getId())});
                            }
                            return new SelectableText(((GameProfile)t.getFirst()).getName(), new class_124[]{class_124.field_1075}).with(new SelectableText.SelectButton[]{this.getButton(C2STeamUuidMessage.Type.INVITE, ((GameProfile)t.getFirst()).getId())});
                        }).toList()).selectMultiple());
                    }
                } else {
                    this.method_37063((class_364)new SelectableListWidget(this.leftPos + 25, this.topPos + 37, 170, 128, this.field_22793, this.info.invites().stream().map(t -> new SelectableText(t.name(), new class_124[0]).with(new SelectableText.SelectButton[]{this.getButton(C2STeamUuidMessage.Type.ACCEPT_INVITE, t.id()), this.getButton(C2STeamUuidMessage.Type.DENY_INVITE, t.id())})).toList()));
                }
                this.method_37063((class_364)new TexturedButton(this.leftPos + 8, this.topPos + 8, 20, 20, (class_2561)class_2561.method_43473(), b -> this.changePage(Pages.MAIN)).withSprite(BACK));
                break;
            }
            case 2: {
                this.method_37063((class_364)new SelectableListWidget(this.leftPos + 25, this.topPos + 37, 170, 128, this.field_22793, this.info.others().stream().map(t -> {
                    if (t.getSecond() == GrailTeam.TeamStatus.INCOMING_REQUEST) {
                        return new SelectableText("\u2709 " + ((GrailTeam.ShortTeamInfo)t.getFirst()).name(), new class_124[]{class_124.field_1060}).with(new SelectableText.SelectButton[]{this.getButton(C2STeamUuidMessage.Type.ACCEPT_ALLY, ((GrailTeam.ShortTeamInfo)t.getFirst()).id()), this.getButton(C2STeamUuidMessage.Type.DENY_ALLY, ((GrailTeam.ShortTeamInfo)t.getFirst()).id())});
                    }
                    if (t.getSecond() == GrailTeam.TeamStatus.OUTGOING_REQUEST) {
                        return new SelectableText("\u23f3 " + ((GrailTeam.ShortTeamInfo)t.getFirst()).name(), new class_124[0]).with(new SelectableText.SelectButton[]{this.getButton(C2STeamUuidMessage.Type.RETRACT_REQUEST, ((GrailTeam.ShortTeamInfo)t.getFirst()).id())});
                    }
                    if (t.getSecond() == GrailTeam.TeamStatus.ALLY) {
                        return new SelectableText("\ud83d\udee1 " + ((GrailTeam.ShortTeamInfo)t.getFirst()).name(), new class_124[]{class_124.field_1075}).with(new SelectableText.SelectButton[]{this.getButton(C2STeamUuidMessage.Type.DISSOLVE_ALLY, ((GrailTeam.ShortTeamInfo)t.getFirst()).id())});
                    }
                    return new SelectableText(((GrailTeam.ShortTeamInfo)t.getFirst()).name(), new class_124[0]).with(new SelectableText.SelectButton[]{this.getButton(C2STeamUuidMessage.Type.REQUEST_ALLY, ((GrailTeam.ShortTeamInfo)t.getFirst()).id())});
                }).toList()));
                this.method_37063((class_364)new TexturedButton(this.leftPos + 8, this.topPos + 8, 20, 20, (class_2561)class_2561.method_43473(), b -> this.changePage(Pages.MAIN)).withSprite(BACK));
                break;
            }
            case 3: {
                List<Pair> members = this.info.players().stream().filter(p -> ((GrailTeam.TeamPosition)((Object)((Object)p.getSecond()))).isInTeam()).toList();
                if (!members.isEmpty()) {
                    this.method_37063((class_364)new SelectableListWidget(this.leftPos + 25, this.topPos + 37, 170, 128, this.field_22793, members.stream().map(t -> {
                        if (t.getSecond() == GrailTeam.TeamPosition.ADMIN) {
                            return new SelectableText("\u25c7 " + ((GameProfile)t.getFirst()).getName(), new class_124[]{class_124.field_1075}).with(new SelectableText.SelectButton[]{this.getButton(C2STeamUuidMessage.Type.DEMOTE, ((GameProfile)t.getFirst()).getId())});
                        }
                        if (t.getSecond() == GrailTeam.TeamPosition.CREATOR) {
                            return new SelectableText("\u2606 " + ((GameProfile)t.getFirst()).getName(), new class_124[]{class_124.field_1065}).noSelect();
                        }
                        return new SelectableText(((GameProfile)t.getFirst()).getName(), new class_124[0]).with(new SelectableText.SelectButton[]{this.getButton(C2STeamUuidMessage.Type.PROMOTE, ((GameProfile)t.getFirst()).getId()), this.getButton(C2STeamUuidMessage.Type.KICK, ((GameProfile)t.getFirst()).getId())});
                    }).toList()));
                }
                this.method_37063((class_364)new TexturedButton(this.leftPos + 8, this.topPos + 8, 20, 20, (class_2561)class_2561.method_43473(), b -> this.changePage(Pages.MAIN)).withSprite(BACK));
            }
        }
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_25302(this.page.texture, this.leftPos, this.topPos, 0, 0, this.sizeX, this.sizeY);
        if (this.leaveButton != null) {
            this.leaveButton.field_22763 = TeamGui.method_25442();
        }
        if (this.page == Pages.MAIN) {
            if (this.info.team().isPresent()) {
                class_5250 txt = class_2561.method_43469((String)"fateubw.gui.team.name", (Object[])new Object[]{this.info.team().get().name()});
                int width = this.field_22793.method_27525((class_5348)txt);
                graphics.method_51439(this.field_22793, (class_2561)txt, this.leftPos + this.sizeX / 2 - width / 2, this.topPos + 15, 0, false);
                if (this.box != null && !this.box.method_20315()) {
                    boolean vis = this.box.field_22764;
                    this.box.field_22764 = true;
                    if (this.box.method_25405((double)mouseX, (double)mouseY)) {
                        graphics.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"fateubw.gui.team.rename"), mouseX, mouseY);
                    }
                    this.box.field_22764 = vis;
                }
            } else {
                int y = 0;
                for (class_5481 lines : this.field_22793.method_1728((class_5348)class_2561.method_43471((String)"fateubw.gui.team.none"), this.sizeX / 2 - 18)) {
                    graphics.method_51430(this.field_22793, lines, this.leftPos + 18, this.topPos + 18 + y * 11, 0, false);
                    ++y;
                }
            }
        } else {
            class_2561 txt = this.page.title;
            int width = this.field_22793.method_27525((class_5348)txt);
            graphics.method_51439(this.field_22793, txt, this.leftPos + this.sizeX / 2 - width / 2, this.topPos + 12, 0, false);
        }
    }

    private SelectableText.SelectButton getButton(C2STeamUuidMessage.Type type, UUID uuid) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case C2STeamUuidMessage.Type.INVITE, C2STeamUuidMessage.Type.REQUEST_ALLY -> new SelectableText.SelectButton(INVITE, () -> LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2STeamUuidMessage(type, uuid)), () -> this.admin);
            case C2STeamUuidMessage.Type.RETRACT_INVITE, C2STeamUuidMessage.Type.RETRACT_REQUEST -> new SelectableText.SelectButton(UNDO, () -> LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2STeamUuidMessage(type, uuid)), () -> this.admin);
            case C2STeamUuidMessage.Type.ACCEPT_INVITE -> new SelectableText.SelectButton(ACCEPT, () -> LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2STeamUuidMessage(type, uuid)));
            case C2STeamUuidMessage.Type.DENY_INVITE -> new SelectableText.SelectButton(DENY, () -> LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2STeamUuidMessage(type, uuid)));
            case C2STeamUuidMessage.Type.ACCEPT_ALLY -> new SelectableText.SelectButton(ACCEPT, () -> LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2STeamUuidMessage(type, uuid)), () -> this.admin);
            case C2STeamUuidMessage.Type.DENY_ALLY -> new SelectableText.SelectButton(DENY, () -> LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2STeamUuidMessage(type, uuid)), () -> this.admin);
            case C2STeamUuidMessage.Type.KICK, C2STeamUuidMessage.Type.DISSOLVE_ALLY -> new SelectableText.SelectButton(DENY, () -> LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2STeamUuidMessage(type, uuid)), () -> this.admin && class_437.method_25442());
            case C2STeamUuidMessage.Type.PROMOTE -> new SelectableText.SelectButton(PROMOTE, () -> LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2STeamUuidMessage(type, uuid)), () -> this.admin);
            case C2STeamUuidMessage.Type.DEMOTE -> new SelectableText.SelectButton(DEMOTE, () -> LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2STeamUuidMessage(type, uuid)), () -> this.admin && class_437.method_25442());
        };
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.box != null && this.info.team().isPresent()) {
            this.box.field_22764 = true;
            if (this.box.method_25405(mouseX, mouseY)) {
                this.box.method_1852(this.info.team().get().name());
                this.box.method_25365(true);
            } else {
                this.box.field_22764 = false;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.box != null && this.info.team().isPresent() && keyCode == 257) {
            this.box.field_22764 = false;
            this.box.method_25365(false);
            if (!this.box.method_1882().isEmpty()) {
                LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2STeamMessage(C2STeamMessage.Type.RENAME, this.box.method_1882()));
            }
            return true;
        }
        if ((this.box == null || !this.box.method_20315()) && this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        super.method_25419();
        LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2STeamMessage(C2STeamMessage.Type.CLOSE, ""));
    }

    public void update(GrailTeam.ClientTeamInfo info, boolean reInit) {
        this.info = info;
        this.admin = this.info.team().map(GrailTeam.ShortTeamInfo::admin).orElse(false);
        if (this.info.team().isEmpty() && this.page != Pages.MAIN && this.page != Pages.INVITES) {
            this.page = Pages.MAIN;
        }
        if (reInit) {
            this.changePage(this.page);
        }
    }

    private static enum Pages {
        MAIN(Fate.modRes("textures/gui/team_gui_1.png"), null, 220, 160),
        INVITES(Fate.modRes("textures/gui/team_gui_2.png"), (class_2561)class_2561.method_43471((String)"fateubw.gui.team.invites"), 220, 206),
        ALLIES(Fate.modRes("textures/gui/team_gui_2.png"), (class_2561)class_2561.method_43471((String)"fateubw.gui.team.allies"), 220, 206),
        MEMBERS(Fate.modRes("textures/gui/team_gui_2.png"), (class_2561)class_2561.method_43471((String)"fateubw.gui.team.members"), 220, 206);

        public final class_2960 texture;
        public final class_2561 title;
        public final int sizeX;
        public final int sizeY;

        private Pages(class_2960 texture, class_2561 title, int sizeX, int sizeY) {
            this.texture = texture;
            this.title = title;
            this.sizeX = sizeX;
            this.sizeY = sizeY;
        }
    }
}

