/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.client.model;

import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.client.ClientHandler;
import io.github.flemmli97.fateubw.client.model.IPreRenderUpdate;
import io.github.flemmli97.fateubw.common.entity.utils.MoveType;
import io.github.flemmli97.fateubw.common.entity.utils.ServantModelLike;
import io.github.flemmli97.tenshilib.client.data.GeoAnimationManager;
import io.github.flemmli97.tenshilib.client.data.GeoModelManager;
import io.github.flemmli97.tenshilib.client.data.ReloadableCache;
import io.github.flemmli97.tenshilib.client.model.BedrockAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ItemHolderModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartsContainer;
import io.github.flemmli97.tenshilib.client.model.PoseExtended;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3882;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5253;
import net.minecraft.class_583;
import net.minecraft.class_630;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ServantModel<T extends class_1309 & ServantModelLike>
extends class_583<T>
implements ItemHolderModel,
class_3882,
IPreRenderUpdate<T>,
ExtendedModel {
    public static final class_2960 DEFAULT_ANIMATION = Fate.modRes("servant/generic");
    protected final ReloadableCache<ModelPartsContainer> model;
    protected final ReloadableCache<BedrockAnimations> animation;
    protected final ReloadableCache<BedrockAnimations> defaultAnimations;
    public ModelPartsContainer.ModelPartExtended head;
    public ModelPartsContainer.ModelPartExtended body;
    public ModelPartsContainer.ModelPartExtended rightItem;
    public ModelPartsContainer.ModelPartExtended leftItem;
    @Nullable
    public ModelPartsContainer.ModelPartExtended rightArm;
    @Nullable
    public ModelPartsContainer.ModelPartExtended leftArm;
    @Nullable
    public ModelPartsContainer.ModelPartExtended rightLeg;
    @Nullable
    public ModelPartsContainer.ModelPartExtended leftLeg;
    @Nullable
    public ModelPartsContainer.ModelPartExtended vehicleAttachment;
    @Nullable
    private Vector3f bodyVehicleOffset;
    @Nullable
    public ModelPartsContainer.ModelPartExtended leftItemDetached;
    @Nullable
    public ModelPartsContainer.ModelPartExtended rightItemDetached;
    protected final class_630 dummyHead = new class_630(new ArrayList(), new HashMap());
    public int heldItemMain;
    public int heldItemOff;
    private float alpha = -1.0f;

    public ServantModel(class_2960 location) {
        this(location, location);
    }

    public ServantModel(class_2960 modelLocation, class_2960 animationLocation) {
        super(class_1921::method_23580);
        this.model = GeoModelManager.getInstance().getModel(modelLocation, model -> {
            this.head = model.getPart("Head");
            this.body = model.getPart("Body");
            this.rightItem = model.getPart("RightItem");
            this.leftItem = model.getPart("LeftItem");
            this.rightArm = model.getOptionalPart("RightArm").orElse(null);
            this.leftArm = model.getOptionalPart("LeftArm").orElse(null);
            this.rightLeg = model.getOptionalPart("RightLeg").orElse(null);
            this.leftLeg = model.getOptionalPart("LeftLeg").orElse(null);
            this.vehicleAttachment = model.getOptionalPart("VehicleAttachment").orElse(null);
            if (this.vehicleAttachment != null) {
                this.vehicleAttachment.updateDefaultPose(this.vehicleAttachment.getDefaultPose().withScale(0.0f, 0.0f, 0.0f));
                PoseExtended bodyPose = this.body.getDefaultPose();
                PoseExtended attachmentPose = this.vehicleAttachment.getDefaultPose();
                this.bodyVehicleOffset = new Vector3f(attachmentPose.x - bodyPose.x, attachmentPose.y - bodyPose.y, attachmentPose.z - bodyPose.z);
            }
            this.leftItemDetached = model.getOptionalPart("LeftItemStandalone").orElse(null);
            if (this.leftItemDetached != null) {
                this.leftItemDetached.updateDefaultPose(this.leftItemDetached.getDefaultPose().withScale(0.0f, 0.0f, 0.0f));
            }
            this.rightItemDetached = model.getOptionalPart("RightItemStandalone").orElse(null);
            if (this.rightItemDetached != null) {
                this.rightItemDetached.updateDefaultPose(this.rightItemDetached.getDefaultPose().withScale(0.0f, 0.0f, 0.0f));
            }
            this.modelReloadListener((ModelPartsContainer)model);
        });
        this.animation = GeoAnimationManager.getInstance().getAnimation(animationLocation);
        this.defaultAnimations = GeoAnimationManager.getInstance().getAnimation(DEFAULT_ANIMATION);
    }

    protected void modelReloadListener(ModelPartsContainer model) {
    }

    @Override
    public void update(T obj) {
        this.heldItemMain = obj.method_6047().method_7960() ? 0 : 1;
        this.heldItemOff = obj.method_6079().method_7960() ? 0 : 1;
    }

    public ModelPartsContainer getModel() {
        return (ModelPartsContainer)this.model.get();
    }

    public void transform(class_1306 hand, class_4587 stack) {
        if (hand == class_1306.field_6182) {
            boolean detached;
            boolean bl = detached = this.leftItemDetached != null && this.leftItemDetached.xScale != 0.0f && this.leftItemDetached.yScale != 0.0f && this.leftItemDetached.zScale != 0.0f && this.leftItemDetached.visible;
            if (detached) {
                this.leftItemDetached.translateAndRotateWithParents(stack);
            } else if (this.leftItem != null) {
                this.leftItem.translateAndRotateWithParents(stack);
            }
        } else {
            boolean detached;
            boolean bl = detached = this.rightItemDetached != null && this.rightItemDetached.xScale != 0.0f && this.rightItemDetached.yScale != 0.0f && this.rightItemDetached.zScale != 0.0f && this.rightItemDetached.visible;
            if (detached) {
                this.rightItemDetached.translateAndRotateWithParents(stack);
            } else if (this.rightItem != null) {
                this.rightItem.translateAndRotateWithParents(stack);
            }
        }
    }

    public class_630 method_2838() {
        this.dummyHead.field_3657 = this.head.x;
        this.dummyHead.field_3656 = this.head.y;
        this.dummyHead.field_3655 = this.head.z;
        this.dummyHead.field_3654 = this.head.xRot;
        this.dummyHead.field_3675 = this.head.yRot;
        this.dummyHead.field_3674 = this.head.zRot;
        this.dummyHead.field_37938 = this.head.xScale;
        this.dummyHead.field_37939 = this.head.yScale;
        this.dummyHead.field_37940 = this.head.zScale;
        return this.dummyHead;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTicks = ClientHandler.getPartialTicks();
        this.preAnimSetup(entity, limbSwing, limbSwingAmount, netHeadYaw, headPitch, partialTicks);
        if (((ServantModelLike)entity).isStaying()) {
            ((BedrockAnimations)this.animation.get()).doAnimation((ExtendedModel)this, "stay", ((class_1309)entity).field_6012, partialTicks);
        } else {
            ((BedrockAnimations)this.animation.get()).doAnimation((ExtendedModel)this, ((AnimatedEntity)entity).getAnimationHandler(), partialTicks, ((ServantModelLike)entity).flipAnimation());
        }
        if (entity.method_5765() && entity.method_5854() != null) {
            this.body.x = this.body.getDefaultPose().x;
            this.body.y = this.body.getDefaultPose().y;
            this.body.z = this.body.getDefaultPose().z;
            class_4587 stack = new class_4587();
            this.body.translateAndRotate(stack);
            Vector3f v = this.bodyVehicleOffset != null ? new Vector3f((Vector3fc)this.bodyVehicleOffset) : new Vector3f();
            v.mulTranspose((Matrix3fc)stack.method_23760().method_23762());
            this.body.x += v.x() - this.bodyVehicleOffset.x;
            this.body.y += v.y() - this.bodyVehicleOffset.y;
            this.body.z += v.z() - this.bodyVehicleOffset.z;
        }
        this.alpha = entity.method_29504() && ((ServantModelLike)entity).getDeathAnimation() == null ? Math.max(0.15f, 1.0f - (float)((class_1309)entity).field_6213 / (float)((ServantModelLike)entity).maxDeathTick()) : -1.0f;
    }

    public void preAnimSetup(T entity, float limbSwing, float limbSwingAmount, float netHeadYaw, float headPitch, float partialTicks) {
        ((ModelPartsContainer)this.model.get()).resetPoses();
        BedrockAnimations animation = (BedrockAnimations)this.animation.get();
        this.setupAnimationValues(animation, limbSwing, limbSwingAmount, netHeadYaw, headPitch);
        BedrockAnimations defaulted = (BedrockAnimations)this.defaultAnimations.get();
        this.setupAnimationValues(defaulted, limbSwing, limbSwingAmount, netHeadYaw, headPitch);
        String idle = this.getWeaponBasedAnimationFor(entity, animation, "idle_with_weapon", "idle", null);
        if (idle == null) {
            defaulted.doAnimation((ExtendedModel)this, "idle", ((class_1309)entity).field_6012, partialTicks, 1.0f);
        } else {
            animation.doAnimation((ExtendedModel)this, idle, ((class_1309)entity).field_6012, partialTicks, 1.0f);
        }
        String walk = this.getWeaponBasedAnimationFor(entity, animation, "walk_with_weapon", "walk", null);
        if (walk == null) {
            defaulted.doAnimation((ExtendedModel)this, "walk", ((class_1309)entity).field_6012, partialTicks, 1.0f, false, true);
        } else {
            animation.doAnimation((ExtendedModel)this, walk, ((class_1309)entity).field_6012, partialTicks, ((ServantModelLike)entity).interpolatedMoveTick(partialTicks), false, true);
        }
        animation.doAnimation((ExtendedModel)this, this.getWeaponBasedAnimationFor(entity, animation, "run_with_weapon", "run"), ((class_1309)entity).field_6012, partialTicks, ((ServantModelLike)entity).interpolatedMoveTickOf(MoveType.RUN, partialTicks), false, true);
        if (entity.method_5765() && entity.method_5854() != null) {
            if (this.field_3449) {
                if (animation.has("riding")) {
                    animation.doAnimation((ExtendedModel)this, "riding", ((class_1309)entity).field_6012, partialTicks, 1.0f, false, true);
                } else {
                    defaulted.doAnimation((ExtendedModel)this, "riding", ((class_1309)entity).field_6012, partialTicks, 1.0f, false, true);
                }
            } else if (animation.has("riding_standing")) {
                animation.doAnimation((ExtendedModel)this, "riding_standing", ((class_1309)entity).field_6012, partialTicks, 1.0f, false, true);
            } else {
                defaulted.doAnimation((ExtendedModel)this, "riding_standing", ((class_1309)entity).field_6012, partialTicks, 1.0f, false, true);
            }
        }
    }

    protected void setupAnimationValues(BedrockAnimations animation, float limbSwing, float limbSwingAmount, float netHeadYaw, float headPitch) {
        animation.setVariable("query.head_x_rotation", () -> headPitch);
        animation.setVariable("query.head_y_rotation", () -> netHeadYaw);
        animation.setVariable("left_held", () -> this.heldItemOff);
        animation.setVariable("left_arm_x_rot", () -> this.leftArm != null ? (double)(this.leftArm.xRot * 57.295776f) : 0.0);
        animation.setVariable("right_held", () -> this.heldItemMain);
        animation.setVariable("right_arm_x_rot", () -> this.rightArm != null ? (double)(this.rightArm.xRot * 57.295776f) : 0.0);
        animation.setVariable("limb_swing", () -> limbSwing * 57.295776f);
        animation.setVariable("limb_swing_amount", () -> limbSwingAmount * 57.295776f);
    }

    protected String getWeaponBasedAnimationFor(T entity, BedrockAnimations animations, String either, String or) {
        return this.getWeaponBasedAnimationFor(entity, animations, either, or, or);
    }

    protected String getWeaponBasedAnimationFor(T entity, BedrockAnimations animations, String either, String either2, String or) {
        if (((ServantModelLike)entity).hasOwnWeapon() && animations.has(either)) {
            return either;
        }
        if (animations.has(either2)) {
            return either2;
        }
        return or;
    }

    public void method_2828(class_4587 poseStack, class_4588 buffer, int packedLight, int packedOverlay, int color) {
        if (this.alpha != -1.0f) {
            color = class_5253.class_5254.method_58144((int)((int)(this.alpha * 255.0f)), (int)color);
        }
        ((ModelPartsContainer)this.model.get()).getRoot().render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public void method_17081(class_583<T> model) {
        super.method_17081(model);
        if (model instanceof ServantModel) {
            ServantModel other = (ServantModel)model;
            other.heldItemMain = this.heldItemMain;
            other.heldItemOff = this.heldItemOff;
        }
    }
}

