/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.flemmli97.fateubw.common.attachment.PlayerData;
import io.github.flemmli97.fateubw.common.datapack.DatapackHandler;
import io.github.flemmli97.fateubw.common.loot.GrailLootTable;
import io.github.flemmli97.fateubw.common.loot.entry.AttributeEntry;
import io.github.flemmli97.fateubw.common.world.GrailWarHandler;
import io.github.flemmli97.fateubw.mixin.AttributeMapAccessor;
import io.github.flemmli97.fateubw.platform.Platform;
import java.util.Collection;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class CommandHandler {
    public static SuggestionProvider<class_2168> GRAILLOOTSUGGESTION = (ctx, builder) -> class_2172.method_9257(DatapackHandler.getAllTables().stream(), (SuggestionsBuilder)builder);

    public static void reg(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"fateubw").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").requires(src -> src.method_9259(2))).executes(CommandHandler::resetWar)).then(class_2170.method_9247((String)"attributes").then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(CommandHandler::resetAttributes))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"start").requires(src -> src.method_9259(2))).executes(CommandHandler::startWar))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"loot").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests(GRAILLOOTSUGGESTION).then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(CommandHandler::giveLoot))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"command_spell").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> CommandHandler.modifyCommandspell((CommandContext<class_2168>)ctx, CommnandMode.SET)))))).then(class_2170.method_9247((String)"give").then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> CommandHandler.modifyCommandspell((CommandContext<class_2168>)ctx, CommnandMode.ADD)))))).then(class_2170.method_9247((String)"take").then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> CommandHandler.modifyCommandspell((CommandContext<class_2168>)ctx, CommnandMode.TAKE)))))));
    }

    private static int startWar(CommandContext<class_2168> ctx) {
        if (!GrailWarHandler.get(((class_2168)ctx.getSource()).method_9211()).forceStartGrailWar()) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43471((String)"fateubw.command.war.start.fail"));
            return 0;
        }
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43471((String)"fateubw.command.war.start"), false);
        return 1;
    }

    private static int resetWar(CommandContext<class_2168> ctx) {
        GrailWarHandler.get(((class_2168)ctx.getSource()).method_9211()).reset(true);
        return 1;
    }

    private static int giveLoot(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        Collection players = class_2186.method_9312(ctx, (String)"players");
        class_2960 id = class_2232.method_9443(ctx, (String)"id");
        GrailLootTable loot = DatapackHandler.getLootTable(id).orElse(null);
        if (loot == null) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"fateubw.command.loot.none", (Object[])new Object[]{id.toString()}), false);
            return 0;
        }
        players.forEach(loot::give);
        if (players.size() == 1) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"fateubw.command.loot.give.single", (Object[])new Object[]{((class_3222)players.iterator().next()).method_5476(), id.toString()}), false);
        } else {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"fateubw.command.loot.give", (Object[])new Object[]{((class_3222)players.iterator().next()).method_5476(), id.toString()}), false);
        }
        return 1;
    }

    private static int resetAttributes(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        Collection players = class_2186.method_9312(ctx, (String)"players");
        players.forEach(player -> ((AttributeMapAccessor)player.method_6127()).getAttributes().forEach((att, inst) -> inst.method_6200(AttributeEntry.ATTRIBUTE_UUID)));
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"fateubw.command.attributes.reset", (Object[])new Object[]{players}), false);
        return 1;
    }

    private static int modifyCommandspell(CommandContext<class_2168> ctx, CommnandMode mode) throws CommandSyntaxException {
        Collection players = class_2186.method_9312(ctx, (String)"players");
        int amount = IntegerArgumentType.getInteger(ctx, (String)"amount");
        players.forEach(player -> {
            PlayerData data = Platform.INSTANCE.getPlayerData((class_1657)player);
            int count = switch (mode.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> amount;
                case 1 -> data.getCommandSeals() - amount;
                case 2 -> data.getCommandSeals() + amount;
            };
            data.setCommandSeals(count);
        });
        switch (mode.ordinal()) {
            case 0: {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"fateubw.command.spells.set", (Object[])new Object[]{players, amount}), false);
                break;
            }
            case 1: {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"fateubw.command.spells.take", (Object[])new Object[]{players, amount}), false);
                break;
            }
            case 2: {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"fateubw.command.spells.add", (Object[])new Object[]{players, amount}), false);
            }
        }
        return players.size();
    }

    private static enum CommnandMode {
        SET,
        TAKE,
        ADD;

    }
}

