/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.datapack;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.api.datapack.AttributeHolderProperties;
import io.github.flemmli97.fateubw.api.datapack.ServantProperties;
import io.github.flemmli97.fateubw.common.config.CommonConfig;
import io.github.flemmli97.fateubw.common.datapack.ListenerExtension;
import io.github.flemmli97.fateubw.common.lib.BuiltinServantClasses;
import io.github.flemmli97.fateubw.common.registry.FateDataComponents;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public class EntityPropsManager
extends class_4309
implements ListenerExtension {
    public static final class_2960 ID = Fate.modRes("entity_properties");
    public static final String DIRECTORY = String.format("%s/%s", ID.method_12836(), ID.method_12832());
    private static final Gson GSON = new GsonBuilder().create();
    private Map<class_1299<?>, ServantProperties> props = ImmutableMap.of();
    private Map<class_1299<?>, AttributeHolderProperties> genericProps = ImmutableMap.of();
    private Set<EntityTypeAndID> servants = ImmutableSet.of();
    private class_7225.class_7874 provider;

    public EntityPropsManager() {
        super(GSON, DIRECTORY);
    }

    public ServantProperties get(class_1299<?> type) {
        return this.props.getOrDefault(type, ServantProperties.DEFAULT);
    }

    public AttributeHolderProperties getGeneric(class_1299<?> type) {
        return this.genericProps.getOrDefault(type, AttributeHolderProperties.DEFAULT);
    }

    public Set<EntityTypeAndID> getServants() {
        return this.servants;
    }

    public Optional<EntityTypeAndID> getRandom(class_5819 random, Predicate<EntityTypeAndID> check, class_1799 stack) {
        Set<EntityTypeAndID> servants = this.getServants();
        List<EntityTypeAndID> entities = servants.stream().filter(check).map(entry -> entry.updatedWeight(stack)).filter(entry -> entry.weight > 0.0).toList();
        if (entities.isEmpty()) {
            return Optional.empty();
        }
        double weight = entities.stream().mapToDouble(t -> t.weight).sum();
        if (weight > 0.0) {
            double idx = random.method_43058() * weight;
            for (EntityTypeAndID weightedEntry : entities) {
                if (!((idx -= weightedEntry.weight()) < 0.0)) continue;
                return Optional.of(weightedEntry);
            }
        }
        return Optional.empty();
    }

    protected void apply(Map<class_2960, JsonElement> data, class_3300 manager, class_3695 profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableMap.Builder attBuilder = ImmutableMap.builder();
        class_6903 ops = this.provider.method_57093((DynamicOps)JsonOps.INSTANCE);
        data.forEach((arg_0, arg_1) -> EntityPropsManager.lambda$apply$4((DynamicOps)ops, builder, attBuilder, arg_0, arg_1));
        this.props = builder.build();
        this.genericProps = attBuilder.build();
        HashSet servants = new HashSet();
        this.props.forEach((type, prop) -> {
            if (!prop.servantClass().equals((Object)BuiltinServantClasses.NONE)) {
                servants.add(new EntityTypeAndID(class_7923.field_41177.method_47983(type), prop.servantClass(), prop.weight()));
            }
        });
        this.servants = ImmutableSet.copyOf(servants);
    }

    @Override
    public class_2960 id() {
        return ID;
    }

    @Override
    public void insertRegistryAccess(class_7225.class_7874 provider) {
        this.provider = provider;
    }

    private static /* synthetic */ void lambda$apply$4(DynamicOps ops, ImmutableMap.Builder builder, ImmutableMap.Builder attBuilder, class_2960 fres, JsonElement el) {
        try {
            class_7923.field_41177.method_17966(fres).ifPresent(type -> {
                Optional servantProps = ServantProperties.CODEC.parse(ops, (Object)el).result();
                if (servantProps.isPresent()) {
                    builder.put(type, (Object)((ServantProperties)servantProps.get()));
                } else {
                    AttributeHolderProperties props = (AttributeHolderProperties)AttributeHolderProperties.CODEC.parse(ops, (Object)el).getOrThrow();
                    attBuilder.put(type, (Object)props);
                }
            });
        }
        catch (Exception ex) {
            Fate.LOGGER.error("Couldn't parse entity properties json {} {}", (Object)fres, (Object)ex, (Object)ex.fillInStackTrace());
        }
    }

    public record EntityTypeAndID(class_6880<class_1299<?>> type, class_2960 servantClass, double weight) {
        public EntityTypeAndID updatedWeight(@Nullable class_1799 stack) {
            if (stack == null) {
                return this;
            }
            class_2960 clss = (class_2960)stack.method_57824((class_9331)FateDataComponents.CLASS_RELIC.get());
            class_2960 servant = (class_2960)stack.method_57824((class_9331)FateDataComponents.SERVANT_RELIC.get());
            double weight = this.weight;
            if (this.servantClass().equals((Object)clss)) {
                weight *= CommonConfig.classArtifactMultiplier;
            }
            if (this.type().method_40226(servant)) {
                weight *= CommonConfig.servantArtifactMultiplier;
            }
            if (this.weight == weight) {
                return this;
            }
            return new EntityTypeAndID(this.type(), this.servantClass(), weight);
        }

        public class_2960 id() {
            return ((class_5321)this.type().method_40230().orElseThrow()).method_29177();
        }
    }
}

