/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity;

import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.api.datapack.ServantProperties;
import io.github.flemmli97.fateubw.api.entity.CommandType;
import io.github.flemmli97.fateubw.api.entity.ServantLike;
import io.github.flemmli97.fateubw.common.attachment.PlayerData;
import io.github.flemmli97.fateubw.common.datapack.DatapackHandler;
import io.github.flemmli97.fateubw.common.entity.HeldEquipmentHandler;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.BehaviourUtils;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.SetTargetFromRider;
import io.github.flemmli97.fateubw.common.entity.utils.MoveStateTracker;
import io.github.flemmli97.fateubw.common.entity.utils.MoveType;
import io.github.flemmli97.fateubw.common.entity.utils.ServantModelLike;
import io.github.flemmli97.fateubw.common.entity.utils.TargetableOpponent;
import io.github.flemmli97.fateubw.common.lib.FateTags;
import io.github.flemmli97.fateubw.common.network.S2CAttackDebug;
import io.github.flemmli97.fateubw.common.network.S2CServantGui;
import io.github.flemmli97.fateubw.common.particles.trail.provider.entity.EntityWeaponTrailHolder;
import io.github.flemmli97.fateubw.common.particles.trail.provider.entity.EntityWeaponTrailHolderProvider;
import io.github.flemmli97.fateubw.common.registry.FateActivities;
import io.github.flemmli97.fateubw.common.registry.FateAttributes;
import io.github.flemmli97.fateubw.common.registry.FateDamageTypes;
import io.github.flemmli97.fateubw.common.registry.FateMemoryTypes;
import io.github.flemmli97.fateubw.common.registry.FateParticles;
import io.github.flemmli97.fateubw.common.utils.ExtendedCombatRules;
import io.github.flemmli97.fateubw.common.utils.MathsHelper;
import io.github.flemmli97.fateubw.common.utils.Utils;
import io.github.flemmli97.fateubw.common.world.GrailWarHandler;
import io.github.flemmli97.fateubw.platform.Platform;
import io.github.flemmli97.tenshilib.common.entity.AOEAttackEntity;
import io.github.flemmli97.tenshilib.common.entity.ai.MoveControllerPlus;
import io.github.flemmli97.tenshilib.common.entity.ai.TargetPosition;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetMoveToRestriction;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinition;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedMobDataHandler;
import io.github.flemmli97.tenshilib.common.item.SpawnEgg;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1408;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3902;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4168;
import net.minecraft.class_4209;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5862;
import net.minecraft.class_5863;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8103;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.AllApplicableBehaviours;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FollowEntity;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.InteractWithDoor;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.navigation.SmoothGroundNavigation;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public abstract class BaseServant
extends class_1314
implements AnimatedEntity,
AOEAttackEntity,
TargetableOpponent,
EntityWeaponTrailHolderProvider,
ServantModelLike,
ServantLike<BaseServant>,
SmartBrainOwner<BaseServant>,
SyncedMobDataHandler {
    public static final int MOVE_TICK_MAX = 3;
    protected static final class_2960 MANA_LEECH_DEBUFF_ID = Fate.modRes("mana_leech_debuff");
    protected static final class_2940<Boolean> SHOW_SERVANT = class_2945.method_12791(BaseServant.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Boolean> STATIONARY = class_2945.method_12791(BaseServant.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Optional<UUID>> OWNER_UUID = class_2945.method_12791(BaseServant.class, (class_2941)class_2943.field_13313);
    protected static final class_2940<Byte> MOVE_FLAGS = class_2945.method_12791(BaseServant.class, (class_2941)class_2943.field_13319);
    public static final TypedResource<TargetPosition> TARGET_POSITION = new TypedResource(Fate.modRes("target_position"));
    protected static final Vector4f SUMMON_COLOR = new Vector4f(0.23529412f, 0.4627451f, 0.78039217f, 0.8f);
    private final SyncedDataContainer<BaseServant> syncedDataContainer;
    private double servantMana = 100.0;
    private double manaRegenCounter;
    private double nobelPhantasmCooldown;
    private int manaLeechDebuffDuration;
    protected boolean commandNPUse;
    protected CommandType commandBehaviour = CommandType.NORMAL;
    protected AttackBehaviour attackBehaviour = AttackBehaviour.NORMAL;
    private class_1657 owner;
    private final class_2561 hogou;
    private final ServantProperties prop;
    public final Predicate<class_1309> targetPred = Utils.servantTargetPredicate((class_1308)this);
    private final MoveStateTracker moveStateTracker = new MoveStateTracker((class_1309)this, 3, MOVE_FLAGS, this::calculateMoveType);
    private final List<class_3222> tracked = new ArrayList<class_3222>();
    private boolean sendToOwnerData;
    private boolean initAnim;
    private final EntityWeaponTrailHolder<BaseServant> trailHolder = new EntityWeaponTrailHolder<BaseServant>(this);

    public BaseServant(class_1299<? extends BaseServant> entityType, class_1937 level) {
        super(entityType, level);
        SyncedDataContainer.Builder builder = SyncedDataContainer.builder((class_1297)this);
        this.definedAdditinoalSyncedData((SyncedDataContainer.Builder<BaseServant>)builder);
        this.syncedDataContainer = builder.build();
        this.field_6207 = new MoveControllerPlus((class_1308)this);
        this.field_6194 = 35;
        this.prop = DatapackHandler.SERVANT_PROPS.get(this.method_5864());
        if (!level.field_9236) {
            this.updateAttributes();
        }
        this.hogou = class_2561.method_43471((String)(String.valueOf(class_7923.field_41177.method_10221((Object)this.method_5864())) + ".hogou"));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23717, 32.0).method_26868(class_5134.field_23718, 1.0).method_26867(FateAttributes.MAGIC_ATTACK.asHolder()).method_26867(FateAttributes.MAGIC_RESISTANCE.asHolder()).method_26867(FateAttributes.PROJECTILE_BLOCK_CHANCE.asHolder()).method_26867(FateAttributes.PROJECTILE_RESISTANCE.asHolder()).method_26867(FateAttributes.COMBAT_REGEN.asHolder()).method_26867(FateAttributes.PASSIVE_REGEN.asHolder()).method_26868(FateAttributes.MANA_REGEN.asHolder(), 1.0).method_26868(FateAttributes.MANA_LEECH.asHolder(), 1.0);
    }

    private void updateAttributes() {
        this.prop.attributes().forEach((att, val) -> {
            class_1324 inst = this.method_5996((class_6880)att);
            if (inst != null) {
                inst.method_6192(val.doubleValue());
                if (att == class_5134.field_23716) {
                    this.method_6033(this.method_6063());
                }
            }
        });
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(STATIONARY, (Object)false);
        builder.method_56912(SHOW_SERVANT, (Object)false);
        builder.method_56912(OWNER_UUID, Optional.empty());
        builder.method_56912(MOVE_FLAGS, (Object)0);
    }

    protected void definedAdditinoalSyncedData(SyncedDataContainer.Builder<BaseServant> builder) {
        builder.define(TARGET_POSITION, (SyncedEntityData)TenshilibSyncableEntityDatas.TARGET_POS.get(), null);
    }

    public SyncedDataContainer<?> getDataContainer() {
        return this.syncedDataContainer;
    }

    protected class_1408 method_5965(class_1937 level) {
        SmoothGroundNavigation nav = new SmoothGroundNavigation((class_1308)this, level);
        nav.method_6363(true);
        nav.method_35139(true);
        return nav;
    }

    public List<? extends ExtendedSensor<? extends BaseServant>> getSensors() {
        return List.of(new NearbyPlayersSensor(), new NearbyLivingEntitySensor().setPredicate((target, entity) -> entity.targetPred.test((class_1309)target)).setScanRate(e -> 10), new HurtBySensor().setPredicate((source, entity) -> {
            class_1297 patt0$temp = source.method_5529();
            if (patt0$temp instanceof class_1309) {
                class_1309 attacker = (class_1309)patt0$temp;
                return !Utils.alliedTo((class_1297)entity, (class_1297)attacker);
            }
            return true;
        }));
    }

    public BrainActivityGroup<? extends BaseServant> getCoreTasks() {
        return BrainActivityGroup.coreTasks((class_4097[])new class_4097[]{new FloatToSurfaceOfFluid(), new SetTargetFromRider(), new InteractWithDoor(), new FollowEntity().following(BaseServant::getOwner).teleportToTargetAfter(17.0).stopFollowingWithin(6.0).speedMod(1.1f).startCondition(m -> m.commandBehaviour == CommandType.FOLLOW), this.lookBehaviour(), new LookAtTarget().runFor(entity -> entity.method_59922().method_39332(40, 100)).whenStopping(m -> BrainUtils.clearMemory((class_1309)m, (class_4140)class_4140.field_18446))});
    }

    protected ExtendedBehaviour<? extends BaseServant> lookBehaviour() {
        return new AllApplicableBehaviours(new ExtendedBehaviour[]{new LookAtAttackTarget(), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomLookTarget().lookChance((class_5863)class_5862.method_33908((float)1.0f)), new SetPlayerLookTarget()}).startCondition(m -> (double)m.method_59922().method_43057() < 0.1 && !BrainUtils.hasMemory((class_1309)m, (class_4140)class_4140.field_18445))}).startCondition(e -> !BrainUtils.hasMemory((class_1309)e, (class_4140)class_4140.field_22355) && !e.method_6113() && !e.getAnimationHandler().hasAnimation());
    }

    public BrainActivityGroup<? extends BaseServant> getIdleTasks() {
        return BrainActivityGroup.idleTasks((class_4097[])new class_4097[]{new MoveToWalkTarget(), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate().attackablePredicate(entity -> {
            if (entity == BrainUtils.getMemory((class_1309)this, (class_4140)class_4140.field_18452)) {
                return true;
            }
            if (entity instanceof class_1569 && this.attackBehaviour == AttackBehaviour.AGGRESSIVE) {
                return true;
            }
            return entity instanceof ServantLike;
        }), new SetMoveToRestriction(), this.getWanderBehaviour().startCondition(m -> m.method_59922().method_43048(120) == 0)})});
    }

    public BrainActivityGroup<? extends BaseServant> getFightTasks() {
        return BrainActivityGroup.fightTasks((class_4097[])new class_4097[]{new InvalidateAttackTarget(), this.getCooldownAI().startCondition(BehaviourUtils::runCooldownBehaviour).stopIf(e -> !BehaviourUtils.runCooldownBehaviour(e)), this.getCombatAI().startCondition(BehaviourUtils::runCombatBehaviour)});
    }

    public ExtendedBehaviour<? extends BaseServant> getCombatAI() {
        return new Idle();
    }

    public ExtendedBehaviour<? extends BaseServant> getCooldownAI() {
        return new Idle();
    }

    public Map<class_4168, BrainActivityGroup<? extends BaseServant>> getAdditionalTasks() {
        HashMap<class_4168, BrainActivityGroup<? extends BaseServant>> map = new HashMap<class_4168, BrainActivityGroup<? extends BaseServant>>();
        map.put((class_4168)FateActivities.STAY.get(), new BrainActivityGroup((class_4168)FateActivities.STAY.get()).priority(20).behaviours(new class_4097[]{new Idle()}).onlyStartWithMemoryStatus((class_4140)FateMemoryTypes.STAYING.get(), class_4141.field_18456));
        return map;
    }

    public List<class_4168> getActivityPriorities() {
        return ObjectArrayList.of((Object[])new class_4168[]{(class_4168)FateActivities.STAY.get(), class_4168.field_22396, class_4168.field_18595});
    }

    protected ExtendedBehaviour<? extends BaseServant> getWanderBehaviour() {
        return new SetRandomWalkTarget();
    }

    protected class_4095.class_5303<?> method_28306() {
        return new SmartBrainProvider((class_1309)this);
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    public void method_5773() {
        if (!this.initAnim) {
            this.getAnimationHandler().withChangeListener(anim -> {
                if (!this.method_37908().field_9236 && this.getTargetPosition() != null) {
                    this.setTargetPosition((TargetPosition)null);
                }
                if (anim != null) {
                    this.setupAttack((AnimationDefinition)anim);
                }
                return false;
            });
            this.initAnim = true;
        }
        super.method_5773();
        class_243 lookDir = this.directionToLookAt();
        if (lookDir != null) {
            float[] yxRot = MathsHelper.YXRotFrom(lookDir);
            float[] clamp = this.targetLookClamp();
            this.method_36456(MathsHelper.rotlerp(this.method_36454(), yxRot[0], clamp[0]));
            this.method_36457(MathsHelper.rotlerp(this.method_36455(), yxRot[1], clamp[1]));
            this.method_5636(this.method_36454());
            this.method_5847(this.method_36454());
        }
        this.getTrailHolder().tick();
        this.trackingTick();
    }

    public void method_6007() {
        super.method_6007();
        this.getAnimationHandler().tick();
        this.moveStateTracker.tick();
        if (this.getSummonAnimation() != null && this.getAnimationHandler().isCurrent(new String[]{this.getSummonAnimation()})) {
            this.method_18799(class_243.field_1353);
            this.method_5942().method_6340();
        }
        if (this.method_37908() instanceof class_3218) {
            class_3222 serverPlayer;
            this.nobelPhantasmCooldown -= 1.0;
            this.regenMana();
            --this.manaLeechDebuffDuration;
            if (this.manaLeechDebuffDuration == 0) {
                class_1324 inst = this.method_5996(FateAttributes.MANA_LEECH.asHolder());
                inst.method_6200(MANA_LEECH_DEBUFF_ID);
            }
            this.getAnimationHandler().runIfNotNull(this::handleAttack);
            class_1657 class_16572 = this.getOwner();
            if (class_16572 instanceof class_3222 && !this.tracked.contains(serverPlayer = (class_3222)class_16572) && !this.method_31481() && this.sendToOwnerData) {
                S2CServantGui.sendServantGui(serverPlayer, this, false);
            }
            if (this.method_5968() != null && this.method_5968().method_5854() instanceof class_1309) {
                this.method_5980((class_1309)this.method_5968().method_5854());
            }
        }
    }

    public void method_5958() {
        super.method_5958();
        this.tickBrain((class_1309)this);
    }

    @Override
    public float interpolatedMoveTick(float partialTicks) {
        return this.moveStateTracker.interpolatedMoveTick(partialTicks);
    }

    @Override
    public float interpolatedMoveTickOf(MoveType moveType, float partialTicks) {
        return this.moveStateTracker.interpolatedMoveTickOf(moveType, partialTicks);
    }

    public MoveType calculateMoveType() {
        if (this.method_5642() instanceof class_1657 || !this.field_42108.method_48571()) {
            return MoveType.NONE;
        }
        if (this.method_6062()) {
            return MoveType.NONE;
        }
        double d0 = this.method_5962().method_6242();
        MoveType move = d0 > 1.0 || this.method_5968() != null ? MoveType.RUN : (d0 <= 0.8 ? MoveType.SNEAK : MoveType.WALK);
        return move;
    }

    protected class_243 directionToLookAt() {
        return this.getAnimationHandler().hasAnimation() && this.getTargetPosition() != null ? this.getTargetPosition().asVec(this.method_19538()).method_1020(this.method_19538()) : null;
    }

    protected float[] targetLookClamp() {
        return new float[]{60.0f, 30.0f};
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        ((Optional)this.field_6011.method_12789(OWNER_UUID)).ifPresent(uuid -> tag.method_25927("Owner", uuid));
        tag.method_10569("Death", this.field_6213);
        tag.method_10582("Command", this.attackBehaviour.toString());
        tag.method_10549("Mana", this.servantMana);
        tag.method_10556("Revealed", this.showServant());
        if (this.getEquipmentHandler() != null) {
            tag.method_10566("EquipmentHandler", (class_2520)this.getEquipmentHandler().save((class_7225.class_7874)this.method_56673()));
        }
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        if (tag.method_10545("Owner")) {
            this.field_6011.method_12778(OWNER_UUID, Optional.of(tag.method_25926("Owner")));
        }
        this.field_6213 = tag.method_10550("Death");
        try {
            this.onBehaviourCommand(CommandType.valueOf(tag.method_10558("Command")));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.servantMana = tag.method_10550("Mana");
        this.field_6011.method_12778(SHOW_SERVANT, (Object)tag.method_10577("Revealed"));
        if (this.getEquipmentHandler() != null) {
            this.getEquipmentHandler().read(tag.method_10562("EquipmentHandler"), (class_7225.class_7874)this.method_56673());
        }
    }

    public TargetPosition getTargetPosition() {
        return (TargetPosition)this.getDataContainer().get(TARGET_POSITION);
    }

    public void setTargetPositionFromAttackTarget() {
        class_1309 target = this.method_5968();
        if (target != null) {
            this.setTargetPosition(target);
        } else {
            this.setTargetPosition(TargetPosition.of((class_243)this.method_19538().method_1019(this.method_5828(1.0f).method_1021(10.0))));
        }
    }

    public void setTargetPosition(class_1309 target) {
        this.setTargetPosition(target == null ? null : TargetPosition.of((class_1309)target));
    }

    public void setTargetPosition(TargetPosition position) {
        this.getDataContainer().set(TARGET_POSITION, (Object)position);
    }

    @Nullable
    public class_243 tryGetTargetPosition(class_1309 target) {
        if (this.getTargetPosition() != null) {
            return this.getTargetPosition().asVec(this.method_19538());
        }
        return target != null ? target.method_19538() : null;
    }

    public boolean method_18395(class_1309 target) {
        return super.method_18395(target) && this.method_18407(target.method_24515());
    }

    public class_1309 method_5968() {
        return BrainUtils.getTargetOfEntity((class_1309)this);
    }

    public void method_5980(@Nullable class_1309 target) {
        super.method_5980(target);
        if (super.method_5968() == null) {
            BrainUtils.clearMemory((class_1309)this, (class_4140)class_4140.field_22355);
        } else {
            BrainUtils.setMemory((class_1309)this, (class_4140)class_4140.field_22355, (Object)super.method_5968());
        }
    }

    public void setupAttack(AnimationDefinition anim) {
        BrainUtils.clearMemory((class_1309)this, (class_4140)class_4140.field_18446);
        if (this.method_5968() != null) {
            this.setTargetPosition(this.method_5968());
        }
        this.method_5942().method_6340();
    }

    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{this.getSummonAnimation()})) {
            return;
        }
        if (anim.isAt("attack")) {
            this.mobAttack(anim, this.method_5968(), this::method_6121);
        }
    }

    public void mobAttack(AnimationState anim, class_1309 target, Consumer<class_1309> cons) {
        OrientedBoundingBox obb = this.calculateAttackAABB(anim, this.tryGetTargetPosition(target), 0.2);
        this.method_37908().method_8390(class_1309.class, obb.getEncompassingBox(), entity -> this.targetPred.test((class_1309)entity) && obb.intersects(entity.method_5829())).forEach(cons);
        if (!this.method_37908().field_9236) {
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (class_1297)this);
        }
    }

    public OrientedBoundingBox prepareAttackBox(String anim, class_1297 target, double grow, boolean debug) {
        OrientedBoundingBox obb = this.calculateAttackAABB(this.getAnimationHandler().createDefaulted(anim), target != null ? target.method_19538() : null, grow);
        if (debug) {
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTEMPT, (class_1297)this);
        }
        return obb;
    }

    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, @Nullable class_243 target, double grow) {
        float yRot = this.method_5791();
        float xRot = this.method_36455();
        class_1309 class_13092 = this.method_5642();
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            yRot = player.method_5791();
            xRot = player.method_36455();
        } else if (target != null) {
            class_243 dir = target.method_1020(this.method_19538()).method_1029();
            float[] yXRot = MathsHelper.YXRotFrom(dir);
            yRot = yXRot[0];
            xRot = -yXRot[1];
        }
        double off = (double)this.method_17682() * 0.5;
        return new OrientedBoundingBox(this.attackBB(anim).method_1009(grow, 0.0, grow).method_989(0.0, -off, grow), yRot, class_3532.method_15363((float)xRot, (float)-15.0f, (float)15.0f), this.method_19538().method_1031(0.0, off, 0.0));
    }

    public class_238 attackBB(AnimationState anim) {
        double range = 1.0;
        return new class_238(-range * 0.5, -0.02, 0.0, range * 0.5, this.vehicleDependentHeight() + 0.02, range);
    }

    public final double vehicleDependentHeight() {
        double height = this.method_17682();
        class_1297 entity = this.method_5854();
        if (entity != null) {
            height = this.method_53511().field_1325 - entity.method_5829().field_1322;
        }
        return height;
    }

    public boolean method_6121(class_1297 entity) {
        return Utils.runWithInvulTimer((class_1297)this, entity, this::mobHurtTarget, 0);
    }

    protected boolean mobHurtTarget(class_1297 target) {
        boolean result;
        float damage = (float)this.method_45325(class_5134.field_23721);
        class_1282 damageSource = this.damageSourceAttack(target);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            damage = class_1890.method_60120((class_3218)serverLevel, (class_1799)this.method_59958(), (class_1297)target, (class_1282)damageSource, (float)damage);
        }
        if (result = target.method_5643(damageSource, damage *= this.damageModifier(target))) {
            class_1937 class_19373;
            float knockback = this.method_59924(target, damageSource);
            if (knockback > 0.0f && target instanceof class_1309) {
                class_1309 livingEntity = (class_1309)target;
                livingEntity.method_6005((double)knockback * 0.5, (double)class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)))));
                this.method_18799(this.method_18798().method_18805(0.6, 1.0, 0.6));
            }
            if ((class_19373 = this.method_37908()) instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19373;
                class_1890.method_60107((class_3218)serverLevel, (class_1297)target, (class_1282)damageSource);
            }
            this.method_6114(target);
            this.onEntityHit(target, damage);
        }
        return result;
    }

    public float damageModifier(class_1297 target) {
        return 1.0f;
    }

    public void onEntityHit(class_1297 target, float damage) {
        this.method_59928();
        this.servantMana += this.method_45325(FateAttributes.MANA_LEECH.asHolder());
    }

    protected class_1282 damageSourceAttack(class_1297 target) {
        return this.method_48923().method_48812((class_1309)this);
    }

    protected void tryDisableShield(class_1657 player, class_1799 stack, class_1799 playerUseItem) {
        if (!stack.method_7960() && !playerUseItem.method_7960() && stack.method_7909() instanceof class_1743 && playerUseItem.method_31574(class_1802.field_8255)) {
            player.method_7357().method_7906(class_1802.field_8255, 100);
            this.method_37908().method_8421((class_1297)player, (byte)30);
        }
    }

    @Override
    public Predicate<class_1309> validTargetPredicate() {
        return this.targetPred;
    }

    public boolean method_5679(class_1282 source) {
        if (this.getSummonAnimation() != null && this.getAnimationHandler().isCurrent(new String[]{this.getSummonAnimation()})) {
            return true;
        }
        return super.method_5679(source);
    }

    public boolean method_5643(class_1282 damageSource, float damage) {
        if (damageSource.method_48789(class_8103.field_42242)) {
            return super.method_5643(damageSource, damage);
        }
        if (damageSource.method_5529() == null || !damageSource.method_5529().method_5864().method_20210(FateTags.EntityTypes.STRONG_MOB)) {
            damage *= 0.75f;
        }
        return super.method_5643(damageSource, Math.min(50.0f, damage));
    }

    protected float method_6132(class_1282 damageSource, float damageAmount) {
        if (!damageSource.method_48789(class_8103.field_42241)) {
            this.method_6105(damageSource, damageAmount);
            damageAmount = ExtendedCombatRules.getDamageAfterArmor((class_1309)this, damageAmount, damageSource, this.method_45325(class_5134.field_23724), this.method_45325(class_5134.field_23725));
        }
        return damageAmount;
    }

    public void method_6005(double strength, double xRatio, double zRatio) {
        super.method_6005(strength * 0.75, xRatio, zRatio);
    }

    @Override
    public ServantProperties props() {
        return this.prop;
    }

    @Override
    public class_2561 nobelPhantasm() {
        return this.hogou;
    }

    @Override
    public void onPlayerCommand(class_3222 player, CommandType behaviour) {
        if (behaviour.isBehaviour) {
            this.onBehaviourCommand(behaviour);
        }
        if (behaviour == CommandType.KILL) {
            if (!player.method_5667().equals(this.method_6139())) {
                return;
            }
            this.method_5643(FateDamageTypes.grail(this.method_56673()), Float.MAX_VALUE);
        }
        if (behaviour == CommandType.NP) {
            if (!this.commandNPUse) {
                PlayerData data = Platform.INSTANCE.getPlayerData((class_1657)player);
                if (player.method_56992() || data.useMana(this.props().manaCost()) && data.useCommandSeal()) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"fateubw.chat.command.npsuccess").method_27692(class_124.field_1061));
                    this.commandNPUse = true;
                } else {
                    player.method_43496((class_2561)class_2561.method_43471((String)"fateubw.chat.command.npfail").method_27692(class_124.field_1061));
                }
            } else {
                player.method_43496((class_2561)class_2561.method_43471((String)"fateubw.chat.command.npprep").method_27692(class_124.field_1061));
            }
        }
    }

    public void onBehaviourCommand(CommandType command) {
        if (!command.isBehaviour) {
            return;
        }
        this.commandBehaviour = command;
        switch (command) {
            case NORMAL: 
            case AGGRESSIVE: 
            case DEFENSIVE: {
                this.method_5980(null);
                this.method_5942().method_6340();
                this.attackBehaviour = AttackBehaviour.of(command);
                break;
            }
            case FOLLOW: {
                this.setStaying(false);
                this.method_35055();
                break;
            }
            case STAY: {
                this.setStaying(true);
                break;
            }
            case GUARD: {
                this.setStaying(false);
                this.method_18408(this.getOwner().method_24515(), 8);
            }
        }
    }

    @Override
    public void shouldScheduleEntityDataSync(boolean sync) {
        this.sendToOwnerData = sync;
    }

    public boolean showServant() {
        return (Boolean)this.field_6011.method_12789(SHOW_SERVANT);
    }

    public void revealServant() {
        this.field_6011.method_12778(SHOW_SERVANT, (Object)true);
    }

    @Override
    public boolean isStaying() {
        return (Boolean)this.field_6011.method_12789(STATIONARY);
    }

    public void setStaying(boolean stay) {
        this.field_6011.method_12778(STATIONARY, (Object)stay);
        if (!this.method_37908().field_9236) {
            if (stay) {
                BrainUtils.setMemory((class_1309)this, (class_4140)((class_4140)FateMemoryTypes.STAYING.get()), (Object)class_3902.field_17274);
            } else {
                BrainUtils.clearMemory((class_1309)this, (class_4140)((class_4140)FateMemoryTypes.STAYING.get()));
            }
        }
    }

    public boolean useMana(float amount) {
        if (this.servantMana < (double)amount) {
            return false;
        }
        this.servantMana -= (double)amount;
        this.manaRegenCounter = 40.0;
        return true;
    }

    protected void regenMana() {
        double d;
        this.manaRegenCounter -= 1.0;
        if (d <= 0.0) {
            this.regenMana(this.method_45325(FateAttributes.MANA_REGEN.asHolder()));
            this.manaRegenCounter = 20.0;
        }
    }

    public void regenMana(class_1297 source) {
        double amount = this.method_45325(FateAttributes.MANA_LEECH.asHolder());
        this.regenMana(amount);
    }

    public void regenMana(double amount) {
        this.servantMana = class_3532.method_15350((double)(this.servantMana + amount), (double)0.0, (double)100.0);
    }

    public int getMana() {
        return (int)this.servantMana;
    }

    public void applyManaLeechDebuff(int duration, double amount) {
        this.manaLeechDebuffDuration = duration;
        class_1324 inst = this.method_5996(FateAttributes.MANA_LEECH.asHolder());
        inst.method_6200(MANA_LEECH_DEBUFF_ID);
        inst.method_26835(new class_1322(MANA_LEECH_DEBUFF_ID, 1.0 - amount, class_1322.class_1323.field_6331));
    }

    public boolean healthBelow(float percentage) {
        return this.method_6032() < this.method_6063() * percentage;
    }

    public boolean canUseNobelPhantasm() {
        return this.nobelPhantasmCheck() || this.commandNPUse;
    }

    public boolean nobelPhantasmCheck() {
        return this.getMana() >= this.props().manaCost() && this.nobelPhantasmCooldown <= 0.0;
    }

    public boolean attemptUseNobelPhantasm() {
        if (!this.commandNPUse && !this.useMana(this.props().manaCost())) {
            return false;
        }
        if (!this.commandNPUse) {
            this.nobelPhantasmCooldown = this.nobelPhantasmCooldown();
        }
        this.commandNPUse = false;
        return true;
    }

    protected int nobelPhantasmCooldown() {
        return 200 + this.method_59922().method_43048(100);
    }

    public HeldEquipmentHandler getEquipmentHandler() {
        return null;
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 reason, class_1315 data) {
        super.method_5943(world, difficulty, reason, data);
        this.method_5964(this.method_59922(), difficulty);
        for (class_1304 type : class_1304.values()) {
            this.method_5946(type, 0.0f);
        }
        this.method_5937(false);
        if (this.getSummonAnimation() != null && (reason == class_3730.field_16465 || reason == class_3730.field_16471)) {
            this.getAnimationHandler().setAnimation(this.getSummonAnimation());
        }
        return data;
    }

    @Override
    public class_1657 getOwner() {
        Object owner;
        if (this.owner != null && this.owner.method_5805()) {
            return this.owner;
        }
        UUID ownerId = this.method_6139();
        if (ownerId != null && (owner = this.method_5682() != null ? this.method_5682().method_3760().method_14602(ownerId) : this.method_37908().method_18470(ownerId)) != null) {
            this.setOwner((class_1657)owner);
        }
        return this.owner;
    }

    public UUID method_6139() {
        return ((Optional)this.field_6011.method_12789(OWNER_UUID)).orElse(null);
    }

    @Override
    public void setOwner(class_1657 player) {
        if (player != null) {
            this.field_6011.method_12778(OWNER_UUID, Optional.of(player.method_5667()));
        } else {
            this.field_6011.method_12778(OWNER_UUID, Optional.empty());
        }
        this.owner = player;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (player.method_5715() && player.method_5667().equals(this.method_6139())) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                S2CServantGui.sendServantGui(serverPlayer, this);
            }
            return class_1269.method_29236((boolean)player.method_37908().field_9236);
        }
        return class_1269.field_5814;
    }

    protected boolean method_6062() {
        return super.method_6062() || this.getSummonAnimation() != null && this.getAnimationHandler().isCurrent(new String[]{this.getSummonAnimation()});
    }

    public void method_5837(class_3222 player) {
        this.tracked.add(player);
    }

    public void method_5742(class_3222 player) {
        this.tracked.remove(player);
    }

    public boolean method_5974(double d) {
        return false;
    }

    protected void method_6108() {
        if (this.method_37908().field_9236) {
            for (int i = 0; i < (int)(9.0f / (float)this.maxDeathTick() * (float)this.field_6213 - 1.0f); ++i) {
                AdvancedParticleContainer.make((class_2394)((class_2394)FateParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.29803923f, 0.5019608f, 0.8117647f, 0.3f)).addData((AdvancedParticleData)new ScaleData(0.15f)).addData((AdvancedParticleData)new MotionData(this.field_5974.method_43059() * 0.02, this.field_5974.method_43059() * 0.02, this.field_5974.method_43059() * 0.02)).addData((AdvancedParticleData)new ParticleMetaData(20, false, 0.0f)).add(this.method_37908(), this.method_23316(this.field_5974.method_43058() * 3.0 - 1.5), this.method_23323(this.field_5974.method_43058() * 3.0 - 1.5), this.method_23324(this.field_5974.method_43058() * 3.0 - 1.5));
            }
        }
        ++this.field_6213;
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.field_6213 == 1) {
                GrailWarHandler handler = GrailWarHandler.get(serverLevel.method_8503());
                if (handler.isParticipant((class_1297)this) || this.method_6081() != null && this.method_6081().method_49708(FateDamageTypes.GRAIL)) {
                    handler.broadcastParticipants((class_2561)class_2561.method_43471((String)"fateubw.chat.servant.death").method_27692(class_124.field_1061));
                }
                this.method_5783(class_3417.field_14792, 1.0f, 1.0f);
                this.getAnimationHandler().setAnimation(this.getDeathAnimation());
            }
            if ((this.method_6081() == null || !this.method_6081().method_49708(FateDamageTypes.GRAIL)) && this.field_6213 > 15 && this.field_6213 % 5 == 0 && (this.field_6238 > 0 || this.method_6071()) && this.method_6054() && this.method_37908().method_8450().method_8355(class_1928.field_19391)) {
                int splitExp;
                for (int exp = this.field_6194; exp > 0; exp -= splitExp) {
                    splitExp = class_1303.method_5918((int)exp);
                    this.method_37908().method_8649((class_1297)new class_1303(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), splitExp));
                }
            }
            AnimationState anim = this.getAnimationHandler().getAnimation();
            if (this.field_6213 >= this.maxDeathTick() && (anim == null || anim.done(0))) {
                this.method_5650(class_1297.class_5529.field_26998);
            }
        }
    }

    @Override
    public int maxDeathTick() {
        return 200;
    }

    public boolean method_6054() {
        if (this.method_5682() != null && GrailWarHandler.get(this.method_5682()).isParticipant((class_1297)this)) {
            return false;
        }
        return super.method_6054();
    }

    protected void method_16080(class_3218 level, class_1282 damageSource) {
        if (damageSource.method_49708(FateDamageTypes.GRAIL) || this.method_5682() != null && GrailWarHandler.get(this.method_5682()).isParticipant((class_1297)this)) {
            return;
        }
        super.method_16080(level, damageSource);
    }

    @Nullable
    public class_1799 method_31480() {
        return SpawnEgg.fromType((class_1299)this.method_5864()).map(class_1799::new).orElse(null);
    }

    protected String getSummonAnimation() {
        return null;
    }

    public double getSummonProgress(float partialTicks) {
        String summon = this.getSummonAnimation();
        if (summon != null && this.getAnimationHandler().isCurrent(new String[]{summon})) {
            return this.getAnimationHandler().getAnimation().progress(partialTicks);
        }
        return -1.0;
    }

    public Vector4f summonColor() {
        return SUMMON_COLOR;
    }

    public EntityWeaponTrailHolder<BaseServant> getTrailHolder() {
        return this.trailHolder;
    }

    public static enum AttackBehaviour {
        NORMAL,
        AGGRESSIVE,
        DEFENSIVE;


        @Nullable
        public static AttackBehaviour of(CommandType type) {
            return switch (type) {
                case CommandType.NORMAL -> NORMAL;
                case CommandType.AGGRESSIVE -> AGGRESSIVE;
                case CommandType.DEFENSIVE -> DEFENSIVE;
                default -> null;
            };
        }
    }
}

