/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.ai.behaviour;

import io.github.flemmli97.tenshilib.common.entity.AOEAttackEntity;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.MoveToAttackTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.MoveToWalkTargetWithSight;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.PlayAnimation;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetAnimationToPlay;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.data.AnimationPlayHolder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.registry.TenshilibMemoryModules;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.ToIntBiFunction;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_3532;
import net.minecraft.class_4140;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class BehaviourUtils {
    public static <E extends class_1308> PlayAnimation<E> cooldownedPlay(boolean requireInRange, int min, int max) {
        return BehaviourUtils.cooldownedPlay(requireInRange, (String s, E entity) -> min + entity.method_59922().method_43048(max - min));
    }

    public static <E extends class_1308> PlayAnimation<E> cooldownedPlay(Predicate<E> condition, int min, int max) {
        return BehaviourUtils.cooldownedPlay(condition, (String s, E entity) -> min + entity.method_59922().method_43048(max - min));
    }

    public static <E extends class_1308> PlayAnimation<E> cooldownedPlay(boolean requireInRange, ToIntBiFunction<String, E> cooldownFunc) {
        return BehaviourUtils.cooldownedPlay(requireInRange ? entity -> {
            class_1309 living;
            AnimationPlayHolder anim = (AnimationPlayHolder)BrainUtils.getMemory((class_1309)entity, (class_4140)((class_4140)TenshilibMemoryModules.ANIMATION_TO_PLAY.get()));
            class_1309 target = BrainUtils.getTargetOfEntity((class_1309)entity);
            if (target == null) {
                return false;
            }
            if (entity instanceof AOEAttackEntity) {
                AOEAttackEntity aoeEntity = (AOEAttackEntity)entity;
                return aoeEntity.prepareAttackBox(anim.animation(), (class_1297)target, -0.15, true).intersects(target.method_5829());
            }
            return target instanceof class_1309 && entity.method_42150(living = target);
        } : null, cooldownFunc);
    }

    public static <E extends class_1308> PlayAnimation<E> cooldownedPlay(Predicate<E> condition, ToIntBiFunction<String, E> cooldownFunc) {
        PlayAnimation behaviour = new PlayAnimation().withCallback(BehaviourUtils.cooldownHandler(cooldownFunc)).withCallback(BehaviourUtils.cooldownHandlerCont());
        if (condition != null) {
            behaviour.startCondition(condition);
        }
        return behaviour;
    }

    public static <E extends class_1308> PlayAnimation.OnStart<E> cooldownHandler(ToIntBiFunction<String, E> cooldownFunc) {
        return (animation, entity) -> {
            double calc = cooldownFunc.applyAsInt(animation, entity);
            int cooldown = class_3532.method_15384((double)(calc += ((AnimatedEntity)entity).getAnimationHandler().get(animation).length()));
            BrainUtils.setForgettableMemory((class_1309)entity, (class_4140)class_4140.field_22475, (Object)true, (int)cooldown);
        };
    }

    public static <E extends class_1308> PlayAnimation.OnContinue<E> cooldownHandlerCont() {
        return (animation, chains, entity) -> {
            if (chains != null) {
                double add = 0.0;
                for (AnimationPlayHolder.AnimationHolder chain : chains) {
                    add += ((AnimatedEntity)entity).getAnimationHandler().get(chain.animation()).length();
                }
                BehaviourUtils.modifyExpiringMemory(entity, class_4140.field_22475, class_3532.method_15384((double)add));
            }
        };
    }

    @SafeVarargs
    public static <E extends class_1308> SetAnimationToPlay<E> of(AnimationPlayHolder<E> ... animations) {
        return new SetAnimationToPlay(animations);
    }

    public static <E extends class_1309> ToIntBiFunction<E, class_1309> closeEnough(int dist) {
        return (entity, target) -> dist;
    }

    public static <E extends class_1309> Predicate<E> ifCloserThan(double dist) {
        return entity -> {
            class_1309 target;
            double distance = dist + (double)entity.method_17681() * 0.5;
            class_1309 class_13092 = target = BrainUtils.hasMemory((class_1309)entity, (class_4140)class_4140.field_22355) ? BrainUtils.getTargetOfEntity((class_1309)entity) : null;
            if (target == null && entity instanceof class_1308) {
                class_1308 mob = (class_1308)entity;
                target = mob.method_5968();
            }
            if (target == null) {
                return false;
            }
            return entity.method_5858((class_1297)target) <= (distance += (double)target.method_17681() * 0.5) * distance;
        };
    }

    public static <E extends class_1309> Predicate<E> ifFurtherThan(double dist) {
        return entity -> {
            class_1309 target;
            double distance = dist + (double)entity.method_17681() * 0.5;
            class_1309 class_13092 = target = BrainUtils.hasMemory((class_1309)entity, (class_4140)class_4140.field_22355) ? BrainUtils.getTargetOfEntity((class_1309)entity) : null;
            if (target == null && entity instanceof class_1308) {
                class_1308 mob = (class_1308)entity;
                target = mob.method_5968();
            }
            if (target == null) {
                return false;
            }
            return entity.method_5858((class_1297)target) >= (distance += (double)target.method_17681() * 0.5) * distance;
        };
    }

    public static <E extends class_1309> Predicate<E> ifFurtherThan(double dist, double verticalDist) {
        return entity -> {
            class_1309 target;
            double distance = dist + (double)entity.method_17681() * 0.5;
            class_1309 class_13092 = target = BrainUtils.hasMemory((class_1309)entity, (class_4140)class_4140.field_22355) ? BrainUtils.getTargetOfEntity((class_1309)entity) : null;
            if (target == null && entity instanceof class_1308) {
                class_1308 mob = (class_1308)entity;
                target = mob.method_5968();
            }
            if (target == null) {
                return false;
            }
            return entity.method_5649(target.method_23317(), entity.method_23318(), target.method_23321()) >= (distance += (double)target.method_17681() * 0.5) * distance && Math.abs(entity.method_23318() - target.method_23318()) <= verticalDist;
        };
    }

    public static <E extends class_1309> Consumer<ExtendedBehaviour<E>> withCondition(Predicate<E> test) {
        return behaviour -> {
            behaviour.startCondition(test);
            behaviour.stopIf(e -> !test.test(e));
        };
    }

    public static <E extends class_1314 & AnimatedEntity> MoveToAttackTarget<E> timedMoveAttack() {
        return BehaviourUtils.timedMoveAttack(25, 40);
    }

    public static <E extends class_1314 & AnimatedEntity> MoveToAttackTarget<E> timedMoveAttack(int min, int max) {
        MoveToAttackTarget<E> behaviour = BehaviourUtils.moveAttack();
        behaviour.runFor(e -> min + e.method_59922().method_43048(max - min));
        return behaviour;
    }

    public static <E extends class_1314 & AnimatedEntity> MoveToAttackTarget<E> moveAttack() {
        return new MoveToAttackTarget();
    }

    public static <E extends class_1314> MoveToWalkTargetWithSight<E> moveTo() {
        return new MoveToWalkTargetWithSight();
    }

    public static <T> void modifyExpiringMemory(class_1308 mob, class_4140<T> memory, int modifier) {
        long current = BrainUtils.getTimeUntilMemoryExpires((class_1309)mob, memory);
        if (current > 0L) {
            if ((current += (long)modifier) <= 0L) {
                BrainUtils.clearMemory((class_1309)mob, memory);
            } else {
                Object value = BrainUtils.getMemory((class_1309)mob, memory);
                BrainUtils.setForgettableMemory((class_1309)mob, memory, (Object)value, (int)Math.toIntExact(current));
            }
        }
    }

    public static <T extends class_1309> boolean runCooldownBehaviour(T entity) {
        return !((AnimatedEntity)entity).getAnimationHandler().hasAnimation() && (BrainUtils.hasMemory(entity, (class_4140)class_4140.field_22475) || !BrainUtils.hasMemory(entity, (class_4140)((class_4140)TenshilibMemoryModules.ANIMATION_TO_PLAY.get())));
    }

    public static <T extends class_1308> boolean runCombatBehaviour(T entity) {
        return !((AnimatedEntity)entity).getAnimationHandler().hasAnimation() && entity.method_5968() != null && !BrainUtils.hasMemory(entity, (class_4140)class_4140.field_22475);
    }
}

