/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.misc;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.fateubw.common.config.CommonConfig;
import io.github.flemmli97.fateubw.common.entity.misc.BaseProjectile;
import io.github.flemmli97.fateubw.common.entity.utils.EntityTrailHandler;
import io.github.flemmli97.fateubw.common.particles.trail.TrailPositions;
import io.github.flemmli97.fateubw.common.registry.FateDamageTypes;
import io.github.flemmli97.fateubw.common.registry.FateEntities;
import io.github.flemmli97.fateubw.common.registry.FateParticles;
import io.github.flemmli97.fateubw.common.registry.FateSounds;
import io.github.flemmli97.fateubw.common.utils.Utils;
import io.github.flemmli97.tenshilib.common.entity.EntityUtils;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import io.github.flemmli97.tenshilib.common.utils.HitResultUtils;
import io.github.flemmli97.tenshilib.common.utils.ItemUtils;
import java.util.ArrayList;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public class BabylonWeapon
extends BaseProjectile {
    protected static final class_2940<class_1799> WEAPON_TYPE = class_2945.method_12791(BabylonWeapon.class, (class_2941)class_2943.field_13322);
    protected static final class_2940<Integer> SHOOT_TIME = class_2945.method_12791(BabylonWeapon.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Boolean> PREPARING = class_2945.method_12791(BabylonWeapon.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Boolean> DESPAWN = class_2945.method_12791(BabylonWeapon.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<class_2338> GROUND = class_2945.method_12791(BabylonWeapon.class, (class_2941)class_2943.field_13324);
    private class_1309 target;
    public final int renderRand;
    private final class_2680 particleState;
    private int preparationTick;
    private int despawnTimer;
    private final EntityTrailHandler trailHandler;

    public BabylonWeapon(class_1299<? extends BabylonWeapon> type, class_1937 level) {
        super(type, level);
        this.renderRand = this.field_5974.method_43048(1000);
        this.particleState = class_2246.field_10205.method_9564();
        this.trailHandler = new EntityTrailHandler((class_1297)this, 12);
    }

    public BabylonWeapon(class_1937 level, class_1309 shootingEntity) {
        super((class_1299<? extends BaseProjectile>)((class_1299)FateEntities.BABYLON.get()), level, shootingEntity);
        this.renderRand = this.field_5974.method_43048(1000);
        this.particleState = class_2246.field_10205.method_9564();
        this.trailHandler = new EntityTrailHandler((class_1297)this, 12);
        this.field_6011.method_12778(SHOOT_TIME, (Object)(this.field_5974.method_43048(15) + 15));
    }

    public BabylonWeapon(class_1937 level, class_1309 shootingEntity, class_1309 target) {
        this(level, shootingEntity);
        this.target = target;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(WEAPON_TYPE, (Object)class_1799.field_8037);
        builder.method_56912(PREPARING, (Object)true);
        builder.method_56912(SHOOT_TIME, (Object)20);
        builder.method_56912(DESPAWN, (Object)false);
        builder.method_56912(GROUND, (Object)class_2338.field_10980);
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (key == GROUND) {
            this.setInGround((class_2338)this.field_6011.method_12789(GROUND));
        }
    }

    public boolean preparing() {
        return (Boolean)this.field_6011.method_12789(PREPARING);
    }

    public int livingTickMax() {
        return this.inGround ? Integer.MAX_VALUE : 250;
    }

    public void method_5773() {
        if (this.preparing()) {
            this.updatePreparation();
        } else {
            class_1297 thrower;
            if (!(this.method_37908().field_9236 || (thrower = this.method_24921()) != null && thrower.method_5805())) {
                this.method_31472();
                return;
            }
            if (this.field_5953) {
                this.trailHandler.tick();
            }
            if (this.method_37908().field_9236 && !this.inGround) {
                this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, this.particleState), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
            }
            super.method_5773();
            this.trailHandler.tick();
        }
        if (this.despawning()) {
            ++this.despawnTimer;
            if (!this.method_37908().field_9236) {
                if (this.despawnTimer >= 40) {
                    this.method_31472();
                }
            } else if (this.field_5974.method_43056()) {
                AdvancedParticleContainer.make((class_2394)((class_2394)FateParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(1.0f, 0.85f, 0.3f, 0.5f)).addData((AdvancedParticleData)new ScaleData(0.15f)).addData((AdvancedParticleData)new MotionData(this.field_5974.method_43059() * 0.01, this.field_5974.method_43059() * 0.01, this.field_5974.method_43059() * 0.01)).addData((AdvancedParticleData)new ParticleMetaData(20, false, 0.0f)).add(this.method_37908(), this.method_23316(this.field_5974.method_43059()), this.method_23323(this.field_5974.method_43059()), this.method_23324(this.field_5974.method_43059()));
            }
        }
    }

    protected void tickInGround() {
        super.tickInGround();
        if (!this.method_37908().method_8608() && this.ticksInGround > 40 && !this.despawning()) {
            this.field_6011.method_12778(DESPAWN, (Object)true);
        }
    }

    protected void resetInGround() {
        this.field_6011.method_12778(DESPAWN, (Object)true);
    }

    public void moveEntity() {
        if (this.inGround) {
            return;
        }
        super.moveEntity();
    }

    public boolean despawning() {
        return (Boolean)this.field_6011.method_12789(DESPAWN);
    }

    public float despawnProgress() {
        return Math.min(1.0f, (float)this.despawnTimer / 40.0f);
    }

    public float preparationState(float partialTicks) {
        if (!this.preparing()) {
            return 1.0f;
        }
        return class_3532.method_15363((float)(((float)this.preparationTick + partialTicks) / (float)((Integer)this.field_6011.method_12789(SHOOT_TIME)).intValue()), (float)0.0f, (float)1.0f);
    }

    private void updatePreparation() {
        ++this.preparationTick;
        class_243 motion = this.method_18798();
        double f = Math.sqrt(BabylonWeapon.horizontalMag((class_243)motion));
        this.method_36456(this.updateRotation(this.field_5982, (float)(class_3532.method_15349((double)motion.field_1352, (double)motion.field_1350) * 57.2957763671875)));
        this.method_36457(this.updateRotation(this.field_6004, (float)(class_3532.method_15349((double)motion.field_1351, (double)f) * 57.2957763671875)));
        if (this.method_37908().field_9236) {
            AdvancedParticleContainer.make((class_2394)((class_2394)FateParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.92156863f, 0.92156863f, 0.0f, 1.0f)).addData((AdvancedParticleData)new ScaleData(0.15f)).addData((AdvancedParticleData)new MotionData(this.field_5974.method_43059() * 0.01, this.field_5974.method_43059() * 0.01, this.field_5974.method_43059() * 0.01)).addData((AdvancedParticleData)new ParticleMetaData(20, false, 0.0f)).add(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321());
        } else {
            if (this.field_6012 == 1) {
                this.method_5783((class_3414)FateSounds.ENTITY_BABYLON_SPAWN.get(), 0.7f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 0.9f);
            }
            if (this.preparing() && this.preparationTick >= (Integer)this.field_6011.method_12789(SHOOT_TIME)) {
                this.field_6011.method_12778(PREPARING, (Object)false);
                class_1297 thrower = this.method_24921();
                if (thrower instanceof class_1657) {
                    class_239 hit = HitResultUtils.entityRayTrace((class_1297)thrower, (double)64.0, (class_3959.class_3960)class_3959.class_3960.field_17558, (class_3959.class_242)class_3959.class_242.field_1348, (boolean)false, (boolean)false, null);
                    this.shootAtPosition(hit.method_17784().field_1352, hit.method_17784().field_1351, hit.method_17784().field_1350, 1.0f, 6.0f);
                } else if (this.target != null) {
                    this.shootAtEntity((class_1297)this.target, 1.0f, 6.0f);
                } else {
                    this.method_31472();
                }
                this.method_5783((class_3414)FateSounds.ENTITY_BABYLON_SHOOT.get(), 0.8f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 0.5f);
            }
        }
    }

    public void shootAtEntity(class_1297 target, float velocity, float inaccuracy, boolean ignoreGravity) {
        class_243 targetPos = EntityUtils.getStraightProjectileTarget((class_243)this.method_19538(), (class_1297)target).method_1019(target.method_18798().method_1021(2.0));
        this.shootAtPosition(targetPos.method_10216(), targetPos.method_10214(), targetPos.method_10215(), velocity, inaccuracy, ignoreGravity);
    }

    private float updateRotation(float prev, float current) {
        while (current - prev < -180.0f) {
            prev -= 360.0f;
        }
        while (current - prev >= 180.0f) {
            prev += 360.0f;
        }
        return class_3532.method_16439((float)0.2f, (float)prev, (float)current);
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    protected float motionReduction(boolean inWater) {
        return 1.0f;
    }

    protected boolean entityRayTraceHit(class_3966 result) {
        class_1282 source = FateDamageTypes.indirect(FateDamageTypes.BABYLON, (class_1297)this, this.method_24921());
        float damage = (float)ItemUtils.damage((class_1937)this.method_37908(), null, (class_1297)result.method_17782(), (class_1282)source, (class_1799)this.getWeapon());
        boolean res = Utils.runWithInvulTimer(this.method_24921(), result.method_17782(), e -> e.method_5643(source, damage * CommonConfig.babylonScale), 2);
        if (res) {
            class_1297 class_12972 = result.method_17782();
            if (class_12972 instanceof class_1309) {
                class_1309 entity = (class_1309)class_12972;
                entity.method_6092(new class_1293(class_1294.field_5909, 40));
            }
            if ((class_12972 = this.method_37908()) instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_12972;
                class_1890.method_60107((class_3218)serverLevel, (class_1297)result.method_17782(), (class_1282)source);
            }
        }
        this.method_31472();
        return true;
    }

    protected void onBlockHit(class_3965 result) {
        class_243 vec3 = result.method_17784().method_1023(this.method_23317(), this.method_23318(), this.method_23321());
        this.method_18799(vec3);
        class_243 vec32 = vec3.method_1029().method_1021(0.2);
        this.method_23327(result.method_17784().method_10216() - vec32.field_1352, result.method_17784().method_10214() - vec32.field_1351, result.method_17784().method_10215() - vec32.field_1350);
        this.setInGround(result.method_17777());
    }

    public void setInGround(class_2338 pos) {
        super.setInGround(pos);
        this.inGround = true;
        if (!this.method_37908().field_9236) {
            this.field_6011.method_12778(GROUND, (Object)(this.inGround ? pos : class_2338.field_10980));
        }
    }

    public class_1799 getWeapon() {
        return (class_1799)this.field_6011.method_12789(WEAPON_TYPE);
    }

    public void setWeapon(class_1799 stack) {
        if (!stack.method_7960()) {
            this.field_6011.method_12778(WEAPON_TYPE, (Object)stack);
        }
    }

    @Override
    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10566("Weapon", (class_2520)class_1799.field_24671.encodeStart((DynamicOps)this.method_56673().method_57093((DynamicOps)class_2509.field_11560), (Object)this.getWeapon()).getOrThrow());
        compound.method_10556("Preparing", this.preparing());
    }

    @Override
    protected void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setWeapon((class_1799)class_1799.field_24671.parse((DynamicOps)this.method_56673().method_57093((DynamicOps)class_2509.field_11560), (Object)compound.method_10580("Weapon")).getOrThrow());
        this.field_6011.method_12778(PREPARING, (Object)compound.method_10577("Preparing"));
    }

    public TrailPositions trailPositions() {
        return this.trailHandler.getPositions();
    }

    public static void spawnWeapons(class_1309 thrower, class_1309 target, int amount, int range) {
        for (class_243 offset : Utils.randomSidedPositions(thrower, amount, range)) {
            BabylonWeapon weapon = new BabylonWeapon(thrower.method_37908(), thrower, target);
            weapon.method_5814(offset.field_1352, offset.field_1351 + (double)thrower.method_17682() * 0.5, offset.field_1350);
            class_243 dir = class_243.method_1030((float)0.0f, (float)thrower.method_36454());
            weapon.method_7485(dir.method_10216(), dir.method_10214(), dir.method_10215(), 0.02f, 0.0f);
            weapon.setWeapon(CommonConfig.babylonWeapons.getRandomWeapon(weapon.field_5974));
            weapon.method_37908().method_8649((class_1297)weapon);
        }
    }

    public static void spawnWeaponsAround(class_1309 thrower, class_1309 target, int amount, int range) {
        int targetSize = Math.max(class_3532.method_15386((float)target.method_17682()), class_3532.method_15386((float)target.method_17681()));
        range = Math.max(targetSize + 3, range);
        ArrayList<Pair> angles = new ArrayList<Pair>(amount);
        block0: for (int i = 0; i < amount; ++i) {
            float yRot = thrower.method_59922().method_43057() * 360.0f;
            float xRot = thrower.method_59922().method_43057() * 70.0f + 20.0f;
            int retry = 0;
            do {
                float greatDist = Float.MAX_VALUE;
                for (Pair p : angles) {
                    float d;
                    if (p == null || !((d = BabylonWeapon.greatCircDist(yRot, xRot, ((Float)p.getFirst()).floatValue(), ((Float)p.getSecond()).floatValue())) < greatDist)) continue;
                    greatDist = d;
                }
                if (!(greatDist * (float)range > 2.0f)) continue;
                angles.add(Pair.of((Object)Float.valueOf(yRot), (Object)Float.valueOf(xRot)));
                continue block0;
            } while (++retry <= 10);
        }
        class_243 pos = target.method_19538();
        for (Pair offset : angles) {
            if (offset == null) continue;
            BabylonWeapon weapon = new BabylonWeapon(thrower.method_37908(), thrower, target);
            class_243 dir = class_243.method_1030((float)(-((Float)offset.getSecond()).floatValue()), (float)((Float)offset.getFirst()).floatValue());
            class_243 area = pos.method_1019(dir.method_1021((double)range));
            weapon.method_5814(area.field_1352, area.field_1351, area.field_1350);
            weapon.method_7485(-dir.method_10216(), -dir.method_10214(), -dir.method_10215(), 0.02f, 0.0f);
            weapon.setWeapon(CommonConfig.babylonWeapons.getRandomWeapon(weapon.field_5974));
            weapon.method_37908().method_8649((class_1297)weapon);
        }
    }

    private static float greatCircDist(float yRot1, float xRot1, float yRot2, float xRot2) {
        return (float)Math.acos(class_3532.method_15374((float)xRot1) * class_3532.method_15374((float)xRot2) + class_3532.method_15362((float)xRot1) * class_3532.method_15362((float)xRot2) * class_3532.method_15362((float)class_3532.method_15379((float)(yRot1 - yRot2))));
    }
}

