/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.servant;

import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.api.datapack.ServantExtraData;
import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.BehaviourUtils;
import io.github.flemmli97.fateubw.common.network.S2CAttackDebug;
import io.github.flemmli97.fateubw.common.network.S2CScreenShake;
import io.github.flemmli97.fateubw.common.particles.RingParticleData;
import io.github.flemmli97.fateubw.common.particles.trail.TrailInfo;
import io.github.flemmli97.fateubw.common.particles.trail.TrailParticleData;
import io.github.flemmli97.fateubw.common.particles.trail.provider.entity.EntityWeaponTrailHolderProvider;
import io.github.flemmli97.fateubw.common.particles.trail.provider.entity.EntityWeaponTrailProvider;
import io.github.flemmli97.fateubw.common.registry.FateItems;
import io.github.flemmli97.fateubw.common.registry.FateMobEffects;
import io.github.flemmli97.fateubw.common.registry.FateParticles;
import io.github.flemmli97.fateubw.common.registry.FateSounds;
import io.github.flemmli97.fateubw.common.utils.Utils;
import io.github.flemmli97.tenshilib.common.entity.ai.TargetPosition;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.data.AnimationPlayHolder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_8103;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.joml.Vector4f;

public class Heracles
extends BaseServant {
    protected static final class_2940<Integer> DEATH_COUNT = class_2945.method_12791(Heracles.class, (class_2941)class_2943.field_13327);
    private static final class_2960 DEATH_MOD = Fate.modRes("heracles_death_modifier");
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    private static final String ONE_HAND_HEAVY_1 = BUILDER.add("one_hand_heavy_1", AnimationsBuilder.definition((double)0.84).marker("attack", new double[]{0.72}).marker("step", new double[]{0.48}).marker("weapon_swing_start", new double[]{0.56}).marker("weapon_swing_end", new double[]{0.76}));
    private static final String ONE_HAND_HEAVY_2 = BUILDER.add("one_hand_heavy_2", AnimationsBuilder.definition((double)0.84).marker("attack", new double[]{0.68}).marker("step", new double[]{0.48}).marker("weapon_swing_start", new double[]{0.56}).marker("weapon_swing_end", new double[]{0.76}));
    private static final String ONE_HAND_HEAVY_3 = BUILDER.add("one_hand_heavy_3", AnimationsBuilder.definition((double)0.84).marker("attack", new double[]{0.68}).marker("step", new double[]{0.48}).marker("weapon_swing_start", new double[]{0.56}).marker("weapon_swing_end", new double[]{0.76}));
    private static final String TWO_HAND_HEAVY_1 = BUILDER.add("two_hand_heavy_1", AnimationsBuilder.definition((double)0.84).marker("attack", new double[]{0.72}).marker("weapon_swing_start", new double[]{0.56}).marker("weapon_swing_end", new double[]{0.76}));
    private static final String TWO_HAND_HEAVY_2 = BUILDER.add("two_hand_heavy_2", AnimationsBuilder.definition((double)0.84).marker("attack", new double[]{0.68}).marker("weapon_swing_start", new double[]{0.56}).marker("weapon_swing_end", new double[]{0.76}));
    private static final String UPPER_CUT = BUILDER.add("upper_cut", AnimationsBuilder.definition((double)1.04).marker("attack", new double[]{0.64}).marker("weapon_swing_start", new double[]{0.48}).marker("weapon_swing_end", new double[]{0.72}));
    private static final String JUMP = BUILDER.add("jump", AnimationsBuilder.definition((double)0.8).marker("jump", new double[]{0.12}).marker("attempt", new double[]{0.24}).infinite());
    private static final String JUMP_HIT = BUILDER.add("jump_hit", AnimationsBuilder.definition((double)0.6).marker("attack", new double[]{0.2}).infinite());
    private static final String LAND = BUILDER.add("land", AnimationsBuilder.definition((double)0.44));
    private static final String LEAP = BUILDER.add("leap", AnimationsBuilder.definition((double)1.6).marker("leap", new double[]{0.64}));
    private static final String LEAP_SLASH = BUILDER.add("leap_slash", AnimationsBuilder.definition((double)0.64).marker("attack", new double[]{0.16}).marker("weapon_swing_start", new double[]{0.05}).marker("weapon_swing_end", new double[]{0.28}));
    private static final String DEATH = BUILDER.add("death", AnimationsBuilder.definition((double)0.68).infinite());
    private static final String FAKE_DEATH = BUILDER.add("fake_death", AnimationsBuilder.definition((double)5.92).marker("roar", new double[]{5.0}).marker("revive", new double[]{5.5}));
    private static final String SUMMON = BUILDER.add("summon", AnimationsBuilder.definition((double)2.0).marker("roar", new double[]{0.84}));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<Heracles> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        if (anim == null && this.getAnimationHandler().isCurrent(new String[]{UPPER_CUT})) {
            if (this.upperCutTarget != null) {
                this.upperCutTarget = null;
                this.getAnimationHandler().setAnimation(JUMP);
                return true;
            }
        } else if (anim != null) {
            if (anim.is(new String[]{UPPER_CUT})) {
                this.upperCutTarget = null;
            }
            if (anim.is(new String[]{LEAP})) {
                this.hitEntity = null;
            }
        }
        return false;
    });
    private boolean voidDeath;
    private class_1309 upperCutTarget;
    private List<class_1309> hits;
    private int lastHitTick;
    private final Vector4f summonColor = new Vector4f(0.19607843f, 0.17254902f, 0.14901961f, 0.8f);
    private int jumpCooldown;
    protected List<class_1309> hitEntity;

    public Heracles(class_1299<? extends BaseServant> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DEATH_COUNT, (Object)0);
    }

    protected void method_5964(class_5819 random, class_1266 difficulty) {
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)FateItems.HERACLES_AXE.get()));
    }

    @Override
    public boolean hasOwnWeapon() {
        return this.method_6047().method_31574((class_1792)FateItems.HERACLES_AXE.get());
    }

    @Override
    public ExtendedBehaviour<? extends BaseServant> getCombatAI() {
        return AttackBehaviourBuilder.create().start(BehaviourUtils.of(AnimationPlayHolder.builder((String)ONE_HAND_HEAVY_1).start(ONE_HAND_HEAVY_2, 2, 0.48f, 1).start(ONE_HAND_HEAVY_3, 2, 0.48f, 1).chainChance(0.5f).build())).play(BehaviourUtils.cooldownedPlay(true, 20, 35)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(12).start(BehaviourUtils.of(AnimationPlayHolder.builder((String)ONE_HAND_HEAVY_2).start(ONE_HAND_HEAVY_1, 2, 0.48f, 1).start(TWO_HAND_HEAVY_1, 2, 0.48f, 1).start(TWO_HAND_HEAVY_2, 2, 0.48f, 1).chain(ONE_HAND_HEAVY_3, 2, 0.48f).chainChance(0.5f).build())).play(BehaviourUtils.cooldownedPlay(true, 20, 35)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(12).start(BehaviourUtils.of(AnimationPlayHolder.builder((String)TWO_HAND_HEAVY_1).start(TWO_HAND_HEAVY_2, 2, 0.48f, 1).start(TWO_HAND_HEAVY_2, 2, 0.48f, 1).chain(ONE_HAND_HEAVY_2, 2, 0.48f).chainChance(0.5f).build())).play(BehaviourUtils.cooldownedPlay(true, 20, 35)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(12).start(new String[]{JUMP}).play(BehaviourUtils.cooldownedPlay(false, 40, 60)).condition(entity -> {
            class_1309 target = BrainUtils.getTargetOfEntity((class_1309)entity);
            if (this.jumpCooldown <= 0 && target != null && target.method_23318() - entity.method_23318() > 4.0) {
                class_243 pos = entity.method_19538();
                class_243 targetPos = target.method_19538();
                class_243 dir = targetPos.method_1020(pos);
                class_3966 hit = class_1675.method_18077((class_1937)entity.method_37908(), (class_1297)entity, (class_243)pos, (class_243)targetPos, (class_238)entity.method_5829().method_18804(dir), e -> e == target);
                if (hit != null) {
                    this.jumpCooldown = 80 + entity.method_59922().method_43048(40);
                    return true;
                }
            }
            return false;
        }).end(11).start(new String[]{UPPER_CUT}).play(BehaviourUtils.cooldownedPlay(true, 20, 35)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(6).start(new String[]{LEAP}).play(BehaviourUtils.cooldownedPlay(false, 20, 35)).condition(BehaviourUtils.ifFurtherThan(6.0, 2.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(BehaviourUtils.closeEnough(16))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(13).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseServant> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(12, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), BehaviourUtils.moveTo()}).add(4, new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget(), BehaviourUtils.moveTo()}).build();
    }

    @Override
    public void method_6007() {
        super.method_6007();
        AnimationState anim = this.getAnimationHandler().getAnimation();
        if (!this.method_37908().field_9236) {
            if (anim != null) {
                if (anim.isAt("roar")) {
                    this.method_5783((class_3414)FateSounds.HERACLES_ROAR.get(), 1.0f, 1.0f);
                    S2CScreenShake.sendAround((class_1297)this, 24.0, 16, 2.0f);
                }
                if (anim.is(new String[]{FAKE_DEATH}) && anim.isAt("revive")) {
                    int maxDeaths = this.props().getConfig(ServantExtraData.HERACLES_DEATH_MAX);
                    double mod = (double)this.getDeaths() / (double)maxDeaths * 0.7;
                    this.applyDeathMod(mod);
                    this.method_6033(this.method_6063());
                    this.method_6092(new class_1293(class_1294.field_5907, 300, 2, false, false));
                    this.revealServant();
                }
            }
        } else if (anim != null && anim.isAt("weapon_swing_start")) {
            this.method_37908().method_8406((class_2394)new TrailParticleData((class_2396<TrailParticleData>)((class_2396)FateParticles.TRAIL.get()), TrailInfo.builder(EntityWeaponTrailProvider.EntityTrailData.create(this, anim.getID(), false)).setColor(0.23529412f, 0.24313726f, 0.19215687f, 0.6f).setColor2(0.23529412f, 0.24313726f, 0.19215687f, 0.2f).setType(TrailInfo.Visual.TEXTURE, 0).build()), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("Deaths", this.getDeaths());
        tag.method_10556("DeathType", this.voidDeath);
    }

    @Override
    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setDeathNumber(tag.method_10550("Deaths"));
        this.voidDeath = tag.method_10577("DeathType");
    }

    public void setDeathNumber(int death) {
        this.field_6011.method_12778(DEATH_COUNT, (Object)class_3532.method_15340((int)death, (int)0, (int)this.props().getConfig(ServantExtraData.HERACLES_DEATH_MAX)));
    }

    public int getDeaths() {
        return (Integer)this.field_6011.method_12789(DEATH_COUNT);
    }

    public boolean method_5805() {
        return super.method_5805() && (this.getAnimationHandler() == null || !this.getAnimationHandler().isCurrent(new String[]{FAKE_DEATH}));
    }

    @Override
    public boolean method_5643(class_1282 damageSource, float damage) {
        if (!damageSource.method_48789(class_8103.field_42242)) {
            float f;
            damage -= 4.0f;
            if (f < 0.0f) {
                return false;
            }
        }
        return !this.getAnimationHandler().isCurrent(new String[]{FAKE_DEATH}) && super.method_5643(damageSource, damage);
    }

    protected void method_6074(class_1282 damageSource, float damageAmount) {
        super.method_6074(damageSource, damageAmount);
        if (this.method_6032() <= 0.0f && !damageSource.method_48789(class_8103.field_42242)) {
            int maxDeaths = this.props().getConfig(ServantExtraData.HERACLES_DEATH_MAX);
            if (this.getDeaths() < maxDeaths) {
                this.getAnimationHandler().setAnimation(FAKE_DEATH);
                this.method_6033(1.0E-4f);
                this.setDeathNumber(this.getDeaths() + 1);
            }
        }
    }

    private void applyDeathMod(double mod) {
        class_1324 att = this.method_5996(class_5134.field_23716);
        att.method_6200(DEATH_MOD);
        class_1324 dmg = this.method_5996(class_5134.field_23721);
        dmg.method_6200(DEATH_MOD);
        if (mod != 0.0) {
            att.method_26837(new class_1322(DEATH_MOD, -mod, class_1322.class_1323.field_6331));
            dmg.method_26837(new class_1322(DEATH_MOD, mod * 0.35, class_1322.class_1323.field_6331));
        }
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{UPPER_CUT})) {
            if (anim.isAt("attack")) {
                class_243 dir = class_243.method_1030((float)0.0f, (float)this.method_36454()).method_1021(2.0);
                this.setTargetPosition((TargetPosition)null);
                this.mobAttack(anim, this.method_5968(), e -> {
                    if (this.method_6121((class_1297)e)) {
                        e.method_18800(dir.method_10216(), 2.0, dir.method_10215());
                        e.field_6037 = true;
                        if (e instanceof class_3222) {
                            class_3222 player = (class_3222)e;
                            player.field_13987.method_14364((class_2596)new class_2743((class_1297)player));
                        }
                        if (this.upperCutTarget == null || e == this.method_5968()) {
                            this.upperCutTarget = e;
                        }
                    }
                });
            }
        } else if (anim.is(new String[]{JUMP})) {
            if (anim.isAt("jump")) {
                class_1309 target;
                class_1309 class_13092 = target = this.upperCutTarget != null ? this.upperCutTarget : this.method_5968();
                if (target != null) {
                    class_243 diff;
                    class_243 dir = diff.method_1031(0.0, (diff = target.method_19538().method_1019(target.method_18798().method_1021(20.0)).method_1020(this.method_19538())).method_10214() > 0.0 ? -diff.method_10214() * 0.5 : 0.0, 0.0).method_1029().method_1021(3.5);
                    this.method_18800(dir.method_10216(), class_3532.method_15350((double)dir.method_10214(), (double)1.5, (double)2.5), dir.method_10215());
                } else {
                    class_243 dir = class_243.method_1030((float)0.0f, (float)this.method_36454()).method_1021(2.0);
                    this.method_18800(dir.method_10216(), 2.0, dir.method_10215());
                }
            }
            if (anim.isPast("attempt") && !anim.done(0)) {
                OrientedBoundingBox obb = this.calculateAttackAABB(anim, null, 0.0);
                S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTEMPT, (class_1297)this);
                List hits = this.method_37908().method_8390(class_1309.class, obb.getEncompassingBox(), entity -> this.targetPred.test(entity) && obb.intersects(entity.method_5829()));
                if (!hits.isEmpty()) {
                    S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (class_1297)this);
                    this.getAnimationHandler().setAnimation(JUMP_HIT);
                    this.method_18799(class_243.field_1353);
                    this.hits = hits;
                    return;
                }
            }
            if (anim.done(0)) {
                this.method_18799(this.method_18798().method_1021(0.98));
                this.handleAirFall(anim);
            }
        } else if (anim.is(new String[]{JUMP_HIT})) {
            if (anim.isAt("attack") && this.hits != null) {
                class_243 dir = class_243.method_1030((float)0.0f, (float)this.method_36454());
                this.hits.forEach(e -> {
                    if (this.method_6121((class_1297)e)) {
                        e.method_18800(dir.method_10216(), -4.0, dir.method_10215());
                        e.field_6037 = true;
                        e.method_6092(new class_1293(FateMobEffects.GRAVITY.asHolder(), 200, 3));
                        if (e instanceof class_3222) {
                            class_3222 player = (class_3222)e;
                            player.field_13987.method_14364((class_2596)new class_2743((class_1297)player));
                        }
                    }
                });
                if (!this.hits.isEmpty()) {
                    AdvancedParticleContainer.make((class_2394)new RingParticleData(this.method_36454(), 40.0f)).addData((AdvancedParticleData)new ColorData(0.9f, 0.9f, 0.9f)).addData((AdvancedParticleData)new ScaleData(1.0f, 4.0f, 3)).addData((AdvancedParticleData)new ParticleMetaData(8, false, 0.0f)).add(this.method_37908(), this.method_23317(), this.method_23320(), this.method_23321());
                }
                this.hits = null;
                this.method_18799(this.method_18798().method_1031(0.0, -0.1, 0.0));
            }
            if (anim.isPast("attack")) {
                this.handleAirFall(anim);
            } else {
                this.method_18799(class_243.field_1353);
                if (this.hits != null) {
                    this.hits.forEach(e -> {
                        e.method_18799(class_243.field_1353);
                        if (e instanceof class_3222) {
                            class_3222 player = (class_3222)e;
                            player.field_13987.method_14364((class_2596)new class_2743((class_1297)player));
                        }
                    });
                }
            }
        } else if (anim.is(new String[]{LEAP})) {
            if (anim.isAt("leap")) {
                class_243 dir = this.method_5968() != null ? this.method_5968().method_19538().method_1020(this.method_19538()) : this.method_5828(1.0f);
                dir = new class_243(dir.method_10216(), 0.0, dir.method_10215());
                this.method_18799(dir.method_1029().method_1021(4.5).method_1031(0.0, 0.25, 0.0));
            }
            if (anim.isPast("leap")) {
                if (this.hitEntity == null) {
                    this.hitEntity = new ArrayList<class_1309>();
                }
                this.mobAttack(anim, this.method_5968(), e -> {
                    if (!this.hitEntity.contains(e)) {
                        this.hitEntity.add((class_1309)e);
                        this.method_6121((class_1297)e);
                    }
                });
                if (!this.hitEntity.isEmpty()) {
                    S2CScreenShake.sendAround((class_1297)this, 12.0, 8, 2.0f);
                    this.method_18799(this.method_18798().method_1021(0.05));
                    this.getAnimationHandler().setAnimation(LEAP_SLASH);
                }
            }
        } else {
            if (anim.isAt("step")) {
                class_243 dir = Utils.fromRelativeVector((class_1297)this, new class_243(0.0, 0.0, 1.0)).method_1021(0.3);
                this.method_18799(this.method_18798().method_1019(dir));
            }
            super.handleAttack(anim);
        }
    }

    private void handleAirFall(AnimationState anim) {
        this.field_6017 = 0.0f;
        if (anim.done(0) && this.method_24828()) {
            this.getAnimationHandler().setAnimation(LAND);
        }
        if (!(!anim.isPast(6.0) || this.method_55667().method_27852(class_2246.field_10124) && this.method_25936().method_27852(class_2246.field_10124))) {
            this.getAnimationHandler().setAnimation(LAND);
        }
    }

    @Override
    public boolean method_6121(class_1297 entity) {
        boolean hurt = super.method_6121(entity);
        if (hurt) {
            if (this.lastHitTick != this.field_6012) {
                S2CScreenShake.sendAround((class_1297)this, 12.0, 8, 2.0f);
                this.method_5783((class_3414)class_3417.field_15152.comp_349(), 1.0f, this.method_59922().method_43057() * 0.2f + 0.9f);
            }
            this.lastHitTick = this.field_6012;
        }
        return hurt;
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        if (anim.is(new String[]{JUMP})) {
            double widthH = (double)this.method_17681() * 0.5 + 1.3;
            double length = (double)this.method_17681() + 2.5;
            return new class_238(-widthH, -1.0, -0.5, widthH, (double)this.method_17682() + 1.5, length);
        }
        double height = this.method_17682();
        double width = this.method_17681();
        double length = 1.0f * this.method_55693();
        if (anim.is(new String[]{ONE_HAND_HEAVY_1, TWO_HAND_HEAVY_1})) {
            width += 0.6 * (double)this.method_55693();
            length += 1.7 * (double)this.method_55693();
        }
        if (anim.is(new String[]{ONE_HAND_HEAVY_2, ONE_HAND_HEAVY_3, TWO_HAND_HEAVY_2})) {
            width += 2.2 * (double)this.method_55693();
            length += 1.3 * (double)this.method_55693();
        }
        if (anim.is(new String[]{UPPER_CUT})) {
            width += 0.6 * (double)this.method_55693();
            length += 1.7 * (double)this.method_55693();
        }
        return new class_238(-width * 0.5, -0.03, 0.0, width * 0.5, height + 0.03, length);
    }

    public AnimationHandler<Heracles> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public String getDeathAnimation() {
        return DEATH;
    }

    @Override
    protected String getSummonAnimation() {
        return SUMMON;
    }

    @Override
    public double getSummonProgress(float partialTicks) {
        double prog = super.getSummonProgress(partialTicks);
        return prog >= 0.0 ? class_3532.method_15350((double)(prog * 2.0), (double)0.0, (double)1.0) : prog;
    }

    @Override
    public Vector4f summonColor() {
        return this.summonColor;
    }

    @Override
    public EntityWeaponTrailHolderProvider.WeaponTrail weaponTrailEdge(boolean left) {
        return new EntityWeaponTrailHolderProvider.WeaponTrail(new Vector4f(0.0f, 0.0f, -0.8f, 1.0f), new Vector4f(0.0f, 0.0f, -1.9f, 1.0f));
    }
}

