/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.servant;

import io.github.flemmli97.fateubw.common.config.CommonConfig;
import io.github.flemmli97.fateubw.common.effects.PetrificationEffect;
import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.BehaviourUtils;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.SetWalkToFront;
import io.github.flemmli97.fateubw.common.entity.misc.ChainDagger;
import io.github.flemmli97.fateubw.common.entity.summons.GordiusWheel;
import io.github.flemmli97.fateubw.common.entity.summons.Pegasus;
import io.github.flemmli97.fateubw.common.entity.utils.OnProjectileHit;
import io.github.flemmli97.fateubw.common.particles.RingParticleData;
import io.github.flemmli97.fateubw.common.particles.trail.TrailInfo;
import io.github.flemmli97.fateubw.common.particles.trail.TrailParticleData;
import io.github.flemmli97.fateubw.common.particles.trail.provider.entity.EntityWeaponTrailHolderProvider;
import io.github.flemmli97.fateubw.common.particles.trail.provider.entity.EntityWeaponTrailProvider;
import io.github.flemmli97.fateubw.common.registry.FateEntities;
import io.github.flemmli97.fateubw.common.registry.FateItems;
import io.github.flemmli97.fateubw.common.registry.FateMobEffects;
import io.github.flemmli97.fateubw.common.registry.FateParticles;
import io.github.flemmli97.fateubw.common.utils.Utils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4140;
import net.minecraft.class_5575;
import net.minecraft.class_5819;
import net.minecraft.class_8103;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public class Medusa
extends BaseServant
implements OnProjectileHit {
    protected static final class_2940<Boolean> THROWN_DAGGER = class_2945.method_12791(Medusa.class, (class_2941)class_2943.field_13323);
    public static final double VIEW_ANGLE = 0.5235987901687622;
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String DUAL_REVERSE_1 = BUILDER.add("dual_reverse_1", AnimationsBuilder.definition((double)0.64).marker("attack", new double[]{0.48}).marker("step", new double[]{0.24}).marker("weapon_swing_start", new double[]{0.32}).marker("weapon_swing_end", new double[]{0.52}));
    public static final String DUAL_REVERSE_2 = BUILDER.add("dual_reverse_2", AnimationsBuilder.definition((double)0.64).marker("attack", new double[]{0.48}).marker("step", new double[]{0.24}).marker("weapon_swing_start", new double[]{0.32}).marker("weapon_swing_end", new double[]{0.52}));
    public static final String DUAL_REVERSE_3 = BUILDER.add("dual_reverse_3", AnimationsBuilder.definition((double)0.64).marker("attack", new double[]{0.48}).marker("step", new double[]{0.24}).marker("weapon_swing_start", new double[]{0.32}).marker("weapon_swing_end", new double[]{0.52}));
    public static final String DUAL_REVERSE_4 = BUILDER.add("dual_reverse_4", AnimationsBuilder.definition((double)0.64).marker("attack", new double[]{0.48}).marker("step", new double[]{0.24}).marker("weapon_swing_start", new double[]{0.32}).marker("weapon_swing_end", new double[]{0.52}));
    public static final String CHAIN_THROW = BUILDER.add("chain_throw", AnimationsBuilder.definition((double)0.84).marker("attack", new double[]{0.6}));
    public static final String RETRIEVE = BUILDER.add("chain_retrieve", AnimationsBuilder.definition((double)0.88).marker("retrieve", new double[]{0.56}));
    public static final String EYE = BUILDER.add("eye", AnimationsBuilder.definition((double)1.88).marker("open", new double[]{0.64}).marker("close", new double[]{1.64}));
    public static final String JUMP = BUILDER.add("jump", AnimationsBuilder.definition((double)0.48).marker("jump", new double[]{0.24}).infinite());
    public static final String LAND = BUILDER.add("land", AnimationsBuilder.definition((double)0.64).marker("attack", new double[]{0.16}));
    public static final String BELLEROPHON = BUILDER.add("bellerophon", AnimationsBuilder.definition((double)2.28).marker("attack", new double[]{0.2}));
    public static final String SUMMON = BUILDER.add("summon", AnimationsBuilder.definition((double)2.0));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<Medusa> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        this.eyeAffected = null;
        return false;
    });
    private final Vector4f summonColor = new Vector4f(0.6862745f, 0.34509805f, 0.5568628f, 0.7f);
    private List<class_1309> eyeAffected;
    private ChainDagger dagger;
    private int throwCooldown;
    private int summonCooldown;
    private int eyeCooldown;

    private static Predicate<Medusa> meleeCondition(String anim) {
        return medusa -> {
            Pegasus pegasus;
            class_1297 vehicle = medusa.method_5854();
            if (!(vehicle instanceof Pegasus) || !(pegasus = (Pegasus)vehicle).canFly()) {
                return true;
            }
            class_1309 target = BrainUtils.getTargetOfEntity((class_1309)medusa);
            return target == null || medusa.prepareAttackBox(anim, (class_1297)target, -0.2f, false).intersects(target.method_5829());
        };
    }

    public Medusa(class_1299<? extends BaseServant> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(THROWN_DAGGER, (Object)false);
    }

    public boolean daggerThrown() {
        return (Boolean)this.method_5841().method_12789(THROWN_DAGGER);
    }

    protected void method_5964(class_5819 random, class_1266 difficulty) {
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)FateItems.MEDUSA_DAGGER.get()));
        this.method_5673(class_1304.field_6171, new class_1799((class_1935)FateItems.MEDUSA_DAGGER.get()));
    }

    @Override
    public boolean hasOwnWeapon() {
        return this.method_6047().method_31574((class_1792)FateItems.MEDUSA_DAGGER.get()) || this.method_6079().method_31574((class_1792)FateItems.MEDUSA_DAGGER.get());
    }

    @Override
    public ExtendedBehaviour<? extends BaseServant> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{DUAL_REVERSE_1}).play(BehaviourUtils.cooldownedPlay(true, 12, 20)).condition(Medusa.meleeCondition(DUAL_REVERSE_1)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((m, e) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(6).start(new String[]{DUAL_REVERSE_2}).play(BehaviourUtils.cooldownedPlay(true, 12, 20)).condition(entity -> Medusa.meleeCondition(DUAL_REVERSE_2).test((Medusa)entity) && !entity.method_6079().method_7960()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((m, e) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(6).start(new String[]{DUAL_REVERSE_3}).play(BehaviourUtils.cooldownedPlay(true, 12, 20)).condition(Medusa.meleeCondition(DUAL_REVERSE_3)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((m, e) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(6).start(new String[]{DUAL_REVERSE_4}).play(BehaviourUtils.cooldownedPlay(true, 12, 20)).condition(entity -> Medusa.meleeCondition(DUAL_REVERSE_4).test((Medusa)entity) && !entity.method_6079().method_7960()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((m, e) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(6).start(new String[]{JUMP}).play(BehaviourUtils.cooldownedPlay(false, 15, 25)).condition(entity -> !entity.method_5765()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((m, e) -> Float.valueOf(1.1f)).closeEnoughDist(BehaviourUtils.closeEnough(9))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(2).start(new String[]{JUMP}).play(BehaviourUtils.cooldownedPlay(false, 15, 25)).condition(entity -> !entity.method_5765() && BehaviourUtils.ifFurtherThan(8.0).test(entity)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((m, e) -> Float.valueOf(1.1f)).closeEnoughDist(BehaviourUtils.closeEnough(9))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(13).start(new String[]{CHAIN_THROW}).play(BehaviourUtils.cooldownedPlay(false, 15, 25)).condition(Medusa::canThrow).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(5.0).max(16.0).speedMod((m, e) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveTo()}).end(6).start(new String[]{CHAIN_THROW}).play(BehaviourUtils.cooldownedPlay(false, 15, 25)).condition(entity -> entity.canThrow() && BehaviourUtils.ifFurtherThan(6.0).test(entity)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(5.0).max(16.0).speedMod((m, e) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveTo()}).end(7).start(new String[]{EYE}).play(BehaviourUtils.cooldownedPlay(false, 30, 50)).condition(entity -> entity.eyeCooldown <= 0 && entity.healthBelow(0.75f)).prepare(new ExtendedBehaviour[]{new SetWalkToFront().distance(7.0f).speedMod((m, e) -> Float.valueOf(1.1f)).startCondition(medusa -> medusa.method_5968() != null && !Utils.isInView((class_1297)medusa.method_5968(), (class_1297)medusa, 0.5235987901687622))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack(20, 25)}).end(7).start(new String[]{EYE}).play(BehaviourUtils.cooldownedPlay(false, 30, 50)).condition(entity -> entity.eyeCooldown <= 0 && entity.healthBelow(0.5f)).prepare(new ExtendedBehaviour[]{new SetWalkToFront().distance(7.0f).speedMod((m, e) -> Float.valueOf(1.1f)).startCondition(medusa -> medusa.method_5968() != null && !Utils.isInView((class_1297)medusa.method_5968(), (class_1297)medusa, 0.5235987901687622))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack(20, 25)}).end(5).start(new String[]{EYE}).play(BehaviourUtils.cooldownedPlay(false, 30, 50)).condition(entity -> entity.eyeCooldown <= 0 && entity.healthBelow(0.75f) && !entity.method_5765()).prepare(new ExtendedBehaviour[]{new SetWalkToFront().distance(7.0f).speedMod((m, e) -> Float.valueOf(1.1f)).startCondition(medusa -> medusa.method_5968() != null && !Utils.isInView((class_1297)medusa.method_5968(), (class_1297)medusa, 0.5235987901687622))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack(20, 25)}).end(5).start(new String[]{BELLEROPHON}).play(BehaviourUtils.cooldownedPlay(false, 20, 40)).condition(Medusa::canSummonPegasus).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(6.0).max(12.0).speedMod((m, e) -> Float.valueOf(1.3f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveTo()}).end(40).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseServant> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(6, entity -> !entity.method_5765(), new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), BehaviourUtils.moveTo()}).add(3, new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().speedMod(1.1f), BehaviourUtils.moveTo()}).add(6, class_1297::method_5765, new ExtendedBehaviour[]{new SetRandomWalkTarget(), BehaviourUtils.moveTo()}).add(3, class_1297::method_5765, new ExtendedBehaviour[]{new Idle()}).build();
    }

    @Override
    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().field_9236) {
            if (this.dagger != null) {
                if (!this.dagger.method_5805()) {
                    this.dagger = null;
                    this.method_5841().method_12778(THROWN_DAGGER, (Object)false);
                }
            } else {
                --this.throwCooldown;
            }
            if (!this.method_5765()) {
                --this.summonCooldown;
            }
            --this.eyeCooldown;
        } else {
            AnimationState anim = this.getAnimationHandler().getAnimation();
            if (anim != null && anim.isAt("weapon_swing_start")) {
                this.method_37908().method_8406((class_2394)new TrailParticleData((class_2396<TrailParticleData>)((class_2396)FateParticles.TRAIL.get()), TrailInfo.builder(EntityWeaponTrailProvider.EntityTrailData.create(this, anim.getID(), false)).setColor(0.3137255f, 0.3137255f, 0.3137255f, 0.6f).setColor2(0.3137255f, 0.3137255f, 0.3137255f, 0.2f).setType(TrailInfo.Visual.TEXTURE, 0).build()), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{CHAIN_THROW})) {
            class_1309 target = this.method_5968();
            if (target != null) {
                this.method_5951((class_1297)target, 60.0f, 30.0f);
            }
            if (anim.isAt("attack")) {
                this.throwDaggerAt(target);
            }
        } else if (anim.is(new String[]{RETRIEVE})) {
            if (anim.isAt("retrieve") && this.dagger != null) {
                this.dagger.retractHook();
                this.dagger = null;
                this.method_5841().method_12778(THROWN_DAGGER, (Object)false);
                BrainUtils.clearMemory((class_1309)this, (class_4140)class_4140.field_22475);
            }
        } else if (anim.is(new String[]{EYE})) {
            class_1309 target = this.method_5968();
            if (target != null) {
                this.method_5951((class_1297)target, 60.0f, 30.0f);
            }
            if (anim.isAt("open")) {
                this.eyeAffected = new ArrayList<class_1309>();
                this.eyeCooldown = this.field_5974.method_43048(150) + 150;
            }
            if (anim.isPast("open") && !anim.isPast("close")) {
                this.gorgonsEyes();
            }
        } else if (anim.is(new String[]{JUMP})) {
            class_1309 target = this.method_5968();
            if (anim.isAt("jump")) {
                class_243 dir;
                if (target != null) {
                    dir = target.method_19538().method_1020(this.method_19538());
                    dir = (dir = new class_243(dir.method_10216(), 0.0, dir.method_10215())).method_1027() > 1024.0 ? dir.method_1029().method_1021(4.48) : dir.method_1021(0.14);
                } else {
                    dir = this.method_5828(1.0f).method_1021(0.75);
                }
                this.method_18800(dir.method_10216(), 0.8, dir.method_10215());
            }
            if (anim.isPast("jump")) {
                this.field_6017 = 0.0f;
                if (anim.done(0) && this.method_24828()) {
                    this.getAnimationHandler().setAnimation(this.getAnimationHandler().get(LAND), 0, -1, 0.0);
                }
                if (!(!anim.isPast(6.0) || this.method_55667().method_27852(class_2246.field_10124) && this.method_25936().method_27852(class_2246.field_10124))) {
                    this.getAnimationHandler().setAnimation(this.getAnimationHandler().get(LAND), 0, -1, 0.0);
                }
            }
        } else if (anim.is(new String[]{BELLEROPHON})) {
            class_1309 target = this.method_5968();
            if (target != null && !anim.isPast(0.28)) {
                this.method_5951((class_1297)target, 60.0f, 30.0f);
            }
            this.method_37908().method_18023(class_5575.method_31795(class_1309.class), this.method_5829().method_1009(12.0, 8.0, 12.0), this.targetPred).forEach(e -> {
                class_243 dir = e.method_19538().method_1020(this.method_19538());
                boolean none = dir.method_10216() == 0.0 && dir.method_10215() == 0.0;
                dir = new class_243(none ? 1.0 : dir.method_10216(), 0.0, dir.method_10215()).method_1029().method_1021(0.5);
                e.method_18799(e.method_18798().method_1019(dir));
                e.field_6037 = true;
            });
            if (anim.isAt("attack")) {
                this.summonPegasus();
            }
        } else {
            if (anim.isAt("step")) {
                class_243 dir = Utils.fromRelativeVector((class_1297)this, new class_243(0.0, 0.0, 1.0)).method_1021(0.3);
                this.method_18799(this.method_18798().method_1019(dir));
            }
            super.handleAttack(anim);
        }
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, class_243 target, double grow) {
        if (anim.is(new String[]{LAND})) {
            return new OrientedBoundingBox(this.attackBB(anim), this.method_36454(), 0.0f, this.method_19538());
        }
        if (this.method_5854() != null) {
            GordiusWheel gordiusWheel;
            class_1297 vehicle = this.method_5854();
            class_1297 class_12972 = this.method_5854();
            if (class_12972 instanceof GordiusWheel && (gordiusWheel = (GordiusWheel)class_12972).getWheelEntity() != null) {
                vehicle = gordiusWheel.getWheelEntity();
            }
            double width = (double)vehicle.method_17681() * 0.5 + 1.7;
            double height = this.method_23318() - vehicle.method_23318() + (double)this.method_17682() + 0.2;
            class_238 aabb = new class_238(-width * 0.5, -0.02, -width * 0.5, width * 0.5, height, width * 0.5);
            return new OrientedBoundingBox(aabb, vehicle.method_36454(), 0.0f, vehicle.method_19538());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        if (anim.is(new String[]{LAND})) {
            double width = this.method_17681() + 3.0f * this.method_55693();
            return new class_238(-width * 0.5, -0.02, -width * 0.3, width * 0.5, (double)this.method_17682() * 0.5, width * 0.7);
        }
        double height = this.method_17682();
        double width = this.method_17681();
        double length = 1.0f * this.method_55693();
        if (anim.is(new String[]{DUAL_REVERSE_1})) {
            return new class_238(-(width += 0.9 * (double)this.method_55693()) * 0.7, -0.03, 0.0, width * 0.3, height + 0.03, length += 0.6 * (double)this.method_55693());
        }
        if (anim.is(new String[]{DUAL_REVERSE_2})) {
            return new class_238(-(width += 0.9 * (double)this.method_55693()) * 0.3, -0.03, 0.0, width * 0.7, height + 0.03, length += 0.6 * (double)this.method_55693());
        }
        if (anim.is(new String[]{DUAL_REVERSE_3, DUAL_REVERSE_4})) {
            width += 0.8 * (double)this.method_55693();
            length += 0.7 * (double)this.method_55693();
        }
        return new class_238(-width * 0.5, -0.03, 0.0, width * 0.5, height + 0.03, length);
    }

    public AnimationHandler<Medusa> getAnimationHandler() {
        return this.animationHandler;
    }

    public boolean method_5747(float distance, float damageMultiplier, class_1282 source) {
        return false;
    }

    @Override
    public boolean method_5643(class_1282 damageSource, float damage) {
        if (this.getAnimationHandler().isCurrent(new String[]{BELLEROPHON})) {
            return false;
        }
        if (damageSource.method_48789(class_8103.field_42242)) {
            return super.method_5643(damageSource, damage);
        }
        if (this.method_5854() != null) {
            this.method_5854().method_5643(damageSource, damage *= 0.5f);
        }
        return super.method_5643(damageSource, damage);
    }

    @Override
    public boolean nobelPhantasmCheck() {
        return this.healthBelow(0.5f) && super.nobelPhantasmCheck();
    }

    public void throwDaggerAt(@Nullable class_1309 target) {
        if (!this.method_37908().field_9236) {
            ChainDagger dagger = new ChainDagger(this.method_37908(), (class_1309)this, true);
            if (target == null) {
                dagger.shoot((class_1297)this, this.method_36455(), this.method_36454(), 0.0f, 3.0f, 0.0f);
            } else {
                dagger.shootAtEntity((class_1297)target, 3.0f, 0.0f);
            }
            this.method_37908().method_8649((class_1297)dagger);
            this.dagger = dagger;
            this.throwCooldown = this.field_5974.method_43048(50) + 45;
            this.method_5841().method_12778(THROWN_DAGGER, (Object)true);
        }
    }

    public void gorgonsEyes() {
        if (this.eyeAffected == null) {
            this.eyeAffected = new ArrayList<class_1309>();
        }
        List entities = this.method_37908().method_18023(class_5575.method_31795(class_1309.class), this.method_5829().method_1014(32.0), e -> e == this.method_5968() || this.targetPred.test(e));
        boolean success = false;
        for (class_1309 entity : entities) {
            if (this.eyeAffected.contains(entity) || !Utils.isInView((class_1297)entity, (class_1297)this, 0.5235987901687622)) continue;
            this.eyeAffected.add(entity);
            class_1293 eff = entity.method_6112(FateMobEffects.PETRIFICATION.asHolder());
            int amplifier = 0;
            if (eff != null) {
                if (eff.method_5578() >= PetrificationEffect.MAX_PROGRESS) continue;
                amplifier = eff.method_5578() + 1;
            }
            entity.method_6092(new class_1293(FateMobEffects.PETRIFICATION.asHolder(), CommonConfig.petrificationDuration, amplifier));
            success = true;
        }
        if (success) {
            AdvancedParticleContainer.make((class_2394)new RingParticleData(this.method_5791(), 0.0f)).addData((AdvancedParticleData)new ScaleData(1.0f, 4.0f, 8)).addData((AdvancedParticleData)new ColorData(new Vector4f(0.49019608f, 0.047058824f, 0.49803922f, 1.0f), Optional.of(new Vector4f(0.49019608f, 0.047058824f, 0.49803922f, 0.2f)), 10)).addData((AdvancedParticleData)new ParticleMetaData(10, false, 0.0f)).add(this.method_37908(), this.method_23317(), this.method_23320(), this.method_23321());
            this.method_5783(class_3417.field_14931, 1.0f, this.method_59922().method_43057() * 0.2f + 1.1f);
        }
    }

    protected boolean canSummonPegasus() {
        return !this.method_5765() && this.canUseNobelPhantasm() && this.summonCooldown <= 0;
    }

    public void summonPegasus() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (!this.attemptUseNobelPhantasm()) {
                return;
            }
            Pegasus peg = (Pegasus)((class_1299)FateEntities.PEGASUS.get()).method_5888(serverLevel, null, this.method_24515(), class_3730.field_16471, false, false);
            peg.method_33574(this.method_19538());
            peg.method_36456(this.method_36454());
            peg.field_5982 = this.method_36454();
            peg.field_6241 = this.method_36454();
            peg.field_6259 = this.method_36454();
            peg.field_6283 = this.method_36454();
            peg.field_6220 = this.method_36454();
            this.method_37908().method_8649((class_1297)peg);
            this.method_5873((class_1297)peg, true);
            this.revealServant();
            this.summonCooldown = 150 + this.method_59922().method_43048(100);
        }
    }

    @Override
    protected String getSummonAnimation() {
        return SUMMON;
    }

    @Override
    public Vector4f summonColor() {
        return this.summonColor;
    }

    public boolean canThrow() {
        return this.dagger == null && this.throwCooldown <= 0;
    }

    @Override
    public void onProjectileHit(class_1297 entity) {
        if (entity instanceof ChainDagger) {
            this.getAnimationHandler().setAnimation(RETRIEVE);
        }
    }

    @Override
    public EntityWeaponTrailHolderProvider.WeaponTrail weaponTrailEdge(boolean left) {
        return new EntityWeaponTrailHolderProvider.WeaponTrail(new Vector4f(0.0f, 0.0f, -0.5f, 1.0f), new Vector4f(0.0f, 0.0f, -0.8f, 1.0f));
    }
}

