/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.servant.lancelot;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.fateubw.api.datapack.ServantExtraData;
import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.fateubw.common.entity.HeldEquipmentHandler;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.BehaviourUtils;
import io.github.flemmli97.fateubw.common.entity.servant.lancelot.LancelotAttackAI;
import io.github.flemmli97.fateubw.common.entity.servant.lancelot.LancelotInventory;
import io.github.flemmli97.fateubw.common.entity.servant.lancelot.LancelotUseHandler;
import io.github.flemmli97.fateubw.common.lib.FateTags;
import io.github.flemmli97.fateubw.common.network.S2CScreenShake;
import io.github.flemmli97.fateubw.common.particles.trail.TrailInfo;
import io.github.flemmli97.fateubw.common.particles.trail.TrailParticleData;
import io.github.flemmli97.fateubw.common.particles.trail.provider.entity.EntityWeaponTrailHolderProvider;
import io.github.flemmli97.fateubw.common.particles.trail.provider.entity.EntityWeaponTrailProvider;
import io.github.flemmli97.fateubw.common.registry.FateDataComponents;
import io.github.flemmli97.fateubw.common.registry.FateEntities;
import io.github.flemmli97.fateubw.common.registry.FateItems;
import io.github.flemmli97.fateubw.common.registry.FateParticles;
import io.github.flemmli97.fateubw.common.utils.MathsHelper;
import io.github.flemmli97.fateubw.common.utils.Utils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.LeapInDirection;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.data.AnimationPlayHolder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.utils.ItemUtils;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.function.Predicate;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1676;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1835;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3902;
import net.minecraft.class_5151;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_8103;
import net.minecraft.class_9331;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import org.joml.Vector4f;

public class Lancelot
extends BaseServant {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String TWO_HAND_1 = BUILDER.add("two_hand_1", AnimationsBuilder.definition((double)1.0).marker("attack", new double[]{0.88}).marker("step", new double[]{0.6}).marker("weapon_swing_start", new double[]{0.6}).marker("weapon_swing_end", new double[]{0.92}));
    public static final String TWO_HAND_2 = BUILDER.add("two_hand_2", AnimationsBuilder.definition((double)0.96).marker("attack", new double[]{0.84}).marker("step", new double[]{0.52}).marker("weapon_swing_start", new double[]{0.6}).marker("weapon_swing_end", new double[]{0.88}));
    public static final String TWO_HAND_3 = BUILDER.add("two_hand_3", AnimationsBuilder.definition((double)0.92).marker("attack", new double[]{0.8}).marker("step", new double[]{0.52}).marker("weapon_swing_start", new double[]{0.6}).marker("weapon_swing_end", new double[]{0.84}));
    public static final String TWO_HAND_4 = BUILDER.add("two_hand_4", AnimationsBuilder.definition((double)0.96).marker("attack", new double[]{0.84}).marker("step", new double[]{0.52}).marker("weapon_swing_start", new double[]{0.6}).marker("weapon_swing_end", new double[]{0.88}));
    public static final String ONE_HAND_1 = BUILDER.add("one_hand_1", AnimationsBuilder.definition((double)0.68).marker("attack", new double[]{0.56}).marker("step", new double[]{0.32}).marker("weapon_swing_start", new double[]{0.4}).marker("weapon_swing_end", new double[]{0.6}));
    public static final String STAB_1 = BUILDER.add("stab_1", AnimationsBuilder.definition((double)0.8).marker("attack", new double[]{0.68}));
    public static final String JUMP = BUILDER.add("jump", AnimationsBuilder.definition((double)0.48).marker("jump", new double[]{0.28}).infinite());
    public static final String JUMP_LAND = BUILDER.add("jump_land", AnimationsBuilder.definition((double)1.08).marker("attack", new double[]{0.2}));
    public static final String TRIDENT = BUILDER.add("trident", AnimationsBuilder.definition((double)1.52).marker("attack", new double[]{1.0}));
    public static final String BOW = BUILDER.add("bow", AnimationsBuilder.definition((double)1.28).marker("use_start", new double[]{0.24}).marker("attack", new double[]{1.08}));
    public static final String CROSSBOW = BUILDER.add("crossbow", AnimationsBuilder.definition((double)2.2).marker("use_start", new double[]{0.32}).marker("attack", new double[]{1.88}));
    public static final String GUN = BUILDER.add("gun", AnimationsBuilder.definition((double)3.28).marker("attack_start", new double[]{1.0}).marker("attack_end", new double[]{2.16}));
    public static final String SUMMON = BUILDER.add("summon", AnimationsBuilder.definition((double)2.0));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<Lancelot> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        if (anim != null) {
            this.swapWithInventory(anim.animation());
        } else {
            this.swapWithInventory(null);
        }
        return false;
    });
    private final Vector4f summonColor = new Vector4f(0.10980392f, 0.10980392f, 0.12941177f, 0.7f);
    public final HeldEquipmentHandler heldEquipmentHandler = new HeldEquipmentHandler((class_1309)this, new class_1799((class_1935)FateItems.ARONDIGHT.get()), null);
    private final LancelotInventory inventory = new LancelotInventory((class_1309)this);
    private final class_1277 swapped = new class_1277(1);
    private int pickupDelay;

    public Lancelot(class_1299<? extends Lancelot> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void method_5964(class_5819 random, class_1266 difficulty) {
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8091));
    }

    @Override
    public boolean hasOwnWeapon() {
        return this.method_6047().method_31574((class_1792)FateItems.ARONDIGHT.get());
    }

    @Override
    public HeldEquipmentHandler getEquipmentHandler() {
        return this.heldEquipmentHandler;
    }

    @Override
    public ExtendedBehaviour<? extends BaseServant> getCombatAI() {
        return AttackBehaviourBuilder.create().start(BehaviourUtils.of(AnimationPlayHolder.builder((String)TWO_HAND_1).start(TWO_HAND_2, 2, 0.24f, 1).start(TWO_HAND_3, 2, 0.24f, 1).chainChance(0.5f).build())).play(BehaviourUtils.cooldownedPlay(true, 20, 30)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(5).start(BehaviourUtils.of(AnimationPlayHolder.builder((String)TWO_HAND_2).start(TWO_HAND_1, 2, 0.24f, 1).chain(ONE_HAND_1).chainChance(0.5f).build())).play(BehaviourUtils.cooldownedPlay(true, 20, 30)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(5).start(BehaviourUtils.of(AnimationPlayHolder.builder((String)TWO_HAND_4).start(TWO_HAND_2, 2, 0.24f, 1).start(TWO_HAND_3, 2, 0.24f, 1).chainChance(0.5f).build())).play(BehaviourUtils.cooldownedPlay(true, 20, 30)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(5).start(new String[]{ONE_HAND_1}).play(BehaviourUtils.cooldownedPlay(true, 20, 30)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(5).start(new String[]{STAB_1}).play(BehaviourUtils.cooldownedPlay(true, 20, 30)).condition(entity -> entity.canUseAttack(STAB_1)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(2.0).max(4.0)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveTo()}).end(5).start(new String[]{JUMP}).play(BehaviourUtils.cooldownedPlay(false, 20, 30)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((m, e) -> Float.valueOf(1.1f)).closeEnoughDist(BehaviourUtils.closeEnough(9))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(2).start(new String[]{JUMP}).play(BehaviourUtils.cooldownedPlay(false, 20, 25)).condition(BehaviourUtils.ifFurtherThan(8.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((m, e) -> Float.valueOf(1.1f)).closeEnoughDist(BehaviourUtils.closeEnough(9))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(12).start(new String[]{BOW}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(11.0), 25, 35)).condition(entity -> entity.canUseAttack(BOW)).prepare(new ExtendedBehaviour[]{new LeapInDirection().shouldLeap((owner, target) -> owner.method_5858((class_1297)target) < 49.0).horizontalDirection((owner, target) -> LeapInDirection.createBackwardsVec((class_243)owner.method_19538(), (class_243)target.method_19538()).method_1021((double)1.3f))}).end(3).start(new String[]{BOW}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(11.0), 25, 35)).condition(entity -> entity.canUseAttack(BOW)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(5.0).max(10.0).speedMod(1.1f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(2).start(new String[]{CROSSBOW}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(15.0), 25, 35)).condition(entity -> entity.canUseAttack(CROSSBOW)).prepare(new ExtendedBehaviour[]{new LeapInDirection().shouldLeap((owner, target) -> owner.method_5858((class_1297)target) < 49.0).horizontalDirection((owner, target) -> LeapInDirection.createBackwardsVec((class_243)owner.method_19538(), (class_243)target.method_19538()).method_1021((double)1.3f))}).end(3).start(new String[]{CROSSBOW}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(15.0), 25, 35)).condition(entity -> entity.canUseAttack(CROSSBOW)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(5.0).max(10.0).speedMod(1.1f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(2).start(new String[]{TRIDENT}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(11.0), 25, 35)).condition(entity -> entity.canUseAttack(TRIDENT)).prepare(new ExtendedBehaviour[]{new LeapInDirection().shouldLeap((owner, target) -> owner.method_5858((class_1297)target) < 49.0).horizontalDirection((owner, target) -> LeapInDirection.createBackwardsVec((class_243)owner.method_19538(), (class_243)target.method_19538()).method_1021((double)1.3f))}).end(3).start(new String[]{TRIDENT}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(11.0), 25, 35)).condition(entity -> entity.canUseAttack(TRIDENT)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(5.0).max(10.0).speedMod(1.1f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(2).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseServant> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(6, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), BehaviourUtils.moveTo()}).add(3, new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().speedMod(1.1f).radius(7.0), BehaviourUtils.moveTo()}).build();
    }

    @Override
    public void method_6007() {
        super.method_6007();
        --this.pickupDelay;
        if (this.method_37908().field_9236) {
            for (int x = 0; x < 2; ++x) {
                this.method_37908().method_8406((class_2394)class_2398.field_11237, this.method_23317() + (this.field_5974.method_43058() - 0.5) * (double)this.method_17681(), this.method_23318() + this.field_5974.method_43058() * (double)this.method_17682(), this.method_23321() + (this.field_5974.method_43058() - 0.5) * (double)this.method_17681(), this.field_5974.method_43059() * 0.02, this.field_5974.method_43059() * 0.02, this.field_5974.method_43059() * 0.02);
            }
            AnimationState anim = this.getAnimationHandler().getAnimation();
            if (anim != null && anim.isAt("weapon_swing_start")) {
                this.method_37908().method_8406((class_2394)new TrailParticleData((class_2396<TrailParticleData>)((class_2396)FateParticles.TRAIL.get()), TrailInfo.builder(EntityWeaponTrailProvider.EntityTrailData.create(this, anim.getID(), false)).setColor(0.0f, 0.0f, 0.0f, 0.5f).setColor2(0.2f, 0.0f, 0.0f, 0.5f).setType(TrailInfo.Visual.SOLID, 0).build()), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
            }
        } else {
            this.heldEquipmentHandler.setInUse(this.healthBelow(0.5f) && !this.inventory.swapped());
        }
    }

    @Override
    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10566("Inventory", (class_2520)this.inventory.save((class_7225.class_7874)this.method_56673()));
        tag.method_10566("Swapped", (class_2520)this.swapped.method_7660((class_7225.class_7874)this.method_56673()));
    }

    @Override
    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.inventory.load(tag.method_10562("Inventory"), (class_7225.class_7874)this.method_56673());
        this.swapped.method_7659(tag.method_10554("Swapped", 10), (class_7225.class_7874)this.method_56673());
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{JUMP})) {
            class_1309 target = this.method_5968();
            if (anim.isAt("jump")) {
                class_243 dir;
                if (target != null) {
                    dir = target.method_19538().method_1020(this.method_19538());
                    dir = (dir = new class_243(dir.method_10216(), 0.0, dir.method_10215())).method_1027() > 676.0 ? dir.method_1029().method_1021(3.6400000000000006) : dir.method_1021(0.14);
                } else {
                    dir = this.method_5828(1.0f).method_1021(0.75);
                }
                this.method_18800(dir.method_10216(), 1.0, dir.method_10215());
            }
            if (anim.isPast("jump")) {
                this.field_6017 = 0.0f;
                if (anim.done(0) && this.method_24828()) {
                    this.getAnimationHandler().setAnimation(this.getAnimationHandler().get(JUMP_LAND), 0, -1, 0.0);
                }
                if (!(!anim.isPast(6.0) || this.method_55667().method_27852(class_2246.field_10124) && this.method_25936().method_27852(class_2246.field_10124))) {
                    this.getAnimationHandler().setAnimation(this.getAnimationHandler().get(JUMP_LAND), 0, -1, 0.0);
                }
            }
        } else if (anim.is(new String[]{CROSSBOW, BOW, TRIDENT})) {
            class_1268 hand;
            Pair<class_2960, LancelotUseHandler> handler;
            class_1309 target = this.method_5968();
            if (anim.isAt("use_start") && (handler = LancelotAttackAI.getFor(this.method_5998(hand = this.toUseHand()))) != null) {
                ((LancelotUseHandler)handler.getSecond()).startUse((class_1309)this, target, hand);
            }
            if (!anim.isPast("attack")) {
                this.setTargetPositionFromAttackTarget();
            }
            if (anim.isAt("attack") && (target == null || this.method_5985().method_6369((class_1297)target)) && (handler = LancelotAttackAI.getFor(this.method_5998(hand = this.toUseHand()))) != null) {
                this.field_6222 = 1;
                ((LancelotUseHandler)handler.getSecond()).use((class_1309)this, target, this.method_6058());
            }
        } else {
            if (anim.isAt("step")) {
                class_243 dir = Utils.fromRelativeVector((class_1297)this, new class_243(0.0, 0.0, 1.0)).method_1021(0.3);
                this.method_18799(this.method_18798().method_1019(dir));
            }
            if (anim.isAt("attack") && anim.is(new String[]{JUMP_LAND})) {
                S2CScreenShake.sendAround((class_1297)this, 10.0, 8, 3.0f);
                this.method_5783((class_3414)class_3417.field_15152.comp_349(), 1.0f, 0.9f);
            }
            super.handleAttack(anim);
        }
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, class_243 target, double grow) {
        if (anim.is(new String[]{JUMP_LAND})) {
            return new OrientedBoundingBox(this.attackBB(anim), this.method_36454(), 0.0f, this.method_19538());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        if (anim.is(new String[]{JUMP_LAND})) {
            double width = this.method_17681() + 4.0f * this.method_55693();
            return new class_238(-width * 0.5, -0.02, -width * 0.3, width * 0.5, (double)this.method_17682() * 0.5, width * 0.7);
        }
        double height = this.method_17682();
        double width = this.method_17681();
        double length = 1.0f * this.method_55693();
        if (anim.is(new String[]{TWO_HAND_1})) {
            return new class_238(-(width += 2.4 * (double)this.method_55693()) * 0.6, -0.03, 0.0, width * 0.4, height + 0.03, length += (double)(1.0f * this.method_55693()));
        }
        if (anim.is(new String[]{TWO_HAND_2})) {
            return new class_238(-(width += 2.4 * (double)this.method_55693()) * 0.4, -0.03, 0.0, width * 0.6, height + 0.03, length += (double)(1.0f * this.method_55693()));
        }
        if (anim.is(new String[]{TWO_HAND_3, TWO_HAND_4})) {
            width += 1.9 * (double)this.method_55693();
            length += (double)(1.0f * this.method_55693());
        }
        if (anim.is(new String[]{ONE_HAND_1})) {
            width += 1.5 * (double)this.method_55693();
            length += 0.75 * (double)this.method_55693();
        }
        if (anim.is(new String[]{STAB_1})) {
            width += 0.3 * (double)this.method_55693();
            length += (double)(2.0f * this.method_55693());
        }
        return new class_238(-width * 0.5, -0.03, 0.0, width * 0.5, height + 0.03, length);
    }

    public AnimationHandler<Lancelot> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public boolean method_5643(class_1282 damageSource, float damage) {
        if (damageSource.method_48789(class_8103.field_42242)) {
            return super.method_5643(damageSource, damage);
        }
        if (this.method_5765()) {
            return this.method_5854().method_5643(damageSource, damage);
        }
        if (!damageSource.method_48789(class_8103.field_42242) && !this.method_37908().field_9236 && damageSource.method_48789(class_8103.field_42247) && !damageSource.method_48789(class_8103.field_42241) && this.method_59922().method_43057() < this.props().getConfig(ServantExtraData.LANCELOT_REFLECT_CHANCE).floatValue() && damageSource.method_5526() != null && !(damageSource.method_5526() instanceof class_1309)) {
            this.reflectProjectile(damageSource.method_5526());
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_14785, class_3419.field_15254, 1.0f, 1.0f);
            return false;
        }
        return super.method_5643(damageSource, damage);
    }

    public boolean method_5936() {
        return true;
    }

    protected void method_5949(class_1542 itemEntity) {
        if (itemEntity.method_6977()) {
            return;
        }
        super.method_5949(itemEntity);
    }

    public class_1799 method_24523(class_1799 stack) {
        if (this.pickupDelay > 0) {
            return class_1799.field_8037;
        }
        class_1799 res = this.inventory.insert(stack);
        if (res != null) {
            if (!res.method_7960()) {
                this.method_5775(res);
            }
            return stack;
        }
        class_5151 equipable = class_5151.method_48957((class_1799)stack);
        class_1304 equipmentSlot = equipable != null ? equipable.method_7685() : class_1304.field_6173;
        class_1799 current = this.method_6118(equipmentSlot);
        if (current.method_7909() == FateItems.ARONDIGHT.get() && equipmentSlot == class_1304.field_6173) {
            return class_1799.field_8037;
        }
        if (this.method_5939(stack) && this.method_5955(stack, current)) {
            if (!current.method_7960()) {
                this.method_5775(current);
            }
            this.method_24834(equipmentSlot, stack);
            this.revealServant();
            return stack;
        }
        return class_1799.field_8037;
    }

    protected boolean method_5955(class_1799 candidate, class_1799 existing) {
        return ItemUtils.isItemBetter((class_1309)this, null, (class_1799)candidate, (class_1799)existing);
    }

    public void method_5673(class_1304 slot, class_1799 stack) {
        if (stack.method_7909() != FateItems.ARONDIGHT.get()) {
            stack.method_57379((class_9331)FateDataComponents.CORRUPTED_ITEM.get(), (Object)class_3902.field_17274);
        }
        super.method_5673(slot, stack);
    }

    protected void method_16078() {
        super.method_16078();
        for (class_1799 stack : this.inventory) {
            this.method_5775(stack);
        }
        this.inventory.clearContent();
    }

    public class_1542 method_5775(class_1799 stack) {
        stack.method_57381((class_9331)FateDataComponents.CORRUPTED_ITEM.get());
        return super.method_5775(stack);
    }

    @Override
    public boolean nobelPhantasmCheck() {
        return this.healthBelow(0.5f) && super.nobelPhantasmCheck();
    }

    public boolean canUseAttack(String animation) {
        if (animation.equals(TRIDENT)) {
            return this.checkHands(s -> LancelotAttackAI.get(LancelotAttackAI.TRIDENT).matches((class_1799)s)) || !this.inventory.get(LancelotAttackAI.TRIDENT).method_7960();
        }
        if (animation.equals(BOW)) {
            return this.checkHands(s -> LancelotAttackAI.get(LancelotAttackAI.BOW).matches((class_1799)s)) || !this.inventory.get(LancelotAttackAI.BOW).method_7960();
        }
        if (animation.equals(CROSSBOW)) {
            return this.checkHands(s -> LancelotAttackAI.get(LancelotAttackAI.CROSSBOW).matches((class_1799)s)) || !this.inventory.get(LancelotAttackAI.CROSSBOW).method_7960();
        }
        if (animation.equals(STAB_1)) {
            return this.checkHands(s -> s.method_31573(FateTags.Items.SPEARS)) || !this.inventory.get(LancelotAttackAI.TRIDENT).method_7960() || !this.inventory.get(LancelotInventory.SPEAR).method_7960();
        }
        return !this.method_6047().method_7960() || !this.method_6079().method_7960();
    }

    private boolean checkHands(Predicate<class_1799> stack) {
        return stack.test(this.method_6047()) || stack.test(this.method_6079());
    }

    private void swapWithInventory(String animation) {
        if (this.method_37908().field_9236) {
            return;
        }
        if (animation == null) {
            this.inventory.swapItems(null);
        } else if (animation.equals(BOW)) {
            if (!this.checkHands(s -> LancelotAttackAI.get(LancelotAttackAI.BOW).matches((class_1799)s))) {
                this.inventory.swapItems(LancelotAttackAI.BOW);
            }
        } else if (animation.equals(CROSSBOW)) {
            if (!this.checkHands(s -> LancelotAttackAI.get(LancelotAttackAI.CROSSBOW).matches((class_1799)s))) {
                this.inventory.swapItems(LancelotAttackAI.CROSSBOW);
            }
        } else if (animation.equals(TRIDENT)) {
            if (!this.checkHands(s -> LancelotAttackAI.get(LancelotAttackAI.TRIDENT).matches((class_1799)s))) {
                this.inventory.swapItems(LancelotAttackAI.TRIDENT);
            }
        } else if (animation.equals(STAB_1) && !this.checkHands(s -> s.method_31573(FateTags.Items.SPEARS)) && !this.inventory.swapItems(LancelotInventory.SPEAR)) {
            this.inventory.swapItems(LancelotAttackAI.TRIDENT);
        }
    }

    protected class_1268 toUseHand() {
        if (this.getAnimationHandler().isCurrent(new String[]{CROSSBOW})) {
            return this.method_6047().method_7909() instanceof class_1764 ? class_1268.field_5808 : class_1268.field_5810;
        }
        if (this.getAnimationHandler().isCurrent(new String[]{TRIDENT})) {
            return this.method_6047().method_7909() instanceof class_1835 ? class_1268.field_5808 : class_1268.field_5810;
        }
        if (this.getAnimationHandler().isCurrent(new String[]{BOW})) {
            return this.method_6047().method_7909() instanceof class_1753 ? class_1268.field_5808 : class_1268.field_5810;
        }
        if (this.getAnimationHandler().isCurrent(new String[]{STAB_1})) {
            return this.method_6047().method_31573(FateTags.Items.SPEARS) ? class_1268.field_5808 : class_1268.field_5810;
        }
        return !this.method_6047().method_7960() ? class_1268.field_5808 : class_1268.field_5810;
    }

    public class_1799 method_18808(class_1799 weaponStack) {
        class_1792 class_17922 = weaponStack.method_7909();
        if (class_17922 instanceof class_1811) {
            class_1811 weapon = (class_1811)class_17922;
            Predicate predicate = weapon.method_20310();
            class_1799 itemstack = class_1811.method_18815((class_1309)this, (Predicate)predicate);
            if (itemstack.method_7960()) {
                class_1799 arrow = this.inventory.get(LancelotInventory.ARROWS);
                if (predicate.test(arrow)) {
                    return arrow;
                }
                class_1799 firework = this.inventory.get(LancelotInventory.FIREWORKS);
                if (predicate.test(firework)) {
                    return firework;
                }
            }
            return itemstack.method_7960() ? new class_1799((class_1935)class_1802.field_8107) : itemstack;
        }
        return super.method_18808(weaponStack);
    }

    private void reflectProjectile(class_1297 oldProjectile) {
        class_1297 entity;
        class_2487 old = new class_2487();
        oldProjectile.method_5647(old);
        old.method_10551("UUID");
        if (old.method_10545("Owner")) {
            old.method_25927("Owner", this.method_5667());
        }
        if ((entity = oldProjectile.method_5864().method_5883(this.method_37908())) instanceof class_1676) {
            class_1676 projectile = (class_1676)entity;
            entity.method_5651(old);
            projectile.method_7432((class_1297)this);
            float velocity = (float)(entity.method_18798().method_1033() * 0.7);
            if (this.method_5968() != null) {
                class_1309 target = this.method_5968();
                class_243 dir = new class_243(target.method_23317() - entity.method_23317(), target.method_23318() + (double)target.method_5751() - entity.method_23318(), target.method_23321() - entity.method_23321());
                this.shootProj(entity, dir.field_1352, dir.field_1351, dir.field_1350, velocity, 1.0f);
            } else {
                this.shootProj(entity, -entity.method_18798().field_1352, -entity.method_18798().field_1351, -entity.method_18798().field_1350, velocity, 1.0f);
            }
            this.method_37908().method_8649(entity);
        }
    }

    private void shootProj(class_1297 e, double dirX, double dirY, double dirZ, float vel, float acc) {
        class_243 dir = new class_243(dirX, dirY, dirZ).method_1029().method_1031(this.field_5974.method_43059() * (double)0.0075f * (double)acc, this.field_5974.method_43059() * (double)0.0075f * (double)acc, this.field_5974.method_43059() * (double)0.0075f * (double)acc).method_1021((double)vel);
        e.method_18799(dir);
        float[] xYRot = MathsHelper.YXRotFrom(dir);
        float targetYRot = xYRot[0];
        float targetXRot = xYRot[1];
        e.method_36456(targetYRot);
        e.method_36457(targetXRot);
        e.field_5982 = e.method_36454();
        e.field_6004 = e.method_36455();
    }

    @Override
    public String[] specialCommands() {
        return new String[]{String.valueOf(FateEntities.LANCELOT.getID()) + ".drop"};
    }

    @Override
    public void doSpecialCommand(class_3222 sender, String id) {
        if (id.equals(String.valueOf(FateEntities.LANCELOT.getID()) + ".drop")) {
            this.swapWithInventory(null);
            for (class_1799 stack : this.inventory) {
                this.method_5775(stack);
            }
            this.inventory.clearContent();
            this.pickupDelay = 100;
        }
    }

    @Override
    public boolean flipAnimation() {
        return this.toUseHand() == class_1268.field_5810;
    }

    @Override
    protected String getSummonAnimation() {
        return SUMMON;
    }

    @Override
    public Vector4f summonColor() {
        return this.summonColor;
    }

    @Override
    public EntityWeaponTrailHolderProvider.WeaponTrail weaponTrailEdge(boolean left) {
        return new EntityWeaponTrailHolderProvider.WeaponTrail(new Vector4f(0.0f, 0.0f, -0.6f, 1.0f), new Vector4f(0.0f, 0.0f, -1.3f, 1.0f));
    }
}

