/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.servant.lancelot;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.common.entity.servant.lancelot.LancelotUseHandler;
import io.github.flemmli97.fateubw.common.entity.servant.lancelot.impl.BowHandler;
import io.github.flemmli97.fateubw.common.entity.servant.lancelot.impl.CrossbowHandler;
import io.github.flemmli97.fateubw.common.entity.servant.lancelot.impl.TridentHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LancelotAttackAI {
    private static final List<OrderedResource> ORDERED_RESOURCES = new ArrayList<OrderedResource>();
    private static final Map<class_2960, LancelotUseHandler> REGISTRY = new HashMap<class_2960, LancelotUseHandler>();
    public static class_2960 BOW = LancelotAttackAI.register(Fate.modRes("bow"), new BowHandler());
    public static class_2960 CROSSBOW = LancelotAttackAI.register(Fate.modRes("crossbow"), new CrossbowHandler());
    public static class_2960 TRIDENT = LancelotAttackAI.register(Fate.modRes("trident"), new TridentHandler());

    public static void init() {
    }

    public static synchronized class_2960 register(class_2960 id, LancelotUseHandler handler) {
        return LancelotAttackAI.register(id, ORDERED_RESOURCES.size(), handler);
    }

    public static synchronized class_2960 register(class_2960 id, int order, LancelotUseHandler handler) {
        if (REGISTRY.put(id, handler) != null) {
            throw new IllegalStateException("Handler with id " + String.valueOf(id) + " already registered!");
        }
        ORDERED_RESOURCES.add(new OrderedResource(order, id));
        ORDERED_RESOURCES.sort(Collections.reverseOrder());
        return id;
    }

    public static Map<class_2960, LancelotUseHandler> getView() {
        return ImmutableMap.copyOf(REGISTRY);
    }

    public static LancelotUseHandler get(class_2960 id) {
        return REGISTRY.get(id);
    }

    @Nullable
    public static Pair<class_2960, LancelotUseHandler> getFor(class_1799 stack) {
        for (OrderedResource r : ORDERED_RESOURCES) {
            LancelotUseHandler v = REGISTRY.get(r.res);
            if (!v.matches(stack)) continue;
            return Pair.of((Object)r.res, (Object)v);
        }
        return null;
    }

    record OrderedResource(int order, class_2960 res) implements Comparable<OrderedResource>
    {
        @Override
        public int compareTo(@NotNull OrderedResource o) {
            return this.order == o.order ? this.res.method_12833(o.res) : Integer.compare(this.order, o.order);
        }
    }
}

