/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.servant.lancelot;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.common.entity.servant.lancelot.LancelotAttackAI;
import io.github.flemmli97.fateubw.common.entity.servant.lancelot.LancelotUseHandler;
import io.github.flemmli97.fateubw.common.lib.FateTags;
import io.github.flemmli97.tenshilib.common.utils.ItemUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1744;
import net.minecraft.class_1781;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_9284;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class LancelotInventory
implements Iterable<class_1799> {
    public static final class_2960 SPEAR = Fate.modRes("spear");
    public static final class_2960 ARROWS = Fate.modRes("arrows");
    public static final class_2960 FIREWORKS = Fate.modRes("fireworks");
    public static final Comparator<class_2960> NAMESPACE_FIRST = Comparator.comparing(class_2960::method_12836).thenComparing(class_2960::method_12832);
    private final class_1309 entity;
    private final List<class_2960> slotData;
    private final class_2371<class_1799> items;
    private SwappedStack swappedStack;

    public LancelotInventory(class_1309 entity) {
        this.entity = entity;
        ArrayList<class_2960> list = new ArrayList<class_2960>(LancelotAttackAI.getView().keySet().stream().sorted(NAMESPACE_FIRST).toList());
        list.add(SPEAR);
        list.add(ARROWS);
        list.add(FIREWORKS);
        this.slotData = ImmutableList.copyOf(list);
        this.items = class_2371.method_10213((int)this.slotData.size(), (Object)class_1799.field_8037);
    }

    @Nullable
    public class_1799 insert(class_1799 stack) {
        int idx;
        class_1799 current;
        if (stack.method_7909() instanceof class_1744) {
            int idx2 = this.slotData.indexOf(ARROWS);
            class_1799 current2 = (class_1799)this.items.get(idx2);
            if (class_1799.method_31577((class_1799)current2, (class_1799)stack)) {
                int grow = Math.min(stack.method_7947(), current2.method_7914() - current2.method_7947());
                if (grow > 0) {
                    current2.method_7933(grow);
                    stack.method_7934(grow);
                }
                return class_1799.field_8037;
            }
            if (current2.method_7960() || stack.method_7947() > current2.method_7947()) {
                this.items.set(idx2, (Object)stack);
                return current2;
            }
            return null;
        }
        if (stack.method_7909() instanceof class_1781) {
            int idx3 = this.slotData.indexOf(FIREWORKS);
            class_1799 current3 = (class_1799)this.items.get(idx3);
            if (class_1799.method_31577((class_1799)current3, (class_1799)stack)) {
                int grow = Math.min(stack.method_7947(), current3.method_7914() - current3.method_7947());
                if (grow > 0) {
                    current3.method_7933(grow);
                    stack.method_7934(grow);
                }
                return class_1799.field_8037;
            }
            class_9284 stackFireworks = (class_9284)stack.method_57824(class_9334.field_49616);
            class_9284 currentFireworks = (class_9284)current3.method_57824(class_9334.field_49616);
            if (current3.method_7960() || currentFireworks == null || stackFireworks != null && stackFireworks.comp_2392().size() > currentFireworks.comp_2392().size()) {
                this.items.set(idx3, (Object)stack);
                return current3;
            }
            return null;
        }
        Pair<class_2960, LancelotUseHandler> handler = LancelotAttackAI.getFor(stack);
        if (handler != null && ((current = (class_1799)this.items.get(idx = this.slotData.indexOf(handler.getFirst()))).method_7960() || ((LancelotUseHandler)handler.getSecond()).isBetterThan(this.entity, current, stack))) {
            this.items.set(idx, (Object)stack);
            return current;
        }
        if (stack.method_31573(FateTags.Items.SPEARS)) {
            idx = this.slotData.indexOf(SPEAR);
            current = (class_1799)this.items.get(idx);
            if (current.method_7960() || ItemUtils.isItemBetter((class_1309)this.entity, null, (class_1799)stack, (class_1799)current)) {
                this.items.set(idx, (Object)stack);
                return current;
            }
            return null;
        }
        return null;
    }

    private int idxFor(class_2960 id) {
        return this.slotData.indexOf(id);
    }

    public class_1799 get(class_2960 id) {
        int idx = this.idxFor(id);
        if (idx == -1) {
            return class_1799.field_8037;
        }
        return (class_1799)this.items.get(idx);
    }

    public void clearContent() {
        this.items.clear();
    }

    public boolean swapItems(class_2960 id) {
        if (id == null) {
            if (this.swappedStack != null) {
                this.entity.method_6122(class_1268.field_5810, this.swappedStack.stack());
            }
            this.swappedStack = null;
            return true;
        }
        int idx = this.idxFor(id);
        if (idx == -1) {
            return false;
        }
        class_1799 current = (class_1799)this.items.get(idx);
        if (current.method_7960()) {
            return false;
        }
        if (this.swappedStack != null) {
            this.swapItems(null);
        }
        this.swappedStack = new SwappedStack(this.entity.method_6079(), id);
        this.entity.method_6122(class_1268.field_5810, ((class_1799)this.items.get(idx)).method_7972());
        return true;
    }

    public boolean swapped() {
        return this.swappedStack != null;
    }

    public LancelotInventory setSwappedStack(SwappedStack swappedStack) {
        this.swappedStack = swappedStack;
        return this;
    }

    public class_2487 save(class_7225.class_7874 provider) {
        class_2487 tag = new class_2487();
        class_2499 content = new class_2499();
        class_6903 ops = provider.method_57093((DynamicOps)class_2509.field_11560);
        for (class_1799 stack : this.items) {
            content.add((Object)((class_2520)class_1799.field_49266.encodeStart((DynamicOps)ops, (Object)stack).getOrThrow()));
        }
        tag.method_10566("Content", (class_2520)content);
        class_2499 ids = new class_2499();
        for (class_2960 id : this.slotData) {
            ids.add((Object)((class_2520)class_2960.field_25139.encodeStart((DynamicOps)ops, (Object)id).getOrThrow()));
        }
        tag.method_10566("Ids", (class_2520)ids);
        if (this.swappedStack != null) {
            tag.method_10566("SwappedStack", (class_2520)class_1799.field_49266.encodeStart((DynamicOps)ops, (Object)this.swappedStack.stack()).getOrThrow());
            tag.method_10566("SwappedId", (class_2520)class_2960.field_25139.encodeStart((DynamicOps)ops, (Object)this.swappedStack.id()).getOrThrow());
        }
        return tag;
    }

    public void load(class_2487 tag, class_7225.class_7874 provider) {
        int i;
        class_2499 content = tag.method_10554("Content", 10);
        class_2499 idTag = tag.method_10554("Ids", 8);
        class_6903 ops = provider.method_57093((DynamicOps)class_2509.field_11560);
        int[] idxs = new int[idTag.size()];
        block0: for (i = 0; i < idTag.size(); ++i) {
            class_2960 id = (class_2960)class_2960.field_25139.parse((DynamicOps)ops, (Object)idTag.method_10534(i)).getOrThrow();
            for (int j = 0; j < this.slotData.size(); ++j) {
                if (!this.slotData.get(i).equals((Object)id)) continue;
                idxs[i] = i;
                continue block0;
            }
        }
        for (i = 0; i < content.size(); ++i) {
            class_1799 stack = (class_1799)class_1799.field_49266.parse((DynamicOps)ops, (Object)content.method_10534(i)).getOrThrow();
            this.items.set(idxs[i], (Object)stack);
        }
        if (tag.method_10545("SwappedStack")) {
            this.swappedStack = new SwappedStack((class_1799)class_1799.field_49266.parse((DynamicOps)ops, (Object)tag.method_10580("SwappedStack")).getOrThrow(), (class_2960)class_2960.field_25139.parse((DynamicOps)ops, (Object)tag.method_10580("SwappedId")).getOrThrow());
        }
    }

    @Override
    public Iterator<class_1799> iterator() {
        return this.items.iterator();
    }

    record SwappedStack(class_1799 stack, class_2960 id) {
    }
}

