/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.summons;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.api.datapack.AttributeHolderProperties;
import io.github.flemmli97.fateubw.common.datapack.DatapackHandler;
import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.BehaviourUtils;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.SetTargetFromRider;
import io.github.flemmli97.fateubw.common.entity.summons.GordiusChariot;
import io.github.flemmli97.fateubw.common.entity.utils.MoveStateTracker;
import io.github.flemmli97.fateubw.common.entity.utils.MoveType;
import io.github.flemmli97.fateubw.common.entity.utils.StandingVehicle;
import io.github.flemmli97.fateubw.common.network.S2CAttackDebug;
import io.github.flemmli97.fateubw.common.network.S2CScreenShake;
import io.github.flemmli97.fateubw.common.registry.FateDamageTypes;
import io.github.flemmli97.fateubw.common.utils.MathsHelper;
import io.github.flemmli97.fateubw.common.utils.Utils;
import io.github.flemmli97.tenshilib.common.entity.AOEAttackEntity;
import io.github.flemmli97.tenshilib.common.entity.MultiPartEntity;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetMoveToRestriction;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedMobDataHandler;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1324;
import net.minecraft.class_1333;
import net.minecraft.class_1335;
import net.minecraft.class_1408;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4209;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_6025;
import net.minecraft.class_6880;
import net.minecraft.class_8103;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.navigation.SmoothGroundNavigation;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class GordiusWheel
extends class_1314
implements AnimatedEntity,
StandingVehicle,
AOEAttackEntity,
SmartBrainOwner<GordiusWheel>,
SyncedMobDataHandler {
    private static final class_2940<Integer> WHEEL = class_2945.method_12791(GordiusWheel.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Byte> MOVE_FLAGS = class_2945.method_12791(GordiusWheel.class, (class_2941)class_2943.field_13319);
    public static final TypedResource<class_243> CHARGE_MOTION = new TypedResource(Fate.modRes("charge_motion"));
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String STOMP = BUILDER.add("stomp", AnimationsBuilder.definition((double)0.8).marker("attack", new double[]{0.52}));
    public static final String CHARGING = BUILDER.add("charge", AnimationsBuilder.definition((double)2.6).marker("charge_start", new double[]{0.48}).marker("charge_end", new double[]{2.16}));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    public final Predicate<class_1309> targetPred = target -> {
        class_1308 mob;
        if (target == this) {
            return false;
        }
        if (this.method_5968() == target) {
            return true;
        }
        class_1297 patt0$temp = this.method_31483();
        if (patt0$temp instanceof class_1308 && target == (mob = (class_1308)patt0$temp).method_5968()) {
            return true;
        }
        class_1297 patt1$temp = this.method_31483();
        if (patt1$temp instanceof BaseServant) {
            BaseServant servant = (BaseServant)patt1$temp;
            return servant.targetPred.test((class_1309)target);
        }
        return this.method_18395((class_1309)target) && !this.method_5626((class_1297)target);
    };
    private final AnimationHandler<GordiusWheel> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        if (!this.method_37908().field_9236 && anim != null && anim.is(new String[]{CHARGING})) {
            this.setChargeMotion(null);
        }
        return false;
    });
    private final SyncedDataContainer<GordiusWheel> syncedDataContainer = SyncedDataContainer.builder((class_1297)this).define(CHARGE_MOTION, (SyncedEntityData)TenshilibSyncableEntityDatas.VEC_3.get(), null).build();
    private MultiPartEntity wheels;
    private final MoveStateTracker moveStateTracker = new MoveStateTracker((class_1309)this, 2, MOVE_FLAGS, this::calculateMoveType);
    public int wheelMoveTick;
    public float wheelPartial;

    public GordiusWheel(class_1299<? extends GordiusWheel> type, class_1937 level) {
        super(type, level);
        if (!level.field_9236) {
            this.updateAttributes();
        }
        this.field_6206 = new GordiusLookControl((class_1308)this);
        this.field_6207 = new GordiusMoveControl((class_1308)this);
    }

    public static class_5132.class_5133 createAttributes() {
        return BaseServant.createAttributes().method_26868(class_5134.field_47761, 1.6);
    }

    private void updateAttributes() {
        AttributeHolderProperties props = DatapackHandler.SERVANT_PROPS.getGeneric(this.method_5864());
        props.attributes().forEach((att, val) -> {
            class_1324 inst = this.method_5996((class_6880)att);
            if (inst != null) {
                inst.method_6192(val.doubleValue());
                if (att == class_5134.field_23716) {
                    this.method_6033(this.method_6063());
                }
            }
        });
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(WHEEL, (Object)-1);
        builder.method_56912(MOVE_FLAGS, (Object)0);
    }

    public SyncedDataContainer<?> getDataContainer() {
        return this.syncedDataContainer;
    }

    public List<? extends ExtendedSensor<? extends GordiusWheel>> getSensors() {
        return List.of();
    }

    protected class_1408 method_5965(class_1937 level) {
        return new SmoothGroundNavigation((class_1308)this, level);
    }

    public BrainActivityGroup<? extends GordiusWheel> getCoreTasks() {
        return BrainActivityGroup.coreTasks((class_4097[])new class_4097[]{new FloatToSurfaceOfFluid(), new SetTargetFromRider()});
    }

    public BrainActivityGroup<? extends GordiusWheel> getIdleTasks() {
        return BrainActivityGroup.idleTasks((class_4097[])new class_4097[]{new MoveToWalkTarget(), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate(), new SetMoveToRestriction(), new SetRandomWalkTarget().startCondition(m -> m.method_59922().method_43048(120) == 0)})});
    }

    public BrainActivityGroup<? extends GordiusWheel> getFightTasks() {
        return BrainActivityGroup.fightTasks((class_4097[])new class_4097[]{new InvalidateAttackTarget(), SelectableBehaviourBuilder.builder().add(1, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), BehaviourUtils.moveTo()}).build().startCondition(BehaviourUtils::runCooldownBehaviour).stopIf(e -> !BehaviourUtils.runCooldownBehaviour(e)), AttackBehaviourBuilder.create().start(new String[]{STOMP}).play(BehaviourUtils.cooldownedPlay(true, 10, 40)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(1).start(new String[]{CHARGING}).play(BehaviourUtils.cooldownedPlay(false, 10, 40)).prepare(new ExtendedBehaviour[]{new SetChargeTarget()}).end(1).build().startCondition(BehaviourUtils::runCombatBehaviour)});
    }

    protected class_4095.class_5303<?> method_28306() {
        return new SmartBrainProvider((class_1309)this);
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    public void method_5670() {
        class_243 lookDir;
        super.method_5670();
        this.getAnimationHandler().tick();
        if (!this.method_37908().field_9236) {
            class_1308 mob;
            class_1297 class_12972;
            if (this.wheels == null) {
                this.wheels = new GordiusChariot((class_1309)this, 2.2f, 1.6f);
            }
            if (this.wheels.parentTick()) {
                this.field_6011.method_12778(WHEEL, (Object)this.wheels.method_5628());
            }
            this.getAnimationHandler().runIfNotNull(this::handleAttack);
            if (this.method_5968() == null && (class_12972 = this.method_31483()) instanceof class_1308 && (mob = (class_1308)class_12972).method_5968() != this.method_5968()) {
                this.method_5980(mob.method_5968());
            }
        }
        this.moveStateTracker.tick();
        if (this.getMoveType() != MoveType.NONE) {
            ++this.wheelMoveTick;
        }
        if ((lookDir = this.directionToLookAt()) != null) {
            float[] yxRot = MathsHelper.YXRotFrom(lookDir);
            this.method_36456(MathsHelper.rotlerp(this.method_36454(), yxRot[0], 30.0f));
            this.method_36457(MathsHelper.rotlerp(this.method_36455(), yxRot[1], 30.0f));
            this.method_5636(this.method_36454());
            this.method_5847(this.method_36454());
        }
    }

    private class_243 directionToLookAt() {
        if (this.isCharging()) {
            return this.getChargeMotion();
        }
        return null;
    }

    protected void method_5958() {
        super.method_5958();
        this.tickBrain((class_1309)this);
    }

    public float interpolatedMoveTick(float partialTicks) {
        return this.moveStateTracker.interpolatedMoveTick(partialTicks);
    }

    public float interpolatedMoveTickOf(MoveType moveType, float partialTicks) {
        return this.moveStateTracker.interpolatedMoveTickOf(moveType, partialTicks);
    }

    public MoveType getMoveType() {
        return MoveType.values()[(Byte)this.field_6011.method_12789(MOVE_FLAGS)];
    }

    public MoveType calculateMoveType() {
        if (this.method_5642() instanceof class_1657 || !this.field_42108.method_48571()) {
            return MoveType.NONE;
        }
        if (this.method_6062()) {
            return MoveType.NONE;
        }
        double d0 = this.method_5962().method_6242();
        MoveType move = d0 > 1.0 || this.method_5968() != null ? MoveType.RUN : (d0 <= 0.8 ? MoveType.SNEAK : MoveType.WALK);
        return move;
    }

    public class_243 method_52538(class_1297 passenger) {
        MultiPartEntity wheel;
        if (this.method_5626(passenger) && (wheel = this.getWheelEntity()) != null) {
            return wheel.method_52538(passenger);
        }
        return super.method_52538(passenger);
    }

    @Nullable
    public MultiPartEntity getWheelEntity() {
        GordiusChariot part;
        class_1297 entity;
        if (this.method_37908().field_9236 && this.wheels == null && (entity = this.method_37908().method_8469(((Integer)this.field_6011.method_12789(WHEEL)).intValue())) instanceof GordiusChariot && (part = (GordiusChariot)entity).getOwner() == this) {
            this.wheels = part;
        }
        return this.wheels;
    }

    public class_243 getWheelJoint() {
        class_243 offset = new class_243(0.0, 0.0, -1.0);
        offset.method_1021((double)this.method_55693());
        return this.method_19538().method_1019(offset.method_1024(-this.method_36454() * ((float)Math.PI / 180)));
    }

    public class_1309 method_5968() {
        return BrainUtils.getTargetOfEntity((class_1309)this);
    }

    public void method_5980(@Nullable class_1309 target) {
        super.method_5980(target);
        if (super.method_5968() == null) {
            BrainUtils.clearMemory((class_1309)this, (class_4140)class_4140.field_22355);
        } else {
            BrainUtils.setMemory((class_1309)this, (class_4140)class_4140.field_22355, (Object)super.method_5968());
        }
    }

    public boolean method_5747(float distance, float damageMultiplier, class_1282 source) {
        return false;
    }

    public boolean method_5643(class_1282 damageSource, float damage) {
        if (!damageSource.method_48789(class_8103.field_42242) && this.isCharging()) {
            damage *= 0.5f;
        }
        return super.method_5643(damageSource, damage);
    }

    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{CHARGING})) {
            class_243 dir;
            if (anim.isPast("charge_start") && !anim.isPast("charge_end") && (dir = this.getChargeMotion()) != null) {
                this.method_18800(dir.method_10216(), this.method_18798().method_10214(), dir.method_10215());
                OrientedBoundingBox obb = this.prepareAttackBox(anim.getAnimation(), null, 0.2, false);
                List list = this.method_37908().method_8390(class_1309.class, obb.getEncompassingBox(), entity -> this.targetPred.test((class_1309)entity) && obb.intersects(entity.method_5829()));
                for (class_1309 e : list) {
                    e.method_5643(FateDamageTypes.direct(FateDamageTypes.GORDIUS_TRAMPLE, (class_1297)this), (float)this.method_45325(class_5134.field_23721));
                }
                this.method_5783(class_3417.field_15110, 0.4f, 0.4f);
                S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (class_1297)this);
                S2CScreenShake.sendAround((class_1297)this, 14.0, 4, 1.5f);
            }
        } else {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                this.mobAttack(anim, this.method_5968(), this::method_6121);
                S2CScreenShake.sendAround((class_1297)this, 6.0, 8, 2.0f);
            }
        }
    }

    public void mobAttack(AnimationState anim, class_1309 target, Consumer<class_1309> cons) {
        OrientedBoundingBox obb = this.prepareAttackBox(anim.getAnimation(), (class_1297)target, 0.2, false);
        this.method_37908().method_8390(class_1309.class, obb.getEncompassingBox(), entity -> this.targetPred.test((class_1309)entity) && obb.intersects(entity.method_5829())).forEach(cons);
        if (!this.method_37908().field_9236) {
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (class_1297)this);
        }
    }

    public OrientedBoundingBox prepareAttackBox(String anim, class_1297 target, double grow, boolean debug) {
        OrientedBoundingBox obb = this.calculateAttackAABB(this.getAnimationHandler().createDefaulted(anim), target != null ? target.method_19538() : null, grow);
        if (debug) {
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTEMPT, (class_1297)this);
        }
        return obb;
    }

    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, @Nullable class_243 target, double grow) {
        if (anim.is(new String[]{CHARGING})) {
            class_238 aabb2 = this.method_5829().method_991(this.wheels.method_5829());
            double lenX = aabb2.method_17939();
            double lenZ = aabb2.method_17941();
            double expand = 0.3 + grow;
            double len = Math.sqrt(lenX * lenX + lenZ * lenZ) + 2.0 * expand;
            double width = Math.min(lenX, lenZ) * 0.5 + expand;
            double offset = (double)this.wheels.method_17681() * 0.5 + expand;
            class_238 aabb = new class_238(-width, -0.02, -offset, width, (double)this.method_17682(), len - offset);
            return new OrientedBoundingBox(aabb, this.method_36454(), 0.0f, this.wheels.method_19538());
        }
        double width = (double)this.method_17681() * 0.5 + 1.5;
        class_238 aabb = new class_238(-width * 0.8, -0.02, -width * 0.5, width * 0.8, (double)this.method_17682() * 0.5, width * 1.2);
        return new OrientedBoundingBox(aabb, this.method_36454(), 0.0f, this.method_19538());
    }

    public boolean method_6121(class_1297 entity) {
        return Utils.runWithInvulTimer((class_1297)this, entity, x$0 -> super.method_6121(x$0), 0);
    }

    public AnimationHandler<GordiusWheel> getAnimationHandler() {
        return this.animationHandler;
    }

    public class_243 getChargeMotion() {
        return (class_243)this.getDataContainer().get(CHARGE_MOTION);
    }

    public void setChargeTo(class_243 pos) {
        class_243 dir = pos.method_1020(this.method_19538());
        dir = new class_243(dir.method_10216(), 0.0, dir.method_10215());
        this.setChargeMotion(dir.method_1029().method_1021(0.55));
    }

    public void setChargeMotion(class_243 chargeMotion) {
        this.getDataContainer().set(CHARGE_MOTION, (Object)chargeMotion);
    }

    public boolean isCharging() {
        if (this.getAnimationHandler() == null) {
            return false;
        }
        AnimationState anim = this.getAnimationHandler().getAnimation();
        return anim != null && anim.is(new String[]{CHARGING}) && anim.isPast("attack");
    }

    protected class_3414 method_5994() {
        return class_3417.field_14780;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return class_3417.field_14597;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14857;
    }

    public float method_6017() {
        return (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f;
    }

    public boolean method_5863() {
        return true;
    }

    public void method_5697(class_1297 entity) {
    }

    public boolean method_18395(class_1309 entity) {
        class_1297 class_12972 = this.method_31483();
        if (class_12972 instanceof class_6025) {
            class_6025 ownable = (class_6025)class_12972;
            return entity != ownable.method_35057();
        }
        return super.method_18395(entity);
    }

    protected static class GordiusLookControl
    extends class_1333 {
        public GordiusLookControl(class_1308 mob) {
            super(mob);
        }

        public void method_6230(double x, double y, double z, float deltaYaw, float deltaPitch) {
            super.method_6230(x, y, z, Math.min(deltaYaw, 10.0f), deltaPitch);
        }
    }

    protected class GordiusMoveControl
    extends class_1335 {
        public GordiusMoveControl(class_1308 mob) {
            super(mob);
        }

        public void method_6240() {
            if (this.field_6374 == class_1335.class_1336.field_6378) {
                double dZ;
                double dY;
                this.field_6374 = class_1335.class_1336.field_6377;
                double dX = this.field_6370 - GordiusWheel.this.method_23317();
                double len = dX * dX + (dY = this.field_6369 - GordiusWheel.this.method_23318()) * dY + (dZ = this.field_6367 - GordiusWheel.this.method_23321()) * dZ;
                if (len < 2.5E-7) {
                    this.field_6371.method_5930(0.0f);
                    return;
                }
                float n = (float)(class_3532.method_15349((double)dZ, (double)dX) * 57.2957763671875) - 90.0f;
                float rotY = this.method_6238(this.field_6371.method_36454(), n, 30.0f);
                this.field_6371.method_36456(rotY);
                float speed = (float)(this.field_6372 * this.field_6371.method_45325(class_5134.field_23719));
                speed = class_3532.method_15356((float)rotY, (float)this.field_6371.method_36454()) > 10.0f ? speed * 0.5f : speed;
                this.field_6371.method_6125(speed);
                class_2338 blockPos = this.field_6371.method_24515();
                class_2680 blockState = this.field_6371.method_37908().method_8320(blockPos);
                class_265 voxelShape = blockState.method_26220((class_1922)this.field_6371.method_37908(), blockPos);
                if (dY > (double)this.field_6371.method_49476() && dX * dX + dZ * dZ < (double)Math.max(1.0f, this.field_6371.method_17681()) || !voxelShape.method_1110() && this.field_6371.method_23318() < voxelShape.method_1105(class_2350.class_2351.field_11052) + (double)blockPos.method_10264() && !blockState.method_26164(class_3481.field_15495) && !blockState.method_26164(class_3481.field_16584)) {
                    this.field_6371.method_5993().method_6233();
                    this.field_6374 = class_1335.class_1336.field_6379;
                }
            } else {
                super.method_6240();
            }
        }
    }

    public static class SetChargeTarget
    extends ExtendedBehaviour<GordiusWheel> {
        private static final MemoryTest MEMORIES = MemoryTest.builder((int)1).hasMemories(new class_4140[]{class_4140.field_22355});
        private class_243 targetPos;

        protected List<Pair<class_4140<?>, class_4141>> getMemoryRequirements() {
            return MEMORIES;
        }

        protected boolean shouldKeepRunning(GordiusWheel entity) {
            double dX = this.targetPos.method_10216() - entity.method_23317();
            double dZ = this.targetPos.method_10215() - entity.method_23321();
            float yRot = MathsHelper.YRotFrom(dX, dZ);
            float diffY = class_3532.method_15381((float)entity.method_36454(), (float)yRot);
            if (Math.abs(diffY) < 16.0f) {
                entity.setChargeTo(this.targetPos);
                return false;
            }
            return true;
        }

        protected void start(GordiusWheel entity) {
            this.targetPos = BrainUtils.getTargetOfEntity((class_1309)entity).method_33571();
        }

        protected void tick(GordiusWheel entity) {
            super.tick((class_1309)entity);
            double dY = this.targetPos.method_10214() - entity.method_23320();
            double dX = this.targetPos.method_10216() - entity.method_23317();
            double dZ = this.targetPos.method_10215() - entity.method_23321();
            float[] yXRot = MathsHelper.YXRotFrom(dX, dY, dZ);
            entity.method_36456(MathsHelper.rotlerp(entity.method_36454(), yXRot[0], 17.0f));
            entity.method_36457(MathsHelper.rotlerp(entity.method_36455(), yXRot[1], 30.0f));
            entity.method_5636(entity.method_36454());
            entity.method_5847(entity.method_36454());
        }
    }
}

