/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.summons;

import io.github.flemmli97.fateubw.api.datapack.AttributeHolderProperties;
import io.github.flemmli97.fateubw.api.datapack.ServantExtraData;
import io.github.flemmli97.fateubw.common.datapack.DatapackHandler;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.BehaviourUtils;
import io.github.flemmli97.fateubw.common.entity.misc.StarfishShot;
import io.github.flemmli97.fateubw.common.entity.utils.MoveStateTracker;
import io.github.flemmli97.fateubw.common.entity.utils.MoveType;
import io.github.flemmli97.fateubw.common.registry.FateEntities;
import io.github.flemmli97.fateubw.common.utils.Utils;
import io.github.flemmli97.fateubw.mixin.CombatTrackerAccessor;
import io.github.flemmli97.tenshilib.common.entity.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetMoveToRestriction;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1281;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1324;
import net.minecraft.class_1408;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4209;
import net.minecraft.class_5134;
import net.minecraft.class_5862;
import net.minecraft.class_5863;
import net.minecraft.class_6025;
import net.minecraft.class_6880;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.AllApplicableBehaviours;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.navigation.SmoothGroundNavigation;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.util.BrainUtils;

public class LesserMonster
extends class_1314
implements AnimatedEntity,
class_6025,
SmartBrainOwner<LesserMonster> {
    protected static final class_2940<Byte> MOVE_FLAGS = class_2945.method_12791(LesserMonster.class, (class_2941)class_2943.field_13319);
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String ATTACK = BUILDER.add("attack", AnimationsBuilder.definition((double)0.76).marker("attack", new double[]{0.52}));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private UUID ownerUUID;
    private class_1309 owner;
    private int livingTicks;
    private final AnimationHandler<LesserMonster> animationHandler = new AnimationHandler((class_1297)this, ANIMS);
    private final MoveStateTracker moveStateTracker = new MoveStateTracker((class_1309)this, 3, MOVE_FLAGS, this::calculateMoveType);
    private final int maxLivingTicks;
    private boolean ranged;

    public LesserMonster(class_1299<? extends LesserMonster> type, class_1937 level) {
        super(type, level);
        if (!level.field_9236) {
            this.updateAttributes();
        }
        this.maxLivingTicks = DatapackHandler.SERVANT_PROPS.get((class_1299)FateEntities.GILLES.get()).getConfig(ServantExtraData.GILLES_MONSTER_DURATION);
    }

    public LesserMonster(class_1937 level, class_1309 owner) {
        this((class_1299<? extends LesserMonster>)((class_1299)FateEntities.LESSER_MONSTER.get()), level);
        this.owner = owner;
        this.ownerUUID = owner.method_5667();
    }

    protected void updateAttributes() {
        AttributeHolderProperties props = DatapackHandler.SERVANT_PROPS.getGeneric(this.method_5864());
        props.attributes().forEach((att, val) -> {
            class_1324 inst = this.method_5996((class_6880)att);
            if (inst != null) {
                inst.method_6192(val.doubleValue());
                if (att == class_5134.field_23716) {
                    this.method_6033(this.method_6063());
                }
            }
        });
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(MOVE_FLAGS, (Object)0);
    }

    protected class_1408 method_5965(class_1937 level) {
        return new SmoothGroundNavigation((class_1308)this, level);
    }

    public void setRanged(boolean ranged) {
        this.ranged = ranged;
    }

    public List<? extends ExtendedSensor<? extends LesserMonster>> getSensors() {
        return List.of(new NearbyLivingEntitySensor().setPredicate((target, entity) -> !Utils.alliedTo((class_1297)target, (class_1297)entity)).setScanRate(e -> 10), new HurtBySensor().setPredicate((source, entity) -> {
            class_1297 patt0$temp = source.method_5529();
            if (patt0$temp instanceof class_1309) {
                class_1309 attacker = (class_1309)patt0$temp;
                return !Utils.alliedTo((class_1297)entity, (class_1297)attacker);
            }
            return true;
        }));
    }

    public BrainActivityGroup<? extends LesserMonster> getCoreTasks() {
        return BrainActivityGroup.coreTasks((class_4097[])new class_4097[]{new FloatToSurfaceOfFluid(), this.lookBehaviour(), new LookAtTarget().runFor(entity -> entity.method_59922().method_39332(40, 100)).whenStopping(m -> BrainUtils.clearMemory((class_1309)m, (class_4140)class_4140.field_18446))});
    }

    protected ExtendedBehaviour<? extends LesserMonster> lookBehaviour() {
        return new AllApplicableBehaviours(new ExtendedBehaviour[]{new LookAtAttackTarget(), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomLookTarget().lookChance((class_5863)class_5862.method_33908((float)1.0f)), new SetPlayerLookTarget()}).startCondition(m -> (double)m.method_59922().method_43057() < 0.1 && !BrainUtils.hasMemory((class_1309)m, (class_4140)class_4140.field_18445))});
    }

    public BrainActivityGroup<? extends LesserMonster> getIdleTasks() {
        return BrainActivityGroup.idleTasks((class_4097[])new class_4097[]{new MoveToWalkTarget(), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate(), new SetMoveToRestriction(), new SetRandomWalkTarget().startCondition(m -> m.method_59922().method_43048(120) == 0)})});
    }

    public BrainActivityGroup<? extends LesserMonster> getFightTasks() {
        return BrainActivityGroup.fightTasks((class_4097[])new class_4097[]{new InvalidateAttackTarget(), SelectableBehaviourBuilder.builder().add(1, entity -> !entity.ranged, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), BehaviourUtils.moveTo()}).add(1, entity -> entity.ranged, new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(4.0).max(8.0), BehaviourUtils.moveTo()}).build().startCondition(BehaviourUtils::runCooldownBehaviour).stopIf(e -> !BehaviourUtils.runCooldownBehaviour(e)), AttackBehaviourBuilder.create().start(new String[]{ATTACK}).play(BehaviourUtils.cooldownedPlay(false, 10, 25)).condition(entity -> !entity.ranged).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveTo()}).end(1).start(new String[]{ATTACK}).play(BehaviourUtils.cooldownedPlay(false, 10, 25)).condition(entity -> entity.ranged).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(4.0).max(8.0)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveTo()}).end(1).build().startCondition(BehaviourUtils::runCombatBehaviour)});
    }

    protected class_4095.class_5303<?> method_28306() {
        return new SmartBrainProvider((class_1309)this);
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    public void method_6007() {
        super.method_6007();
        this.moveStateTracker.tick();
        this.getAnimationHandler().tick();
        if (!this.method_37908().field_9236) {
            class_1309 target;
            AnimationState anim;
            ++this.livingTicks;
            if (this.livingTicks > this.maxLivingTicks) {
                this.method_5650(class_1297.class_5529.field_26998);
            }
            if ((anim = this.getAnimationHandler().getAnimation()) != null && anim.is(new String[]{ATTACK}) && anim.isAt("attack") && (target = this.method_5968()) != null) {
                if (this.ranged) {
                    this.shoot();
                } else if (this.method_53511().method_994(target.method_5829())) {
                    this.method_6121((class_1297)target);
                }
            }
        }
    }

    protected void method_5958() {
        super.method_5958();
        this.tickBrain((class_1309)this);
    }

    public float interpolatedMoveTick(float partialTicks) {
        return this.moveStateTracker.interpolatedMoveTick(partialTicks);
    }

    public MoveType calculateMoveType() {
        if (this.method_6062() || !this.field_42108.method_48571()) {
            return MoveType.NONE;
        }
        return MoveType.RUN;
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        if (tag.method_10545("Owner")) {
            this.ownerUUID = tag.method_25926("Owner");
        }
        this.ranged = tag.method_10577("Ranged");
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        if (this.ownerUUID != null) {
            tag.method_25927("Owner", this.ownerUUID);
        }
        tag.method_10556("Ranged", this.ranged);
    }

    public AnimationHandler<LesserMonster> getAnimationHandler() {
        return this.animationHandler;
    }

    public boolean method_6121(class_1297 target) {
        float damage;
        class_1309 living;
        List<class_1281> entries;
        boolean res = super.method_6121(target);
        if (res && target instanceof class_1309 && !(entries = ((CombatTrackerAccessor)(living = (class_1309)target).method_6066()).getEntries()).isEmpty() && entries.getLast().comp_1535().method_5529() == this && (damage = Math.max(0.0f, entries.getLast().comp_1536())) > 0.0f && this.method_35057() != null) {
            class_1309 owner = this.method_35057();
            owner.method_6025(damage * 0.33f);
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                serverLevel.method_14199((class_2394)class_2398.field_11201, owner.method_23317(), owner.method_23318() + (double)owner.method_17682() + 0.5, owner.method_23321(), 0, 0.0, 0.1, 0.0, 0.0);
            }
        }
        return res;
    }

    public void shoot() {
        StarfishShot proj = new StarfishShot(this.method_37908(), (class_1309)this);
        if (this.method_5968() != null) {
            class_243 pos = this.method_5968().method_19538();
            proj.shootAtPosition(pos.method_10216(), this.method_5968().method_23323(0.5), pos.method_10215(), 0.6f, 0.0f);
        } else {
            proj.shoot((class_1297)this, this.method_36455() - 15.0f, this.method_36454(), 0.0f, 0.6f, 0.0f);
        }
        this.method_37908().method_8649((class_1297)proj);
        this.method_5783(class_3417.field_21070, 1.0f, 1.0f);
    }

    public class_1309 method_35057() {
        if (this.owner == null && this.ownerUUID != null) {
            this.owner = (class_1309)EntityUtils.findFromUUID(class_1309.class, (class_1937)this.method_37908(), (UUID)this.ownerUUID);
        }
        return this.owner;
    }

    public UUID method_6139() {
        return this.ownerUUID;
    }
}

