/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.summons;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.api.datapack.AttributeHolderProperties;
import io.github.flemmli97.fateubw.common.datapack.DatapackHandler;
import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.BehaviourUtils;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.SetTargetFromRider;
import io.github.flemmli97.fateubw.common.entity.utils.MoveStateTracker;
import io.github.flemmli97.fateubw.common.entity.utils.MoveType;
import io.github.flemmli97.fateubw.common.entity.utils.StandingVehicle;
import io.github.flemmli97.fateubw.common.network.S2CAttackDebug;
import io.github.flemmli97.fateubw.common.network.S2CScreenShake;
import io.github.flemmli97.fateubw.common.particles.trail.TrailInfo;
import io.github.flemmli97.fateubw.common.particles.trail.TrailParticleData;
import io.github.flemmli97.fateubw.common.particles.trail.provider.ParticlePositionProvider;
import io.github.flemmli97.fateubw.common.registry.FateDamageTypes;
import io.github.flemmli97.fateubw.common.registry.FateParticles;
import io.github.flemmli97.fateubw.common.utils.MathsHelper;
import io.github.flemmli97.fateubw.common.utils.Utils;
import io.github.flemmli97.tenshilib.common.entity.AOEAttackEntity;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetMoveToRestriction;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedMobDataHandler;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1324;
import net.minecraft.class_1335;
import net.minecraft.class_1408;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4209;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5493;
import net.minecraft.class_5535;
import net.minecraft.class_6880;
import net.minecraft.class_8103;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.AllApplicableBehaviours;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.SequentialBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomFlyingTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.navigation.SmoothFlyingPathNavigation;
import net.tslat.smartbrainlib.api.core.navigation.SmoothGroundNavigation;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class Pegasus
extends class_1314
implements AnimatedEntity,
StandingVehicle,
AOEAttackEntity,
SyncedMobDataHandler,
SmartBrainOwner<Pegasus> {
    public static float PORTAL_SIZE = 2.0f;
    public static float PORTAL_OFFSET = 1.3f;
    private static final class_2940<Boolean> FLYING = class_2945.method_12791(Pegasus.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Byte> MOVE_FLAGS = class_2945.method_12791(Pegasus.class, (class_2941)class_2943.field_13319);
    public static final TypedResource<class_243> CHARGE_MOTION = new TypedResource(Fate.modRes("charge_motion"));
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String CHARGING = BUILDER.add("charge", AnimationsBuilder.definition((double)1.2).marker("charge_start", new double[]{0.36}).marker("charge_end", new double[]{1.0}));
    public static final String STOMP = BUILDER.add("stomp", AnimationsBuilder.definition((double)0.56).marker("attack", new double[]{0.4}));
    public static final String SUMMON = BUILDER.add("summon", AnimationsBuilder.definition((double)2.04).marker("seated", new double[]{1.04}));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    public final Predicate<class_1309> targetPred = target -> {
        class_1308 mob;
        if (target == this) {
            return false;
        }
        if (this.method_5968() == target) {
            return true;
        }
        class_1297 patt0$temp = this.method_31483();
        if (patt0$temp instanceof class_1308 && target == (mob = (class_1308)patt0$temp).method_5968()) {
            return true;
        }
        class_1297 patt1$temp = this.method_31483();
        if (patt1$temp instanceof BaseServant) {
            BaseServant servant = (BaseServant)patt1$temp;
            return servant.targetPred.test((class_1309)target);
        }
        return this.method_18395((class_1309)target) && !this.method_5626((class_1297)target);
    };
    private final AnimationHandler<Pegasus> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        if (!this.method_37908().field_9236 && anim != null && anim.is(new String[]{CHARGING})) {
            this.hitEntities = new ArrayList<class_1297>();
            this.setChargeMotion(null);
        }
        return false;
    });
    private final class_1408 main;
    private final class_1408 flyingNavigator;
    private int flyTimer;
    private final SyncedDataContainer<Pegasus> syncedDataContainer = SyncedDataContainer.builder((class_1297)this).define(CHARGE_MOTION, (SyncedEntityData)TenshilibSyncableEntityDatas.VEC_3.get(), null).build();
    private List<class_1297> hitEntities = new ArrayList<class_1297>();
    private final MoveStateTracker moveStateTracker = new MoveStateTracker((class_1309)this, 2, MOVE_FLAGS, this::calculateMoveType);

    public Pegasus(class_1299<? extends Pegasus> type, class_1937 level) {
        super(type, level);
        if (!level.field_9236) {
            this.updateAttributes();
        }
        this.main = this.field_6189;
        this.flyingNavigator = this.createFlyNavigator(level);
        this.field_6207 = new PegasusMoveController(this);
    }

    private void updateAttributes() {
        AttributeHolderProperties props = DatapackHandler.SERVANT_PROPS.getGeneric(this.method_5864());
        props.attributes().forEach((att, val) -> {
            class_1324 inst = this.method_5996((class_6880)att);
            if (inst != null) {
                inst.method_6192(val.doubleValue());
                if (att == class_5134.field_23716) {
                    this.method_6033(this.method_6063());
                }
            }
        });
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(FLYING, (Object)false);
        builder.method_56912(MOVE_FLAGS, (Object)0);
    }

    public SyncedDataContainer<?> getDataContainer() {
        return this.syncedDataContainer;
    }

    protected class_1408 createFlyNavigator(class_1937 level) {
        return new SmoothFlyingPathNavigation(this, (class_1308)this, level){

            public boolean method_6333(class_2338 pos) {
                return true;
            }
        };
    }

    protected class_1408 method_5965(class_1937 level) {
        return new SmoothGroundNavigation((class_1308)this, level);
    }

    public List<? extends ExtendedSensor<? extends Pegasus>> getSensors() {
        return List.of();
    }

    public BrainActivityGroup<? extends Pegasus> getCoreTasks() {
        return BrainActivityGroup.coreTasks((class_4097[])new class_4097[]{new FloatToSurfaceOfFluid(), new SetTargetFromRider()});
    }

    public BrainActivityGroup<? extends Pegasus> getIdleTasks() {
        return BrainActivityGroup.idleTasks((class_4097[])new class_4097[]{new MoveToWalkTarget(), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate(), new SetMoveToRestriction(), new SetRandomWalkTarget().startCondition(m -> m.method_59922().method_43048(120) == 0)})});
    }

    public BrainActivityGroup<? extends Pegasus> getFightTasks() {
        return BrainActivityGroup.fightTasks((class_4097[])new class_4097[]{new InvalidateAttackTarget(), this.getCooldownAI().startCondition(BehaviourUtils::runCooldownBehaviour).stopIf(e -> !BehaviourUtils.runCooldownBehaviour(e)), this.getCombatAI().startCondition(BehaviourUtils::runCombatBehaviour)});
    }

    public ExtendedBehaviour<? extends Pegasus> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{STOMP}).play(BehaviourUtils.cooldownedPlay(true, 20, 45)).condition(entity -> !entity.canFly()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(6).start(new String[]{CHARGING}).play(BehaviourUtils.cooldownedPlay(false, 20, 50)).condition(entity -> !entity.canFly()).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(3.0).max(10.0).speedMod(1.2f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack(40, 70)}).prepare(new ExtendedBehaviour[]{new ChargeBehaviour()}).end(6).start(new String[]{CHARGING}).play(BehaviourUtils.cooldownedPlay(false, 20, 50)).condition(entity -> !entity.canFly() && BehaviourUtils.ifFurtherThan(7.0).test(entity)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(3.0).max(10.0).speedMod(1.2f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack(40, 70)}).prepare(new ExtendedBehaviour[]{new ChargeBehaviour()}).end(7).start(new String[]{CHARGING}).play(BehaviourUtils.cooldownedPlay(false, 80, 160)).condition(Pegasus::canFly).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(3.0).max(10.0).speedMod(1.2f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack(40, 70)}).prepare(new ExtendedBehaviour[]{new ChargeBehaviour()}).end(5).build();
    }

    public ExtendedBehaviour<? extends Pegasus> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(7, BehaviourUtils.withCondition(entity -> !entity.canFly()), new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), BehaviourUtils.moveTo()}).add(5, BehaviourUtils.withCondition(entity -> !entity.canFly() && BehaviourUtils.ifCloserThan(7.0).test(entity)), new ExtendedBehaviour[]{new SetRandomWalkTarget().setRadius(12.0, 5.0), BehaviourUtils.moveTo()}).add(4, BehaviourUtils.withCondition(entity -> !entity.canFly() && BehaviourUtils.ifCloserThan(4.0).test(entity)), new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().radius(6.0), BehaviourUtils.moveTo()}).add(5, BehaviourUtils.withCondition(Pegasus::canFly), new ExtendedBehaviour[]{new AllApplicableBehaviours(new ExtendedBehaviour[]{new SequentialBehaviour(new ExtendedBehaviour[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(BehaviourUtils.closeEnough(8)).startCondition(BehaviourUtils.ifFurtherThan(8.0)), new RandomPositionAroundTarget()}), BehaviourUtils.moveTo()}), new LookAtTarget(), new LookAtAttackTarget()})}).build();
    }

    protected class_4095.class_5303<?> method_28306() {
        return new SmartBrainProvider((class_1309)this);
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    public void method_5773() {
        super.method_5773();
        class_243 lookDir = this.directionToLookAt();
        if (lookDir != null) {
            float[] yxRot = MathsHelper.YXRotFrom(lookDir);
            this.method_36456(MathsHelper.rotlerp(this.method_36454(), yxRot[0], 30.0f));
            this.method_36457(MathsHelper.rotlerp(this.method_36455(), yxRot[1], 30.0f));
            this.method_5636(this.method_36454());
            this.method_5847(this.method_36454());
        }
    }

    public void method_6007() {
        super.method_6007();
        this.getAnimationHandler().tick();
        if (this.method_37908().field_9236) {
            class_243 pos;
            double upScale;
            double sideScale;
            int i;
            class_243 base;
            if (this.getAnimationHandler().isCurrent(new String[]{SUMMON})) {
                base = class_243.method_1030((float)0.0f, (float)this.field_6283).method_1021((double)(-PORTAL_OFFSET));
                class_243 base2 = base.method_1024(1.5707964f).method_1029();
                for (i = 0; i < 4; ++i) {
                    sideScale = (this.field_5974.method_43058() - this.field_5974.method_43058()) * (double)PORTAL_SIZE;
                    upScale = (this.field_5974.method_43058() - this.field_5974.method_43058()) * (double)PORTAL_SIZE + (double)PORTAL_SIZE;
                    pos = this.method_19538().method_1019(base).method_1019(base2.method_1021(sideScale)).method_1019(new class_243(0.0, 1.0, 0.0).method_1021(upScale));
                    AdvancedParticleContainer.make((class_2394)((class_2394)FateParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.9607843f, 0.039215688f, 0.039215688f, 0.5f)).addData((AdvancedParticleData)new ScaleData(0.5f)).addData((AdvancedParticleData)new MotionData(this.field_5974.method_43059() * 0.01, this.field_5974.method_43059() * 0.01, this.field_5974.method_43059() * 0.01)).addData((AdvancedParticleData)new ParticleMetaData(20, false, 0.0f)).add(this.method_37908(), pos.method_10216(), pos.method_10214(), pos.method_10215());
                }
            }
            if (this.getAnimationHandler().isCurrent(new String[]{CHARGING}) && this.getAnimationHandler().getAnimation().isPast("attack")) {
                base = class_243.method_1030((float)0.0f, (float)this.field_6283).method_1024(1.5707964f).method_1029();
                class_243 dir = this.method_18798().method_1021(-0.23);
                for (i = 0; i < 9; ++i) {
                    sideScale = (this.field_5974.method_43058() * 2.0 - 1.0) * 3.0;
                    upScale = this.field_5974.method_43058() * 2.0 - 1.0;
                    pos = this.method_19538().method_1019(base.method_1021(sideScale)).method_1019(new class_243(0.0, 1.0, 0.0).method_1021(upScale));
                    float r = (float)(235 + this.method_59922().method_43048(10)) / 255.0f;
                    float g = (float)(235 + this.method_59922().method_43048(10)) / 255.0f;
                    float b = 0.9607843f;
                    float scale = (float)(0.01 + this.method_59922().method_43058() * 0.01);
                    AdvancedParticleContainer.make((class_2394)new TrailParticleData((class_2396<TrailParticleData>)((class_2396)FateParticles.TRAIL.get()), TrailInfo.builder(new ParticlePositionProvider.ParticlePositionData(8)).setColor(r, g, b, 0.4f).setColor2(r, g, b, 0.4f).setWidth(scale).setWidth2(scale).build())).addData((AdvancedParticleData)new MotionData(dir)).addData((AdvancedParticleData)new ParticleMetaData(8 + this.method_59922().method_43048(8), false, 0.0f)).add(this.method_37908(), pos.method_10216(), pos.method_10214(), pos.method_10215());
                }
            }
        }
        if (!this.method_37908().field_9236) {
            this.getAnimationHandler().runIfNotNull(this::handleAttack);
            if (this.method_5968() == null || !this.method_5968().method_5805()) {
                if (this.canFly()) {
                    this.setCanFly(false);
                }
            } else if (--this.flyTimer <= 0) {
                if (this.canFly()) {
                    this.flyTimer = 400 + this.method_59922().method_43048(300);
                    this.setCanFly(false);
                } else {
                    this.flyTimer = 250 + this.method_59922().method_43048(350);
                    this.setCanFly(true);
                }
            }
        }
        this.moveStateTracker.tick();
    }

    private class_243 directionToLookAt() {
        if (this.isCharging()) {
            return this.getChargeMotion();
        }
        return null;
    }

    protected void method_5958() {
        super.method_5958();
        this.tickBrain((class_1309)this);
    }

    public float interpolatedMoveTick(float partialTicks) {
        return this.moveStateTracker.interpolatedMoveTick(partialTicks);
    }

    public float interpolatedMoveTickOf(MoveType type, float partialTicks) {
        return this.moveStateTracker.interpolatedMoveTickOf(type, partialTicks);
    }

    public MoveType calculateMoveType() {
        if (!this.method_24828()) {
            return MoveType.FLY;
        }
        if (this.method_5642() instanceof class_1657 || !this.field_42108.method_48571()) {
            return MoveType.NONE;
        }
        if (this.method_6062()) {
            return MoveType.NONE;
        }
        double d0 = this.method_5962().method_6242();
        MoveType move = d0 > 1.0 || this.method_5968() != null ? MoveType.RUN : (d0 <= 0.8 ? MoveType.SNEAK : MoveType.WALK);
        return move;
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("Flying", this.canFly());
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setCanFly(compound.method_10577("Flying"));
    }

    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{CHARGING})) {
            if (anim.isPast("charge_start") && !anim.isPast("charge_end")) {
                boolean hit;
                class_243 dir = this.getChargeMotion();
                if (dir == null) {
                    this.setChargeTo(this.method_19538().method_1019(this.method_5828(1.0f).method_1021(10.0)));
                    dir = this.getChargeMotion();
                }
                this.method_18799(dir);
                OrientedBoundingBox obb = this.prepareAttackBox(anim.getAnimation(), null, 0.2, false);
                List list = this.method_37908().method_8390(class_1309.class, obb.getEncompassingBox(), entity -> this.targetPred.test((class_1309)entity) && obb.intersects(entity.method_5829()));
                boolean bl = hit = this.canFly() && this.field_5992;
                if (hit) {
                    this.setChargeMotion(new class_243(dir.method_10216() * 0.4, Math.abs(dir.method_10214()) * 0.7, dir.method_10215() * 0.4));
                }
                for (class_1309 e : list) {
                    if (this.hitEntities.contains(e) || !e.method_5643(FateDamageTypes.direct(FateDamageTypes.PEGASUS_CHARGE, (class_1297)this), (float)this.method_45325(class_5134.field_23721))) continue;
                    if (this.hitEntities.isEmpty()) {
                        hit = true;
                    }
                    this.hitEntities.add((class_1297)e);
                }
                S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (class_1297)this);
                if (hit) {
                    S2CScreenShake.sendAround((class_1297)this, 14.0, 8, 2.0f);
                }
            }
        } else if (!anim.is(new String[]{SUMMON})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                this.mobAttack(anim, this.method_5968(), this::method_6121);
                S2CScreenShake.sendAround((class_1297)this, 6.0, 8, 2.0f);
            }
        }
    }

    public void mobAttack(AnimationState anim, class_1309 target, Consumer<class_1309> cons) {
        OrientedBoundingBox obb = this.prepareAttackBox(anim.getAnimation(), (class_1297)target, 0.2, false);
        this.method_37908().method_8390(class_1309.class, obb.getEncompassingBox(), entity -> this.targetPred.test((class_1309)entity) && obb.intersects(entity.method_5829())).forEach(cons);
        if (!this.method_37908().field_9236) {
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (class_1297)this);
        }
    }

    public OrientedBoundingBox prepareAttackBox(String anim, class_1297 target, double grow, boolean debug) {
        OrientedBoundingBox obb = this.calculateAttackAABB(this.getAnimationHandler().createDefaulted(anim), target != null ? target.method_19538() : null, grow);
        if (debug) {
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTEMPT, (class_1297)this);
        }
        return obb;
    }

    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, @Nullable class_243 target, double grow) {
        if (anim.is(new String[]{CHARGING})) {
            class_238 aabb = OrientedBoundingBox.originAABB((class_1297)this).method_1014(grow).method_18804(this.method_18798());
            return new OrientedBoundingBox(aabb, this.method_36454(), 0.0f, this.method_19538());
        }
        double width = (double)this.method_17681() * 0.5 + 1.5;
        class_238 aabb = new class_238(-width * 0.8, -0.02, -width * 0.5, width * 0.8, (double)this.method_17682() * 0.5, width * 1.2).method_1014(grow);
        return new OrientedBoundingBox(aabb, this.method_36454(), 0.0f, this.method_19538());
    }

    public boolean method_6121(class_1297 entity) {
        return Utils.runWithInvulTimer((class_1297)this, entity, x$0 -> super.method_6121(x$0), 0);
    }

    public AnimationHandler<Pegasus> getAnimationHandler() {
        return this.animationHandler;
    }

    public boolean isCharging() {
        if (this.getAnimationHandler() == null) {
            return false;
        }
        AnimationState anim = this.getAnimationHandler().getAnimation();
        return anim != null && anim.is(new String[]{CHARGING}) && anim.isPast("attack");
    }

    public class_243 getChargeMotion() {
        return (class_243)this.getDataContainer().get(CHARGE_MOTION);
    }

    public void setChargeTo(class_243 pos) {
        class_243 dir = pos.method_1020(this.method_19538());
        if (!this.canFly()) {
            if ((dir = new class_243(dir.method_10216(), 0.0, dir.method_10215())).method_1027() > 1.6900000000000002) {
                dir = dir.method_1029().method_1021(1.3);
            }
        } else if ((dir = dir.method_1021(0.21)).method_1027() > 2.8899999999999997) {
            dir = dir.method_1029().method_1021(1.7);
        }
        this.setChargeMotion(dir);
    }

    public void setChargeMotion(class_243 chargeMotion) {
        this.getDataContainer().set(CHARGE_MOTION, (Object)chargeMotion);
    }

    public boolean method_5747(float distance, float damageMultiplier, class_1282 source) {
        return false;
    }

    public boolean method_5643(class_1282 damageSource, float damage) {
        if (damageSource.method_48789(class_8103.field_42242)) {
            return super.method_5643(damageSource, damage);
        }
        if (this.getAnimationHandler().isCurrent(new String[]{SUMMON})) {
            return false;
        }
        if (this.isCharging()) {
            damage *= 0.5f;
        }
        return super.method_5643(damageSource, damage);
    }

    protected boolean method_6062() {
        return super.method_6062() | this.getAnimationHandler().isCurrent(new String[]{SUMMON});
    }

    @Nullable
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData) {
        class_1315 data = super.method_5943(level, difficulty, reason, spawnData);
        if (reason == class_3730.field_16465 || reason == class_3730.field_16471) {
            this.getAnimationHandler().setAnimation(SUMMON);
        }
        return data;
    }

    public void setCanFly(boolean flag) {
        this.field_6011.method_12778(FLYING, (Object)flag);
        this.method_5875(flag);
        this.field_6189.method_6340();
        this.field_6189 = flag ? this.flyingNavigator : this.main;
        this.method_18799(this.method_18798().method_1021(0.3));
    }

    public boolean canFly() {
        return (Boolean)this.field_6011.method_12789(FLYING);
    }

    @Override
    public boolean shouldStand() {
        AnimationState anim = this.getAnimationHandler().getAnimation();
        return anim != null && anim.is(new String[]{SUMMON}) && !anim.isPast(1.0);
    }

    class PegasusMoveController
    extends class_1335 {
        public PegasusMoveController(Pegasus pegasus) {
            super((class_1308)pegasus);
        }

        public void method_6240() {
            class_1309 target;
            class_1335.class_1336 op = this.field_6374;
            if (this.field_6374 == class_1335.class_1336.field_6378 && Pegasus.this.canFly()) {
                this.field_6374 = class_1335.class_1336.field_6377;
                class_2338 targetPos = this.field_6371.method_5942().method_6355();
                if (targetPos == null) {
                    return;
                }
                float speed = (float)(this.field_6372 * this.field_6371.method_45325(class_5134.field_23720));
                class_243 target2 = class_243.method_24953((class_2382)targetPos);
                double dX = target2.method_10216() - this.field_6371.method_23317();
                double dY = target2.method_10214() - this.field_6371.method_23318();
                double dZ = target2.method_10215() - this.field_6371.method_23321();
                double horDist = Math.sqrt(dX * dX + dZ * dZ);
                if (Math.abs(horDist) > 0.5) {
                    double h = 1.0 - Math.abs(dY * (double)0.7f) / horDist;
                    horDist = Math.sqrt((dX *= h) * dX + (dZ *= h) * dZ);
                    double dist = Math.sqrt(dX * dX + dZ * dZ + dY * dY);
                    float targetYRot = (float)class_3532.method_15338((double)(class_3532.method_15349((double)dZ, (double)dX) * 57.2957763671875)) - 90.0f;
                    float targetXRot = (float)class_3532.method_15338((double)(class_3532.method_15349((double)dY, (double)horDist) * 57.2957763671875));
                    this.field_6371.method_36456(targetYRot);
                    this.field_6371.field_6283 = this.field_6371.method_36454();
                    this.field_6371.method_36457(targetXRot);
                    float yRot = this.field_6371.method_36454() + 90.0f;
                    double x = (double)(speed * class_3532.method_15362((float)(yRot * ((float)Math.PI / 180)))) * Math.abs(dX / dist);
                    double y = (double)(speed * class_3532.method_15374((float)(targetXRot * ((float)Math.PI / 180)))) * Math.abs(dY / dist);
                    double z = (double)(speed * class_3532.method_15374((float)(yRot * ((float)Math.PI / 180)))) * Math.abs(dZ / dist);
                    class_243 vec3 = this.field_6371.method_18798();
                    this.field_6371.method_18799(vec3.method_1019(new class_243(x, y, z).method_1020(vec3).method_1021(0.1)));
                }
            } else {
                super.method_6240();
            }
            if (Pegasus.this.canFly() && (target = this.field_6371.method_5968()) != null) {
                if (target.method_5858((class_1297)this.field_6371) < 576.0) {
                    this.field_6371.method_5951((class_1297)target, 60.0f, 30.0f);
                }
                if (op == class_1335.class_1336.field_6377) {
                    if (!Pegasus.this.getAnimationHandler().hasAnimation() && this.field_6371.method_23318() < target.method_23318() + (double)target.method_17682() + 2.5) {
                        class_243 delta = this.field_6371.method_18798().method_1031(0.0, 0.02, 0.0);
                        if (delta.method_10214() > 0.14) {
                            delta = new class_243(delta.method_10216(), 0.14, delta.method_10215());
                        }
                        this.field_6371.method_18799(delta);
                    } else {
                        this.field_6371.method_18799(this.field_6371.method_18798().method_1021(0.98));
                    }
                }
            }
        }
    }

    public static class ChargeBehaviour
    extends ExtendedBehaviour<Pegasus> {
        private static final MemoryTest MEMORIES = MemoryTest.builder((int)1).hasMemories(new class_4140[]{class_4140.field_22355});
        private class_243 targetPos;

        protected List<Pair<class_4140<?>, class_4141>> getMemoryRequirements() {
            return MEMORIES;
        }

        protected boolean shouldKeepRunning(Pegasus entity) {
            double dX = this.targetPos.method_10216() - entity.method_23317();
            double dZ = this.targetPos.method_10215() - entity.method_23321();
            float yRot = MathsHelper.YRotFrom(dX, dZ);
            float diffY = class_3532.method_15381((float)entity.method_36454(), (float)yRot);
            if (Math.abs(diffY) < 32.0f) {
                entity.setChargeTo(this.targetPos);
                return false;
            }
            return true;
        }

        protected void start(Pegasus entity) {
            this.targetPos = BrainUtils.getTargetOfEntity((class_1309)entity).method_33571();
        }

        protected void tick(Pegasus entity) {
            super.tick((class_1309)entity);
            double dY = this.targetPos.method_10214() - entity.method_23320();
            double dX = this.targetPos.method_10216() - entity.method_23317();
            double dZ = this.targetPos.method_10215() - entity.method_23321();
            float[] yXRot = MathsHelper.YXRotFrom(dX, dY, dZ);
            entity.method_36456(MathsHelper.rotlerp(entity.method_36454(), yXRot[0], 20.0f));
            entity.method_36457(MathsHelper.rotlerp(entity.method_36455(), yXRot[1], 30.0f));
            entity.method_5636(entity.method_36454());
            entity.method_5847(entity.method_36454());
        }
    }

    public static class RandomPositionAroundTarget<E extends class_1314>
    extends SetRandomFlyingTarget<E> {
        private static final MemoryTest MEMORIES = MemoryTest.builder((int)2).noMemory(class_4140.field_18445).hasMemories(new class_4140[]{class_4140.field_22355});

        protected List<Pair<class_4140<?>, class_4141>> getMemoryRequirements() {
            return MEMORIES;
        }

        protected class_243 getTargetPos(E entity) {
            class_1309 target = BrainUtils.getTargetOfEntity(entity);
            if (target == null) {
                return null;
            }
            for (int i = 0; i < 10; ++i) {
                double x = target.method_23317() + entity.method_59922().method_43058() * 10.0 - 5.0;
                double y = target.method_23320() + 3.0 + entity.method_59922().method_43058() * 4.0;
                double z = target.method_23321() + entity.method_59922().method_43058() * 10.0 - 5.0;
                class_2338 blockPos = class_2338.method_49637((double)x, (double)y, (double)z);
                if (class_5493.method_31520((class_2338)(blockPos = class_5535.method_31540((class_2338)blockPos, (int)entity.method_37908().method_31600(), pos -> class_5493.method_31523((class_1314)entity, (class_2338)pos))), entity) || class_5493.method_31521((boolean)true, entity, (class_2338)blockPos) || class_5493.method_31522(entity, (class_2338)blockPos)) continue;
                return new class_243(x, y, z);
            }
            return null;
        }
    }
}

