/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.summons;

import io.github.flemmli97.fateubw.api.datapack.ServantExtraData;
import io.github.flemmli97.fateubw.common.datapack.DatapackHandler;
import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.fateubw.common.network.S2CAttackDebug;
import io.github.flemmli97.fateubw.common.network.S2CScreenShake;
import io.github.flemmli97.fateubw.common.registry.FateEntities;
import io.github.flemmli97.tenshilib.common.entity.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_8046;

public class Tentacle
extends class_1297
implements AnimatedEntity,
class_8046 {
    public static final float SCALE = 1.75f;
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String SLAM = BUILDER.add("slam", AnimationsBuilder.definition((double)2.4).marker("attack", new double[]{1.56}).marker("can_despawn", new double[]{1.84}));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<Tentacle> animationHandler = new AnimationHandler((class_1297)this, ANIMS);
    private UUID ownerUuid;
    private class_1309 owner;

    public Tentacle(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
        this.field_5985 = true;
    }

    public Tentacle setOwner(class_1309 owner) {
        this.owner = owner;
        this.ownerUuid = this.owner != null ? this.owner.method_5667() : null;
        return this;
    }

    protected void method_5693(class_2945.class_9222 builder) {
    }

    protected void method_5749(class_2487 compound) {
        if (compound.method_25928("Owner")) {
            this.ownerUuid = compound.method_25926("Owner");
        }
    }

    protected void method_5652(class_2487 compound) {
        if (this.ownerUuid != null) {
            compound.method_25927("Shooter", this.ownerUuid);
        }
    }

    public boolean method_5640(double distance) {
        double d = this.method_5830().method_995();
        if (Double.isNaN(d)) {
            d = 1.0;
        }
        return distance < (d *= 64.0 * Tentacle.method_5824()) * d;
    }

    public class_238 method_5830() {
        return super.method_5830().method_1009(3.5, 7.0, 3.5);
    }

    public void method_5670() {
        AnimationState anim;
        if (!this.method_37908().field_9236 && !this.getAnimationHandler().hasAnimation()) {
            this.method_5650(class_1297.class_5529.field_26998);
            return;
        }
        super.method_5670();
        this.getAnimationHandler().tick();
        if (!this.method_37908().field_9236 && (anim = this.getAnimationHandler().getAnimation()) != null && anim.is(new String[]{SLAM}) && anim.isAt("attack")) {
            Predicate<class_1309> predicate;
            double width = 2.975;
            double len = 7.875;
            double height = 3.8500000000000005;
            class_238 aabb = new class_238(-width * 0.5, -0.03, 0.0, width * 0.5, height + 0.003, len);
            OrientedBoundingBox obb = new OrientedBoundingBox(aabb, -this.method_36454(), 0.0f, this.method_19538());
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, this);
            float damage = DatapackHandler.SERVANT_PROPS.get((class_1299)FateEntities.GILLES.get()).getConfig(ServantExtraData.GILLES_TENTACLE_DAMAGE).floatValue();
            class_1309 class_13092 = this.getOwner();
            if (class_13092 instanceof BaseServant) {
                BaseServant servant = (BaseServant)class_13092;
                predicate = servant.targetPred;
            } else {
                predicate = e -> true;
            }
            Predicate<class_1309> pred = predicate;
            this.method_37908().method_8390(class_1309.class, obb.getEncompassingBox(), entity -> pred.test((class_1309)entity) && obb.intersects(entity.method_5829())).forEach(e -> e.method_5643(this.method_48923().method_48800((class_1297)this, this.getOwner()), damage));
            S2CScreenShake.sendAround(this, 16.0, 8, 4.0f);
            this.method_5783((class_3414)class_3417.field_15152.comp_349(), 1.0f, 0.7f);
        }
    }

    public class_1309 getOwner() {
        if (this.owner != null && !this.owner.method_31481()) {
            return this.owner;
        }
        if (this.ownerUuid != null) {
            this.owner = (class_1309)EntityUtils.findFromUUID(class_1309.class, (class_1937)this.method_37908(), (UUID)this.ownerUuid);
        }
        return this.owner;
    }

    public AnimationHandler<?> getAnimationHandler() {
        return this.animationHandler;
    }

    public void setup(class_243 target) {
        this.getAnimationHandler().setAnimation(SLAM);
        class_243 dir = target.method_1020(this.method_19538());
        dir = dir.method_1027() < 1.0E-4 ? new class_243(1.0, 0.0, 0.0) : new class_243(dir.method_10216(), 0.0, dir.method_10215()).method_1029();
        dir = dir.method_1021(3.0).method_1024(this.method_59922().method_43057() * ((float)Math.PI * 2));
        this.method_33574(this.method_19538().method_1019(dir));
        this.method_18799(dir);
        double f = Math.sqrt(dir.method_37267());
        this.method_36456((float)(class_3532.method_15349((double)dir.field_1352, (double)dir.field_1350) * 57.29577951308232) - 180.0f);
        this.method_36457((float)(class_3532.method_15349((double)dir.field_1351, (double)f) * 57.29577951308232));
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
    }

    public float getDespawnProgress(float partialTicks) {
        AnimationState anim = this.getAnimationHandler().getAnimation();
        if (anim == null) {
            return 1.0f;
        }
        if (!anim.isPast("can_despawn")) {
            return -1.0f;
        }
        return (float)anim.progress(anim.getMarker("can_despawn", 0) * 20.0, anim.getLength(), partialTicks, 0);
    }
}

