/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.particles.trail;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.common.particles.trail.provider.ParticlePositionProvider;
import io.github.flemmli97.fateubw.common.particles.trail.provider.TrailData;
import io.github.flemmli97.fateubw.common.particles.trail.provider.entity.EntityWeaponTrailProvider;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_9139;

public class TrailProviderRegistry {
    private static final Map<class_2960, TrailType<?>> DECODERS = new HashMap();
    public static final Codec<TrailData> CODEC = class_2960.field_25139.dispatch(t -> t.type().id(), r -> TrailProviderRegistry.DECODERS.get((Object)r).codec);
    public static final TrailType<EntityWeaponTrailProvider.EntityTrailData> ENTITY_TRAIL = TrailProviderRegistry.register(Fate.modRes("entity_trail"), EntityWeaponTrailProvider.EntityTrailData.CODEC, EntityWeaponTrailProvider.EntityTrailData.STREAM_CODEC);
    public static final TrailType<ParticlePositionProvider.ParticlePositionData> MOTION_TRAIL = TrailProviderRegistry.register(Fate.modRes("motion_trail"), ParticlePositionProvider.ParticlePositionData.CODEC, ParticlePositionProvider.ParticlePositionData.STREAM_CODEC);

    public static synchronized <T extends TrailData> TrailType<T> register(class_2960 res, MapCodec<T> codec, class_9139<? super class_2540, T> streamCodec) {
        if (DECODERS.containsKey(res)) {
            throw new IllegalStateException("Entry with key " + String.valueOf(res) + " is already registered");
        }
        TrailType<T> entry = new TrailType<T>(res, codec, streamCodec);
        DECODERS.put(res, entry);
        return entry;
    }

    public static TrailData fromBuffer(class_2540 buf) {
        class_2960 id = buf.method_10810();
        TrailType<?> entry = DECODERS.get(id);
        if (entry == null) {
            throw new IllegalStateException("No such provider " + String.valueOf(id));
        }
        return (TrailData)entry.streamCodec.decode((Object)buf);
    }

    public static <T extends TrailData> void toBuffer(T data, class_2540 buf) {
        buf.method_10812(data.type().id());
        TrailType<?> type = data.type();
        type.streamCodec().encode((Object)buf, data);
    }

    public record TrailType<T extends TrailData>(class_2960 id, MapCodec<T> codec, class_9139<? super class_2540, T> streamCodec) {
    }
}

