/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.particles.trail.provider.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.fateubw.common.particles.trail.TrailPositions;
import io.github.flemmli97.fateubw.common.particles.trail.TrailProviderRegistry;
import io.github.flemmli97.fateubw.common.particles.trail.provider.TrailData;
import io.github.flemmli97.fateubw.common.particles.trail.provider.TrailProvider;
import io.github.flemmli97.fateubw.common.particles.trail.provider.entity.EntityWeaponTrailHolderProvider;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.netty.buffer.ByteBuf;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class EntityWeaponTrailProvider<T extends class_1297 & EntityWeaponTrailHolderProvider>
implements TrailProvider {
    public static final String TRAIL_START = "weapon_swing_start";
    public static final String TRAIL_END = "weapon_swing_end";
    private final EntityTrailData data;
    private final T entity;
    private final TrailPositions position;
    private boolean valid = true;
    private boolean sameTick;
    private int invalidTicks;

    public EntityWeaponTrailProvider(EntityTrailData data, T entity) {
        this.data = data;
        this.entity = entity;
        this.position = new TrailPositions(data.frames());
    }

    @Override
    public TrailPositions positions() {
        return this.position;
    }

    @Override
    public class_243 particleTick() {
        this.sameTick = false;
        if (this.valid) {
            AnimationState anim = ((AnimatedEntity)this.entity).getAnimationHandler().getAnimation();
            if (!this.entity.method_5805() || anim == null || !anim.is(new String[]{this.data.context()}) || anim.isPast(this.data.animationEnd)) {
                this.valid = false;
            }
        } else {
            ++this.invalidTicks;
            this.position.add(this.position.getLast());
        }
        return this.position.getLast() != null ? this.position.getLast().pos() : null;
    }

    @Override
    public TrailData data() {
        return this.data;
    }

    @Override
    public boolean removed() {
        return this.invalidTicks > this.position.getLength();
    }

    @Override
    public float adjustedPartialTicks(float partialTicks) {
        return 1.0f;
    }

    public void recordData(String context, boolean left, class_243 pos, class_243 normal) {
        if (!this.valid || !context.equals(this.data.context) || left != this.data.left) {
            return;
        }
        TrailPositions.TrailPosition trail = new TrailPositions.TrailPosition(this.entity.method_19538().method_1019(pos), normal);
        if (!this.sameTick) {
            this.position.add(trail);
        } else {
            this.position.replaceLast(trail);
        }
        this.sameTick = true;
    }

    public record EntityTrailData(int entityId, String context, boolean left, int frames, String animationEnd) implements TrailData
    {
        public static final MapCodec<EntityTrailData> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.INT.fieldOf("entity_id").forGetter(d -> d.entityId), (App)Codec.STRING.fieldOf("context").forGetter(d -> d.context), (App)Codec.BOOL.fieldOf("left").forGetter(d -> d.left), (App)Codec.INT.fieldOf("frames").forGetter(d -> d.frames), (App)Codec.STRING.fieldOf("end").forGetter(d -> d.animationEnd)).apply((Applicative)builder, EntityTrailData::new));
        public static final class_9139<ByteBuf, EntityTrailData> STREAM_CODEC = class_9139.method_56906((class_9139)class_9135.field_49675, EntityTrailData::entityId, (class_9139)class_9135.field_48554, EntityTrailData::context, (class_9139)class_9135.field_48547, EntityTrailData::left, (class_9139)class_9135.field_49675, EntityTrailData::frames, (class_9139)class_9135.field_48554, EntityTrailData::animationEnd, EntityTrailData::new);

        public EntityTrailData(int entityId, String context, int size, boolean left) {
            this(entityId, context, left, size, EntityWeaponTrailProvider.TRAIL_END);
        }

        public static <T extends class_1297> EntityTrailData create(T entity, String context, boolean left) {
            return new EntityTrailData(entity.method_5628(), context, 4, left);
        }

        public static <T extends class_1297> EntityTrailData create(T entity, String context, int size, boolean left) {
            return new EntityTrailData(entity.method_5628(), context, size, left);
        }

        @Override
        public TrailProviderRegistry.TrailType<?> type() {
            return TrailProviderRegistry.ENTITY_TRAIL;
        }

        @Override
        public TrailProvider createProvider(class_1937 level, Supplier<class_243> position, IntSupplier lifetime) {
            class_1297 e = level.method_8469(this.entityId);
            if (!(e instanceof EntityWeaponTrailHolderProvider)) {
                return null;
            }
            EntityWeaponTrailHolderProvider provider = (EntityWeaponTrailHolderProvider)e;
            return provider.getTrailHolder().createFor(this);
        }
    }
}

