/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.world;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.fateubw.common.world.TeamHandler;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GrailTeam {
    private static final Codec<UUID> UUID_CODEC = Codec.STRING.xmap(UUID::fromString, UUID::toString);
    public static final Codec<GrailTeam> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(d -> d.name), (App)UUID_CODEC.fieldOf("id").forGetter(d -> d.id), (App)UUID_CODEC.fieldOf("creator").forGetter(d -> d.creator), (App)Codec.unboundedMap(UUID_CODEC, (Codec)CodecUtils.stringEnumCodec(TeamPosition.class, null)).fieldOf("players").forGetter(d -> d.players), (App)Codec.unboundedMap(UUID_CODEC, (Codec)CodecUtils.stringEnumCodec(TeamStatus.class, null)).fieldOf("allies").forGetter(d -> d.allies)).apply((Applicative)instance, GrailTeam::new));
    private String name;
    private final UUID id;
    private final UUID creator;
    private final Map<UUID, TeamPosition> players = new HashMap<UUID, TeamPosition>();
    private final Map<UUID, TeamStatus> allies = new HashMap<UUID, TeamStatus>();

    public GrailTeam(String name, UUID creator) {
        this.name = name;
        this.creator = creator;
        this.id = UUID.randomUUID();
    }

    private GrailTeam(String name, UUID id, UUID creator, Map<UUID, TeamPosition> players, Map<UUID, TeamStatus> allies) {
        this.name = name;
        this.id = id;
        this.creator = creator;
        this.players.putAll(players);
        this.allies.putAll(allies);
    }

    public static GameProfile readProfile(class_2540 buf) {
        return new GameProfile(buf.readBoolean() ? buf.method_10790() : null, buf.readBoolean() ? buf.method_19772() : null);
    }

    public static void writeProfile(class_2540 buf, GameProfile profile) {
        buf.method_52964(profile.getId() != null);
        if (profile.getId() != null) {
            buf.method_10797(profile.getId());
        }
        buf.method_52964(profile.getName() != null);
        if (profile.getName() != null) {
            buf.method_10814(profile.getName());
        }
    }

    public String getName() {
        return this.name;
    }

    protected boolean rename(class_1657 source, String name) {
        if (!this.isAdmin(source.method_5667())) {
            source.method_43496((class_2561)class_2561.method_43471((String)"fateubw.chat.team.permission.no").method_27692(class_124.field_1079));
            return false;
        }
        this.name = name;
        return true;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getCreator() {
        return this.creator;
    }

    public boolean isAdmin(UUID player) {
        TeamPosition position = this.getPosition(player);
        return position == TeamPosition.CREATOR || position == TeamPosition.ADMIN;
    }

    public boolean isMember(UUID player) {
        return this.getPosition(player).isInTeam();
    }

    public Collection<UUID> members() {
        ArrayList<UUID> members = new ArrayList<UUID>();
        members.add(this.creator);
        members.addAll(this.players.keySet());
        return members;
    }

    public TeamPosition getPosition(UUID player) {
        if (this.getCreator().equals(player)) {
            return TeamPosition.CREATOR;
        }
        return this.players.getOrDefault(player, TeamPosition.NONE);
    }

    public boolean isAlliedTo(GrailTeam other) {
        if (other.equals(this)) {
            return true;
        }
        return this.getAllyStatus(other) == TeamStatus.ALLY;
    }

    public TeamStatus getAllyStatus(GrailTeam other) {
        return this.allies.getOrDefault(other.getId(), TeamStatus.NONE);
    }

    protected boolean addPlayer(UUID player) {
        if (this.getPosition(player) != TeamPosition.INVITED) {
            return false;
        }
        this.players.put(player, TeamPosition.MEMBER);
        return true;
    }

    protected boolean removePlayer(class_1657 source, UUID uuid) {
        if (!this.isAdmin(source.method_5667()) && !source.method_5667().equals(uuid)) {
            source.method_43496((class_2561)class_2561.method_43471((String)"fateubw.chat.team.permission.no").method_27692(class_124.field_1079));
            return false;
        }
        class_3222 player = source.method_5682().method_3760().method_14602(uuid);
        if (player != null) {
            player.method_43496((class_2561)class_2561.method_43469((String)"fateubw.chat.team.kicked", (Object[])new Object[]{source.method_5477(), this.getName()}).method_27692(class_124.field_1061));
        }
        return this.players.remove(uuid) != null;
    }

    protected boolean givePerms(class_1657 source, UUID uuid) {
        class_2561 target;
        if (!this.isAdmin(source.method_5667())) {
            source.method_43496((class_2561)class_2561.method_43471((String)"fateubw.chat.team.permission.no").method_27692(class_124.field_1079));
            return false;
        }
        if (!this.isMember(uuid) || source.method_5682() == null) {
            return false;
        }
        this.players.put(uuid, TeamPosition.ADMIN);
        class_3222 player = source.method_5682().method_3760().method_14602(uuid);
        if (player != null) {
            target = player.method_5477();
            player.method_43496((class_2561)class_2561.method_43469((String)"fateubw.chat.team.promote", (Object[])new Object[]{source.method_5477()}).method_27692(class_124.field_1065));
        } else {
            target = source.method_5682().method_3793().method_14512(uuid).map(p -> class_2561.method_43470((String)p.getName())).orElse(null);
        }
        if (target != null) {
            source.method_43496((class_2561)class_2561.method_43469((String)"fateubw.chat.team.promote.user", (Object[])new Object[]{target}).method_27692(class_124.field_1080));
        }
        return true;
    }

    protected boolean revokePerms(class_1657 source, UUID uuid) {
        class_2561 target;
        if (!this.isAdmin(source.method_5667())) {
            source.method_43496((class_2561)class_2561.method_43471((String)"fateubw.chat.team.permission.no").method_27692(class_124.field_1079));
            return false;
        }
        if (source.method_5667().equals(uuid)) {
            source.method_43496((class_2561)class_2561.method_43471((String)"fateubw.chat.team.self.no").method_27692(class_124.field_1079));
            return false;
        }
        if (source.method_5682() == null) {
            return false;
        }
        this.players.put(uuid, TeamPosition.MEMBER);
        class_3222 player = source.method_5682().method_3760().method_14602(uuid);
        if (player != null) {
            target = player.method_5477();
            player.method_43496((class_2561)class_2561.method_43469((String)"fateubw.chat.team.demote", (Object[])new Object[]{source.method_5477()}).method_27692(class_124.field_1061));
        } else {
            target = source.method_5682().method_3793().method_14512(uuid).map(p -> class_2561.method_43470((String)p.getName())).orElse(null);
        }
        if (target != null) {
            source.method_43496((class_2561)class_2561.method_43469((String)"fateubw.chat.team.demote.user", (Object[])new Object[]{target}).method_27692(class_124.field_1080));
        }
        return true;
    }

    protected boolean invite(class_1657 source, UUID uuid) {
        class_2561 target;
        if (!this.isAdmin(source.method_5667())) {
            source.method_43496((class_2561)class_2561.method_43471((String)"fateubw.chat.team.permission.no").method_27692(class_124.field_1079));
            return false;
        }
        if (source.method_5682() == null || this.isMember(uuid)) {
            return false;
        }
        this.players.put(uuid, TeamPosition.INVITED);
        class_3222 player = source.method_5682().method_3760().method_14602(uuid);
        if (player != null) {
            target = player.method_5477();
            player.method_43496((class_2561)class_2561.method_43469((String)"fateubw.chat.team.invite.received", (Object[])new Object[]{this.getName()}).method_27692(class_124.field_1060));
        } else {
            target = source.method_5682().method_3793().method_14512(uuid).map(p -> class_2561.method_43470((String)p.getName())).orElse(null);
        }
        if (target != null) {
            source.method_43496((class_2561)class_2561.method_43469((String)"fateubw.chat.team.invite.sent", (Object[])new Object[]{target}).method_27692(class_124.field_1080));
        }
        return true;
    }

    protected boolean removeInvite(class_1657 source, UUID uuid) {
        if (!this.isAdmin(source.method_5667()) && !source.method_5667().equals(uuid)) {
            source.method_43496((class_2561)class_2561.method_43471((String)"fateubw.chat.team.permission.no").method_27692(class_124.field_1079));
            return false;
        }
        return this.players.remove(uuid, (Object)TeamPosition.INVITED);
    }

    protected boolean addAlly(class_1657 source, GrailTeam team) {
        if (!this.isAdmin(source.method_5667())) {
            source.method_43496((class_2561)class_2561.method_43471((String)"fateubw.chat.team.permission.no").method_27692(class_124.field_1079));
            return false;
        }
        if (source.method_5682() == null) {
            return false;
        }
        TeamStatus status = this.getAllyStatus(team);
        TeamStatus other = team.getAllyStatus(this);
        if (status != TeamStatus.INCOMING_REQUEST || other != TeamStatus.OUTGOING_REQUEST) {
            if (status != TeamStatus.ALLY && other != TeamStatus.ALLY) {
                this.allies.remove(team.getId());
                team.allies.remove(this.getId());
                return true;
            }
            return false;
        }
        this.allies.put(team.getId(), TeamStatus.ALLY);
        team.allies.put(this.getId(), TeamStatus.ALLY);
        this.notifyAdmins(this, source.method_5682(), player -> player.method_43496((class_2561)class_2561.method_43469((String)"fateubw.chat.team.alliance.start", (Object[])new Object[]{this.getName(), team.getName()}).method_27692(class_124.field_1065)));
        this.notifyAdmins(team, source.method_5682(), player -> player.method_43496((class_2561)class_2561.method_43469((String)"fateubw.chat.team.alliance.start", (Object[])new Object[]{this.getName(), team.getName()}).method_27692(class_124.field_1065)));
        return true;
    }

    protected boolean removeAlly(class_1657 source, GrailTeam team) {
        if (!this.isAdmin(source.method_5667())) {
            source.method_43496((class_2561)class_2561.method_43471((String)"fateubw.chat.team.permission.no").method_27692(class_124.field_1079));
            return false;
        }
        if (source.method_5682() == null) {
            return false;
        }
        this.allies.remove(team.getId());
        team.allies.remove(this.getId());
        team.notifyAdmins(this, source.method_5682(), player -> player.method_43496((class_2561)class_2561.method_43469((String)"fateubw.chat.team.alliance.dissolved.with", (Object[])new Object[]{source.method_5477(), team.getName()}).method_27692(class_124.field_1061)));
        source.method_43496((class_2561)class_2561.method_43469((String)"fateubw.chat.team.alliance.dissolved", (Object[])new Object[]{source.method_5477(), this.getName()}).method_27692(class_124.field_1080));
        return true;
    }

    protected boolean requestAlliance(class_1657 source, GrailTeam team) {
        if (!this.isAdmin(source.method_5667())) {
            source.method_43496((class_2561)class_2561.method_43471((String)"fateubw.chat.team.permission.no").method_27692(class_124.field_1079));
            return false;
        }
        if (source.method_5682() == null || this.getAllyStatus(team) != TeamStatus.NONE) {
            return false;
        }
        this.allies.put(team.getId(), TeamStatus.OUTGOING_REQUEST);
        team.allies.put(this.getId(), TeamStatus.INCOMING_REQUEST);
        team.notifyAdmins(team, source.method_5682(), player -> player.method_43496((class_2561)class_2561.method_43469((String)"fateubw.chat.team.alliance.received", (Object[])new Object[]{this.getName()}).method_27692(class_124.field_1060)));
        source.method_43496((class_2561)class_2561.method_43469((String)"fateubw.chat.team.alliance.sent", (Object[])new Object[]{team.getName()}).method_27692(class_124.field_1080));
        return true;
    }

    protected boolean removeRequest(class_1657 source, GrailTeam team) {
        if (!this.isAdmin(source.method_5667())) {
            source.method_43496((class_2561)class_2561.method_43471((String)"fateubw.chat.team.permission.no").method_27692(class_124.field_1079));
            return false;
        }
        TeamStatus status = this.getAllyStatus(team);
        if (status != TeamStatus.OUTGOING_REQUEST) {
            return false;
        }
        this.allies.remove(team.getId());
        team.allies.remove(this.getId());
        return true;
    }

    protected boolean denyRequest(class_1657 source, GrailTeam team) {
        if (!this.isAdmin(source.method_5667())) {
            source.method_43496((class_2561)class_2561.method_43471((String)"fateubw.chat.team.permission.no").method_27692(class_124.field_1079));
            return false;
        }
        if (source.method_5682() == null) {
            return false;
        }
        TeamStatus status = this.getAllyStatus(team);
        if (status != TeamStatus.INCOMING_REQUEST) {
            return false;
        }
        this.allies.remove(team.getId());
        team.allies.remove(this.getId());
        this.notifyAdmins(team, source.method_5682(), player -> player.method_43496((class_2561)class_2561.method_43469((String)"fateubw.chat.team.alliance.denied", (Object[])new Object[]{this.getName()}).method_27692(class_124.field_1061)));
        return true;
    }

    protected void onDisband(TeamHandler teamHandler) {
        teamHandler.getTeams(this).forEach(other -> other.allies.remove(this.getId()));
    }

    private void notifyAdmins(GrailTeam team, MinecraftServer server, Consumer<class_3222> consumer) {
        for (UUID member : team.members()) {
            class_3222 player;
            TeamPosition pos = this.getPosition(member);
            if (pos != TeamPosition.ADMIN && pos != TeamPosition.CREATOR || (player = server.method_3760().method_14602(member)) == null) continue;
            consumer.accept(player);
        }
    }

    public ShortTeamInfo getInfo() {
        return this.getInfo(null);
    }

    public ShortTeamInfo getInfo(@Nullable class_1657 player) {
        return new ShortTeamInfo(this.getName(), this.getId(), this.getCreator(), player != null && this.isAdmin(player.method_5667()));
    }

    public static enum TeamPosition {
        NONE,
        INVITED,
        MEMBER,
        ADMIN,
        CREATOR;


        public boolean isInTeam() {
            return this == MEMBER || this == ADMIN || this == CREATOR;
        }
    }

    public static enum TeamStatus {
        NONE,
        OUTGOING_REQUEST,
        INCOMING_REQUEST,
        ALLY;

    }

    public record ShortTeamInfo(String name, UUID id, UUID creator, boolean admin) implements Comparable<ShortTeamInfo>
    {
        public ShortTeamInfo(class_2540 buf) {
            this(buf.method_19772(), buf.method_10790(), buf.method_10790(), buf.readBoolean());
        }

        public void write(class_2540 buf) {
            buf.method_10814(this.name());
            buf.method_10797(this.id());
            buf.method_10797(this.creator());
            buf.method_52964(this.admin());
        }

        @Override
        public int compareTo(@NotNull ShortTeamInfo o) {
            return this.name().compareTo(o.name());
        }

        @Override
        @NotNull
        public String toString() {
            return this.name();
        }
    }

    public record ClientTeamInfo(Optional<ShortTeamInfo> team, List<Pair<GameProfile, TeamPosition>> players, List<Pair<ShortTeamInfo, TeamStatus>> others, List<ShortTeamInfo> invites) {
        public static ClientTeamInfo create(class_3222 player, TeamHandler handler) {
            GrailTeam team = handler.getTeamFor((class_1657)player);
            ArrayList<Pair<GameProfile, TeamPosition>> players = new ArrayList<Pair<GameProfile, TeamPosition>>();
            if (team != null) {
                for (class_3222 class_32222 : player.method_5682().method_3760().method_14571()) {
                    if (handler.getTeamFor((class_1657)class_32222) != null || team.players.containsKey(class_32222.method_5667())) continue;
                    players.add((Pair<GameProfile, TeamPosition>)Pair.of((Object)class_32222.method_7334(), (Object)((Object)TeamPosition.NONE)));
                }
                for (Map.Entry entry : team.players.entrySet()) {
                    player.method_5682().method_3793().method_14512((UUID)entry.getKey()).ifPresent(prof -> players.add(Pair.of((Object)prof, (Object)((Object)((TeamPosition)((Object)((Object)((Object)entry.getValue()))))))));
                }
                player.method_5682().method_3793().method_14512(team.getCreator()).ifPresent(prof -> players.add(Pair.of((Object)prof, (Object)((Object)TeamPosition.CREATOR))));
                players.sort(Comparator.comparing(p -> ((GameProfile)p.getFirst()).getName()));
            }
            List<Pair<ShortTeamInfo, TeamStatus>> others = team == null ? List.of() : handler.getTeams(team).stream().map(other -> Pair.of((Object)other.getInfo(), (Object)((Object)team.getAllyStatus((GrailTeam)other)))).toList();
            return new ClientTeamInfo(Optional.ofNullable(team != null ? team.getInfo((class_1657)player) : null), players, others, handler.fetchInvitesFor((class_1657)player));
        }

        public static ClientTeamInfo read(class_2540 buf) {
            return new ClientTeamInfo(buf.readBoolean() ? Optional.of(new ShortTeamInfo(buf)) : Optional.empty(), buf.method_34066(b -> Pair.of((Object)GrailTeam.readProfile(b), (Object)((Object)((TeamPosition)b.method_10818(TeamPosition.class))))), buf.method_34066(b -> Pair.of((Object)new ShortTeamInfo((class_2540)b), (Object)((Object)((TeamStatus)b.method_10818(TeamStatus.class))))), buf.method_34066(ShortTeamInfo::new));
        }

        public void write(class_2540 buf) {
            buf.method_52964(this.team.isPresent());
            this.team.ifPresent(inf -> inf.write(buf));
            buf.method_34062(this.players, (b, p) -> {
                GrailTeam.writeProfile(b, (GameProfile)p.getFirst());
                b.method_10817((Enum)p.getSecond());
            });
            buf.method_34062(this.others, (b, p) -> {
                ((ShortTeamInfo)p.getFirst()).write((class_2540)b);
                b.method_10817((Enum)p.getSecond());
            });
            buf.method_34062(this.invites, (b, inf) -> inf.write((class_2540)b));
        }
    }
}

