/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.world;

import com.google.common.collect.ImmutableSet;
import io.github.flemmli97.fateubw.api.entity.ServantLike;
import io.github.flemmli97.fateubw.common.config.CommonConfig;
import io.github.flemmli97.fateubw.common.datapack.DatapackHandler;
import io.github.flemmli97.fateubw.common.datapack.EntityPropsManager;
import io.github.flemmli97.fateubw.common.registry.FateCriterionTriggers;
import io.github.flemmli97.fateubw.common.registry.FateDamageTypes;
import io.github.flemmli97.fateubw.common.registry.FateItems;
import io.github.flemmli97.fateubw.common.world.Participant;
import io.github.flemmli97.fateubw.platform.Platform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2135;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4284;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class GrailWarHandler
extends class_18 {
    private static final String IDENTIFIER = "FateGrailWar";
    private static final Function<MinecraftServer, class_18.class_8645<GrailWarHandler>> FACTORY = server -> new class_18.class_8645(() -> new GrailWarHandler((MinecraftServer)server), (tag, provider) -> new GrailWarHandler((MinecraftServer)server, (class_2487)tag, (class_7225.class_7874)provider), class_4284.field_19212);
    private final MinecraftServer server;
    private final Map<UUID, Participant<?>> participants = new HashMap();
    private Set<UUID> joinedParticipants = new HashSet<UUID>();
    private final Set<class_2960> servantsTypes = new HashSet<class_2960>();
    private final Set<class_2960> servantClasses = new HashSet<class_2960>();
    private Phase phase = Phase.NONE;
    private int lastGrailEndDay;
    private int joinTime;
    private int timeToNextServant;
    private Map<class_1923, class_5321<class_1937>> servantTickets;

    private GrailWarHandler(MinecraftServer server) {
        this.server = server;
    }

    private GrailWarHandler(MinecraftServer server, class_2487 tag, class_7225.class_7874 provider) {
        this.server = server;
        this.load(tag);
    }

    public static GrailWarHandler get(MinecraftServer server) {
        return (GrailWarHandler)server.method_30002().method_17983().method_17924(FACTORY.apply(server), IDENTIFIER);
    }

    private static int day(class_1937 level) {
        return (int)(level.method_8532() / 24000L % Integer.MAX_VALUE);
    }

    public boolean join(ServantLike<?> servant) {
        JoinResult res;
        class_1657 player = servant.getOwner();
        if (player != null && (res = this.checkJoining(player)) != JoinResult.SUCCESS) {
            player.method_43496((class_2561)class_2561.method_43471((String)res.translationKey));
            return false;
        }
        if (!this.joinInternal(player, servant)) {
            if (player != null) {
                player.method_43496((class_2561)class_2561.method_43471((String)JoinResult.WRONG_SERVANT.translationKey));
            }
            return false;
        }
        this.method_80();
        return true;
    }

    public boolean forceStartGrailWar() {
        if (this.phase == Phase.NONE) {
            this.setupStart();
            return true;
        }
        return false;
    }

    private boolean joinInternal(@Nullable class_1657 player, ServantLike<?> servant) {
        Participant participant = new Participant(servant, player);
        if (!this.participants.containsKey(participant.getId()) && this.canSpawnServant(servant)) {
            this.participants.put(participant.getId(), participant);
            this.servantClasses.add(servant.props().servantClass());
            this.servantsTypes.add(class_7923.field_41177.method_10221((Object)servant.get().method_5864()));
            this.joinedParticipants.add(participant.getId());
            return true;
        }
        return false;
    }

    public JoinResult checkJoining(class_1657 player) {
        if (this.phase != Phase.JOIN) {
            return JoinResult.WRONG_STATE;
        }
        if (this.isFull()) {
            return JoinResult.FULL;
        }
        if (this.joinedParticipants.contains(player.method_5667())) {
            return JoinResult.JOINED;
        }
        if (!this.canSpawnMoreServants(player.method_37908())) {
            return JoinResult.NO_MORE_SERVANTS;
        }
        return JoinResult.SUCCESS;
    }

    public boolean isFull() {
        if (this.phase == Phase.JOIN) {
            return this.participants.size() >= CommonConfig.maxPlayer;
        }
        return this.joinedParticipants.size() >= CommonConfig.maxPlayer;
    }

    public boolean isParticipant(class_1297 entity) {
        ServantLike servant;
        if (entity instanceof ServantLike && (servant = (ServantLike)entity).method_6139() != null) {
            return this.participants.containsKey(servant.method_6139());
        }
        return this.participants.containsKey(entity.method_5667());
    }

    public Optional<ServantLike<?>> getServant(class_3222 player) {
        Participant<?> participant = this.participants.get(player.method_5667());
        if (participant != null) {
            return Optional.ofNullable((ServantLike)participant.getServant(this.server));
        }
        return Optional.empty();
    }

    public Set<UUID> players(boolean valid) {
        return ImmutableSet.copyOf(this.participants.entrySet().stream().filter(p -> ((Participant)p.getValue()).isPlayerParticipant() && (!valid || ((Participant)p.getValue()).valid(this.server))).map(Map.Entry::getKey).toList());
    }

    public void tick(class_3218 level) {
        this.loadTickets(level);
        switch (this.phase.ordinal()) {
            case 0: {
                if (Math.abs(GrailWarHandler.day((class_1937)level) - this.lastGrailEndDay) <= CommonConfig.grailWarCooldown || level.method_8532() % 24000L != 1L) break;
                this.setupStart();
                break;
            }
            case 1: {
                if (--this.joinTime <= 0) {
                    this.start();
                }
                HashSet invalid = new HashSet();
                this.participants.forEach((id, participant) -> {
                    if (!participant.valid(this.server)) {
                        invalid.add(id);
                        Object servant = participant.getServant(this.server);
                        if (servant != null) {
                            servant.method_5643(FateDamageTypes.grail(servant.method_56673()), 2.1474836E9f);
                        }
                    }
                });
                invalid.forEach(this.participants::remove);
                break;
            }
            case 2: {
                if (CommonConfig.fillMissingSlots && --this.timeToNextServant <= 0) {
                    this.trySpawnNPCServant(level);
                }
                this.runGrailWar();
            }
        }
        this.method_80();
    }

    private void loadTickets(class_3218 level) {
        if (this.servantTickets != null) {
            this.servantTickets.forEach((c, r) -> {
                if (level.method_27983().equals(r)) {
                    level.method_14178().method_17297(ServantLike.TRACKINGTICKET, c, 2, c);
                } else {
                    class_3218 w = this.server.method_3847(r);
                    w.method_14178().method_17297(ServantLike.TRACKINGTICKET, c, 2, c);
                }
            });
            this.servantTickets = null;
        }
    }

    private void setupStart() {
        this.joinTime = CommonConfig.joinTime;
        this.phase = Phase.JOIN;
        this.server.method_3760().method_43514((class_2561)class_2561.method_43469((String)"fateubw.chat.grailwar.init", (Object[])new Object[]{this.joinTime / 20}).method_27692(class_124.field_1076), true);
    }

    private void start() {
        this.phase = Phase.ACTIVE;
        Set<UUID> players = this.players(true);
        if (players.size() >= CommonConfig.minPlayer) {
            this.server.method_3760().method_43514((class_2561)class_2561.method_43471((String)"fateubw.chat.grailwar.start").method_27692(class_124.field_1065), true);
            this.joinedParticipants = new HashSet<UUID>(this.participants.keySet());
        } else if (players.isEmpty()) {
            this.server.method_3760().method_43514((class_2561)class_2561.method_43471((String)"fateubw.chat.grailwar.players.none").method_27692(class_124.field_1061), true);
            this.reset(false);
        } else {
            this.joinTime = CommonConfig.joinTime;
            this.phase = Phase.JOIN;
            this.server.method_3760().method_43514((class_2561)class_2561.method_43471((String)"fateubw.chat.grailwar.players.missing").method_27692(class_124.field_1061), true);
        }
        this.method_80();
    }

    private void runGrailWar() {
        HashSet invalid = new HashSet();
        this.participants.forEach((id, participant) -> {
            if (!participant.valid(this.server) && invalid.size() + 1 < this.participants.size()) {
                Object servant;
                invalid.add(id);
                if (participant.isPlayerParticipant()) {
                    this.server.method_3793().method_14512(participant.getId()).ifPresent(prof -> this.broadcastParticipants((class_2561)class_2561.method_43469((String)"fateubw.chat.grailwar.player.out", (Object[])new Object[]{prof.getName()}).method_27692(class_124.field_1061)));
                }
                if ((servant = participant.getServant(this.server)) != null) {
                    servant.method_5643(FateDamageTypes.grail(servant.method_56673()), 2.1474836E9f);
                }
            }
        });
        invalid.forEach(this.participants::remove);
        if (this.players(false).isEmpty()) {
            this.reset(false);
            this.server.method_3760().method_43514((class_2561)class_2561.method_43471((String)"fateubw.chat.grailwar.players.dead").method_27692(class_124.field_1061), true);
        } else if (this.isFull()) {
            if (this.participants.isEmpty()) {
                this.reset(true);
            } else if (this.participants.size() == 1) {
                Participant<?> participant2 = this.participants.values().iterator().next();
                class_3222 player = participant2.getAsPlayer(this.server);
                if (player != null) {
                    String name = player.method_7334().getName();
                    ((class_2135)FateCriterionTriggers.WIN_GRAIL_WAR.get()).method_9141(player);
                    this.server.method_3760().method_43514((class_2561)class_2561.method_43469((String)"fateubw.chat.grailwar.win", (Object[])new Object[]{name}).method_27692(class_124.field_1065), true);
                    class_1542 holyGrail = new class_1542(player.method_37908(), player.method_23317() + (double)player.method_59922().method_43048(7) - 3.0, player.method_23318() + 3.0, player.method_23321() + (double)player.method_59922().method_43048(7) - 3.0, new class_1799((class_1935)FateItems.GRAIL.get()));
                    holyGrail.method_6976();
                    holyGrail.method_6981((class_1297)player);
                    holyGrail.method_5684(true);
                    holyGrail.method_5834(true);
                    holyGrail.method_5875(true);
                    player.method_37908().method_8649((class_1297)holyGrail);
                    player.method_43496((class_2561)class_2561.method_43471((String)"fateubw.chat.grailwar.win.spawn").method_27692(class_124.field_1080));
                    Platform.INSTANCE.getPlayerData((class_1657)player).saveServant((ServantLike)participant2.getServant(this.server));
                } else {
                    this.server.method_3760().method_43514((class_2561)class_2561.method_43471((String)"fateubw.chat.grailwar.win.none").method_27692(class_124.field_1061), true);
                }
                this.reset(false);
            }
        }
    }

    public void reset(boolean notify) {
        this.participants.values().forEach(participant -> {
            Object servant = participant.getServant(this.server);
            if (servant != null) {
                servant.method_5643(FateDamageTypes.grail(servant.method_56673()), 2.1474836E9f);
            }
        });
        this.participants.clear();
        this.servantsTypes.clear();
        this.servantClasses.clear();
        this.joinedParticipants.clear();
        this.phase = Phase.NONE;
        this.lastGrailEndDay = GrailWarHandler.day((class_1937)this.server.method_30002());
        this.joinTime = 0;
        this.timeToNextServant = 0;
        if (notify) {
            this.server.method_3760().method_43514((class_2561)class_2561.method_43471((String)"fateubw.chat.grailwar.end").method_27692(class_124.field_1061), true);
        }
        this.method_80();
    }

    public boolean canSpawnMoreServants(class_1937 level) {
        for (EntityPropsManager.EntityTypeAndID entry : DatapackHandler.SERVANT_PROPS.getServants()) {
            boolean canSpawn = CommonConfig.allowDuplicateServant || !this.servantsTypes.contains(entry.id());
            if (!canSpawn || !CommonConfig.allowDuplicateClass && this.servantClasses.contains(DatapackHandler.SERVANT_PROPS.get((class_1299)entry.type().comp_349()).servantClass())) continue;
            return true;
        }
        return false;
    }

    public boolean canSpawnServant(ServantLike<?> servant) {
        if (this.isFull()) {
            return false;
        }
        if (!this.canSpawnServantType(class_7923.field_41177.method_10221((Object)servant.get().method_5864()))) {
            return false;
        }
        return this.canSpawnServantClass(servant.props().servantClass());
    }

    public boolean canSpawnServantType(class_2960 entityType) {
        if (this.isFull()) {
            return false;
        }
        return CommonConfig.allowDuplicateServant || !this.servantsTypes.contains(entityType);
    }

    public boolean canSpawnServantClass(class_2960 servantClass) {
        if (this.isFull()) {
            return false;
        }
        return CommonConfig.allowDuplicateClass || !this.servantClasses.contains(servantClass);
    }

    private void trySpawnNPCServant(class_3218 level) {
        if (this.isFull()) {
            return;
        }
        ArrayList players = new ArrayList();
        Set<UUID> playerParticipant = this.players(false);
        this.server.method_3760().method_14571().forEach(player -> {
            if (playerParticipant.contains(player.method_5667())) {
                players.add(player);
            }
        });
        int spawns = Math.min(level.field_9229.method_43048(CommonConfig.maxServantCircle) + 1, CommonConfig.maxPlayer - this.joinedParticipants.size());
        for (int i = 0; i < spawns; ++i) {
            if (players.isEmpty()) {
                return;
            }
            class_3222 player2 = (class_3222)players.remove(level.field_9229.method_43048(players.size()));
            double xR = player2.method_51469().field_9229.method_43058() - 0.5;
            double zR = player2.method_51469().field_9229.method_43058() - 0.5;
            int x = (int)(player2.method_23317() + xR * 128.0 + (double)(xR <= 0.0 ? -24 : 24));
            int z = (int)(player2.method_23321() + zR * 128.0 + (double)(zR <= 0.0 ? -24 : 24));
            class_1923 cpos = new class_1923(x >> 4, z >> 4);
            class_2818 chunk = player2.method_51469().method_8497(cpos.field_9181, cpos.field_9180);
            int y = chunk.method_12005(class_2902.class_2903.field_13203, x, z) + 1;
            ServantLike<?> servant = this.summonRandomServant(player2.method_51469(), new class_243((double)x, (double)y, (double)z), null, null, true, true);
            if (servant == null) continue;
            player2.method_51469().method_14178().method_17297(ServantLike.TRACKINGTICKET, cpos, 2, (Object)cpos);
            this.timeToNextServant = class_3532.method_15395((class_5819)player2.method_51469().field_9229, (int)CommonConfig.servantMinSpawnDelay, (int)CommonConfig.servantMaxSpawnDelay);
            if (!this.notify(class_7923.field_41177.method_10221((Object)servant.get().method_5864()))) continue;
            if (CommonConfig.notifyAll) {
                this.broadcastParticipants((class_2561)class_2561.method_43469((String)"fateubw.chat.grailwar.spawn", (Object[])new Object[]{player2.method_5477()}).method_27692(class_124.field_1080));
                continue;
            }
            player2.method_43496((class_2561)class_2561.method_43469((String)"fateubw.chat.grailwar.spawn", (Object[])new Object[]{player2.method_5477()}).method_27692(class_124.field_1080));
        }
    }

    private boolean notify(class_2960 loc) {
        return CommonConfig.notificationWhitelist == CommonConfig.notifyBlacklist.contains(loc.toString());
    }

    public void broadcastParticipants(class_2561 message) {
        this.server.method_3760().method_43512(message, player -> this.isParticipant((class_1297)player) ? message : null, true);
    }

    public ServantLike<?> summonRandomServant(class_3218 level, class_243 pos, @Nullable class_3222 player, @Nullable class_1799 stack, boolean event, boolean addToLevel) {
        class_1297 entity = DatapackHandler.SERVANT_PROPS.getRandom(level.method_8409(), entry -> this.canSpawnServantClass(entry.servantClass()) && this.canSpawnServantType(entry.id()), stack).map(t -> ((class_1299)t.type().comp_349()).method_5888(level, null, class_2338.method_49638((class_2374)pos), class_3730.field_16471, false, false)).orElse(null);
        if (!(entity instanceof ServantLike)) {
            return null;
        }
        ServantLike servant = (ServantLike)entity;
        Object mob = servant.get();
        mob.method_5808(pos.method_10216(), pos.method_10214(), pos.method_10215(), level.field_9229.method_43057() * 360.0f, 0.0f);
        if (player != null) {
            mob.method_5702(class_2183.class_2184.field_9851, player.method_19538());
        }
        servant.setOwner((class_1657)player);
        if (!mob.method_5957((class_4538)level) || event && !Platform.INSTANCE.canSpawnEvent((class_1308)mob, (class_5425)level, class_3730.field_16461)) {
            return null;
        }
        this.join(servant);
        mob.method_5943((class_5425)level, level.method_8404(mob.method_24515()), class_3730.field_16461, null);
        if (addToLevel) {
            level.method_8649(mob);
        }
        return servant;
    }

    public void moveToPlayer(ServantLike<?> servantLike) {
        if (servantLike.method_6139() != null || servantLike.get().method_5682() == null) {
            return;
        }
        Object servant = servantLike.get();
        if (!this.hasPlayersNearby((class_1297)servant)) {
            List<class_3222> players = servant.method_5682().method_3760().method_14571().stream().filter(this::isParticipant).toList();
            class_3222 player = players.get(servant.method_59922().method_43048(players.size()));
            for (int i = 0; i < 10; ++i) {
                double xR = servant.method_59922().method_43058() - 0.5;
                double zR = servant.method_59922().method_43058() - 0.5;
                double x = player.method_23317() + xR * 128.0 + (double)(xR <= 0.0 ? -24 : 24);
                double z = player.method_23321() + zR * 128.0 + (double)(zR <= 0.0 ? -24 : 24);
                double y = player.method_23318() + (double)(servant.method_59922().method_43048(64) - 32);
                if (servant.method_6082(x, y, z, false)) break;
            }
        }
    }

    private boolean hasPlayersNearby(class_1297 entity) {
        for (class_1657 player : entity.method_37908().method_18456()) {
            double dist;
            if (!this.isParticipant((class_1297)player) || !((dist = player.method_5649(entity.method_23317(), player.method_23318(), entity.method_23321())) < 65536.0)) continue;
            return true;
        }
        return false;
    }

    public void load(class_2487 compound) {
        class_2499 tag = compound.method_10554("Participants", 10);
        tag.forEach(cT -> {
            Participant participant = new Participant((class_2487)cT);
            this.participants.put(participant.getId(), participant);
        });
        class_2499 joined = compound.method_10554("JoinedParticipants", 11);
        joined.forEach(s -> this.joinedParticipants.add(class_2512.method_25930((class_2520)s)));
        class_2499 list = compound.method_10554("Servants", 8);
        list.forEach(s -> this.servantsTypes.add(class_2960.method_60654((String)s.method_10714())));
        class_2499 list2 = compound.method_10554("ServantClasses", 8);
        list2.forEach(s -> this.servantClasses.add(class_2960.method_60654((String)s.method_10714())));
        this.phase = Phase.valueOf(compound.method_10558("Phase"));
        this.lastGrailEndDay = compound.method_10550("LastGrailWarDay");
        this.joinTime = compound.method_10550("JoinTime");
        this.timeToNextServant = compound.method_10550("NextServantSpawnTick");
        class_2487 tickets = compound.method_10562("ToLoadChunks");
        tickets.method_10541().forEach(id -> {
            class_2487 entryTag = tickets.method_10562(id);
            this.servantTickets.put(new class_1923(entryTag.method_10537("Position")), (class_5321<class_1937>)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)entryTag.method_10558("Level"))));
        });
    }

    public class_2487 method_75(class_2487 compound, class_7225.class_7874 provider) {
        class_2499 tag = new class_2499();
        this.participants.values().forEach(p -> tag.add((Object)p.save()));
        compound.method_10566("Participants", (class_2520)tag);
        class_2499 joined = new class_2499();
        this.joinedParticipants.forEach(id -> joined.add((Object)class_2512.method_25929((UUID)id)));
        compound.method_10566("JoinedParticipants", (class_2520)joined);
        class_2499 list = new class_2499();
        this.servantsTypes.forEach(res -> list.add((Object)class_2519.method_23256((String)res.toString())));
        compound.method_10566("Servants", (class_2520)list);
        class_2499 list2 = new class_2499();
        this.servantClasses.forEach(e -> list2.add((Object)class_2519.method_23256((String)e.toString())));
        compound.method_10566("ServantClasses", (class_2520)list2);
        compound.method_10582("Phase", this.phase.toString());
        compound.method_10569("LastGrailWarDay", this.lastGrailEndDay);
        compound.method_10569("JoinTime", this.joinTime);
        compound.method_10569("NextServantSpawnTick", this.timeToNextServant);
        class_2487 tickets = new class_2487();
        this.participants.forEach((uuid, participant) -> {
            Object servant = participant.getServant(this.server);
            if (servant != null) {
                class_2487 entryTag = new class_2487();
                entryTag.method_10544("Position", class_1923.method_37232((class_2338)servant.method_24515()));
                entryTag.method_10582("Level", servant.method_37908().method_27983().method_29177().toString());
                tickets.method_10566(uuid.toString(), (class_2520)entryTag);
            }
        });
        compound.method_10566("ToLoadChunks", (class_2520)tickets);
        return compound;
    }

    static enum Phase {
        NONE,
        JOIN,
        ACTIVE;

    }

    public static enum JoinResult {
        WRONG_STATE("fateubw.war.join.result.fail"),
        FULL("fateubw.war.join.result.full"),
        JOINED("fateubw.war.join.result.joined"),
        WRONG_SERVANT("fateubw.war.join.servant.fail"),
        NO_MORE_SERVANTS("fateubw.war.join.servant.full"),
        SUCCESS("fateubw.war.join.success");

        public final String translationKey;

        private JoinResult(String translationKey) {
            this.translationKey = translationKey;
        }
    }
}

