/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.world;

import io.github.flemmli97.fateubw.api.entity.ServantLike;
import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.tenshilib.common.entity.EntityUtils;
import java.lang.ref.WeakReference;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class Participant<T extends class_1308> {
    private final ParticipantId uuid;
    private class_5321<class_1937> levelCache;
    private WeakReference<T> servant;

    public Participant(ServantLike<T> servant, @Nullable class_1657 player) {
        this(servant.get(), player != null ? player.method_5667() : null);
    }

    public Participant(ServantLike<T> servant, @Nullable UUID player) {
        this(servant.get(), player);
    }

    private Participant(T servant, @Nullable UUID player) {
        this.uuid = new ParticipantId(player != null ? player : servant.method_5667(), servant.method_5667());
        this.servant = new WeakReference<T>(servant);
    }

    public Participant(class_2487 tag) {
        this.uuid = new ParticipantId(tag.method_25926("UUID"), tag.method_25926("Servant"));
        if (tag.method_10545("CachedLevel")) {
            this.levelCache = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)tag.method_10558("CachedLevel")));
        }
    }

    public boolean isPlayerParticipant() {
        return !this.uuid.participant().equals(this.uuid.servant());
    }

    public UUID getId() {
        return this.uuid.participant();
    }

    @Nullable
    public class_3222 getAsPlayer(MinecraftServer server) {
        if (!this.isPlayerParticipant()) {
            return null;
        }
        return server.method_3760().method_14602(this.uuid.participant());
    }

    public T getServant(MinecraftServer server) {
        class_1308 servant;
        class_1308 class_13082 = servant = this.servant == null ? null : (class_1308)this.servant.get();
        if (servant == null || !servant.method_5805()) {
            class_1297 entity;
            class_3218 level;
            if (this.levelCache != null && (level = server.method_3847(this.levelCache)) != null && (entity = EntityUtils.findFromUUID(class_1297.class, (class_1937)level, (UUID)this.uuid.servant())) instanceof ServantLike) {
                this.servant = new WeakReference<class_1308>((class_1308)entity);
                return (T)((class_1308)this.servant.get());
            }
            for (class_3218 level2 : server.method_3738()) {
                class_1297 entity2 = EntityUtils.findFromUUID(BaseServant.class, (class_1937)level2, (UUID)this.uuid.servant());
                if (!(entity2 instanceof ServantLike)) continue;
                this.servant = new WeakReference<class_1308>((class_1308)entity2);
                this.levelCache = entity2.method_37908().method_27983();
                break;
            }
        }
        return (T)servant;
    }

    public boolean valid(MinecraftServer server) {
        T servant = this.getServant(server);
        return servant != null && servant.method_5805();
    }

    private class_5321<class_1937> cachedLevel() {
        class_1308 servant = this.servant == null ? null : (class_1308)this.servant.get();
        return servant != null ? servant.method_37908().method_27983() : null;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Participant)) {
            return false;
        }
        Participant participant = (Participant)obj;
        return this.getId().equals(participant.getId());
    }

    public class_2487 save() {
        class_2487 tag = new class_2487();
        tag.method_25927("UUID", this.uuid.participant());
        tag.method_25927("Servant", this.uuid.servant());
        class_5321<class_1937> cache = this.cachedLevel();
        if (cache != null) {
            tag.method_10582("CachedLevel", cache.method_29177().toString());
        }
        return tag;
    }

    private record ParticipantId(UUID participant, UUID servant) {
    }
}

