/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.world;

import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.common.network.S2CTeamGuiData;
import io.github.flemmli97.fateubw.common.world.GrailTeam;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_3222;
import net.minecraft.class_4284;
import net.minecraft.class_6025;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class TeamHandler
extends class_18 {
    private static final String IDENTIFIER = "FateGrailTeams";
    private static final class_18.class_8645<TeamHandler> FACTORY = new class_18.class_8645(TeamHandler::new, TeamHandler::new, class_4284.field_19212);
    private final Map<UUID, GrailTeam> teams = new HashMap<UUID, GrailTeam>();
    private final Map<UUID, UUID> teamsByPlayer = new HashMap<UUID, UUID>();
    private final Map<UUID, WeakReference<class_3222>> listeners = new HashMap<UUID, WeakReference<class_3222>>();

    private TeamHandler() {
    }

    private TeamHandler(class_2487 tag, class_7225.class_7874 provider) {
        this.load(tag);
    }

    public static TeamHandler get(MinecraftServer server) {
        return (TeamHandler)server.method_30002().method_17983().method_17924(FACTORY, IDENTIFIER);
    }

    @Nullable
    public GrailTeam getTeamFor(class_1657 player) {
        return this.getTeamFor(player.method_5667());
    }

    @Nullable
    private GrailTeam getTeamFor(UUID player) {
        UUID team = this.teamsByPlayer.get(player);
        if (team != null) {
            return this.teams.get(team);
        }
        return null;
    }

    @Nullable
    public GrailTeam getTeamFor(class_1297 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return this.getTeamFor(player);
        }
        if (entity instanceof class_6025) {
            class_6025 ownable = (class_6025)entity;
            if (ownable.method_6139() == null) {
                return null;
            }
            class_1309 owner = ownable.method_35057();
            if (owner != null) {
                return this.getTeamFor((class_1297)owner);
            }
            return this.getTeamFor(ownable.method_6139());
        }
        return null;
    }

    public List<GrailTeam> getTeams(GrailTeam except) {
        return this.teams.values().stream().filter(name -> !name.equals(except)).sorted(Comparator.comparing(GrailTeam::getName)).toList();
    }

    public boolean areAllies(class_1297 entity, class_1297 other) {
        class_268 team = entity.method_5781();
        if (team != null && team.method_1206((class_270)other.method_5781())) {
            return true;
        }
        GrailTeam first = this.getTeamFor(entity);
        GrailTeam second = this.getTeamFor(other);
        if (first != null && second != null) {
            return first.isAlliedTo(second);
        }
        return false;
    }

    public void createTeam(class_1657 player, String name) {
        UUID uuid = player.method_5667();
        if (this.teamsByPlayer.containsKey(uuid)) {
            player.method_43496((class_2561)class_2561.method_43469((String)"fateubw.chat.team.player.exist", (Object[])new Object[]{player.method_5477()}).method_27692(class_124.field_1061));
            return;
        }
        GrailTeam team = new GrailTeam(name, uuid);
        this.teams.put(team.getId(), team);
        this.teamsByPlayer.put(uuid, team.getId());
        this.onTeamChange(this.listeners.keySet());
    }

    public void joinTeam(class_1657 player, UUID teamID) {
        UUID uuid = player.method_5667();
        if (this.teamsByPlayer.containsKey(uuid)) {
            player.method_43496((class_2561)class_2561.method_43469((String)"fateubw.chat.team.player.exist", (Object[])new Object[]{player.method_5477()}).method_27692(class_124.field_1061));
            return;
        }
        GrailTeam team = this.teams.get(teamID);
        if (team == null) {
            player.method_43496((class_2561)class_2561.method_43469((String)"fateubw.chat.team.missing", (Object[])new Object[]{teamID.toString()}).method_27692(class_124.field_1061));
            return;
        }
        if (team.addPlayer(uuid)) {
            this.teamsByPlayer.put(uuid, team.getId());
            this.fetchInvitesFor(player).forEach(inf -> this.denyInvite(player, inf.id()));
            this.onTeamChange(team.members());
        }
    }

    public void removeFromTeam(class_1657 player, UUID target) {
        UUID team = this.teamsByPlayer.get(player.method_5667());
        if (team != null) {
            this.removeFromTeam(player, target, team);
        }
    }

    public void removeFromTeam(class_1657 source, UUID player, UUID teamID) {
        GrailTeam team = this.teams.get(teamID);
        if (team == null) {
            return;
        }
        if (source.method_5667().equals(player) && team.getCreator().equals(player)) {
            team.onDisband(this);
            this.teamsByPlayer.remove(player);
            this.teams.remove(team.getId());
            this.onTeamChange(this.listeners.keySet());
        } else if (team.removePlayer(source, player)) {
            this.teamsByPlayer.remove(player);
            this.onTeamChange(team.members());
            this.onTeamChange(List.of(player));
        }
    }

    public List<GrailTeam.ShortTeamInfo> fetchInvitesFor(class_1657 player) {
        return this.teams.values().stream().filter(t -> t.getPosition(player.method_5667()) == GrailTeam.TeamPosition.INVITED).map(GrailTeam::getInfo).sorted().toList();
    }

    public List<GrailTeam.ShortTeamInfo> fetchRequestsFor(class_1657 player, GrailTeam team) {
        if (team == null) {
            return List.of();
        }
        return this.teams.values().stream().filter(t -> !t.equals(team) && t.isAdmin(player.method_5667()) && t.getAllyStatus(team) == GrailTeam.TeamStatus.INCOMING_REQUEST).map(GrailTeam::getInfo).sorted().toList();
    }

    public void rename(class_1657 source, String newName) {
        GrailTeam team = this.getTeamFor(source);
        if (team == null) {
            return;
        }
        if (team.rename(source, newName)) {
            this.onTeamChange(team.members());
        }
    }

    public void givePerms(class_1657 source, UUID player) {
        GrailTeam team = this.getTeamFor(source);
        if (team == null) {
            return;
        }
        if (team.givePerms(source, player)) {
            this.onTeamChange(team.members());
        }
    }

    public void revokePerms(class_1657 source, UUID player) {
        GrailTeam team = this.getTeamFor(source);
        if (team == null) {
            return;
        }
        if (team.revokePerms(source, player)) {
            this.onTeamChange(team.members());
        }
    }

    public void retractInvite(class_1657 source, UUID player) {
        GrailTeam team = this.getTeamFor(source);
        if (team == null) {
            return;
        }
        if (team.removeInvite(source, player)) {
            this.onTeamChange(team.members());
            this.onTeamChange(List.of(player));
        }
    }

    public void invite(class_1657 source, UUID player) {
        GrailTeam team = this.getTeamFor(source);
        if (team == null) {
            return;
        }
        if (team.invite(source, player)) {
            this.onTeamChange(team.members());
            this.onTeamChange(List.of(player));
        }
    }

    public void denyInvite(class_1657 player, UUID teamID) {
        GrailTeam team = this.teams.get(teamID);
        if (team == null) {
            return;
        }
        if (team.removeInvite(player, player.method_5667())) {
            this.onTeamChange(team.members());
            this.onTeamChange(List.of(player.method_5667()));
        }
    }

    public void requestAlliance(class_1657 source, UUID teamID) {
        GrailTeam team = this.getTeamFor(source);
        GrailTeam other = this.teams.get(teamID);
        if (team == null || other == null) {
            return;
        }
        if (team.requestAlliance(source, other)) {
            this.onTeamChange(team.members());
            this.onTeamChange(other.members());
        }
    }

    public void retractRequest(class_1657 source, UUID teamID) {
        GrailTeam team = this.getTeamFor(source);
        GrailTeam other = this.teams.get(teamID);
        if (team == null || other == null) {
            return;
        }
        if (team.removeRequest(source, other)) {
            this.onTeamChange(team.members());
            this.onTeamChange(other.members());
        }
    }

    public void acceptAlliance(class_1657 source, UUID teamID) {
        GrailTeam team = this.getTeamFor(source);
        GrailTeam other = this.teams.get(teamID);
        if (team == null || other == null) {
            return;
        }
        if (team.addAlly(source, other)) {
            this.onTeamChange(team.members());
            this.onTeamChange(other.members());
        }
    }

    public void denyAlliance(class_1657 player, UUID teamID) {
        GrailTeam team = this.getTeamFor(player);
        GrailTeam other = this.teams.get(teamID);
        if (team == null || other == null) {
            return;
        }
        if (team.denyRequest(player, other)) {
            this.onTeamChange(team.members());
            this.onTeamChange(other.members());
        }
    }

    public void dissolveAlliance(class_1657 player, UUID teamID) {
        GrailTeam team = this.getTeamFor(player);
        GrailTeam other = this.teams.get(teamID);
        if (team == null || other == null) {
            return;
        }
        if (team.removeAlly(player, other)) {
            this.onTeamChange(team.members());
            this.onTeamChange(other.members());
        }
    }

    public void listenChanges(class_3222 player) {
        this.listeners.put(player.method_5667(), new WeakReference<class_3222>(player));
    }

    public void removeListener(class_1657 player) {
        this.listeners.remove(player.method_5667());
    }

    private void onTeamChange(Collection<UUID> players) {
        players.forEach(uuid -> {
            WeakReference<class_3222> player = this.listeners.get(uuid);
            if (player != null && player.get() != null) {
                S2CTeamGuiData.sendTeamData((class_3222)player.get(), false);
            }
        });
        this.method_80();
    }

    public void load(class_2487 nbt) {
        class_2499 teams = nbt.method_10554("Teams", 10);
        teams.forEach(tag -> {
            try {
                GrailTeam team = (GrailTeam)GrailTeam.CODEC.parse((DynamicOps)class_2509.field_11560, tag).getOrThrow();
                this.teams.put(team.getId(), team);
                team.members().forEach(player -> this.teamsByPlayer.put((UUID)player, team.getId()));
            }
            catch (Exception e) {
                Fate.LOGGER.error("Unable to load team from tag {}", tag, (Object)e);
            }
        });
    }

    public class_2487 method_75(class_2487 compound, class_7225.class_7874 provider) {
        class_2499 teams = new class_2499();
        this.teams.values().forEach(team -> {
            try {
                teams.add((Object)((class_2520)GrailTeam.CODEC.encodeStart((DynamicOps)class_2509.field_11560, team).getOrThrow()));
            }
            catch (Exception e) {
                Fate.LOGGER.error("Unable to save team {} with id {}", (Object)team.getId(), (Object)team.getName(), (Object)e);
            }
        });
        compound.method_10566("Teams", (class_2520)teams);
        return compound;
    }
}

