/*
 * Decompiled with CFR 0.152.
 */
package net.xbtstudio.school.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.xbtstudio.school.SchoolMod;
import net.xbtstudio.school.procedures.DoctorSoundProcedure;
import net.xbtstudio.school.procedures.Oggta1Procedure;
import net.xbtstudio.school.procedures.Oggta2Procedure;
import net.xbtstudio.school.procedures.Oggta3Procedure;
import net.xbtstudio.school.procedures.Oggta4Procedure;
import net.xbtstudio.school.procedures.Oggta5Procedure;
import net.xbtstudio.school.procedures.ShutdownProcedure;
import net.xbtstudio.school.procedures.StopSoundProcedure;
import net.xbtstudio.school.world.inventory.MusicselectionpageMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MusicselectionpageButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public MusicselectionpageButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public MusicselectionpageButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(MusicselectionpageButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(MusicselectionpageButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            MusicselectionpageButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = MusicselectionpageMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ShutdownProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            Oggta4Procedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            Oggta1Procedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            Oggta5Procedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            Oggta3Procedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            Oggta2Procedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            DoctorSoundProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 7) {
            StopSoundProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SchoolMod.addNetworkMessage(MusicselectionpageButtonMessage.class, MusicselectionpageButtonMessage::buffer, MusicselectionpageButtonMessage::new, MusicselectionpageButtonMessage::handler);
    }
}

