/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.monster;

import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.dungeon.monster.ArmorSet;
import xiroc.dungeoncrawl.util.IRandom;

public class RandomEquipment {
    public static final ResourceLocation[] BOWS = new ResourceLocation[]{new ResourceLocation("minecraft:bow")};
    public static final ResourceLocation[] SWORDS = new ResourceLocation[]{new ResourceLocation("minecraft:stone_sword"), new ResourceLocation("minecraft:golden_sword"), new ResourceLocation("minecraft:iron_sword"), new ResourceLocation("minecraft:diamond_sword")};
    public static final ResourceLocation[] PICKAXES = new ResourceLocation[]{new ResourceLocation("minecraft:stone_pickaxe"), new ResourceLocation("minecraft:golden_pickaxe"), new ResourceLocation("minecraft:iron_pickaxe")};
    public static final ResourceLocation[] AXES = new ResourceLocation[]{new ResourceLocation("minecraft:stone_axe"), new ResourceLocation("minecraft:golden_axe"), new ResourceLocation("minecraft:iron_axe"), new ResourceLocation("minecraft:diamond_axe")};
    public static final ArmorSet[] ARMOR_SETS = new ArmorSet[]{new ArmorSet("minecraft:leather_boots", "minecraft:leather_leggings", "minecraft:leather_chestplate", "minecraft:leather_helmet"), new ArmorSet("minecraft:golden_boots", "minecraft:golden_leggings", "minecraft:golden_chestplate", "minecraft:golden_helmet"), new ArmorSet("minecraft:chainmail_boots", "minecraft:chainmail_leggings", "minecraft:chainmail_chestplate", "minecraft:chainmail_helmet"), new ArmorSet("minecraft:iron_boots", "minecraft:iron_leggings", "minecraft:iron_chestplate", "minecraft:iron_helmet")};
    public static final ResourceLocation[] BOW_ENCHANTMENTS = new ResourceLocation[]{new ResourceLocation("minecraft:power"), new ResourceLocation("minecraft:unbreaking"), new ResourceLocation("minecraft:punch"), new ResourceLocation("minecraft:infinity")};
    public static final ResourceLocation[] SWORD_ENCHANTMENTS = new ResourceLocation[]{new ResourceLocation("minecraft:sharpness"), new ResourceLocation("minecraft:unbreaking"), new ResourceLocation("minecraft:fire_aspect"), new ResourceLocation("minecraft:knockback")};
    public static final ResourceLocation[] PICKAXE_ENCHANTMENTS = new ResourceLocation[]{new ResourceLocation("minecraft:efficiency")};
    public static final ResourceLocation[] AXE_ENCHANTMENTS = new ResourceLocation[]{new ResourceLocation("minecraft:efficiency")};
    public static final ResourceLocation[] ARMOR_ENCHANTMENTS = new ResourceLocation[]{new ResourceLocation("minecraft:protection"), new ResourceLocation("minecraft:unbreaking"), new ResourceLocation("minecraft:thorns"), new ResourceLocation("minecraft:projectile_protection")};
    public static final IRandom<ItemStack> BOW = rand -> {
        ItemStack item = new ItemStack((IItemProvider)RandomEquipment.getItem(BOWS[rand.nextInt(BOWS.length)]));
        RandomEquipment.enchantBow(item, rand);
        RandomEquipment.applyDamage(item, rand);
        return item;
    };
    public static final IRandom<ItemStack> RANGED_WEAPON = rand -> BOW.roll(rand);
    public static final IRandom<ItemStack> SWORD = rand -> {
        ItemStack item = new ItemStack((IItemProvider)RandomEquipment.getItem(SWORDS[rand.nextInt(SWORDS.length)]));
        RandomEquipment.enchantSword(item, rand);
        RandomEquipment.applyDamage(item, rand);
        return item;
    };
    public static final IRandom<ItemStack> PICKAXE = rand -> {
        ItemStack item = new ItemStack((IItemProvider)RandomEquipment.getItem(PICKAXES[rand.nextInt(PICKAXES.length)]));
        RandomEquipment.enchantPickaxe(item, rand);
        RandomEquipment.applyDamage(item, rand);
        return item;
    };
    public static final IRandom<ItemStack> AXE = rand -> {
        ItemStack item = new ItemStack((IItemProvider)RandomEquipment.getItem(AXES[rand.nextInt(AXES.length)]));
        RandomEquipment.enchantAxe(item, rand);
        RandomEquipment.applyDamage(item, rand);
        return item;
    };
    public static final IRandom<ItemStack> MELEE_WEAPON = rand -> {
        switch (rand.nextInt(3)) {
            case 0: {
                return SWORD.roll(rand);
            }
            case 1: {
                return PICKAXE.roll(rand);
            }
            case 2: {
                return AXE.roll(rand);
            }
        }
        return null;
    };
    public static final IRandom<ItemStack[]> ARMOR = rand -> {
        ItemStack[] items = new ItemStack[4];
        ArmorSet armor = ARMOR_SETS[rand.nextInt(ARMOR_SETS.length)];
        for (int i = 0; i < 4; ++i) {
            if ((double)rand.nextFloat() < 0.5) {
                ItemStack item = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(armor.items[i]));
                RandomEquipment.enchantArmor(item, rand);
                RandomEquipment.applyDamage(item, rand);
                items[i] = item;
                continue;
            }
            items[i] = ItemStack.field_190927_a;
        }
        return items;
    };

    public static void applyDamage(ItemStack item, Random rand) {
        item.func_196085_b(rand.nextInt(item.func_77958_k()));
    }

    public static void enchantItem(ItemStack item, Random rand, Enchantment enchantment) {
        int maxLevel;
        int minLevel = enchantment.func_77319_d();
        item.func_77966_a(enchantment, minLevel < (maxLevel = enchantment.func_77325_b()) ? minLevel + rand.nextInt(maxLevel - minLevel) : maxLevel);
    }

    public static void enchantBow(ItemStack item, Random rand) {
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(BOW_ENCHANTMENTS[rand.nextInt(BOW_ENCHANTMENTS.length)]);
        RandomEquipment.enchantItem(item, rand, enchantment);
    }

    public static void enchantArmor(ItemStack item, Random rand) {
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ARMOR_ENCHANTMENTS[rand.nextInt(ARMOR_ENCHANTMENTS.length)]);
        RandomEquipment.enchantItem(item, rand, enchantment);
    }

    public static void enchantSword(ItemStack item, Random rand) {
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(SWORD_ENCHANTMENTS[rand.nextInt(SWORD_ENCHANTMENTS.length)]);
        RandomEquipment.enchantItem(item, rand, enchantment);
    }

    public static void enchantPickaxe(ItemStack item, Random rand) {
        RandomEquipment.enchantSword(item, rand);
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(PICKAXE_ENCHANTMENTS[rand.nextInt(PICKAXE_ENCHANTMENTS.length)]);
        RandomEquipment.enchantItem(item, rand, enchantment);
    }

    public static void enchantAxe(ItemStack item, Random rand) {
        RandomEquipment.enchantSword(item, rand);
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(AXE_ENCHANTMENTS[rand.nextInt(AXE_ENCHANTMENTS.length)]);
        RandomEquipment.enchantItem(item, rand, enchantment);
    }

    public static Item getItem(ResourceLocation resourceLocation) {
        return (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
    }
}

