/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.part.block;

import com.google.common.collect.ImmutableSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.monster.RandomEquipment;
import xiroc.dungeoncrawl.util.IBlockPlacementHandler;

public class Spawner
implements IBlockPlacementHandler {
    public static int spawnerEntities = 5;
    public static final Set<EntityType<?>> INVENTORY_ENTITIES = ImmutableSet.builder().add((Object)EntityType.field_200725_aD).add((Object)EntityType.field_200741_ag).add((Object)EntityType.field_200727_aF).add((Object)EntityType.field_200763_C).build();

    @Override
    public void setupBlock(IWorld world, BlockState state, BlockPos pos, Random rand, int stage) {
        world.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 2);
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof MobSpawnerTileEntity) {
            MobSpawnerTileEntity tile = (MobSpawnerTileEntity)tileentity;
            EntityType<?> type = Spawner.getRandomEntityType(rand);
            tile.func_145881_a().func_200876_a(type);
            if (INVENTORY_ENTITIES.contains(type)) {
                CompoundNBT spawnerNBT = tile.func_145881_a().func_189530_b(new CompoundNBT());
                ListNBT potentialSpawns = new ListNBT();
                for (int i = 0; i < spawnerEntities; ++i) {
                    CompoundNBT nbt = new CompoundNBT();
                    CompoundNBT spawnData = new CompoundNBT();
                    spawnData.func_74778_a("id", type.getRegistryName().toString());
                    ItemStack[] armor = RandomEquipment.ARMOR.roll(new Random());
                    ListNBT armorList = new ListNBT();
                    for (ItemStack stack : armor) {
                        armorList.add((Object)stack.func_77955_b(new CompoundNBT()));
                    }
                    spawnData.func_218657_a("ArmorItems", (INBT)armorList);
                    ListNBT handItems = new ListNBT();
                    ItemStack mainHand = type == EntityType.field_200741_ag ? RandomEquipment.RANGED_WEAPON.roll(rand) : RandomEquipment.MELEE_WEAPON.roll(new Random());
                    handItems.add((Object)mainHand.func_77955_b(new CompoundNBT()));
                    handItems.add((Object)ItemStack.field_190927_a.func_77955_b(new CompoundNBT()));
                    spawnData.func_218657_a("HandItems", (INBT)handItems);
                    nbt.func_218657_a("Entity", (INBT)spawnData);
                    nbt.func_74768_a("Weight", 1);
                    if (i == 0) {
                        spawnerNBT.func_218657_a("SpawnData", (INBT)spawnData);
                    }
                    potentialSpawns.add((Object)nbt);
                }
                spawnerNBT.func_218657_a("SpawnPotentials", (INBT)potentialSpawns);
                tile.func_145881_a().func_98270_a(spawnerNBT);
            }
        } else {
            DungeonCrawl.LOGGER.error("Failed to fetch mob spawner entity at ({}, {}, {})", (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
        }
    }

    public static EntityType<?> getRandomEntityType(Random rand) {
        switch (rand.nextInt(6)) {
            case 0: {
                return EntityType.field_200725_aD;
            }
            case 1: {
                return EntityType.field_200741_ag;
            }
            case 2: {
                return EntityType.field_200748_an;
            }
            case 3: {
                return EntityType.field_200794_h;
            }
            case 4: {
                return EntityType.field_200727_aF;
            }
            case 5: {
                return EntityType.field_200763_C;
            }
        }
        return null;
    }
}

