/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl;

import com.google.common.collect.Lists;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.List;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.StructurePieceTypes;
import xiroc.dungeoncrawl.dungeon.treasure.Loot;
import xiroc.dungeoncrawl.init.ModStructures;
import xiroc.dungeoncrawl.util.ResourceReloadHandler;
import xiroc.dungeoncrawl.util.tools.Tools;

@Mod(value="dungeoncrawl")
public class DungeonCrawl {
    public static final String MOD_ID = "dungeoncrawl";
    public static final String NAME = "Dungeon Crawl";
    public static final String VERSION = "2.3.4";
    public static final Logger LOGGER = LogManager.getLogger((String)"Dungeon Crawl");
    public static final JsonParser JSON_PARSER = new JsonParser();

    public DungeonCrawl() {
        LOGGER.info("Here we go! Launching Dungeon Crawl {}...", (Object)VERSION);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.addListener(this::onAddReloadListener);
        forgeEventBus.addListener(this::onWorldLoad);
        this.init();
    }

    private void init() {
        ModStructures.init();
        Loot.init();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Common Setup");
        Config.load(FMLPaths.CONFIGDIR.get().resolve("dungeon_crawl.toml"));
        if (((Boolean)Config.ENABLE_TOOLS.get()).booleanValue()) {
            MinecraftForge.EVENT_BUS.register((Object)new Tools());
        }
        event.enqueueWork(() -> {
            StructurePieceTypes.register();
            ModStructures.register();
        });
    }

    private void onWorldLoad(WorldEvent.Load event) {
        if (((Boolean)Config.PRINT_BIOME_CATEGORIES.get()).booleanValue() && event.getWorld() instanceof ServerWorld && ((ServerWorld)event.getWorld()).func_234923_W_().equals(World.field_234918_g_)) {
            HashMap<String, List> biomes = new HashMap<String, List>();
            ForgeRegistries.BIOMES.getEntries().forEach(entry -> {
                ResourceLocation registryName = ((Biome)entry.getValue()).getRegistryName();
                if (registryName != null) {
                    biomes.computeIfAbsent(((Biome)entry.getValue()).func_201856_r().func_222352_a(), key -> Lists.newArrayList()).add(registryName.toString());
                }
            });
            biomes.forEach((key, value) -> {
                LOGGER.info("Biome Category '{}' contains the following biomes:", key);
                value.forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
            });
        }
    }

    private void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)new ResourceReloadHandler());
    }

    public static ResourceLocation locate(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static ResourceLocation key(ResourceLocation resourceLocation, String baseDirectory, String fileEnding) {
        String path = resourceLocation.func_110623_a();
        return new ResourceLocation(resourceLocation.func_110624_b(), path.substring(baseDirectory.length() + 1, path.length() - fileEnding.length()));
    }
}

