/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlockType;

public class DungeonModelBlock {
    public final DungeonModelBlockType type;
    public Vector3i position;
    @Nullable
    private final PropertyHolder[] properties;
    public final boolean hasProperties;
    @Nullable
    public final Integer variation;
    public final Block block;
    @Nullable
    public final ResourceLocation blockName;
    @Nullable
    public ResourceLocation lootTable;

    private DungeonModelBlock(DungeonModelBlockType type, Vector3i position) {
        this(type, position, null, null, Blocks.field_201941_jj, null);
    }

    private DungeonModelBlock(DungeonModelBlockType type, Vector3i position, @Nullable PropertyHolder[] properties, @Nullable Integer variation, Block block, @Nullable ResourceLocation blockName) {
        this.type = type;
        this.position = position;
        this.properties = properties;
        this.hasProperties = properties != null;
        this.variation = variation;
        this.block = block;
        this.blockName = blockName;
    }

    public static DungeonModelBlock fromBlockState(BlockState state, DungeonModelBlockType type, Vector3i position) {
        Block block;
        ArrayList properties = Lists.newArrayList();
        for (Property property : state.func_235904_r_()) {
            properties.add(new PropertyHolder(property, state.func_177229_b(property)));
        }
        PropertyHolder[] blockProperties = properties.isEmpty() ? null : properties.toArray(new PropertyHolder[0]);
        Integer variation = null;
        ResourceLocation blockName = null;
        if (type == DungeonModelBlockType.CARPET) {
            List carpets = BlockTags.field_200028_e.func_230236_b_();
            int index = 0;
            for (Block carpet : carpets) {
                if (state.func_177230_c() == carpet) {
                    variation = index;
                    break;
                }
                ++index;
            }
            block = state.func_177230_c();
            blockName = state.func_177230_c().getRegistryName();
        } else if (type == DungeonModelBlockType.OTHER) {
            block = state.func_177230_c();
            blockName = state.func_177230_c().getRegistryName();
        } else {
            block = Blocks.field_201941_jj;
        }
        return new DungeonModelBlock(type, position, blockProperties, variation, block, blockName);
    }

    public CompoundNBT toNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("type", this.type.toString());
        CompoundNBT position = new CompoundNBT();
        position.func_74768_a("x", this.position.func_177958_n());
        position.func_74768_a("y", this.position.func_177956_o());
        position.func_74768_a("z", this.position.func_177952_p());
        tag.func_218657_a("position", (INBT)position);
        if (this.blockName != null) {
            tag.func_74778_a("resourceName", this.blockName.toString());
        }
        if (this.properties != null) {
            ListNBT properties = new ListNBT();
            for (PropertyHolder holder : this.properties) {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74778_a("property", holder.propertyName);
                nbt.func_74778_a("value", holder.valueName);
                properties.add((Object)nbt);
            }
            if (properties.size() > 0) {
                tag.func_218657_a("properties", (INBT)properties);
            }
        }
        if (this.variation != null) {
            tag.func_74768_a("variation", this.variation.intValue());
        }
        return tag;
    }

    public static DungeonModelBlock fromNBT(CompoundNBT nbt, Vector3i position) {
        Block block;
        String type;
        if (!nbt.func_74764_b("type")) {
            DungeonCrawl.LOGGER.warn("Model block does not have a type parameter");
            return null;
        }
        if (nbt.func_74764_b("position")) {
            CompoundNBT pos = nbt.func_74775_l("position");
            position = new Vector3i(pos.func_74762_e("x"), pos.func_74762_e("y"), pos.func_74762_e("z"));
        }
        if (!DungeonModelBlockType.NAME_TO_TYPE.containsKey((Object)(type = nbt.func_74779_i("type")))) {
            DungeonCrawl.LOGGER.warn("Unknown model block type: {}", (Object)type);
            return new DungeonModelBlock(DungeonModelBlockType.AIR, position);
        }
        DungeonModelBlockType blockType = (DungeonModelBlockType)((Object)DungeonModelBlockType.NAME_TO_TYPE.get((Object)type));
        ResourceLocation blockName = null;
        if (nbt.func_74764_b("resourceName")) {
            blockName = new ResourceLocation(nbt.func_74779_i("resourceName"));
            if (ForgeRegistries.BLOCKS.containsKey(blockName)) {
                block = (Block)ForgeRegistries.BLOCKS.getValue(blockName);
            } else {
                DungeonCrawl.LOGGER.warn("Unknown block: {}", (Object)blockName);
                block = Blocks.field_201941_jj;
            }
        } else {
            block = Blocks.field_201941_jj;
        }
        PropertyHolder[] properties = null;
        if (nbt.func_74764_b("properties")) {
            ListNBT nbtProperties = nbt.func_150295_c("properties", 10);
            properties = new PropertyHolder[nbtProperties.size()];
            for (int i = 0; i < nbtProperties.size(); ++i) {
                CompoundNBT data = (CompoundNBT)nbtProperties.get(i);
                properties[i] = new PropertyHolder(data.func_74779_i("property"), data.func_74779_i("value"));
            }
        }
        Integer variation = null;
        if (nbt.func_74764_b("variation")) {
            variation = nbt.func_74762_e("variation");
        }
        return new DungeonModelBlock(blockType, position, properties, variation, block, blockName);
    }

    public static DungeonModelBlock fromNBT(CompoundNBT nbt) {
        return DungeonModelBlock.fromNBT(nbt, null);
    }

    public BlockState create(BlockState state, IWorld world, BlockPos pos, Rotation rotation) {
        if (this.properties != null) {
            for (PropertyHolder holder : this.properties) {
                state = holder.apply(state);
            }
        }
        return state.rotate(world, pos, rotation);
    }

    public BlockState create(BlockState state) {
        if (this.properties != null) {
            for (PropertyHolder holder : this.properties) {
                state = holder.apply(state);
            }
        }
        return state;
    }

    public Block getBlock() {
        return this.block;
    }

    private static class PropertyHolder {
        public String propertyName;
        public String valueName;
        public Property<?> property;
        public Object value;

        public PropertyHolder(String propertyName, String valueName) {
            this.propertyName = propertyName;
            this.valueName = valueName;
        }

        public PropertyHolder(Property<?> property, Object value) {
            this.property = property;
            this.propertyName = property.func_177701_a();
            this.value = value;
            this.valueName = value.toString().toLowerCase(Locale.ROOT);
        }

        public <T extends Comparable<T>> BlockState apply(BlockState state) {
            if (this.property == null) {
                for (Property p : state.func_235904_r_()) {
                    if (!p.func_177701_a().equals(this.propertyName)) continue;
                    this.property = p;
                    Optional optional = p.func_185929_b(this.valueName);
                    if (optional.isPresent()) {
                        this.value = optional.get();
                        break;
                    }
                    DungeonCrawl.LOGGER.error("Couldn't parse property {} with value {}", (Object)p.func_177701_a(), (Object)this.valueName);
                    break;
                }
            }
            if (state.func_235901_b_(this.property)) {
                return (BlockState)state.func_206870_a(this.property, (Comparable)this.value);
            }
            return state;
        }
    }
}

