/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import com.google.common.collect.ImmutableMap;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.dungeon.block.DungeonBlocks;
import xiroc.dungeoncrawl.dungeon.block.provider.IBlockStateProvider;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlock;
import xiroc.dungeoncrawl.dungeon.model.ModelBlockDefinition;
import xiroc.dungeoncrawl.dungeon.model.PlacementBehaviour;
import xiroc.dungeoncrawl.theme.Theme;

public enum DungeonModelBlockType {
    AIR((block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> DungeonBlocks.CAVE_AIR),
    SOLID(DungeonModelBlockType.tFactory(Theme::getSolid), new TypeBuilder().expandable().placement(PlacementBehaviour.SOLID)),
    SOLID_STAIRS(DungeonModelBlockType.tFactory(Theme::getSolidStairs), new TypeBuilder().placement(PlacementBehaviour.SOLID)),
    SOLID_SLAB(DungeonModelBlockType.tFactory(Theme::getSolidSlab), new TypeBuilder().placement(PlacementBehaviour.SOLID)),
    GENERIC(DungeonModelBlockType.tFactory(Theme::getGeneric), new TypeBuilder().expandable()),
    GENERIC_OR_FENCING(DungeonModelBlockType.tFactory(Theme::getGeneric), new TypeBuilder().placement(PlacementBehaviour.NON_SOLID.withAirBlock((theme, secondaryTheme) -> theme.getFencing()))),
    SLAB(DungeonModelBlockType.tFactory(Theme::getSlab)),
    SOLID_PILLAR(DungeonModelBlockType.tFactory(Theme::getPillar), new TypeBuilder().expandable().pillar().placement(PlacementBehaviour.SOLID)),
    SOLID_FLOOR(DungeonModelBlockType.tFactory(Theme::getFloor), new TypeBuilder().expandable().placement(PlacementBehaviour.SOLID)),
    FENCING(DungeonModelBlockType.tFactory(Theme::getFencing)),
    FLOOR(DungeonModelBlockType.tFactory(Theme::getFloor), new TypeBuilder().placement(PlacementBehaviour.RANDOM_IF_SOLID_NEARBY)),
    FLUID(DungeonModelBlockType.tFactory(Theme::getFluid)),
    LOOSE_GROUND(DungeonModelBlockType.tFactory(Theme::getFloor)),
    STAIRS(DungeonModelBlockType.tFactory(Theme::getStairs)),
    WALL(DungeonModelBlockType.tFactory(Theme::getWall)),
    PILLAR(DungeonModelBlockType.sFactory(Theme.SecondaryTheme::getPillar), new TypeBuilder().expandable().pillar()),
    MATERIAL_STAIRS(DungeonModelBlockType.sFactory(Theme.SecondaryTheme::getStairs)),
    TRAPDOOR(DungeonModelBlockType.sFactory(Theme.SecondaryTheme::getTrapDoor)),
    DOOR(DungeonModelBlockType.sFactory(Theme.SecondaryTheme::getDoor)),
    FENCE(DungeonModelBlockType.sFactory(Theme.SecondaryTheme::getFence)),
    FENCE_GATE(DungeonModelBlockType.sFactory(Theme.SecondaryTheme::getFenceGate)),
    MATERIAL_SLAB(DungeonModelBlockType.sFactory(Theme.SecondaryTheme::getSlab)),
    MATERIAL_BUTTON(DungeonModelBlockType.sFactory(Theme.SecondaryTheme::getButton)),
    MATERIAL_PRESSURE_PLATE(DungeonModelBlockType.sFactory(Theme.SecondaryTheme::getPressurePlate)),
    MATERIAL(DungeonModelBlockType.sFactory(Theme.SecondaryTheme::getMaterial), new TypeBuilder().expandable()),
    CHEST((block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> block.create(Blocks.field_150486_ae.func_176223_P(), world, pos, rotation)),
    SKULL((block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> {
        BlockState state = block.create(Blocks.field_196703_eM.func_176223_P(), world, pos, rotation);
        if (state.func_235901_b_((Property)BlockStateProperties.field_208138_am)) {
            int r = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208138_am);
            int add = rand.nextInt(3);
            if (rand.nextBoolean()) {
                if ((r -= add) < 0) {
                    r += 16;
                }
            } else {
                r = (r + add) % 16;
            }
            state = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208138_am, (Comparable)Integer.valueOf(r));
            return state;
        }
        return state;
    }),
    CARPET((block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> {
        Block b;
        Block block2 = b = block.variation != null && variation != null ? DungeonBlocks.CARPET[(block.variation + variation[block.variation % variation.length]) % DungeonBlocks.CARPET.length] : (Block)ForgeRegistries.BLOCKS.getValue(block.blockName);
        if (b == null) {
            b = DungeonBlocks.CARPET[rand.nextInt(DungeonBlocks.CARPET.length)];
        }
        return block.create(b.func_176223_P());
    }),
    OTHER((block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> block.create(block.getBlock().func_176223_P(), world, pos, rotation));

    public static final ImmutableMap<String, DungeonModelBlockType> NAME_TO_TYPE;
    public final BlockFactory blockFactory;
    public final PlacementBehaviour placementBehavior;
    private final boolean isPillar;
    private final boolean expandable;

    private DungeonModelBlockType(BlockFactory blockFactory) {
        this(blockFactory, new TypeBuilder());
    }

    private DungeonModelBlockType(BlockFactory blockFactory, TypeBuilder typeBuilder) {
        this.blockFactory = blockFactory;
        this.placementBehavior = typeBuilder.placementBehaviour;
        this.isPillar = typeBuilder.isPillar;
        this.expandable = typeBuilder.expandable;
    }

    public boolean isPillar() {
        return this.isPillar;
    }

    public boolean isExpandable() {
        return this.expandable;
    }

    public static DungeonModelBlockType get(Block block, ModelBlockDefinition definition) {
        if (definition.containsBlock(block)) {
            return definition.getType(block);
        }
        if (definition.fallback != null && definition.fallback.containsBlock(block)) {
            return definition.fallback.getType(block);
        }
        if (BlockTags.field_200028_e.func_230235_a_((Object)block)) {
            return CARPET;
        }
        return OTHER;
    }

    private static BlockFactory tFactory(Function<Theme, IBlockStateProvider> blockSelector) {
        return (block, rotation, world, pos, theme, secondaryTheme, rand, variation, stage) -> block.create(((IBlockStateProvider)blockSelector.apply(theme)).get(world, pos, rotation), world, pos, rotation);
    }

    private static BlockFactory sFactory(Function<Theme.SecondaryTheme, IBlockStateProvider> blockSelector) {
        return (block, rotation, world, pos, theme, secondaryTheme, rand, variation, stage) -> block.create(((IBlockStateProvider)blockSelector.apply(secondaryTheme)).get(world, pos, rotation), world, pos, rotation);
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (DungeonModelBlockType type : DungeonModelBlockType.values()) {
            builder.put((Object)type.name(), (Object)type);
        }
        builder.put((Object)"NORMAL", (Object)GENERIC);
        builder.put((Object)"VANILLA_WALL", (Object)WALL);
        builder.put((Object)"WOODEN_BUTTON", (Object)MATERIAL_BUTTON);
        builder.put((Object)"WOODEN_SLAB", (Object)MATERIAL_SLAB);
        builder.put((Object)"WOODEN_PRESSURE_PLATE", (Object)MATERIAL_PRESSURE_PLATE);
        builder.put((Object)"NORMAL_2", (Object)AIR);
        builder.put((Object)"GENERIC_SECONDARY", (Object)AIR);
        builder.put((Object)"SPAWNER", (Object)AIR);
        builder.put((Object)"BARREL", (Object)AIR);
        NAME_TO_TYPE = builder.build();
    }

    private static class TypeBuilder {
        private PlacementBehaviour placementBehaviour = PlacementBehaviour.NON_SOLID;
        private boolean expandable = false;
        private boolean isPillar = false;

        private TypeBuilder() {
        }

        public TypeBuilder placement(@Nonnull PlacementBehaviour placementBehaviour) {
            this.placementBehaviour = placementBehaviour;
            return this;
        }

        public TypeBuilder expandable() {
            this.expandable = true;
            return this;
        }

        public TypeBuilder pillar() {
            this.isPillar = true;
            return this;
        }
    }

    @FunctionalInterface
    public static interface BlockFactory {
        public BlockState get(DungeonModelBlock var1, Rotation var2, IWorld var3, BlockPos var4, Theme var5, Theme.SecondaryTheme var6, Random var7, byte[] var8, int var9);
    }
}

