/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.piece;

import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.StructurePieceTypes;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.model.ModelSelector;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;

public class DungeonEntrance
extends DungeonPiece {
    public DungeonEntrance() {
        super(StructurePieceTypes.ENTRANCE);
    }

    public DungeonEntrance(TemplateManager manager, CompoundNBT nbt) {
        super(StructurePieceTypes.ENTRANCE, nbt);
    }

    @Override
    public void setupModel(DungeonBuilder builder, ModelSelector modelSelector, List<DungeonPiece> pieces, Random rand) {
    }

    public boolean func_230383_a_(ISeedReader worldIn, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
        int cursorHeight;
        if (this.model == null) {
            DungeonCrawl.LOGGER.warn("Missing model for {}", (Object)this);
            return true;
        }
        Heightmap.Type heightmapType = this.worldGen ? Heightmap.Type.WORLD_SURFACE_WG : Heightmap.Type.WORLD_SURFACE;
        int height = worldIn.func_201676_a(heightmapType, this.x + 4, this.z + 4);
        DungeonModel staircaseLayer = DungeonModels.KEY_TO_MODEL.get(DungeonModels.STAIRCASE_LAYER);
        Rotation layerRotation = Rotation.NONE;
        for (cursorHeight = this.y; cursorHeight < height; ++cursorHeight) {
            this.buildRotated(staircaseLayer, (IWorld)worldIn, structureBoundingBoxIn, new BlockPos(this.x + 2, cursorHeight, this.z + 2), this.theme, this.secondaryTheme, this.stage, layerRotation, this.worldGen, true, false);
            layerRotation = layerRotation.func_185830_a(Rotation.CLOCKWISE_90);
        }
        BlockPos pos = new BlockPos(this.x + 4, cursorHeight, this.z + 4).func_177971_a(DungeonEntrance.rotatedOffset(this.model.getOffset(), layerRotation, this.model));
        this.buildRotated(this.model, (IWorld)worldIn, structureBoundingBoxIn, pos, this.theme, this.secondaryTheme, this.stage, layerRotation, this.worldGen, true, true);
        this.placeFeatures((IWorld)worldIn, structureBoundingBoxIn, this.theme, this.secondaryTheme, randomIn, this.stage, this.worldGen);
        MutableBoundingBox populationBox = this.model.createBoundingBox(pos, this.field_186169_c);
        this.decorate((IWorld)worldIn, pos, this.model.width, this.model.height, this.model.length, this.theme, structureBoundingBoxIn, populationBox, this.model, this.worldGen);
        return true;
    }

    private static Vector3i rotatedOffset(Vector3i offset, Rotation rotation, DungeonModel model) {
        switch (rotation) {
            case CLOCKWISE_90: {
                return new Vector3i(-model.length - offset.func_177952_p() + 1, offset.func_177956_o(), offset.func_177958_n());
            }
            case CLOCKWISE_180: {
                return new Vector3i(-model.width - offset.func_177958_n() + 1, offset.func_177956_o(), -model.length - offset.func_177952_p() + 1);
            }
            case COUNTERCLOCKWISE_90: {
                return new Vector3i(offset.func_177952_p(), offset.func_177956_o(), -model.width - offset.func_177958_n() + 1);
            }
        }
        return offset;
    }

    @Override
    public void createBoundingBox() {
        if (this.model != null) {
            Vector3i offset = this.model.getOffset(this.field_186169_c);
            int x = this.x + 4 + offset.func_177958_n();
            int z = this.z + 4 + offset.func_177952_p();
            switch (this.field_186169_c) {
                case CLOCKWISE_180: 
                case NONE: {
                    this.field_74887_e = new MutableBoundingBox(x, 0, z, x + this.model.width - 1, 256, z + this.model.length - 1);
                    break;
                }
                case CLOCKWISE_90: 
                case COUNTERCLOCKWISE_90: {
                    this.field_74887_e = new MutableBoundingBox(x, 0, z, x + this.model.length - 1, 256, z + this.model.width - 1);
                    break;
                }
                default: {
                    DungeonCrawl.LOGGER.warn("Unknown entrance rotation: {}", (Object)this.field_186169_c);
                    this.field_74887_e = new MutableBoundingBox(x, 0, z, x + this.model.width - 1, 256, z + this.model.length - 1);
                }
            }
        }
    }

    @Override
    public int getDungeonPieceType() {
        return 6;
    }

    @Override
    public void func_143011_b(CompoundNBT tagCompound) {
        super.func_143011_b(tagCompound);
    }
}

