/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.piece.room;

import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.DungeonType;
import xiroc.dungeoncrawl.dungeon.StructurePieceTypes;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.model.ModelSelector;
import xiroc.dungeoncrawl.dungeon.piece.DungeonNodeConnector;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.util.Orientation;

public class DungeonNodeRoom
extends DungeonPiece {
    public boolean lootRoom;

    public DungeonNodeRoom() {
        super(StructurePieceTypes.NODE_ROOM);
    }

    public DungeonNodeRoom(TemplateManager manager, CompoundNBT nbt) {
        super(StructurePieceTypes.NODE_ROOM, nbt);
        this.lootRoom = nbt.func_74767_n("lootRoom");
        this.createBoundingBox();
    }

    @Override
    public void setupModel(DungeonBuilder builder, ModelSelector modelSelector, List<DungeonPiece> pieces, Random rand) {
        if (this.lootRoom) {
            this.model = DungeonModels.KEY_TO_MODEL.get(DungeonModels.LOOT_ROOM);
            return;
        }
        switch (this.connectedSides) {
            case 1: {
                this.model = modelSelector.deadEndNodes.roll(rand);
                break;
            }
            case 2: {
                if (this.sides[0] && this.sides[2] || this.sides[1] && this.sides[3]) {
                    this.model = modelSelector.straightNodes.roll(rand);
                    break;
                }
                this.model = modelSelector.turnNodes.roll(rand);
                break;
            }
            case 3: {
                this.model = modelSelector.forkNodes.roll(rand);
                break;
            }
            default: {
                this.model = modelSelector.fullNodes.roll(rand);
            }
        }
    }

    @Override
    public void setWorldPosition(int x, int y, int z) {
        super.setWorldPosition(x - 4, y, z - 4);
    }

    public boolean func_230383_a_(ISeedReader worldIn, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
        if (this.model == null) {
            DungeonCrawl.LOGGER.warn("Missing model for  {}", (Object)this);
            return true;
        }
        Vector3i offset = this.model.getOffset(this.field_186169_c);
        BlockPos pos = new BlockPos(this.x, this.y, this.z).func_177971_a(offset);
        this.buildRotated(this.model, (IWorld)worldIn, structureBoundingBoxIn, pos, this.theme, this.secondaryTheme, this.stage, this.field_186169_c, this.worldGen, false, false);
        this.entrances((IWorld)worldIn, structureBoundingBoxIn, this.model, this.worldGen);
        this.placeFeatures((IWorld)worldIn, structureBoundingBoxIn, this.theme, this.secondaryTheme, randomIn, this.stage, this.worldGen);
        this.decorate((IWorld)worldIn, pos, this.model.width, this.model.height, this.model.length, this.theme, structureBoundingBoxIn, this.field_74887_e, this.model, this.worldGen);
        return true;
    }

    @Override
    public int getDungeonPieceType() {
        return 10;
    }

    @Override
    public boolean canConnect(Direction side, int x, int z) {
        return x == this.gridPosition.x || z == this.gridPosition.z;
    }

    @Override
    public boolean hasChildPieces() {
        return true;
    }

    @Override
    public void addChildPieces(List<DungeonPiece> pieces, DungeonBuilder builder, DungeonType type, ModelSelector modelSelector, int layer, Random rand) {
        DungeonNodeConnector connector;
        super.addChildPieces(pieces, builder, type, modelSelector, layer, rand);
        if (this.sides[0]) {
            connector = new DungeonNodeConnector();
            connector.field_186169_c = Orientation.getOppositeRotationFromFacing(Direction.NORTH);
            connector.theme = this.theme;
            connector.secondaryTheme = this.secondaryTheme;
            connector.stage = this.stage;
            connector.setupModel(builder, modelSelector, pieces, rand);
            connector.setWorldPosition(this.x + 7, this.y, this.z - 5);
            connector.adjustPositionAndBounds();
            connector.customSetup(rand);
            pieces.add(connector);
        }
        if (this.sides[1]) {
            connector = new DungeonNodeConnector();
            connector.field_186169_c = Orientation.getOppositeRotationFromFacing(Direction.EAST);
            connector.theme = this.theme;
            connector.secondaryTheme = this.secondaryTheme;
            connector.stage = this.stage;
            connector.setupModel(builder, modelSelector, pieces, rand);
            connector.setWorldPosition(this.x + 17, this.y, this.z + 7);
            connector.adjustPositionAndBounds();
            connector.customSetup(rand);
            pieces.add(connector);
        }
        if (this.sides[2]) {
            connector = new DungeonNodeConnector();
            connector.field_186169_c = Orientation.getOppositeRotationFromFacing(Direction.SOUTH);
            connector.theme = this.theme;
            connector.secondaryTheme = this.secondaryTheme;
            connector.stage = this.stage;
            connector.setupModel(builder, modelSelector, pieces, rand);
            connector.setWorldPosition(this.x + 7, this.y, this.z + 17);
            connector.adjustPositionAndBounds();
            connector.customSetup(rand);
            pieces.add(connector);
        }
        if (this.sides[3]) {
            connector = new DungeonNodeConnector();
            connector.field_186169_c = Orientation.getOppositeRotationFromFacing(Direction.WEST);
            connector.theme = this.theme;
            connector.secondaryTheme = this.secondaryTheme;
            connector.stage = this.stage;
            connector.setupModel(builder, modelSelector, pieces, rand);
            connector.setWorldPosition(this.x - 5, this.y, this.z + 7);
            connector.adjustPositionAndBounds();
            connector.customSetup(rand);
            pieces.add(connector);
        }
    }

    @Override
    public void func_143011_b(CompoundNBT tagCompound) {
        super.func_143011_b(tagCompound);
        tagCompound.func_74757_a("lootRoom", this.lootRoom);
    }
}

