/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import com.mojang.datafixers.Dynamic;
import java.util.Locale;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.DungeonPieces;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelRegistry;

public class Dungeon
extends Structure<NoFeatureConfig> {
    public static final String NAME = "DCDungeon";
    public static final Dungeon DUNGEON = new Dungeon(NoFeatureConfig::func_214639_a);
    public static final Structure<NoFeatureConfig> DUNGEON_FEATURE = Dungeon.registerFeature("DCDungeon".toLowerCase(Locale.ROOT), DUNGEON);
    public static final Structure<?> DUNGEON_STRUCTURE = Dungeon.registerStructure("DCDungeon", DUNGEON_FEATURE);
    public static final IStructurePieceType ENTRANCE_BUILDER = IStructurePieceType.func_214750_a(DungeonPieces.EntranceBuilder::new, (String)"DUNGEON_ENTR_BLDR");
    public static final IStructurePieceType ROOM = IStructurePieceType.func_214750_a(DungeonPieces.Room::new, (String)"DUNGEON_ROOM");
    public static final IStructurePieceType CORRIDOR = IStructurePieceType.func_214750_a(DungeonPieces.Corridor::new, (String)"DUNGEON_CRRDR");
    public static final IStructurePieceType STAIRSTOP = IStructurePieceType.func_214750_a(DungeonPieces.StairsTop::new, (String)"DUNGEON_STTP");
    public static final IStructurePieceType STAIRS = IStructurePieceType.func_214750_a(DungeonPieces.Stairs::new, (String)"DUNGEON_STRS");
    public static final IStructurePieceType STAIRSBOT = IStructurePieceType.func_214750_a(DungeonPieces.StairsBot::new, (String)"DUNGEON_STBT");
    public static final IStructurePieceType HOLE = IStructurePieceType.func_214750_a(DungeonPieces.Hole::new, (String)"DUNGEON_HOLE");
    public static final IStructurePieceType CORRIDOR_ROOM = IStructurePieceType.func_214750_a(DungeonPieces.CorridorRoom::new, (String)"DUNGEON_CRRDR_ROOM");
    public static final IStructurePieceType CORRIDOR_TRAP = IStructurePieceType.func_214750_a(DungeonPieces.CorridorTrap::new, (String)"DUNGEON_TRAP");

    public Dungeon(Function<Dynamic<?>, ? extends NoFeatureConfig> p_i51427_1_) {
        super(p_i51427_1_);
    }

    public boolean func_202372_a(ChunkGenerator<?> chunkGen, Random rand, int chunkPosX, int chunkPosZ) {
        if (chunkPosX % 12 == 0 && chunkPosZ % 12 == 0) {
            for (Biome biome : chunkGen.func_202090_b().func_201538_a(chunkPosX * 16 + 64, chunkPosZ * 16 + 64, 128)) {
                if (chunkGen.func_202094_a(biome, DUNGEON_FEATURE)) continue;
                return false;
            }
            return rand.nextDouble() < 0.25;
        }
        return false;
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    public String func_143025_a() {
        return NAME;
    }

    public int func_202367_b() {
        return 8;
    }

    public static <C extends IFeatureConfig, F extends Feature<C>> F registerFeature(String key, F value) {
        return (F)((Feature)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)key, value));
    }

    public static Structure<?> registerStructure(String key, Structure<?> p_215141_1_) {
        return (Structure)Registry.func_218325_a((Registry)Registry.field_218361_B, (String)key.toLowerCase(Locale.ROOT), p_215141_1_);
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> p_i51341_1_, int chunkX, int chunkZ, Biome biomeIn, MutableBoundingBox boundsIn, int referenceIn, long seed) {
            super(p_i51341_1_, chunkX, chunkZ, biomeIn, boundsIn, referenceIn, seed);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn) {
            ChunkPos chunkpos = new ChunkPos(chunkX, chunkZ);
            long now = System.currentTimeMillis();
            DungeonBuilder builder = new DungeonBuilder(generator, chunkpos, (Random)this.field_214631_d);
            this.field_75075_a.addAll(builder.build());
            this.func_202500_a();
            DungeonCrawl.LOGGER.info("Built dungeon logic for [" + chunkX + ", " + chunkZ + "](" + (System.currentTimeMillis() - now) + " ms) (" + this.field_75075_a.size() + " pieces)");
        }

        public void func_75068_a(IWorld worldIn, Random rand, MutableBoundingBox structurebb, ChunkPos pos) {
            DungeonSegmentModelRegistry.load((IResourceManager)((ServerWorld)worldIn.func_201672_e()).func_73046_m().func_195570_aG());
            super.func_75068_a(worldIn, rand, structurebb, pos);
        }
    }
}

