/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlockType;

public class DungeonModelBlock {
    public final DungeonModelBlockType type;
    public Vec3i position;
    @Nullable
    private final PropertyHolder[] properties;
    public final boolean hasProperties;
    @Nullable
    public final Integer variation;
    public final Block block;
    @Nullable
    public final ResourceLocation blockName;
    @Nullable
    public ResourceLocation lootTable;

    private DungeonModelBlock(DungeonModelBlockType type, Vec3i position) {
        this(type, position, null, null, Blocks.f_50627_, null);
    }

    private DungeonModelBlock(DungeonModelBlockType type, Vec3i position, @Nullable PropertyHolder[] properties, @Nullable Integer variation, Block block, @Nullable ResourceLocation blockName) {
        this.type = type;
        this.position = position;
        this.properties = properties;
        this.hasProperties = properties != null;
        this.variation = variation;
        this.block = block;
        this.blockName = blockName;
    }

    public static DungeonModelBlock fromBlockState(BlockState state, DungeonModelBlockType type, Vec3i position) {
        Block block;
        ArrayList properties = Lists.newArrayList();
        for (Property property : state.m_61147_()) {
            properties.add(new PropertyHolder(property, state.m_61143_(property)));
        }
        PropertyHolder[] blockProperties = properties.isEmpty() ? null : properties.toArray(new PropertyHolder[0]);
        Integer variation = null;
        ResourceLocation blockName = null;
        if (type == DungeonModelBlockType.CARPET) {
            variation = 0;
            block = state.m_60734_();
            blockName = state.m_60734_().getRegistryName();
        } else if (type == DungeonModelBlockType.OTHER) {
            block = state.m_60734_();
            blockName = state.m_60734_().getRegistryName();
        } else {
            block = Blocks.f_50627_;
        }
        return new DungeonModelBlock(type, position, blockProperties, variation, block, blockName);
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("type", this.type.toString());
        CompoundTag position = new CompoundTag();
        position.m_128405_("x", this.position.m_123341_());
        position.m_128405_("y", this.position.m_123342_());
        position.m_128405_("z", this.position.m_123343_());
        tag.m_128365_("position", (Tag)position);
        if (this.blockName != null) {
            tag.m_128359_("resourceName", this.blockName.toString());
        }
        if (this.properties != null) {
            ListTag properties = new ListTag();
            for (PropertyHolder holder : this.properties) {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128359_("property", holder.propertyName);
                nbt.m_128359_("value", holder.valueName);
                properties.add((Object)nbt);
            }
            if (properties.size() > 0) {
                tag.m_128365_("properties", (Tag)properties);
            }
        }
        if (this.variation != null) {
            tag.m_128405_("variation", this.variation.intValue());
        }
        return tag;
    }

    public static DungeonModelBlock fromNBT(CompoundTag nbt, Vec3i position) {
        Block block;
        String type;
        if (!nbt.m_128441_("type")) {
            DungeonCrawl.LOGGER.info("Model block does not have a type parameter");
            return new DungeonModelBlock(DungeonModelBlockType.AIR, position);
        }
        if (nbt.m_128441_("position")) {
            CompoundTag pos = nbt.m_128469_("position");
            position = new Vec3i(pos.m_128451_("x"), pos.m_128451_("y"), pos.m_128451_("z"));
        }
        if (!DungeonModelBlockType.NAME_TO_TYPE.containsKey((Object)(type = nbt.m_128461_("type")))) {
            DungeonCrawl.LOGGER.warn("Unknown model block type: {}", (Object)type);
            return new DungeonModelBlock(DungeonModelBlockType.AIR, position);
        }
        DungeonModelBlockType blockType = (DungeonModelBlockType)((Object)DungeonModelBlockType.NAME_TO_TYPE.get((Object)type));
        ResourceLocation blockName = null;
        if (nbt.m_128441_("resourceName")) {
            blockName = new ResourceLocation(nbt.m_128461_("resourceName"));
            if (ForgeRegistries.BLOCKS.containsKey(blockName)) {
                block = (Block)ForgeRegistries.BLOCKS.getValue(blockName);
            } else {
                DungeonCrawl.LOGGER.warn("Unknown block: {}", (Object)blockName);
                block = Blocks.f_50627_;
            }
        } else {
            block = Blocks.f_50627_;
        }
        PropertyHolder[] properties = null;
        if (nbt.m_128441_("properties")) {
            ListTag nbtProperties = nbt.m_128437_("properties", 10);
            properties = new PropertyHolder[nbtProperties.size()];
            for (int i = 0; i < nbtProperties.size(); ++i) {
                CompoundTag data = (CompoundTag)nbtProperties.get(i);
                properties[i] = new PropertyHolder(data.m_128461_("property"), data.m_128461_("value"));
            }
        }
        Integer variation = null;
        if (nbt.m_128441_("variation")) {
            variation = nbt.m_128451_("variation");
        }
        return new DungeonModelBlock(blockType, position, properties, variation, block, blockName);
    }

    public static DungeonModelBlock fromNBT(CompoundTag nbt) {
        return DungeonModelBlock.fromNBT(nbt, null);
    }

    public BlockPos worldPos(DungeonModel model, Rotation rotation, BlockPos offset) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_90 -> new BlockPos(offset.m_123341_() + model.length - this.position.m_123343_() - 1, offset.m_123342_() + this.position.m_123342_(), offset.m_123343_() + this.position.m_123341_());
            case Rotation.COUNTERCLOCKWISE_90 -> new BlockPos(offset.m_123341_() + this.position.m_123343_(), offset.m_123342_() + this.position.m_123342_(), offset.m_123343_() + model.width - this.position.m_123341_() - 1);
            case Rotation.CLOCKWISE_180 -> new BlockPos(offset.m_123341_() + model.width - this.position.m_123341_() - 1, offset.m_123342_() + this.position.m_123342_(), offset.m_123343_() + model.length - this.position.m_123343_() - 1);
            default -> offset.m_141952_(this.position);
        };
    }

    public BlockState create(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation) {
        if (this.properties != null) {
            for (PropertyHolder holder : this.properties) {
                state = holder.apply(state);
            }
        }
        return state.rotate(world, pos, rotation);
    }

    public BlockState create(BlockState state) {
        if (this.properties != null) {
            for (PropertyHolder holder : this.properties) {
                state = holder.apply(state);
            }
        }
        return state;
    }

    public Block getBlock() {
        return this.block;
    }

    private static class PropertyHolder {
        public String propertyName;
        public String valueName;
        public Property<?> property;
        public Object value;

        public PropertyHolder(String propertyName, String valueName) {
            this.propertyName = propertyName;
            this.valueName = valueName;
        }

        public PropertyHolder(Property<?> property, Object value) {
            this.property = property;
            this.propertyName = property.m_61708_();
            this.value = value;
            this.valueName = value.toString().toLowerCase(Locale.ROOT);
        }

        public <T extends Comparable<T>> BlockState apply(BlockState state) {
            if (this.property == null) {
                for (Property p : state.m_61147_()) {
                    if (!p.m_61708_().equals(this.propertyName)) continue;
                    this.property = p;
                    Optional optional = p.m_6215_(this.valueName);
                    if (optional.isPresent()) {
                        this.value = optional.get();
                        break;
                    }
                    DungeonCrawl.LOGGER.error("Couldn't parse property {} with value {}", (Object)p.m_61708_(), (Object)this.valueName);
                    break;
                }
            }
            if (state.m_61138_(this.property)) {
                return (BlockState)state.m_61124_(this.property, (Comparable)this.value);
            }
            return state;
        }
    }
}

