/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.FluidState;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.block.DungeonBlocks;
import xiroc.dungeoncrawl.dungeon.block.provider.BlockStateProvider;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.treasure.Loot;
import xiroc.dungeoncrawl.exception.DatapackLoadException;
import xiroc.dungeoncrawl.theme.SecondaryTheme;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.DirectionalBlockPos;
import xiroc.dungeoncrawl.util.IBlockPlacementHandler;
import xiroc.dungeoncrawl.util.JSONUtils;
import xiroc.dungeoncrawl.util.Range;

public final class DungeonModelFeature {
    private final Type type;
    private final Position[] positions;
    private final Range amount;
    @Nullable
    private final DungeonModelFeature followup;

    private DungeonModelFeature(Type type, Position[] positions, Range amount, @Nullable DungeonModelFeature followup) {
        this.type = type;
        this.positions = positions;
        this.amount = amount;
        this.followup = followup;
    }

    public void setup(DungeonModel model, int x, int y, int z, Rotation rotation, List<Instance> features, Random rand) {
        this.setup(model, x, y, z, rotation, features, Lists.newArrayList((Object[])this.positions), rand);
    }

    private void setup(DungeonModel model, int x, int y, int z, Rotation rotation, List<Instance> features, List<Position> positions, Random rand) {
        if (positions.isEmpty()) {
            return;
        }
        int count = this.amount.nextInt(rand);
        if (count >= positions.size()) {
            features.add(new Instance(this.type, (DirectionalBlockPos[])positions.stream().map(pos -> pos.worldPos(x, y, z, rotation, model)).toArray(DirectionalBlockPos[]::new)));
        } else {
            DirectionalBlockPos[] resultingPositions = new DirectionalBlockPos[count];
            for (int i = 0; i < count; ++i) {
                Position pos2 = positions.get(rand.nextInt(positions.size()));
                DirectionalBlockPos position = pos2.worldPos(x, y, z, rotation, model);
                positions.remove(pos2);
                resultingPositions[i] = position;
            }
            features.add(new Instance(this.type, resultingPositions));
        }
        if (this.followup != null && !positions.isEmpty()) {
            this.followup.setup(model, x, y, z, rotation, features, positions, rand);
        }
    }

    private static void placeChest(LevelAccessor world, BlockPos pos, BlockState chest, Theme theme, SecondaryTheme secondaryTheme, int lootLevel, Random rand) {
        world.m_7731_(pos, chest, 2);
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof RandomizableContainerBlockEntity) {
            RandomizableContainerBlockEntity randomizableContainerBlockEntity = (RandomizableContainerBlockEntity)tileEntity;
            Loot.setLoot(world, pos, randomizableContainerBlockEntity, Loot.getLootTable(lootLevel, rand), theme, secondaryTheme, rand);
        }
    }

    public static DungeonModelFeature fromJson(JsonObject object, ResourceLocation file) {
        return DungeonModelFeature.fromJson(object, file, null);
    }

    private static DungeonModelFeature fromJson(JsonObject object, ResourceLocation file, Position[] positions) {
        String type = object.get("type").getAsString();
        if (!Type.TYPES.containsKey((Object)type)) {
            throw new DatapackLoadException("Unknown feature type " + type + " in " + file);
        }
        if (positions == null) {
            JsonArray positionsArray = object.getAsJsonArray("positions");
            positions = new Position[positionsArray.size()];
            for (int i = 0; i < positions.length; ++i) {
                positions[i] = Position.fromJson(positionsArray.get(i).getAsJsonObject());
            }
        }
        JsonObject jsonAmount = object.getAsJsonObject("amount");
        Range amount = new Range(jsonAmount.get("min").getAsInt(), jsonAmount.get("max").getAsInt());
        DungeonModelFeature followUp = null;
        if (object.has("follow_up")) {
            followUp = DungeonModelFeature.fromJson(object.getAsJsonObject("follow_up"), file, positions);
        }
        return new DungeonModelFeature((Type)Type.TYPES.get((Object)type), positions, amount, followUp);
    }

    private static interface Type {
        public static final Type CHEST = new Type(){

            @Override
            public void place(LevelAccessor world, Random rand, BlockPos pos, Direction direction, BoundingBox bounds, Theme theme, SecondaryTheme secondaryTheme, int stage, boolean worldGen) {
                if (bounds.m_71051_((Vec3i)pos) && !DungeonBuilder.isBlockProtected(world, pos) && world.m_8055_(pos.m_7495_()).m_60815_()) {
                    DungeonModelFeature.placeChest(world, pos, (BlockState)DungeonBlocks.CHEST.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)direction), theme, secondaryTheme, stage, rand);
                }
            }

            @Override
            public String getName() {
                return "chest";
            }
        };
        public static final Type TNT_CHEST = new Type(){

            @Override
            public void place(LevelAccessor world, Random rand, BlockPos pos, Direction direction, BoundingBox bounds, Theme theme, SecondaryTheme secondaryTheme, int stage, boolean worldGen) {
                if (bounds.m_71051_((Vec3i)pos) && !DungeonBuilder.isBlockProtected(world, pos) && world.m_8055_(pos.m_7495_()).m_60815_()) {
                    DungeonModelFeature.placeChest(world, pos, (BlockState)DungeonBlocks.CHEST.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)direction), theme, secondaryTheme, stage, rand);
                    BlockPos down = pos.m_6625_(2);
                    if (!DungeonBuilder.isBlockProtected(world, down) && !world.m_46859_(down)) {
                        world.m_7731_(pos.m_6625_(2), Blocks.f_50077_.m_49966_(), 2);
                    }
                }
            }

            @Override
            public String getName() {
                return "tnt_chest";
            }
        };
        public static final Type SPAWNER = new Type(){

            @Override
            public void place(LevelAccessor world, Random rand, BlockPos pos, Direction direction, BoundingBox bounds, Theme theme, SecondaryTheme secondaryTheme, int stage, boolean worldGen) {
                if (bounds.m_71051_((Vec3i)pos) && !DungeonBuilder.isBlockProtected(world, pos) && world.m_8055_(pos.m_7495_()).m_60815_()) {
                    IBlockPlacementHandler.SPAWNER.place(world, DungeonBlocks.SPAWNER, pos, rand, theme, secondaryTheme, stage, worldGen);
                }
            }

            @Override
            public String getName() {
                return "spawner";
            }
        };
        public static final Type CEILING_SPAWNER = new Type(){

            @Override
            public void place(LevelAccessor world, Random rand, BlockPos pos, Direction direction, BoundingBox bounds, Theme theme, SecondaryTheme secondaryTheme, int stage, boolean worldGen) {
                if (bounds.m_71051_((Vec3i)pos) && !DungeonBuilder.isBlockProtected(world, pos) && world.m_8055_(pos.m_7494_()).m_60815_()) {
                    IBlockPlacementHandler.SPAWNER.place(world, DungeonBlocks.SPAWNER, pos, rand, theme, secondaryTheme, stage, worldGen);
                }
            }

            @Override
            public String getName() {
                return "ceiling_spawner";
            }
        };
        public static final Type SPAWNER_GRAVE = new Type(){

            @Override
            public void place(LevelAccessor world, Random rand, BlockPos pos, Direction direction, BoundingBox bounds, Theme theme, SecondaryTheme secondaryTheme, int stage, boolean worldGen) {
                BlockPos p;
                BlockPos spawner;
                if (bounds.m_71051_((Vec3i)pos) && !DungeonBuilder.isBlockProtected(world, pos) && world.m_8055_(pos.m_7495_()).m_60815_()) {
                    DungeonModelFeature.placeChest(world, pos, (BlockState)DungeonBlocks.CHEST.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)direction), theme, secondaryTheme, stage, rand);
                }
                if (bounds.m_71051_((Vec3i)(spawner = pos.m_142300_(direction))) && !DungeonBuilder.isBlockProtected(world, spawner) && world.m_8055_(spawner.m_7495_()).m_60815_()) {
                    IBlockPlacementHandler.SPAWNER.place(world, DungeonBlocks.SPAWNER, spawner, rand, theme, secondaryTheme, stage, worldGen);
                }
                if (bounds.m_71051_((Vec3i)(p = pos.m_5484_(direction, 2))) && world.m_8055_(p.m_7495_()).m_60815_()) {
                    world.m_7731_(p, Blocks.f_50333_.m_49966_(), 2);
                }
            }

            @Override
            public String getName() {
                return "spawner_grave";
            }
        };
        public static final Type EMPTY_GRAVE = new Type(){

            @Override
            public void place(LevelAccessor world, Random rand, BlockPos pos, Direction direction, BoundingBox bounds, Theme theme, SecondaryTheme secondaryTheme, int stage, boolean worldGen) {
                BlockPos position = pos.m_5484_(direction, 2);
                if (bounds.m_71051_((Vec3i)position) && world.m_8055_(position.m_7495_()).m_60815_()) {
                    world.m_7731_(position, Blocks.f_50333_.m_49966_(), 2);
                }
            }

            @Override
            public String getName() {
                return "empty_grave";
            }
        };
        public static final Type STAIRS = new Type(){

            @Override
            public void place(LevelAccessor world, Random rand, BlockPos pos, Direction direction, BoundingBox bounds, Theme theme, SecondaryTheme secondaryTheme, int stage, boolean worldGen) {
                if (direction.m_122434_() == Direction.Axis.Y) {
                    return;
                }
                Heightmap.Types heightMap = worldGen ? Heightmap.Types.WORLD_SURFACE_WG : Heightmap.Types.WORLD_SURFACE;
                for (int length = 0; length < 10; ++length) {
                    if (!bounds.m_71051_((Vec3i)pos)) continue;
                    int height = world.m_5452_(heightMap, pos).m_123342_();
                    if (height >= pos.m_123342_()) break;
                    while (height < pos.m_123342_()) {
                        BlockPos p = new BlockPos(pos.m_123341_(), height, pos.m_123343_());
                        world.m_7731_(p, theme.solid.get(world, p), 2);
                        ++height;
                    }
                    world.m_7731_(pos, (BlockState)theme.solidStairs.get(world, pos).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)direction.m_122424_()), 2);
                    pos = pos.m_142300_(direction).m_142300_(Direction.DOWN);
                }
            }

            @Override
            public String getName() {
                return "stairs";
            }
        };
        public static final Type SEWER_HOLE = new Type(){
            private final BlockStateProvider AIR_WATER = new BlockStateProvider(){

                @Override
                public BlockState get(LevelAccessor world, BlockPos pos, Rotation rotation) {
                    if (pos.m_123342_() > 8) {
                        return Blocks.f_50627_.m_49966_();
                    }
                    return Blocks.f_49990_.m_49966_();
                }

                @Override
                public JsonObject serialize() {
                    return null;
                }
            };
            private final BlockStateProvider AIR_LAVA = new BlockStateProvider(){

                @Override
                public BlockState get(LevelAccessor world, BlockPos pos, Rotation rotation) {
                    if (pos.m_123342_() > 8) {
                        return Blocks.f_50627_.m_49966_();
                    }
                    return Blocks.f_49991_.m_49966_();
                }

                @Override
                public JsonObject serialize() {
                    return null;
                }
            };

            @Override
            public void place(LevelAccessor world, Random rand, BlockPos pos, Direction direction, BoundingBox bounds, Theme theme, SecondaryTheme secondaryTheme, int stage, boolean worldGen) {
                BlockStateProvider inner = stage < 4 ? this.AIR_WATER : this.AIR_LAVA;
                this.buildDown(world, pos, bounds, inner);
                BlockPos east = pos.m_142126_();
                this.buildDown(world, east, bounds, inner);
                BlockPos west = pos.m_142125_();
                this.buildDown(world, west, bounds, inner);
                BlockPos north = pos.m_142127_();
                this.buildDown(world, north, bounds, inner);
                BlockPos south = pos.m_142128_();
                this.buildDown(world, pos.m_142128_(), bounds, inner);
                this.buildDown(world, east.m_142127_(), bounds, inner);
                this.buildDown(world, east.m_142128_(), bounds, inner);
                this.buildDown(world, west.m_142127_(), bounds, inner);
                this.buildDown(world, west.m_142128_(), bounds, inner);
                this.buildDown(world, east.m_142082_(1, -1, 0), bounds, theme.generic);
                this.buildDown(world, east.m_142082_(1, -1, -1), bounds, theme.generic);
                this.buildDown(world, east.m_142082_(1, -1, 1), bounds, theme.generic);
                this.buildDown(world, south.m_142082_(0, -1, 1), bounds, theme.generic);
                this.buildDown(world, south.m_142082_(1, -1, 1), bounds, theme.generic);
                this.buildDown(world, south.m_142082_(-1, -1, 1), bounds, theme.generic);
                this.buildDown(world, west.m_142082_(-1, -1, 0), bounds, theme.generic);
                this.buildDown(world, west.m_142082_(-1, -1, -1), bounds, theme.generic);
                this.buildDown(world, west.m_142082_(-1, -1, 1), bounds, theme.generic);
                this.buildDown(world, north.m_142082_(0, -1, -1), bounds, theme.generic);
                this.buildDown(world, north.m_142082_(1, -1, -1), bounds, theme.generic);
                this.buildDown(world, north.m_142082_(-1, -1, -1), bounds, theme.generic);
            }

            @Override
            public String getName() {
                return "sewer_hole";
            }

            private void buildDown(LevelAccessor world, BlockPos pos, BoundingBox bounds, BlockStateProvider blockStateProvider) {
                if (!bounds.m_71051_((Vec3i)pos)) {
                    return;
                }
                while (pos.m_123342_() > 0) {
                    if (!DungeonBuilder.isBlockProtected(world, pos) && !world.m_46859_(pos)) {
                        world.m_7731_(pos, blockStateProvider.get(world, pos), 2);
                        FluidState state = world.m_6425_(pos);
                        if (!state.m_76178_()) {
                            world.m_186469_(pos, state.m_76152_(), 0);
                        }
                    }
                    pos = pos.m_7495_();
                }
            }
        };
        public static final Type CROPS = new Type(){

            @Override
            public void place(LevelAccessor world, Random rand, BlockPos pos, Direction direction, BoundingBox bounds, Theme theme, SecondaryTheme secondaryTheme, int stage, boolean worldGen) {
                if (bounds.m_71051_((Vec3i)pos) && world.m_8055_(pos.m_7495_()).m_60734_() instanceof FarmBlock) {
                    Registry.f_122824_.m_203431_(BlockTags.f_13073_).flatMap(tag -> tag.m_203450_(rand)).ifPresent(cropBlock -> {
                        BlockState crop = ((Block)cropBlock.m_203334_()).m_49966_();
                        if (crop.m_61138_((Property)BlockStateProperties.f_61409_)) {
                            crop = (BlockState)crop.m_61124_((Property)BlockStateProperties.f_61409_, (Comparable)Integer.valueOf(4 + rand.nextInt(4)));
                        }
                        world.m_7731_(pos, crop, 2);
                    });
                }
            }

            @Override
            public String getName() {
                return "crops";
            }
        };
        public static final ImmutableMap<String, Type> TYPES = new ImmutableMap.Builder().put((Object)CHEST.getName(), (Object)CHEST).put((Object)TNT_CHEST.getName(), (Object)TNT_CHEST).put((Object)SPAWNER_GRAVE.getName(), (Object)SPAWNER_GRAVE).put((Object)EMPTY_GRAVE.getName(), (Object)EMPTY_GRAVE).put((Object)SPAWNER.getName(), (Object)SPAWNER).put((Object)CEILING_SPAWNER.getName(), (Object)CEILING_SPAWNER).put((Object)STAIRS.getName(), (Object)STAIRS).put((Object)SEWER_HOLE.getName(), (Object)SEWER_HOLE).put((Object)CROPS.getName(), (Object)CROPS).build();

        public void place(LevelAccessor var1, Random var2, BlockPos var3, Direction var4, BoundingBox var5, Theme var6, SecondaryTheme var7, int var8, boolean var9);

        public String getName();
    }

    private record Position(Vec3i position, Direction facing) {
        public static Position fromJson(JsonObject object) {
            Vec3i position = JSONUtils.getOffset(object);
            Direction facing = object.has("facing") ? Direction.valueOf((String)object.get("facing").getAsString().toUpperCase(Locale.ROOT)) : Direction.NORTH;
            return new Position(position, facing);
        }

        public DirectionalBlockPos worldPos(int x, int y, int z, Rotation rotation, DungeonModel model) {
            return switch (rotation) {
                case Rotation.CLOCKWISE_90 -> new DirectionalBlockPos(x + model.length - this.position.m_123343_() - 1, y + this.position.m_123342_(), z + this.position.m_123341_(), this.facing.m_122434_() != Direction.Axis.Y ? this.facing.m_122427_() : this.facing);
                case Rotation.CLOCKWISE_180 -> new DirectionalBlockPos(x + model.width - this.position.m_123341_() - 1, y + this.position.m_123342_(), z + model.length - this.position.m_123343_() - 1, this.facing.m_122434_() != Direction.Axis.Y ? this.facing.m_122424_() : this.facing);
                case Rotation.COUNTERCLOCKWISE_90 -> new DirectionalBlockPos(x + this.position.m_123343_(), y + this.position.m_123342_(), z + model.width - this.position.m_123341_() - 1, this.facing.m_122434_() != Direction.Axis.Y ? this.facing.m_122428_() : this.facing);
                default -> new DirectionalBlockPos(x + this.position.m_123341_(), y + this.position.m_123342_(), z + this.position.m_123343_(), this.facing);
            };
        }
    }

    public static class Instance {
        private final Type type;
        private final DirectionalBlockPos[] positions;

        private Instance(Type type, DirectionalBlockPos[] positions) {
            this.type = type;
            this.positions = positions;
        }

        public void place(LevelAccessor world, BoundingBox worldGenBounds, Random rand, Theme theme, SecondaryTheme secondaryTheme, int stage, boolean worldGen) {
            for (DirectionalBlockPos pos : this.positions) {
                this.type.place(world, rand, pos.position, pos.direction, worldGenBounds, theme, secondaryTheme, stage, worldGen);
            }
        }

        public static Instance read(CompoundTag nbt) {
            Type type = (Type)Type.TYPES.get((Object)nbt.m_128461_("type"));
            ListTag nbtPositions = nbt.m_128437_("positions", 10);
            DirectionalBlockPos[] positions = new DirectionalBlockPos[nbtPositions.size()];
            for (int i = 0; i < nbtPositions.size(); ++i) {
                positions[i] = DirectionalBlockPos.fromNBT(nbtPositions.m_128728_(i));
            }
            return new Instance(type, positions);
        }

        public void write(CompoundTag nbt) {
            nbt.m_128359_("type", this.type.getName());
            ListTag positions = new ListTag();
            for (DirectionalBlockPos position : this.positions) {
                CompoundTag pos = new CompoundTag();
                position.writeToNBT(pos);
                positions.add((Object)pos);
            }
            nbt.m_128365_("positions", (Tag)positions);
        }
    }
}

