/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.piece;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.PlacementConfiguration;
import xiroc.dungeoncrawl.dungeon.StructurePieceTypes;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.model.ModelSelector;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;

public class DungeonEntrance
extends DungeonPiece {
    public DungeonEntrance() {
        super(StructurePieceTypes.ENTRANCE);
    }

    public DungeonEntrance(CompoundTag nbt) {
        super(StructurePieceTypes.ENTRANCE, nbt);
    }

    @Override
    public void setupModel(DungeonBuilder builder, ModelSelector modelSelector, List<DungeonPiece> pieces, Random rand) {
    }

    public void m_183269_(WorldGenLevel worldIn, StructureFeatureManager p_230383_2_, ChunkGenerator p_230383_3_, Random randomIn, BoundingBox structureBoundingBoxIn, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
        int cursorHeight;
        if (this.model == null) {
            DungeonCrawl.LOGGER.warn("Missing model for {}", (Object)this);
            return;
        }
        Heightmap.Types heightmapType = this.worldGen ? Heightmap.Types.WORLD_SURFACE_WG : Heightmap.Types.WORLD_SURFACE;
        int height = Math.min(worldIn.m_6924_(heightmapType, this.x + 4, this.z + 4), worldIn.m_151558_() - this.model.height);
        DungeonModel staircaseLayer = DungeonModels.KEY_TO_MODEL.get(DungeonModels.STAIRCASE_LAYER);
        Rotation layerRotation = Rotation.NONE;
        for (cursorHeight = this.y; cursorHeight < height; ++cursorHeight) {
            this.buildModel(staircaseLayer, (LevelAccessor)worldIn, structureBoundingBoxIn, new BlockPos(this.x + 2, cursorHeight, this.z + 2), PlacementConfiguration.DEFAULT, this.theme, this.secondaryTheme, this.stage, layerRotation, this.worldGen, true, false);
            layerRotation = layerRotation.m_55952_(Rotation.CLOCKWISE_90);
        }
        BlockPos pos = new BlockPos(this.x + 4, cursorHeight, this.z + 4).m_141952_(DungeonEntrance.rotatedOffset(this.model.getOffset(), layerRotation, this.model));
        this.buildModel(this.model, (LevelAccessor)worldIn, structureBoundingBoxIn, pos, PlacementConfiguration.DEFAULT, this.theme, this.secondaryTheme, this.stage, layerRotation, this.worldGen, true, true);
        this.placeFeatures((LevelAccessor)worldIn, structureBoundingBoxIn, this.theme, this.secondaryTheme, randomIn, this.stage, this.worldGen);
        BoundingBox populationBox = this.model.createBoundingBox(pos, layerRotation);
        this.decorate((LevelAccessor)worldIn, pos, this.model.width, this.model.height, this.model.length, this.theme, structureBoundingBoxIn, populationBox, this.model, this.worldGen);
    }

    private static Vec3i rotatedOffset(Vec3i offset, Rotation rotation, DungeonModel model) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_90 -> new Vec3i(-model.length - offset.m_123343_() + 1, offset.m_123342_(), offset.m_123341_());
            case Rotation.CLOCKWISE_180 -> new Vec3i(-model.width - offset.m_123341_() + 1, offset.m_123342_(), -model.length - offset.m_123343_() + 1);
            case Rotation.COUNTERCLOCKWISE_90 -> new Vec3i(offset.m_123343_(), offset.m_123342_(), -model.width - offset.m_123341_() + 1);
            default -> offset;
        };
    }

    @Override
    public void createBoundingBox() {
        if (this.model != null) {
            Vec3i defaultOffset = this.model.getOffset();
            Vec3i clockwise90 = DungeonEntrance.rotatedOffset(defaultOffset, Rotation.CLOCKWISE_90, this.model);
            Vec3i clockwise180 = DungeonEntrance.rotatedOffset(defaultOffset, Rotation.CLOCKWISE_180, this.model);
            Vec3i counterClockwise90 = DungeonEntrance.rotatedOffset(defaultOffset, Rotation.COUNTERCLOCKWISE_90, this.model);
            int minOffsetX = Math.min(Math.min(defaultOffset.m_123341_(), clockwise90.m_123341_()), Math.min(clockwise180.m_123341_(), counterClockwise90.m_123341_()));
            int minOffsetZ = Math.min(Math.min(defaultOffset.m_123343_(), clockwise90.m_123343_()), Math.min(clockwise180.m_123343_(), counterClockwise90.m_123343_()));
            int x = this.x + 4 + minOffsetX;
            int z = this.z + 4 + minOffsetZ;
            this.f_73383_ = new BoundingBox(x, 0, z, x + Math.max(this.model.width, this.model.length) - 1, 512, z + Math.max(this.model.width, this.model.length) - 1);
        }
    }

    @Override
    public int getDungeonPieceType() {
        return 6;
    }
}

