/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.util;

import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Rotation;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.util.IRandom;

public class Orientation {
    private static final Direction[] FACINGS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.DOWN, Direction.UP};
    public static final IRandom<Direction> RANDOM_FACING = rand -> FACINGS[rand.nextInt(FACINGS.length)];
    public static final IRandom<Direction> RANDOM_HORIZONTAL_FACING = rand -> FACINGS[rand.nextInt(4)];
    public static final Direction[] HORIZONTAL_FACINGS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    public static final Direction[] EAST_SOUTH_WEST = new Direction[]{Direction.EAST, Direction.SOUTH, Direction.WEST};
    public static final Direction[] EAST_NORTH_WEST = new Direction[]{Direction.EAST, Direction.NORTH, Direction.WEST};
    public static final Direction[] NORTH_SOUTH_EAST = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST};
    public static final Direction[] NORTH_SOUTH_WEST = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST};

    public static Vec3i rotatedMultipartOffset(DungeonModel parent, DungeonModel multipart, Vec3i offset, Rotation parentRotation, Rotation fullRotation) {
        int ordinalBit = fullRotation.ordinal() & 1;
        switch (parentRotation) {
            case CLOCKWISE_90: {
                int multipartLength = ordinalBit == 0 ? multipart.width : multipart.length;
                return new Vec3i(parent.length - offset.m_123343_() - multipartLength, offset.m_123342_(), offset.m_123341_());
            }
            case CLOCKWISE_180: {
                int multipartWidth = ordinalBit == 1 ? multipart.length : multipart.width;
                int multipartLength = ordinalBit == 1 ? multipart.width : multipart.length;
                return new Vec3i(parent.width - offset.m_123341_() - multipartWidth, offset.m_123342_(), parent.length - offset.m_123343_() - multipartLength);
            }
            case COUNTERCLOCKWISE_90: {
                int multipartWidth = ordinalBit == 0 ? multipart.length : multipart.width;
                return new Vec3i(offset.m_123343_(), offset.m_123342_(), parent.width - offset.m_123341_() - multipartWidth);
            }
        }
        return offset;
    }

    public static Direction[] getHorizontalFacingsWithout(Direction excludedDirection) {
        switch (excludedDirection) {
            case NORTH: {
                return EAST_SOUTH_WEST;
            }
            case EAST: {
                return NORTH_SOUTH_WEST;
            }
            case SOUTH: {
                return EAST_NORTH_WEST;
            }
            case WEST: {
                return NORTH_SOUTH_EAST;
            }
        }
        throw new IllegalArgumentException(excludedDirection.name() + " is not a horizontal Direction.");
    }

    public static Rotation getOppositeRotation(Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_90: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
            case COUNTERCLOCKWISE_90: {
                return Rotation.CLOCKWISE_90;
            }
        }
        return rotation;
    }

    public static Rotation getRotationFromFacing(Direction facing) {
        switch (facing) {
            case NORTH: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
            case EAST: {
                return Rotation.NONE;
            }
            case SOUTH: {
                return Rotation.CLOCKWISE_90;
            }
            case WEST: {
                return Rotation.CLOCKWISE_180;
            }
        }
        return Rotation.NONE;
    }

    public static Rotation getOppositeRotationFromFacing(Direction facing) {
        switch (facing) {
            case NORTH: {
                return Rotation.CLOCKWISE_90;
            }
            case EAST: {
                return Rotation.CLOCKWISE_180;
            }
            case SOUTH: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
            case WEST: {
                return Rotation.NONE;
            }
        }
        return Rotation.NONE;
    }

    public static Rotation getRotationFromCW90DoubleFacing(Direction dir1, Direction dir2) {
        switch (dir1) {
            case WEST: {
                switch (dir2) {
                    case SOUTH: {
                        return Rotation.NONE;
                    }
                    case NORTH: {
                        return Rotation.CLOCKWISE_90;
                    }
                }
                return Rotation.NONE;
            }
            case NORTH: {
                switch (dir2) {
                    case WEST: {
                        return Rotation.CLOCKWISE_90;
                    }
                    case EAST: {
                        return Rotation.CLOCKWISE_180;
                    }
                }
                return Rotation.NONE;
            }
            case EAST: {
                switch (dir2) {
                    case NORTH: {
                        return Rotation.CLOCKWISE_180;
                    }
                    case SOUTH: {
                        return Rotation.COUNTERCLOCKWISE_90;
                    }
                }
                return Rotation.NONE;
            }
            case SOUTH: {
                switch (dir2) {
                    case WEST: {
                        return Rotation.NONE;
                    }
                    case EAST: {
                        return Rotation.COUNTERCLOCKWISE_90;
                    }
                }
                return Rotation.NONE;
            }
        }
        return Rotation.NONE;
    }

    public static Rotation getRotationFromTripleFacing(Direction dir1, Direction dir2, Direction dir3) {
        if (Orientation.containsAllThree(dir1, dir2, dir3, EAST_SOUTH_WEST)) {
            return Rotation.NONE;
        }
        if (Orientation.containsAllThree(dir1, dir2, dir3, EAST_NORTH_WEST)) {
            return Rotation.CLOCKWISE_180;
        }
        if (Orientation.containsAllThree(dir1, dir2, dir3, NORTH_SOUTH_EAST)) {
            return Rotation.COUNTERCLOCKWISE_90;
        }
        if (Orientation.containsAllThree(dir1, dir2, dir3, NORTH_SOUTH_WEST)) {
            return Rotation.CLOCKWISE_90;
        }
        return Rotation.NONE;
    }

    public static Rotation getRotation(int rotation) {
        switch (rotation) {
            case 0: {
                return Rotation.NONE;
            }
            case 1: {
                return Rotation.CLOCKWISE_90;
            }
            case 2: {
                return Rotation.CLOCKWISE_180;
            }
            case 3: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public static int rotationAsInt(Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return 2;
            }
            case CLOCKWISE_90: {
                return 1;
            }
            case COUNTERCLOCKWISE_90: {
                return 3;
            }
        }
        return 0;
    }

    public static boolean containsAllThree(Direction dir1, Direction dir2, Direction dir3, Direction[] directions) {
        boolean d1 = false;
        boolean d2 = false;
        boolean d3 = false;
        for (Direction d : directions) {
            if (d == dir1) {
                d1 = true;
                continue;
            }
            if (d == dir2) {
                d2 = true;
                continue;
            }
            if (d != dir3) continue;
            d3 = true;
        }
        return d1 && d2 && d3;
    }
}

