/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.config.JsonConfig;
import xiroc.dungeoncrawl.dungeon.Dungeon;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelBlock;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelRegistry;
import xiroc.dungeoncrawl.dungeon.treasure.Treasure;
import xiroc.dungeoncrawl.module.BOPCompatModule;
import xiroc.dungeoncrawl.module.ModuleManager;
import xiroc.dungeoncrawl.part.block.BlockRegistry;
import xiroc.dungeoncrawl.util.EventManager;
import xiroc.dungeoncrawl.util.IBlockPlacementHandler;

@Mod(value="dungeoncrawl")
public class DungeonCrawl {
    public static final String MODID = "dungeoncrawl";
    public static final String NAME = "Dungeon Crawl";
    public static final String VERSION = "1.6.0";
    public static final Logger LOGGER = LogManager.getLogger((String)"Dungeon Crawl");
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static IEventBus EVENT_BUS;

    public DungeonCrawl() {
        LOGGER.info("Here we go! Launching Dungeon Crawl {}...", (Object)VERSION);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new EventManager());
        ForgeRegistries.FEATURES.register(Dungeon.DUNGEON.setRegistryName(new ResourceLocation(Dungeon.NAME.toLowerCase())));
        Treasure.init();
        EVENT_BUS = (IEventBus)Mod.EventBusSubscriber.Bus.MOD.bus().get();
        ModuleManager.registerModule(new BOPCompatModule());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Common Setup");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.CONFIG);
        Config.load(FMLPaths.CONFIGDIR.get().resolve("dungeon_crawl.toml"));
        DungeonSegmentModelBlock.load();
        IBlockPlacementHandler.load();
        BlockRegistry.load();
        LOGGER.info("Adding features and structures");
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (JsonConfig.BIOME_BLACKLIST.contains(biome.getRegistryName().toString())) continue;
            LOGGER.debug("Biome >> " + biome.getRegistryName());
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new ConfiguredFeature((Feature)Dungeon.DUNGEON, (IFeatureConfig)NoFeatureConfig.field_202429_e));
            if (JsonConfig.BIOME_OVERWORLD_BLACKLIST.contains(biome.getRegistryName().toString())) continue;
            LOGGER.debug("Generation Biome >> " + biome.getRegistryName());
            biome.func_226711_a_(new ConfiguredFeature((Feature)Dungeon.DUNGEON, (IFeatureConfig)NoFeatureConfig.field_202429_e));
        }
        ModuleManager.load();
    }

    public static String getDate() {
        return new SimpleDateFormat().format(new Date());
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld().func_201670_d()) {
            return;
        }
        ServerWorld server = (ServerWorld)event.getWorld();
        DungeonSegmentModelRegistry.load((IResourceManager)server.func_73046_m().func_195570_aG());
    }

    public static ResourceLocation locate(String path) {
        return new ResourceLocation(MODID, path);
    }
}

