/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.monster;

import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.JsonConfig;
import xiroc.dungeoncrawl.dungeon.monster.ArmorSet;
import xiroc.dungeoncrawl.util.IRandom;

public class RandomEquipment {
    public static final int HIGHEST_STAGE = 2;
    public static final int[] ARMOR_COLORS = new int[]{11546150, 16701501, 3949738, 6192150, 16351261, 0xF9FFFE, 15961002, 0x1D1D21, 8439583, 4673362, 1481884, 8991416, 3847130};
    public static final IRandom<ItemStack> BOW = rand -> {
        ItemStack item = new ItemStack((IItemProvider)RandomEquipment.getItem(JsonConfig.BOWS[rand.nextInt(JsonConfig.BOWS.length)]));
        if (item.func_77973_b() == null) {
            return ItemStack.field_190927_a;
        }
        RandomEquipment.applyDamage(item, rand);
        return item;
    };
    public static final IRandom<ItemStack> SWORD = rand -> {
        ItemStack item = new ItemStack((IItemProvider)RandomEquipment.getItem((double)rand.nextFloat() < 0.05 ? JsonConfig.SWORDS_RARE[rand.nextInt(JsonConfig.SWORDS_RARE.length)] : JsonConfig.SWORDS[rand.nextInt(JsonConfig.SWORDS.length)]));
        if (item.func_77973_b() == null) {
            return ItemStack.field_190927_a;
        }
        RandomEquipment.applyDamage(item, rand);
        return item;
    };
    public static final IRandom<ItemStack> PICKAXE = rand -> {
        ItemStack item = new ItemStack((IItemProvider)RandomEquipment.getItem(JsonConfig.PICKAXES[rand.nextInt(JsonConfig.PICKAXES.length)]));
        if (item.func_77973_b() == null) {
            return ItemStack.field_190927_a;
        }
        RandomEquipment.applyDamage(item, rand);
        return item;
    };
    public static final IRandom<ItemStack> AXE = rand -> {
        ItemStack item = new ItemStack((IItemProvider)RandomEquipment.getItem(JsonConfig.AXES[rand.nextInt(JsonConfig.AXES.length)]));
        if (item.func_77973_b() == null) {
            return ItemStack.field_190927_a;
        }
        RandomEquipment.applyDamage(item, rand);
        return item;
    };
    public static final IRandom<ItemStack[]> ARMOR_1 = rand -> {
        ItemStack[] items = new ItemStack[4];
        ArmorSet armor = JsonConfig.ARMOR_SETS_1[rand.nextInt(JsonConfig.ARMOR_SETS_1.length)];
        for (int i = 0; i < 4; ++i) {
            if ((double)rand.nextFloat() < 0.5) {
                ItemStack item = new ItemStack((IItemProvider)RandomEquipment.getItem(armor.items[i]));
                if (item.func_77973_b() != null) {
                    RandomEquipment.enchantArmor(item, rand, 0.25);
                    RandomEquipment.applyDamage(item, rand);
                    if (JsonConfig.COLORED_ARMOR.contains(armor.items[i].toString())) {
                        RandomEquipment.setArmorColor(item, RandomEquipment.getRandomColor(rand));
                    }
                    items[i] = item;
                    continue;
                }
                items[i] = ItemStack.field_190927_a;
                continue;
            }
            items[i] = ItemStack.field_190927_a;
        }
        return items;
    };
    public static final IRandom<ItemStack[]> ARMOR_2 = rand -> {
        ItemStack[] items = new ItemStack[4];
        ArmorSet armor = JsonConfig.ARMOR_SETS_2[rand.nextInt(JsonConfig.ARMOR_SETS_2.length)];
        for (int i = 0; i < 4; ++i) {
            if ((double)rand.nextFloat() < 0.5) {
                ItemStack item = new ItemStack((IItemProvider)RandomEquipment.getItem(armor.items[i]));
                if (item.func_77973_b() != null) {
                    RandomEquipment.enchantArmor(item, rand, 0.5);
                    RandomEquipment.applyDamage(item, rand);
                    if (JsonConfig.COLORED_ARMOR.contains(armor.items[i].toString())) {
                        RandomEquipment.setArmorColor(item, RandomEquipment.getRandomColor(rand));
                    }
                    items[i] = item;
                    continue;
                }
                items[i] = ItemStack.field_190927_a;
                continue;
            }
            items[i] = ItemStack.field_190927_a;
        }
        return items;
    };
    public static final IRandom<ItemStack[]> ARMOR_3 = rand -> {
        ItemStack[] items = new ItemStack[4];
        ArmorSet armor = (double)rand.nextFloat() < 0.05 ? JsonConfig.ARMOR_SETS_RARE[rand.nextInt(JsonConfig.ARMOR_SETS_RARE.length)] : JsonConfig.ARMOR_SETS_3[rand.nextInt(JsonConfig.ARMOR_SETS_3.length)];
        for (int i = 0; i < 4; ++i) {
            if ((double)rand.nextFloat() < 0.5) {
                ItemStack item = new ItemStack((IItemProvider)RandomEquipment.getItem(armor.items[i]));
                if (item.func_77973_b() != null) {
                    RandomEquipment.enchantArmor(item, rand, 1.0);
                    RandomEquipment.applyDamage(item, rand);
                    if (JsonConfig.COLORED_ARMOR.contains(armor.items[i].toString())) {
                        RandomEquipment.setArmorColor(item, RandomEquipment.getRandomColor(rand));
                    }
                    items[i] = item;
                    continue;
                }
                items[i] = ItemStack.field_190927_a;
                continue;
            }
            items[i] = ItemStack.field_190927_a;
        }
        return items;
    };

    public static void applyDamage(ItemStack item, Random rand) {
        if (item.func_77984_f()) {
            item.func_196085_b(rand.nextInt(item.func_77958_k()));
        }
    }

    public static ItemStack enchantItem(ItemStack item, Random rand, Enchantment enchantment, double multiplier) {
        int maxLevel;
        int minLevel = enchantment.func_77319_d();
        item.func_77966_a(enchantment, minLevel < (maxLevel = (int)((double)enchantment.func_77325_b() * multiplier)) ? minLevel + rand.nextInt(maxLevel - minLevel) : minLevel);
        return item;
    }

    public static ItemStack enchantItem(ItemStack item, Enchantment enchantment, double multiplier) {
        int level = (int)((double)enchantment.func_77325_b() * multiplier);
        if (level < 1) {
            level = 1;
        }
        item.func_77966_a(enchantment, level);
        return item;
    }

    public static ItemStack enchantBow(ItemStack item, Random rand, double multiplier) {
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(JsonConfig.BOW_ENCHANTMENTS[rand.nextInt(JsonConfig.BOW_ENCHANTMENTS.length)]);
        RandomEquipment.enchantItem(item, rand, enchantment, multiplier);
        return item;
    }

    public static ItemStack enchantArmor(ItemStack item, Random rand, double multiplier) {
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(JsonConfig.ARMOR_ENCHANTMENTS[rand.nextInt(JsonConfig.ARMOR_ENCHANTMENTS.length)]);
        RandomEquipment.enchantItem(item, rand, enchantment, multiplier);
        return item;
    }

    public static ItemStack enchantSword(ItemStack item, Random rand, double multiplier) {
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(JsonConfig.SWORD_ENCHANTMENTS[rand.nextInt(JsonConfig.SWORD_ENCHANTMENTS.length)]);
        RandomEquipment.enchantItem(item, rand, enchantment, multiplier);
        return item;
    }

    public static ItemStack enchantPickaxe(ItemStack item, Random rand, double multiplier) {
        RandomEquipment.enchantSword(item, rand, multiplier);
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(JsonConfig.PICKAXE_ENCHANTMENTS[rand.nextInt(JsonConfig.PICKAXE_ENCHANTMENTS.length)]);
        RandomEquipment.enchantItem(item, rand, enchantment, multiplier);
        return item;
    }

    public static ItemStack enchantAxe(ItemStack item, Random rand, double multiplier) {
        RandomEquipment.enchantSword(item, rand, multiplier);
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(JsonConfig.AXE_ENCHANTMENTS[rand.nextInt(JsonConfig.AXE_ENCHANTMENTS.length)]);
        RandomEquipment.enchantItem(item, rand, enchantment, multiplier);
        return item;
    }

    public static ItemStack setArmorColor(ItemStack item, int color) {
        INBT displayNBT;
        CompoundNBT tag = item.func_77978_p();
        if (tag == null) {
            tag = new CompoundNBT();
        }
        CompoundNBT display = (displayNBT = tag.func_74781_a("display")) == null ? new CompoundNBT() : (CompoundNBT)displayNBT;
        display.func_74768_a("color", color);
        tag.func_218657_a("display", (INBT)display);
        item.func_77982_d(tag);
        return item;
    }

    public static ItemStack getMeleeWeapon(Random rand, int stage) {
        switch (rand.nextInt(3)) {
            case 0: {
                return RandomEquipment.enchantSword(SWORD.roll(rand), rand, RandomEquipment.getStageMultiplier(stage));
            }
            case 1: {
                return RandomEquipment.enchantPickaxe(PICKAXE.roll(rand), rand, RandomEquipment.getStageMultiplier(stage));
            }
            case 2: {
                return RandomEquipment.enchantAxe(AXE.roll(rand), rand, RandomEquipment.getStageMultiplier(stage));
            }
        }
        return null;
    }

    public static ItemStack getRangedWeapon(Random rand, int stage) {
        return RandomEquipment.enchantBow(BOW.roll(rand), rand, RandomEquipment.getStageMultiplier(stage));
    }

    public static double getStageMultiplier(int stage) {
        if (stage > 2) {
            return 1.0;
        }
        return 1.0 * Math.pow(0.5, 2 - stage);
    }

    public static int getRandomColor(Random rand) {
        return ARMOR_COLORS[rand.nextInt(ARMOR_COLORS.length)];
    }

    public static Item getItem(ResourceLocation resourceLocation) {
        if (ForgeRegistries.ITEMS.containsKey(resourceLocation)) {
            return (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
        }
        DungeonCrawl.LOGGER.warn("Failed to get {} from the item registry.", (Object)resourceLocation.toString());
        return null;
    }
}

