/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.module;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModuleManager {
    public static final Logger LOGGER = LogManager.getLogger((String)"Dungeon Crawl/Module Manager");
    private static final ArrayList<Module> MODULES = Lists.newArrayList();

    public static void load() {
        int size = MODULES.size();
        if (size <= 0) {
            return;
        }
        if (size == 1) {
            LOGGER.info("There is one module present");
        } else {
            LOGGER.info("There are {} modules present", (Object)size);
        }
        int successful = 0;
        int failed = 0;
        block0: for (Module module : MODULES) {
            for (String modId : module.requiredMods) {
                if (!ModList.get().isLoaded(modId)) continue block0;
            }
            LOGGER.info("Loading module {}", (Object)module.name);
            if (module.load()) {
                ++successful;
            } else {
                LOGGER.error("The module {} failed to load.", (Object)module.name);
                ++failed;
            }
            LOGGER.info("Successfully loaded {} , {} failed.", (Object)(successful + (size > 1 ? " Modules" : " Module")), (Object)failed);
        }
    }

    public static boolean registerModule(Module module) {
        return MODULES.add(module);
    }

    public static abstract class Module {
        public String name;
        public String[] requiredMods;
        public int version;

        public Module(ResourceLocation name, String ... requiredMods) {
            this.name = name.toString();
            this.requiredMods = requiredMods;
            this.version = 0;
        }

        public abstract boolean load();
    }
}

