/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.theme;

import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import xiroc.dungeoncrawl.part.block.BlockRegistry;
import xiroc.dungeoncrawl.util.IBlockStateProvider;

public class Theme {
    public static final Random RANDOM = new Random();
    public static HashMap<String, Integer> BIOME_TO_THEME_MAP;
    public static HashMap<String, Integer> BIOME_TO_SUBTHEME_MAP;
    public static HashMap<Integer, Theme> ID_TO_THEME_MAP;
    public static HashMap<Integer, SubTheme> ID_TO_SUBTHEME_MAP;
    public static HashMap<Integer, ThemeRandomizer> RANDOMIZERS;
    public static final Theme TEST;
    public static final Theme DEFAULT;
    public static final Theme OCEAN;
    public static final Theme BRICKS;
    public static final Theme ANDESITE;
    public static final Theme NETHER;
    public static final Theme DESERT;
    public static final Theme BADLANDS;
    public static final Theme ICE;
    public static final Theme MOSS;
    public static final SubTheme NETHER_SUB;
    public static final SubTheme ACACIA;
    public static final SubTheme OAK;
    public static final SubTheme BIRCH;
    public static final SubTheme DARK_OAK;
    public static final SubTheme JUNGLE;
    public static final SubTheme SPRUCE;
    private static final ThemeRandomizer DEFAULT_RANDOMIZER;
    public final IBlockStateProvider ceiling;
    public final IBlockStateProvider wall;
    public final IBlockStateProvider floor;
    public final IBlockStateProvider stairs;
    public final IBlockStateProvider material;
    public final IBlockStateProvider vanillaWall;
    public final IBlockStateProvider column;

    public Theme(IBlockStateProvider ceiling, IBlockStateProvider wall, IBlockStateProvider floor, IBlockStateProvider stairs, IBlockStateProvider material, IBlockStateProvider vanillaWall, IBlockStateProvider column) {
        this.ceiling = ceiling;
        this.wall = wall;
        this.floor = floor;
        this.stairs = stairs;
        this.material = material;
        this.vanillaWall = vanillaWall;
        this.column = column;
    }

    public Theme(BlockState ceiling, BlockState wall, BlockState floor, BlockState stairs, BlockState material, BlockState vanillaWall, BlockState column) {
        this.ceiling = () -> ceiling;
        this.wall = () -> wall;
        this.floor = () -> floor;
        this.stairs = () -> stairs;
        this.material = () -> material;
        this.vanillaWall = () -> vanillaWall;
        this.column = () -> column;
    }

    public Theme(Block ceiling, Block wall, Block floor, Block stairs, Block material, Block vanillaWall, Block column) {
        this.ceiling = () -> ceiling.func_176223_P();
        this.wall = () -> wall.func_176223_P();
        this.floor = () -> floor.func_176223_P();
        this.stairs = () -> stairs.func_176223_P();
        this.material = () -> material.func_176223_P();
        this.vanillaWall = () -> vanillaWall.func_176223_P();
        this.column = () -> column.func_176223_P();
    }

    public static int getTheme(String biome) {
        int theme = BIOME_TO_THEME_MAP.getOrDefault(biome, 0);
        return RANDOMIZERS.getOrDefault(theme, DEFAULT_RANDOMIZER).randomize(RANDOM, theme);
    }

    public static int getSubTheme(String biome) {
        return BIOME_TO_SUBTHEME_MAP.getOrDefault(biome, 0);
    }

    public static Theme get(int theme) {
        return ID_TO_THEME_MAP.getOrDefault(theme, DEFAULT);
    }

    public static SubTheme getSub(int id) {
        return ID_TO_SUBTHEME_MAP.getOrDefault(id, OAK);
    }

    public static ThemeRandomizer createRandomizer(int ... themes) {
        return (rand, base) -> themes[rand.nextInt(themes.length)];
    }

    static {
        TEST = new Theme(() -> BlockRegistry.STONE_BRICKS, () -> BlockRegistry.STONE_BRICKS, () -> BlockRegistry.GRAVEL, () -> Blocks.field_222438_lb.func_176223_P(), () -> Blocks.field_196696_di.func_176223_P(), () -> Blocks.field_222413_lB.func_176223_P(), () -> Blocks.field_150348_b.func_176223_P());
        DEFAULT = new Theme(() -> BlockRegistry.STONE_BRICKS, BlockRegistry.STONE_BRICKS_NORMAL_MOSSY_CRACKED_COBBLESTONE, BlockRegistry.STONE_BRICKS_GRAVEL_COBBLESTONE, BlockRegistry.STAIRS_STONE_COBBLESTONE, BlockRegistry.STONE_BRICKS_NORMAL_MOSSY_CRACKED_COBBLESTONE, BlockRegistry.STONE_WALL, BlockRegistry.STONE_BRICKS_NORMAL_MOSSY_CRACKED_COBBLESTONE);
        OCEAN = new Theme(Blocks.field_180397_cI.func_176223_P(), Blocks.field_196779_gQ.func_176223_P(), Blocks.field_196781_gR.func_176223_P(), Blocks.field_203211_hf.func_176223_P(), Blocks.field_180397_cI.func_176223_P(), Blocks.field_222460_lx.func_176223_P(), Blocks.field_196781_gR.func_176223_P());
        BRICKS = new Theme(BlockRegistry.BRICKS_GRANITE, BlockRegistry.BRICKS_GRANITE, BlockRegistry.BRICKS_GRANITE_FLOOR, BlockRegistry.STAIRS_BRICKS_GRANITE, BlockRegistry.BRICKS_GRANITE, BlockRegistry.BRICKS_GRANITE_WALL, BlockRegistry.BRICKS_GRANITE);
        ANDESITE = new Theme(BlockRegistry.ANDESITE_STONE_BRICKS, BlockRegistry.ANDESITE_STONE_BRICKS, BlockRegistry.ANDESITE_STONE_BRICKS_COBBLESTONE, BlockRegistry.STAIRS_ANDESITE_STONE_COBBLESTONE, BlockRegistry.ANDESITE_STONE_BRICKS, BlockRegistry.ANDESITE_STONE_WALL, BlockRegistry.ANDESITE_STONE_BRICKS_COBBLESTONE);
        NETHER = new Theme(null, BlockRegistry.NETHERRACK_NETHERBRICK, BlockRegistry.NETHERRACK_NETHERBRICK_SOULSAND, BlockRegistry.NETHER_BRICK_STAIRS, BlockRegistry.NETHERRACK_NETHERBRICK, BlockRegistry.NETHER_WALL, BlockRegistry.NETHERRACK_NETHERBRICK);
        DESERT = new Theme(BlockRegistry.SANDSTONE_DEFAULT_CHSELED_SMOOTH, BlockRegistry.SANDSTONE_DEFAULT_CHSELED_SMOOTH, BlockRegistry.SANDSTONE_DEFAULT_SMOOTH_SAND, BlockRegistry.STAIRS_SANDSTONE_DEFAULT_SMOOTH, BlockRegistry.SANDSTONE_DEFAULT_CHSELED_SMOOTH, () -> Blocks.field_222417_lF.func_176223_P(), BlockRegistry.SANDSTONE_DEFAULT_CHSELED_SMOOTH);
        BADLANDS = new Theme(BlockRegistry.RED_SANDSTONE_DEFAULT_CHSELED_SMOOTH, BlockRegistry.RED_SANDSTONE_DEFAULT_CHSELED_SMOOTH, BlockRegistry.RED_SANDSTONE_DEFAULT_SMOOTH_RED_SAND, BlockRegistry.STAIRS_RED_SANDSTONE_DEFAULT_SMOOTH, BlockRegistry.RED_SANDSTONE_DEFAULT_CHSELED_SMOOTH, () -> Blocks.field_222461_ly.func_176223_P(), BlockRegistry.RED_SANDSTONE_DEFAULT_CHSELED_SMOOTH);
        ICE = new Theme(BlockRegistry.ICE_DEFAULT_PACKED, BlockRegistry.ICE_DEFAULT_PACKED, () -> Blocks.field_150432_aD.func_176223_P(), BlockRegistry.ICE_DEFAULT_PACKED, BlockRegistry.ICE_DEFAULT_PACKED, () -> Blocks.field_201941_jj.func_176223_P(), BlockRegistry.ICE_DEFAULT_PACKED);
        MOSS = new Theme(BlockRegistry.MOSS, BlockRegistry.MOSS, BlockRegistry.MOSS_FLOOR, BlockRegistry.MOSS_STAIRS, BlockRegistry.MOSS, BlockRegistry.MOSS_WALL, BlockRegistry.MOSS);
        NETHER_SUB = new SubTheme(Blocks.field_150343_Z.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), Blocks.field_196677_cy.func_176223_P(), Blocks.field_150454_av.func_176223_P(), Blocks.field_150424_aL.func_176223_P());
        ACACIA = new SubTheme(() -> Blocks.field_196621_O.func_176223_P(), () -> Blocks.field_196682_da.func_176223_P(), () -> Blocks.field_196677_cy.func_176223_P(), () -> Blocks.field_180410_as.func_176223_P(), () -> Blocks.field_196670_r.func_176223_P());
        OAK = new SubTheme(() -> Blocks.field_196617_K.func_176223_P(), () -> Blocks.field_196636_cW.func_176223_P(), () -> Blocks.field_196677_cy.func_176223_P(), () -> Blocks.field_180413_ao.func_176223_P(), () -> Blocks.field_196662_n.func_176223_P());
        BIRCH = new SubTheme(() -> Blocks.field_196619_M.func_176223_P(), () -> Blocks.field_196641_cY.func_176223_P(), () -> Blocks.field_196677_cy.func_176223_P(), () -> Blocks.field_180412_aq.func_176223_P(), () -> Blocks.field_196666_p.func_176223_P());
        DARK_OAK = new SubTheme(() -> Blocks.field_196623_P.func_176223_P(), () -> Blocks.field_196684_db.func_176223_P(), () -> Blocks.field_196677_cy.func_176223_P(), () -> Blocks.field_180409_at.func_176223_P(), () -> Blocks.field_196672_s.func_176223_P());
        JUNGLE = new SubTheme(() -> Blocks.field_196620_N.func_176223_P(), () -> Blocks.field_196644_cZ.func_176223_P(), () -> Blocks.field_196677_cy.func_176223_P(), () -> Blocks.field_180411_ar.func_176223_P(), () -> Blocks.field_196668_q.func_176223_P());
        SPRUCE = new SubTheme(() -> Blocks.field_196618_L.func_176223_P(), () -> Blocks.field_196638_cX.func_176223_P(), () -> Blocks.field_196677_cy.func_176223_P(), () -> Blocks.field_180414_ap.func_176223_P(), () -> Blocks.field_196664_o.func_176223_P());
        DEFAULT_RANDOMIZER = (rand, base) -> base;
        BIOME_TO_THEME_MAP = new HashMap();
        BIOME_TO_THEME_MAP.put("minecraft:swamp", 2);
        BIOME_TO_THEME_MAP.put("minecraft:swamp_hills", 2);
        BIOME_TO_THEME_MAP.put("minecraft:ocean", 3);
        BIOME_TO_THEME_MAP.put("minecraft:deep_ocean", 3);
        BIOME_TO_THEME_MAP.put("minecraft:cold_ocean", 3);
        BIOME_TO_THEME_MAP.put("minecraft:deep_cold_ocean", 3);
        BIOME_TO_THEME_MAP.put("minecraft:lukewarm_ocean", 3);
        BIOME_TO_THEME_MAP.put("minecraft:deep_lukewarm_ocean", 3);
        BIOME_TO_THEME_MAP.put("minecraft:warm_ocean", 3);
        BIOME_TO_THEME_MAP.put("minecraft:deep_warm_ocean", 3);
        BIOME_TO_THEME_MAP.put("minecraft:frozen_ocean", 4);
        BIOME_TO_THEME_MAP.put("mineraft:deep_frozen_ocean", 4);
        BIOME_TO_THEME_MAP.put("minecraft:desert", 16);
        BIOME_TO_THEME_MAP.put("minecraft:desert_hills", 16);
        BIOME_TO_THEME_MAP.put("minecraft:desert_lakes", 16);
        BIOME_TO_THEME_MAP.put("minecraft:badlands", 17);
        BIOME_TO_THEME_MAP.put("minecraft:wooded_badlands_plateau", 17);
        BIOME_TO_THEME_MAP.put("minecraft:badlands_plateau", 17);
        BIOME_TO_THEME_MAP.put("minecraft:eroded_badlands", 17);
        BIOME_TO_THEME_MAP.put("minecraft:modified_wooded_badlands_plateau", 17);
        BIOME_TO_THEME_MAP.put("minecraft:modified_badlands_plateau", 17);
        BIOME_TO_THEME_MAP.put("minecraft:ice_spikes", 32);
        ID_TO_THEME_MAP = new HashMap();
        ID_TO_THEME_MAP.put(-1, TEST);
        ID_TO_THEME_MAP.put(0, DEFAULT);
        ID_TO_THEME_MAP.put(1, NETHER);
        ID_TO_THEME_MAP.put(2, OCEAN);
        ID_TO_THEME_MAP.put(16, DESERT);
        ID_TO_THEME_MAP.put(17, BADLANDS);
        ID_TO_THEME_MAP.put(32, ICE);
        ID_TO_THEME_MAP.put(48, BRICKS);
        ID_TO_THEME_MAP.put(49, ANDESITE);
        ID_TO_THEME_MAP.put(80, MOSS);
        BIOME_TO_SUBTHEME_MAP = new HashMap();
        BIOME_TO_SUBTHEME_MAP.put("minecraft:jungle", 1);
        BIOME_TO_SUBTHEME_MAP.put("minecraft:jungle_edge", 1);
        BIOME_TO_SUBTHEME_MAP.put("minecraft:jungle_hills", 1);
        BIOME_TO_SUBTHEME_MAP.put("minecraft:modified_jungle", 1);
        BIOME_TO_SUBTHEME_MAP.put("minecraft:modified_jungle_edge", 1);
        BIOME_TO_SUBTHEME_MAP.put("minecraft:bamboo_jungle", 1);
        BIOME_TO_SUBTHEME_MAP.put("minecraft:bamboo_jungle_hills", 1);
        BIOME_TO_SUBTHEME_MAP.put("minecraft:birch_forest", 2);
        BIOME_TO_SUBTHEME_MAP.put("minecraft:birch_forest_hills", 2);
        BIOME_TO_SUBTHEME_MAP.put("minecraft:tall_birch_forest", 2);
        BIOME_TO_SUBTHEME_MAP.put("minecraft:tall_birch_hills", 2);
        BIOME_TO_SUBTHEME_MAP.put("minecraft:flower_forest", 2);
        BIOME_TO_SUBTHEME_MAP.put("minecraft:savanna", 3);
        BIOME_TO_SUBTHEME_MAP.put("minecraft:savanna_plateau", 3);
        BIOME_TO_SUBTHEME_MAP.put("minecraft:shattered_savanna", 3);
        BIOME_TO_SUBTHEME_MAP.put("minecraft:shattered_savanna_plateau", 3);
        BIOME_TO_SUBTHEME_MAP.put("minecraft:dark_forest", 4);
        BIOME_TO_SUBTHEME_MAP.put("minecraft:dark_forest_hills", 4);
        BIOME_TO_SUBTHEME_MAP.put("minecraft:taiga", 5);
        BIOME_TO_SUBTHEME_MAP.put("minecraft:snowy_tundra", 5);
        BIOME_TO_SUBTHEME_MAP.put("minecraft:taiga_hills", 5);
        BIOME_TO_SUBTHEME_MAP.put("minecraft:snowy_taiga", 5);
        BIOME_TO_SUBTHEME_MAP.put("minecraft:snowy_taga_hills", 5);
        BIOME_TO_SUBTHEME_MAP.put("minecraft:giant_tree_taiga", 5);
        BIOME_TO_SUBTHEME_MAP.put("minecraft:giant_tree_taiga_hills", 5);
        BIOME_TO_SUBTHEME_MAP.put("minecraft:taiga_mountains", 5);
        BIOME_TO_SUBTHEME_MAP.put("minecraft:snowy_taiga_mountains", 5);
        BIOME_TO_SUBTHEME_MAP.put("minecraft:giant_spruce_taiga", 5);
        BIOME_TO_SUBTHEME_MAP.put("minecraft:giant_spruce_taiga_hills", 5);
        ID_TO_SUBTHEME_MAP = new HashMap();
        ID_TO_SUBTHEME_MAP.put(0, OAK);
        ID_TO_SUBTHEME_MAP.put(1, JUNGLE);
        ID_TO_SUBTHEME_MAP.put(2, BIRCH);
        ID_TO_SUBTHEME_MAP.put(3, ACACIA);
        ID_TO_SUBTHEME_MAP.put(4, DARK_OAK);
        ID_TO_SUBTHEME_MAP.put(5, SPRUCE);
        ID_TO_SUBTHEME_MAP.put(8, NETHER_SUB);
        RANDOMIZERS = new HashMap();
        RANDOMIZERS.put(0, Theme.createRandomizer(0, 48, 49));
    }

    @FunctionalInterface
    public static interface ThemeRandomizer {
        public int randomize(Random var1, int var2);
    }

    public static class SubTheme {
        public final IBlockStateProvider wallLog;
        public final IBlockStateProvider trapDoor;
        public final IBlockStateProvider torchDark;
        public final IBlockStateProvider door;
        public final IBlockStateProvider material;

        public SubTheme(IBlockStateProvider wallLog, IBlockStateProvider trapDoor, IBlockStateProvider torchDark, IBlockStateProvider door, IBlockStateProvider material) {
            this.wallLog = wallLog;
            this.trapDoor = trapDoor;
            this.torchDark = torchDark;
            this.door = door;
            this.material = material;
        }

        public SubTheme(BlockState wallLog, BlockState trapDoor, BlockState torchDark, BlockState door, BlockState material) {
            this.wallLog = () -> wallLog;
            this.trapDoor = () -> trapDoor;
            this.torchDark = () -> torchDark;
            this.door = () -> door;
            this.material = () -> material;
        }

        public SubTheme(Block wallLog, Block trapDoor, Block torchDark, Block door, Block material) {
            this.wallLog = () -> wallLog.func_176223_P();
            this.trapDoor = () -> trapDoor.func_176223_P();
            this.torchDark = () -> torchDark.func_176223_P();
            this.door = () -> door.func_176223_P();
            this.material = () -> material.func_176223_P();
        }
    }
}

