/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.util;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModel;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelBlock;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelBlockType;

public class ModelHelper {
    public static void readModelToFile(World world, BlockPos pos, int width, int height, int length) {
        DungeonSegmentModelBlock[][][] model = new DungeonSegmentModelBlock[width][height][length];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    BlockState state = world.func_180495_p(new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z));
                    model[x][y][z] = state.func_177230_c() == Blocks.field_150350_a ? null : new DungeonSegmentModelBlock(DungeonSegmentModelBlockType.get(state.func_177230_c())).set(state);
                }
            }
        }
        ModelHelper.writeModelToFile(new DungeonSegmentModel(model), ((ServerWorld)world).func_217485_w().func_75765_b().getAbsolutePath() + "model_" + System.currentTimeMillis() + ".nbt");
    }

    public static void writeModelToFile(DungeonSegmentModel model, String file) {
        try {
            ModelHelper.convertModelToNBT(model).func_74734_a((DataOutput)new DataOutputStream(new FileOutputStream(file)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DungeonSegmentModel readModelFromFile(File file) {
        DungeonCrawl.LOGGER.info("Loading model from file " + file.getAbsolutePath());
        try {
            FileReader reader = new FileReader(file);
            return (DungeonSegmentModel)DungeonCrawl.GSON.fromJson((Reader)reader, DungeonSegmentModel.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DungeonSegmentModel readModelFromInputStream(InputStream input) {
        try {
            InputStreamReader reader = new InputStreamReader(input);
            return (DungeonSegmentModel)DungeonCrawl.GSON.fromJson((Reader)reader, DungeonSegmentModel.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static CompoundNBT convertModelToNBT(DungeonSegmentModel model) {
        byte width = (byte)(model.width > 127 ? -(model.width - 127) : model.width);
        byte length = (byte)(model.length > 127 ? -(model.length - 127) : model.length);
        byte height = (byte)(model.height > 127 ? -(model.height - 127) : model.height);
        CompoundNBT newModel = new CompoundNBT();
        newModel.func_74774_a("length", length);
        newModel.func_74774_a("height", height);
        newModel.func_74774_a("width", width);
        ListNBT blocks = new ListNBT();
        for (int x = 0; x < model.width; ++x) {
            ListNBT blocks2 = new ListNBT();
            for (int y = 0; y < model.height; ++y) {
                ListNBT blocks3 = new ListNBT();
                for (int z = 0; z < model.length; ++z) {
                    if (model.model[x][y][z] != null) {
                        blocks3.add((Object)model.model[x][y][z].getAsNBT());
                        continue;
                    }
                    blocks3.add((Object)new CompoundNBT());
                }
                blocks2.add((Object)blocks3);
            }
            blocks.add((Object)blocks2);
        }
        newModel.func_218657_a("model", (INBT)blocks);
        return newModel;
    }

    public static DungeonSegmentModel getModelFromNBT(CompoundNBT nbt) {
        int width = nbt.func_74762_e("width");
        int height = nbt.func_74762_e("height");
        int length = nbt.func_74762_e("length");
        ListNBT blocks = nbt.func_150295_c("model", 9);
        DungeonSegmentModelBlock[][][] model = new DungeonSegmentModelBlock[width][height][length];
        for (int x = 0; x < width; ++x) {
            ListNBT blocks2 = blocks.func_202169_e(x);
            for (int y = 0; y < height; ++y) {
                ListNBT blocks3 = blocks2.func_202169_e(y);
                for (int z = 0; z < length; ++z) {
                    model[x][y][z] = DungeonSegmentModelBlock.fromNBT(blocks3.func_150305_b(z));
                }
            }
        }
        return new DungeonSegmentModel(model);
    }
}

