/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.JsonConfig;
import xiroc.dungeoncrawl.dungeon.Dungeon;
import xiroc.dungeoncrawl.dungeon.DungeonFeatures;
import xiroc.dungeoncrawl.dungeon.DungeonLayer;
import xiroc.dungeoncrawl.dungeon.DungeonLayerType;
import xiroc.dungeoncrawl.dungeon.DungeonPieces;
import xiroc.dungeoncrawl.dungeon.DungeonStatTracker;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModel;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelBlock;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelBlockType;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelRegistry;
import xiroc.dungeoncrawl.dungeon.segment.RandomDungeonSegmentModel;
import xiroc.dungeoncrawl.part.block.WeightedRandomBlock;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.BossEntry;
import xiroc.dungeoncrawl.util.IRandom;
import xiroc.dungeoncrawl.util.Position2D;

public class DungeonBuilder {
    public static final HashMap<Integer, Tuple<Integer, Integer>> ENTRANCE_OFFSET_DATA;
    public static final HashMap<Integer, EntranceProcessor> ENTRANCE_PROCESSORS;
    private static final DungeonSegmentModel[] ENTRANCES;
    public static final EntranceProcessor DEFAULT_PROCESSOR;
    public Random rand;
    public Position2D start;
    public DungeonLayer[] layers;
    public DungeonStatTracker statTracker;
    public BlockPos startPos;
    public int theme;
    public static final IRandom<DungeonSegmentModel> ENTRANCE;

    public DungeonBuilder(ChunkGenerator<?> world, ChunkPos pos, Random rand) {
        this.rand = rand;
        this.start = new Position2D(rand.nextInt(Dungeon.SIZE), rand.nextInt(Dungeon.SIZE));
        this.startPos = new BlockPos(pos.field_77276_a * 16, world.func_205470_d() - 16, pos.field_77275_b * 16);
        this.layers = new DungeonLayer[this.startPos.func_177956_o() / 16];
        DungeonCrawl.LOGGER.info("DungeonBuilder starts at (" + this.startPos.func_177958_n() + " / " + this.startPos.func_177956_o() + " / " + this.startPos.func_177952_p() + "), " + this.layers.length + " layers, Theme: {}", (Object)this.theme);
        this.statTracker = new DungeonStatTracker(this.layers.length);
        this.theme = Theme.getTheme(world.func_202090_b().func_222364_a(this.startPos).getRegistryName().toString());
    }

    public List<DungeonPieces.DungeonPiece> build() {
        int i;
        ArrayList list = Lists.newArrayList();
        for (i = 0; i < this.layers.length; ++i) {
            this.layers[i] = new DungeonLayer(DungeonLayerType.NORMAL, Dungeon.SIZE, Dungeon.SIZE);
            this.layers[i].buildMap(this, list, this.rand, i == 0 ? this.start : this.layers[i - 1].end, i, i == this.layers.length - 1);
        }
        for (i = 0; i < this.layers.length; ++i) {
            this.buildLayer(this.layers[i], i, this.startPos);
            DungeonPieces.DungeonPiece stairs = i == 0 ? new DungeonPieces.EntranceBuilder(null, DungeonPieces.DEFAULT_NBT) : new DungeonPieces.Stairs(null, DungeonPieces.DEFAULT_NBT);
            stairs.setRealPosition(this.startPos.func_177958_n() + this.layers[i].start.x * 8, this.startPos.func_177956_o() + 8 - i * 16, this.startPos.func_177952_p() + this.layers[i].start.z * 8);
            stairs.stage = 0;
            list.add(stairs);
        }
        this.postProcessDungeon(list, this.rand, this.theme);
        for (DungeonPieces.DungeonPiece piece : list) {
            if (piece.theme == 1) continue;
            piece.theme = this.theme;
        }
        return list;
    }

    public void buildLayer(DungeonLayer layer, int lyr, BlockPos startPos) {
        int stage = lyr > 2 ? 2 : lyr;
        for (int x = 0; x < layer.width; ++x) {
            for (int z = 0; z < layer.length; ++z) {
                if (layer.segments[x][z] == null) continue;
                layer.segments[x][z].setRealPosition(startPos.func_177958_n() + x * 8, startPos.func_177956_o() - lyr * 16, startPos.func_177952_p() + z * 8);
                layer.segments[x][z].stage = stage;
            }
        }
    }

    public void postProcessDungeon(List<DungeonPieces.DungeonPiece> list, Random rand, int theme) {
        int lyrs = this.layers.length;
        for (int i = 0; i < this.layers.length; ++i) {
            int z;
            int x;
            int stage = i > 2 ? 2 : i;
            DungeonLayer layer = this.layers[i];
            for (x = 0; x < layer.width; ++x) {
                for (z = 0; z < layer.length; ++z) {
                    if (layer.segments[x][z] == null || layer.segments[x][z].getType() != 0) continue;
                    if ((i >= lyrs - 1 || this.layers[i + 1].segments[x][z] == null) && rand.nextDouble() < 0.02) {
                        DungeonPieces.Hole hole = new DungeonPieces.Hole(null, DungeonPieces.DEFAULT_NBT);
                        hole.sides = layer.segments[x][z].sides;
                        hole.connectedSides = layer.segments[x][z].connectedSides;
                        hole.setRealPosition(this.startPos.func_177958_n() + x * 8, this.startPos.func_177956_o() - i * 16, this.startPos.func_177952_p() + z * 8);
                        hole.stage = stage;
                        hole.lava = stage == 2;
                        layer.segments[x][z] = hole;
                        continue;
                    }
                    DungeonFeatures.processCorridor(this, layer, x, z, rand, i, stage, this.startPos);
                }
            }
            for (x = 0; x < layer.width; ++x) {
                for (z = 0; z < layer.length; ++z) {
                    if (layer.segments[x][z] == null) continue;
                    if (i == lyrs - 1) {
                        layer.segments[x][z].theme = 1;
                    }
                    list.add(layer.segments[x][z]);
                }
            }
        }
    }

    public static void buildWallPillar(IWorld world, int theme, BlockPos pos, DungeonPieces.DungeonPiece piece) {
        DungeonSegmentModelBlock block = new DungeonSegmentModelBlock(DungeonSegmentModelBlockType.RAND_WALL_AIR);
        Theme buildTheme = Theme.get(theme);
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        int height = DungeonPieces.getGroudHeightFrom(world, x, z, pos.func_177956_o() - 1);
        for (int y = pos.func_177956_o() - 1; y > height; --y) {
            piece.setBlockState(DungeonSegmentModelBlock.PROVIDERS.get((Object)DungeonSegmentModelBlockType.RAND_WALL_AIR).get(block, buildTheme, WeightedRandomBlock.RANDOM, 0), world, null, x, y, z, theme, 0);
        }
    }

    public static DungeonSegmentModel getModel(DungeonPieces.DungeonPiece piece, Random rand) {
        boolean north = piece.sides[0];
        boolean east = piece.sides[1];
        boolean south = piece.sides[2];
        boolean west = piece.sides[3];
        switch (piece.getType()) {
            case 0: {
                switch (piece.connectedSides) {
                    case 2: {
                        switch (((DungeonPieces.Corridor)piece).specialType) {
                            case 1: {
                                return DungeonSegmentModelRegistry.CORRIDOR_FIRE;
                            }
                            case 2: {
                                return DungeonSegmentModelRegistry.CORRIDOR_GRASS;
                            }
                        }
                        if (north && south || east && west) {
                            return RandomDungeonSegmentModel.CORRIDOR_STRAIGHT.roll(rand);
                        }
                        return RandomDungeonSegmentModel.CORRIDOR_TURN.roll(rand);
                    }
                    case 3: {
                        return RandomDungeonSegmentModel.CORRIDOR_OPEN.roll(rand);
                    }
                    case 4: {
                        return RandomDungeonSegmentModel.CORRIDOR_ALL_OPEN.roll(rand);
                    }
                }
                return null;
            }
            case 1: {
                return DungeonSegmentModelRegistry.STAIRS_BOTTOM;
            }
            case 2: {
                return DungeonSegmentModelRegistry.STAIRS;
            }
            case 3: {
                return DungeonSegmentModelRegistry.STAIRS_TOP;
            }
            case 5: {
                return DungeonSegmentModelRegistry.ROOM;
            }
        }
        return null;
    }

    public static BossEntry getRandomBoss(Random rand) {
        if (JsonConfig.DUNGEON_BOSSES.length < 1) {
            return null;
        }
        return JsonConfig.DUNGEON_BOSSES[rand.nextInt(JsonConfig.DUNGEON_BOSSES.length)];
    }

    static {
        ENTRANCES = new DungeonSegmentModel[]{DungeonSegmentModelRegistry.ENTRANCE_TOWER_1};
        DEFAULT_PROCESSOR = (world, pos, theme, piece) -> {};
        ENTRANCE_OFFSET_DATA = new HashMap();
        ENTRANCE_OFFSET_DATA.put(20, (Tuple<Integer, Integer>)new Tuple((Object)0, (Object)0));
        ENTRANCE_OFFSET_DATA.put(32, (Tuple<Integer, Integer>)new Tuple((Object)-3, (Object)-3));
        ENTRANCE_PROCESSORS = new HashMap();
        ENTRANCE_PROCESSORS.put(20, (world, pos, theme, piece) -> {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            for (int ch = y; ch < y; ch += 8) {
                for (int x1 = 0; x1 < 8; ++x1) {
                    DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + x1, y - 1, z), piece);
                }
                for (int z1 = 0; z1 < 8; ++z1) {
                    DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x, y - 1, z + z1), piece);
                }
            }
        });
        ENTRANCE_PROCESSORS.put(32, (world, pos, theme, piece) -> {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + 4, y, z + 2), piece);
            DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + 5, y, z + 2), piece);
            DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + 6, y, z + 2), piece);
            DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + 7, y, z + 2), piece);
            DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + 8, y, z + 2), piece);
            DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + 2, y, z + 4), piece);
            DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + 2, y, z + 5), piece);
            DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + 2, y, z + 6), piece);
            DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + 2, y, z + 7), piece);
            DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + 2, y, z + 8), piece);
            DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + 4, y, z + 10), piece);
            DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + 5, y, z + 10), piece);
            DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + 6, y, z + 10), piece);
            DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + 7, y, z + 10), piece);
            DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + 8, y, z + 10), piece);
            DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + 10, y, z + 4), piece);
            DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + 10, y, z + 5), piece);
            DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + 10, y, z + 6), piece);
            DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + 10, y, z + 7), piece);
            DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + 10, y, z + 8), piece);
            DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + 5, y, z + 1), piece);
            DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + 7, y, z + 1), piece);
            DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + 1, y, z + 5), piece);
            DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + 1, y, z + 7), piece);
            DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + 5, y, z + 11), piece);
            DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + 7, y, z + 11), piece);
            DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + 11, y, z + 5), piece);
            DungeonBuilder.buildWallPillar(world, theme, new BlockPos(x + 11, y, z + 7), piece);
        });
        ENTRANCE = rand -> ENTRANCES[rand.nextInt(ENTRANCES.length)];
    }

    @FunctionalInterface
    public static interface EntranceProcessor {
        public void process(IWorld var1, BlockPos var2, int var3, DungeonPieces.DungeonPiece var4);
    }
}

